/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#include "timidity.h"
#include "aenc.h"
#include "audriv.h"
#include "timer.h"

#ifdef DEBUG
#include "audio_cnv.h"
#include <math.h>
#endif

void (* audriv_error_handler)(const char *errmsg) = NULL;

static int play_sample_rate = 8000;
static int play_sample_size = 1;
static double play_start_time;
static long play_counter, reset_samples;
static int play_encoding   = AENC_G711_ULAW;
static int play_channels = 1;
static int output_port = AUDRIV_OUTPUT_SPEAKER;
static int play_volume   = 0;
static Bool play_open_flag = False;

char audriv_errmsg[BUFSIZ];

static void audriv_err(const char *msg)
{
    strncpy(audriv_errmsg, msg, sizeof(audriv_errmsg) - 1);
    if(audriv_error_handler != NULL)
	audriv_error_handler(audriv_errmsg);
}

Bool audriv_setup_audio(void)
/* I[fBȈs܂D
 * ꍇ True Csꍇ False Ԃ܂D
 */
{
    return True;
}

void audriv_free_audio(void)
/* audio ̌㏈s܂D
 */
{
}

Bool audriv_play_open(void)
/* audio tpɊJCł audriv_write() ɂ艉t\
 * Ԃɂ܂DɊJĂꍇ͂Ȃɂs܂D
 * ꍇ True Csꍇ False Ԃ܂D
 */
{
    if(play_open_flag)
	return True;
    play_counter = 0;
    reset_samples = 0;
    play_open_flag = True;
    return True;
}

void audriv_play_close(void)
/* tpɃI[vꂽ audio ܂DłɕĂ
 * ꍇ͂Ȃɂs܂D
 */
{
    play_open_flag = False;
}

static long calculate_play_samples(void)
{
    long n, ret;

    if(play_counter <= 0)
	return 0;

    n = (long)((double)play_sample_rate
	       * (double)play_sample_size
	       * (get_current_calender_time() - play_start_time));
    if(n > play_counter)
	ret = play_counter / play_sample_size;
    else
	ret = n / play_sample_size;

    return ret;
}

long audriv_play_stop(void)
/* t𑦍ɒ~C~ÕTvԂ܂D
 * audriv_play_stop() ̌ĂяoɂāCaudio ͕܂D
 * audio ɕĂꍇ audriv_play_stop() Ăяoꍇ 0 
 * Ԃ܂D
 * G[̏ꍇ -1 Ԃ܂D
 */
{
    long n;

    n = audriv_play_samples();
    play_open_flag = False;
    return n;
}

Bool audriv_is_play_open(void)
/* audio tŃI[vĂꍇ True,
 * Ăꍇ False Ԃ܂D
 */
{
    return play_open_flag;
}

Bool audriv_set_play_volume(int volume)
/* tʂ 0 ? 255 ͈͓̔Őݒ肵܂D0 ͖C255 ͍ő剹ʁD
 * 0  0C255 𒴂l 255 ɓD
 * ꍇ True Csꍇ False Ԃ܂D
 */
{
    if(volume < 0)
	play_volume = 0;
    else if(volume > 255)
	play_volume = 255;
    else
	play_volume = volume;
    return True;
}

int audriv_get_play_volume(void)
/* tʂ 0 ? 255 œ܂D0 ͖C255 ͍ő剹ʁD
 * s -1 ԂCłȂꍇ 0 ? 255 ̉ʂԂ܂D
 */
{
    return play_volume;
}

Bool audriv_set_play_output(int port)
/* audio ̏o͐ port w肵܂Dport ɂ͈ȉ̂ǂꂩw肵܂D
 *
 *     AUDRIV_OUTPUT_SPEAKER	Xs[JɏóD
 *     AUDRIV_OUTPUT_HEADPHONE	wbhzɏóD
 *     AUDRIV_OUTPUT_LINE_OUT	CAEgɏóD
 *
 * ꍇ True Csꍇ False Ԃ܂D
 */
{
    switch(port)
    {
      case AUDRIV_OUTPUT_SPEAKER:
      case AUDRIV_OUTPUT_HEADPHONE:
      case AUDRIV_OUTPUT_LINE_OUT:
	output_port = port;
	break;
      default:
	audriv_err("wȌo̓|[gw肳܂D");
	return False;
    }
    return True;
}

int audriv_get_play_output(void)
/* audio ̏o͐ port 𓾂܂D
 * s -1 ԂCƈȉ̂ꂩ̒lԂ܂D
 *
 *     AUDRIV_OUTPUT_SPEAKER	Xs[JɏóD
 *     AUDRIV_OUTPUT_HEADPHONE	wbhzɏóD
 *     AUDRIV_OUTPUT_LINE_OUT	CAEgɏóD
 *
 */
{
    return output_port;
}

#ifdef CFG_FOR_SF
static int record_volume = 0;
#endif
int audriv_get_record_volume(void)
/* ^ʂ 0 ? 255 œ܂D0 ͖C255 ͍ő剹ʁD
 * s -1 ԂCłȂꍇ 0 ? 255 ̉ʂԂ܂D
 */
{
    return record_volume;
}

int audriv_write(char *buff, int n)
/* audio  buff  n oCg݂܂D
 * audriv_set_noblock_write() ŔubNE[hݒ肳ꂽ
 * ꍇ́C̊֐̌Ăяo͑ɏԂ܂D
 * Ԃl͎ۂɗ܂ꂽoCgłCubNE[hݒ
 * Ăꍇ́C n 菭Ȃꍇ܂D
 * s -1 ԂCƁCۂɗ܂ꂽoCgԂ܂D
 */
{
    long qsz;

    qsz = audriv_get_filled();
    if(qsz == -1)
	return -1;
    if(qsz == 0)
    {
	reset_samples += play_counter / play_sample_size;
	play_counter = 0; /* Reset start time */
    }
    if(play_counter == 0)
	play_start_time = get_current_calender_time();
    play_counter += n;
    return n;
}

Bool audriv_set_noblock_write(Bool noblock)
/* noblock  True w肷ƁCaudriv_write() ĂяoŃubN܂D
 * False w肷ƁCftHg̏Ԃɖ߂܂D
 * ɐ True Cs False Ԃ܂D
 */
{
    return True;
}

int audriv_play_active(void)
/* tȂ 1CtłȂȂ 0, G[Ȃ -1 Ԃ܂D
 */
{
    long n;

    n = audriv_get_filled();
    if(n > 0)
	return 1;
    return n;
}

long audriv_play_samples(void)
/* ݉t̃TvʒuԂ܂D
 */
{
    return reset_samples + calculate_play_samples();
}

long audriv_get_filled(void)
/* I[fBIobt@̃oCgԂ܂B
 * G[̏ꍇ -1 Ԃ܂B
 */
{
    long n;

    if(play_counter <= 0)
	return 0;
    n = (int)((double)play_sample_rate
	      * play_sample_size
	      * (get_current_calender_time() - play_start_time));
    if(n > play_counter)
	return 0;
    return play_counter - n;
}

const long *audriv_available_encodings(int *n_ret)
/* }VT|[gĂ邷ׂĂ̕XgԂ܂Dn_ret ɂ
 * ̎ނ̐CԂ܂D킷萔l
 * usffd.h ɒ`Ă enum usffd_data_encoding ̒lłD
 * Ԃl free Ă͂Ȃ܂D
 */
{
    static const long encoding_list[] =
    {
	AENC_SIGBYTE, AENC_UNSIGBYTE, AENC_G711_ULAW,
	AENC_G711_ALAW, AENC_SIGWORDB, AENC_UNSIGWORDB,
	AENC_SIGWORDL, AENC_UNSIGWORDL
    };

    *n_ret = 8;
    return encoding_list;
}

const long *audriv_available_sample_rates(int *n_ret)
/* }VT|[gĂ邷ׂẴTv[g̃XgԂ܂D
 * n_ret ɂ͂̎ނ̐CԂ܂D
 * Ԃl free Ă͂Ȃ܂D
 */
{
    static const long sample_rates[] =
    {
	5512, 6615,
	8000, 9600, 11025, 16000, 18900, 22050, 32000, 37800, 44100, 48000
    };
    *n_ret = 12;
    return sample_rates;
}

const long *audriv_available_channels(int *n_ret)
/* }VT|[gĂ邷ׂẴ`l̃XgԂ܂D
 * n_ret ɂ͂̎ނ̐CԂ܂D
 * Ԃl free Ă͂Ȃ܂D
 */
{
    static const long channels[] = {1, 2};
    *n_ret = 2;
    return channels;
}

Bool audriv_set_play_encoding(long encoding)
/* audio t̕w肵܂D
 * ꍇ True Csꍇ False Ԃ܂D
 */
{
    int i, n;
    const long *enc;

    enc = audriv_available_encodings(&n);
    for(i = 0; i < n; i++)
	if(enc[i] == encoding)
	{
	    play_encoding = encoding;
	    play_sample_size = AENC_SAMPW(encoding) * play_channels;
	    return True;
	}
    return False;
}

Bool audriv_set_play_sample_rate(long sample_rate)
/* audio t̃Tv[gw肵܂D
 * ꍇ True Csꍇ False Ԃ܂D
 */
{
    int i, n;
    const long *r;

    r = audriv_available_sample_rates(&n);
    for(i = 0; i < n; i++)
	if(r[i] == sample_rate)
	{
	    play_sample_rate = sample_rate;
	    return True;
	}
    return False;
}

Bool audriv_set_play_channels(long channels)
/* tp̃`lݒ肵܂D
 * s False ԂC True Ԃ܂D
 */
{
    int i, n;
    const long *c = audriv_available_channels(&n);

    for(i = 0; i < n; i++)
	if(channels == c[i])
	{
	    play_channels = channels;
	    return True;
	}
    return False;
}

void audriv_wait_play(void)
/* CPU p[QȂ悤ɂ邽߂ɁCꎞIɒ~܂D*/
{
}
