/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
//#define DEBUG
#ifndef STRICT
#define STRICT 1
#endif
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#endif

#define RTSYN_THREAD 1 // exclude RTSYN_MULTITHREAD
// #define RTSYN_MULTITHREAD 1 // exclude RTSYN_THREAD


#ifdef __DMC__
unsigned long _beginthreadex(void *security, unsigned stack_size,
			     unsigned (__stdcall *start_address)(void*), void *arglist,
			     unsigned initflag, unsigned *thrdaddr);
void _endthreadex(unsigned retval);
#endif /* __DMC__ */

#ifndef NDEBUG
#define DEBUG_OUTPUT_DIR       "R:\\"
#if 1
/* contain log */
#define DEBUG_OUTPUT_COMMON    DEBUG_OUTPUT_DIR "dbglog.txt"
#define DEBUG_OUTPUT_STATUS    DEBUG_OUTPUT_COMMON
#define DEBUG_OUTPUT_PARSELONG DEBUG_OUTPUT_COMMON
#define DEBUG_OUTPUT_PARSESHRT DEBUG_OUTPUT_COMMON
#elif 0
/* split log */
#define DEBUG_OUTPUT_STATUS    DEBUG_OUTPUT_DIR "dbglog.status.txt"
#define DEBUG_OUTPUT_PARSELONG DEBUG_OUTPUT_DIR "dbglog.long.txt"
#define DEBUG_OUTPUT_PARSESHRT DEBUG_OUTPUT_DIR "dbglog.shrt.txt"
#else
/* disable logging debug */
#endif
#endif /* !NDEBUG */

#ifndef NDEBUG
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#endif /* !NDEBUG */
#include <windows.h>
#include "mmddk.h"
#include <mmsystem.h>
#ifdef __DMC__
//following codes are from wine's mmsystem.h
typedef struct tagMIDIOUTCAPS2A {
    WORD      wMid;
    WORD      wPid;
    MMVERSION vDriverVersion;
    CHAR      szPname[MAXPNAMELEN];
    WORD      wTechnology;
    WORD      wVoices;
    WORD      wNotes;
    WORD      wChannelMask;
    DWORD     dwSupport;
    GUID      ManufacturerGuid;
    GUID      ProductGuid;
    GUID      NameGuid;
} MIDIOUTCAPS2A, *LPMIDIOUTCAPS2A;

typedef struct tagMIDIOUTCAPS2W {
    WORD      wMid;
    WORD      wPid;
    MMVERSION vDriverVersion;
    WCHAR     szPname[MAXPNAMELEN];
    WORD      wTechnology;
    WORD      wVoices;
    WORD      wNotes;
    WORD      wChannelMask;
    DWORD     dwSupport;
    GUID      ManufacturerGuid;
    GUID      ProductGuid;
    GUID      NameGuid;
} MIDIOUTCAPS2W, *LPMIDIOUTCAPS2W;

//DECL_WINELIB_TYPE_AW(MIDIOUTCAPS2)
//DECL_WINELIB_TYPE_AW(LPMIDIOUTCAPS2)
#endif /* __DMC__ */

#include <process.h>
#include <shlwapi.h>
#pragma comment(lib, "shlwapi.lib")

// GUID definitions from wine's guiddef.h
#ifndef GUID_DEFINED
#define GUID_DEFINED
typedef struct _GUID
{
    DWORD Data1;
    WORD  Data2;
    WORD  Data3;
    BYTE  Data4[8];
} GUID;
#endif /* !GUID_DEFINED */

//GUID numbers are generated by timiditydrv.idl
static const GUID CLSID_tim_synth = { 0x0FEC4C35, 0xA705, 0x41d7, { 0xA3, 0xBB, 0xD5, 0x87, 0xA2, 0x31, 0x04, 0x5A }};

static volatile int OpenCount;
static volatile int modm_closed = 1;

static HDRVR hdrvrInstance;
static MIDIOPENDESC mid_desc;
static DWORD dwOpenFlags;

static CRITICAL_SECTION mim_section;
static volatile int stop_thread;
static HANDLE hRtsynThread;
//static DWORD processPriority;
#if defined(RTSYN_MULTITHREAD)
static volatile int stop_rtthread;
static HANDLE hCalcThread;
#endif /* RTSYN_MULTITHREAD */

#include "timidity.h"
#include "common.h"
#include "sysdep.h"
#include "myini.h"
#include "output.h"
#include "timiwp_timidity.h"
#include "instrum.h"
#include "rtsyn.h"
#include "sndfontini.h"
#include "timiwp_timidity.h"
Sample OverrideSample;
OVERRIDETIMIDITYDATA otd;
HINSTANCE hDllInstance;
static int drvDllPortId = -1;


static int GetDllPortId(HINSTANCE hinst)
{
	char DllFilePath[MAX_PATH + 1] = "";
	char DllFileName[MAX_PATH + 1] = "";
	int i = 0;
	GetModuleFileNameA(hinst, DllFilePath, MAX_PATH);
	strcpy(DllFileName, MyIni_PathFindFileName(DllFilePath));
	PathRemoveExtensionA(DllFileName);
	i = DllFileName[strlen(DllFileName) - 1] - '0';
	if (i >= 0 && i <= 9) return i;
	return -1;
}

static char *CreateTiMidityConfigPath()
{
	char path[FILEPATH_MAX] = "";
	int len = 0;
	FILE *fp = NULL;
	const char cszConfig[] = "\\TIMIDITY",
		   cszExt[] = ".CFG";

	len = strlen(cszConfig) + strlen(cszExt);
	GetWindowsDirectoryA(path, FILEPATH_MAX - len - 1);

	if (drvDllPortId != -1) {
		strlcat(path, cszConfig, FILEPATH_MAX);
		len = strlen(path);
		path[len + 1] = '\0';
		path[len] = '0' + drvDllPortId;
	} else {
		strlcat(path, cszConfig, FILEPATH_MAX);
	}
	strlcat(path, cszExt, FILEPATH_MAX);

#ifdef DEBUG_OUTPUT_STATUS
	{
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_STATUS, "a");
	if (logfile) {
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "fopen");
		fputs(" ", logfile);
		fputs(path, logfile);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
	}
#endif /* DEBUG_OUTPUT_STATUS */
	fp = fopen(path, "r");
	if (!fp) return NULL;
	fclose(fp);
	return safe_strdup(path);
}

static void ResetCurrentDirectory(void)
{
	const char defaultpath[] = "C:\\WINDOWS";
	char systempath[MAX_PATH] = { '\0' };
	if (!GetWindowsDirectoryA(systempath, MAX_PATH))
		strcpy(systempath, defaultpath);
	SetCurrentDirectoryA(systempath);
}

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	if (fdwReason == DLL_PROCESS_ATTACH) {
		ResetCurrentDirectory();
		DisableThreadLibraryCalls(hinstDLL);
		timdrvOverrideSFSettingLoad();
		hDllInstance = hinstDLL;
		drvDllPortId = GetDllPortId(hDllInstance);
	} else if (fdwReason == DLL_PROCESS_DETACH) {
		;
	}
	return TRUE;
}

STDAPI DllCanUnloadNow(void)
{
	return S_OK;
}

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID * ppv)
{
	return S_OK;
}

STDAPI DllRegisterServer(void)
{
	return S_OK;
}

STDAPI DllUnregisterServer(void)
{
	return S_OK;
}


extern long cfgMaxVolume;
extern long saveVolume;

extern void OpenMidiVolume(void);
extern void CloseMidiVolume(void);
extern int GetMidiVolume(void);
extern void SetMidiVolume(int newvolume);
extern void MidiMidiVolume(void);
///r
extern DWORD processPriority;
extern DWORD syn_ThreadPriority;

//unsigned __stdcall threadfunc2(LPVOID lpV);
//STDAPI_(LONG) DefDriverProc(DWORD dwDriverId, HDRVR hdrvr, UINT msg, LONG lParam1, LONG lParam2);
//STDAPI_(LONG) DriverProc(DWORD dwDriverId, HDRVR hdrvr, UINT msg, LONG lParam1, LONG lParam2)
STDAPI_(LRESULT) DriverProc(DWORD_PTR dwDriverId, HDRVR hdrvr, UINT msg, LPARAM lParam1, LPARAM lParam2)
{
	switch (msg) {

	case DRV_OPEN:
		hdrvrInstance = hdrvr;
		return DRV_OK;

	case DRV_REMOVE:
		if (modm_closed == 0) {
			int maxloop = 500;

			stop_thread = 1;    //why thread can't stop by this????
			while (stop_thread != 0 && maxloop-- > 0) Sleep(10);
#if defined(RTSYN_MULTITHREAD)
			if (stop_thread == 0) {
				stop_rtthread = 1;
				while (stop_rtthread != 0 && maxloop-- > 0) Sleep(10);
			}
			if (stop_thread != 0) TerminateThread(hRtsynThread, FALSE);
			if (stop_rtthread != 0) TerminateThread(hCalcThread, FALSE);
			CloseHandle(hRtsynThread);
			CloseHandle(hCalcThread);
#else
			if (stop_thread != 0) TerminateThread(hRtsynThread, FALSE);
			CloseHandle(hRtsynThread);
#endif /* RTSYN_MULTITHREAD */

			SetPriorityClass(GetCurrentProcess(), processPriority);
		}
		DeleteCriticalSection(&mim_section);
		CloseMidiVolume();
		return DRV_OK;

	case DRV_LOAD:
	//	processPriority = GetPriorityClass(GetCurrentProcess());
		InitializeCriticalSection(&mim_section);
		OpenMidiVolume();
		return DRV_OK;
	case DRV_CONFIGURE:
#ifdef DRV_GUI
		open_config_gui();
#endif
		return DRV_OK;
	case DRV_CLOSE:
	case DRV_DISABLE:
	case DRV_ENABLE:
	case DRV_EXITSESSION:
	case DRV_FREE:
	case DRV_INSTALL:
	case DRV_POWER:
	case DRV_QUERYCONFIGURE:
	default:
		return DRV_OK;
	}
	return DefDriverProc(dwDriverId, hdrvr, msg, lParam1, lParam2);
}

static HRESULT modGetCaps(PVOID capsPtr, DWORD capsSize)
{
	MIDIOUTCAPSA *myCapsA;
	MIDIOUTCAPSW *myCapsW;
	MIDIOUTCAPS2A *myCaps2A;
	MIDIOUTCAPS2W *myCaps2W;
#ifdef _WIN64
	CHAR synthName[MAXPNAMELEN] = "Timidity++ Driver x64\0\0\0\0"; // 21
	WCHAR synthNameW[MAXPNAMELEN] = L"Timidity++ Driver x64\0\0\0\0"; // 21
#else
	CHAR synthName[MAXPNAMELEN] = "Timidity++ Driver\0\0\0\0"; // 17
	WCHAR synthNameW[MAXPNAMELEN] = L"Timidity++ Driver\0\0\0\0"; // 17
#endif
	CONST DWORD cdwSupportFlags = MIDICAPS_VOLUME;

	if (drvDllPortId != -1) {
		synthName[strlen(synthName)] = ' ';
		synthName[strlen(synthName)] = '0' + drvDllPortId;
		synthNameW[wcslen(synthNameW)] = ' ';
		synthNameW[wcslen(synthNameW)] = '0' + drvDllPortId;
	}
///r
	strcat(synthName, " [unko]\0");
	wcscat(synthNameW, L" [unko]\0");

	switch (capsSize) {
	case (sizeof(MIDIOUTCAPSA)):
		myCapsA = (MIDIOUTCAPSA*)capsPtr;
		myCapsA->wMid = 0xffff; //MM_UNMAPPED
		myCapsA->wPid = 0xffff; //MM_PID_UNMAPPED
		CopyMemory(myCapsA->szPname, synthName, sizeof(synthName));
		myCapsA->wTechnology = MOD_MIDIPORT;
		myCapsA->vDriverVersion = 0x0090;
		myCapsA->wVoices = 0;
		myCapsA->wNotes = 0;
		myCapsA->wChannelMask = 0xffff;
		myCapsA->dwSupport = cdwSupportFlags;
		return MMSYSERR_NOERROR;

	case (sizeof(MIDIOUTCAPSW)):
		myCapsW = (MIDIOUTCAPSW*)capsPtr;
		myCapsW->wMid = 0xffff;
		myCapsW->wPid = 0xffff;
		CopyMemory(myCapsW->szPname, synthNameW, sizeof(synthNameW));
		myCapsW->wTechnology = MOD_MIDIPORT;
		myCapsW->vDriverVersion = 0x0090;
		myCapsW->wVoices = 0;
		myCapsW->wNotes = 0;
		myCapsW->wChannelMask = 0xffff;
		myCapsW->dwSupport = cdwSupportFlags;
		return MMSYSERR_NOERROR;

	case (sizeof(MIDIOUTCAPS2A)):
		myCaps2A = (MIDIOUTCAPS2A*)capsPtr;
		myCaps2A->wMid = 0xffff;
		myCaps2A->wPid = 0xffff;
		CopyMemory(myCaps2A->szPname, synthName, sizeof(synthName));
		myCaps2A->wTechnology = MOD_MIDIPORT;
		myCaps2A->vDriverVersion = 0x0090;
		myCaps2A->wVoices = 0;
		myCaps2A->wNotes = 0;
		myCaps2A->wChannelMask = 0xffff;
		myCaps2A->dwSupport = cdwSupportFlags;
		myCaps2A->ManufacturerGuid = CLSID_tim_synth;
		myCaps2A->ProductGuid = CLSID_tim_synth;
		myCaps2A->NameGuid = CLSID_tim_synth;
		return MMSYSERR_NOERROR;

	case (sizeof(MIDIOUTCAPS2W)):
		myCaps2W = (MIDIOUTCAPS2W*)capsPtr;
		myCaps2W->wMid = 0xffff;
		myCaps2W->wPid = 0xffff;
		CopyMemory(myCaps2W->szPname, synthNameW, sizeof(synthNameW));
		myCaps2W->wTechnology = MOD_MIDIPORT;
		myCaps2W->vDriverVersion = 0x0090;
		myCaps2W->wVoices = 0;
		myCaps2W->wNotes = 0;
		myCaps2W->wChannelMask = 0xffff;
		myCaps2W->dwSupport = cdwSupportFlags;
		myCaps2W->ManufacturerGuid = CLSID_tim_synth;
		myCaps2W->ProductGuid = CLSID_tim_synth;
		myCaps2W->NameGuid = CLSID_tim_synth;
		return MMSYSERR_NOERROR;

	default:
		return MMSYSERR_ERROR;
	}
	return MMSYSERR_ERROR;
}


const char *argv_readOnly[] = { "timidity", "-iW", "-c", "DUMMY" };
#define TIMDRV_ARGC 4
#define TIMDRV_CFGC 3

#define timdrv_safe_free(TP) \
	if (TP) { free(TP); TP = NULL; }

static unsigned __stdcall threadfunc(LPVOID lpV);

static int initialize_timiwp_main(void)
{
	unsigned int thrdaddr;
	HANDLE hThread = NULL;
	int argc, i;
	char *argv[TIMDRV_ARGC] = { NULL };
	int cont = 0;
	const int retry_waitms = 200;
	const int max_continue = 25; /* 25 x 200ms = 5000ms */
	int opend = 0;
	;
	Sleep(retry_waitms / 2);
	while (opend == 0 && cont < max_continue) {
		argc = TIMDRV_ARGC;
		for (i = 0; i < TIMDRV_ARGC; i++) {
			timdrv_safe_free(argv[i]);
			argv[i] = safe_strdup(argv_readOnly[i]);
		}
		timdrv_safe_free(argv[TIMDRV_CFGC]);
		argv[TIMDRV_CFGC] = CreateTiMidityConfigPath();
		if (!argv[TIMDRV_CFGC]) {
			argc -= 2;
			timdrv_safe_free(argv[TIMDRV_CFGC - 1]);
			timdrv_safe_free(argv[TIMDRV_CFGC]);
		}

		if (0 == timiwp_main_ini(argc, argv)) {
			rtsyn_init();
#if defined(RTSYN_MULTITHREAD)
			hThread = (HANDLE)_beginthreadex(NULL, 0, threadfunc, 0, 0, &thrdaddr);
			SetPriorityClass(hThread, processPriority);
			SetThreadPriority(hThread, syn_ThreadPriority);
#endif /* RTSYN_MULTITHREAD */
			opend = 1;
		}
		cfgMaxVolume = amplification; // added
		for (i = 0; i < TIMDRV_ARGC; i++) {
			timdrv_safe_free(argv[i]);
		}
		Sleep(retry_waitms);
		cont++;
	}

#if defined(RTSYN_MULTITHREAD)
	hCalcThread = hThread;
#endif /* RTSYN_MULTITHREAD */

	return opend;
}


#if defined(RTSYN_MULTITHREAD) || defined(RTSYN_THREAD)

struct evbuf_t {
	UINT uMsg;
	double event_time;
	DWORD_PTR dwParam1;
	DWORD_PTR dwParam2;
	int exlen;
	BYTE *sysexbuffer;
};
#define EVBUFF_SIZE 512
static struct evbuf_t evbuf[EVBUFF_SIZE];
static UINT evbwpoint = 0;
static UINT evbrpoint = 0;

static int timsyn_buf_check(void)
{
	int retval;
	EnterCriticalSection(&mim_section);
	retval = (evbrpoint != evbwpoint) ? ~0 :  0;
	LeaveCriticalSection(&mim_section);
	return retval;
}

static int timsyn_play_some_data(void)
{
	UINT uMsg;
	DWORD_PTR dwParam1;
	DWORD_PTR dwParam2;
	UINT evbpoint;
	MIDIHDR *IIMidiHdr;
	int exlen;
	BYTE *sysexbuffer;
	int played;
	double event_time;

	played = 0;
	if (!timsyn_buf_check()) {
		played = ~0;
		return played;
	}

	do {
		EnterCriticalSection(&mim_section);
		evbpoint = evbrpoint;
		if (++evbrpoint >= EVBUFF_SIZE)
			evbrpoint -= EVBUFF_SIZE;

		uMsg = evbuf[evbpoint].uMsg;
		dwParam1 = evbuf[evbpoint].dwParam1;
		dwParam2 = evbuf[evbpoint].dwParam2;
		event_time = evbuf[evbpoint].event_time;
		exlen = evbuf[evbpoint].exlen;
		sysexbuffer = evbuf[evbpoint].sysexbuffer;

#ifdef DEBUG_OUTPUT_PARSESHRT
		if (!exlen) {
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_PARSESHRT, "a");
	if (logfile) {
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "modm shrt");
		fprintf(logfile, " %lu %lu %06x",
			evbpoint, uMsg, dwParam1);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
		}
#endif /* DEBUG_OUTPUT_PARSESHRT */
#ifdef DEBUG_OUTPUT_PARSELONG
		if (exlen) {
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_PARSELONG, "a");
	if (logfile) {
		int i;
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "modm long");
		for (i = 0; i < exlen; i++)
			fprintf(logfile, " %02x",
				(BYTE)sysexbuffer[i]);
		fprintf(logfile, "\n");
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "midihdr flags");
		IIMidiHdr = (LPMIDIHDR) dwParam1;
		fprintf(logfile, " %02x",
			(BYTE)IIMidiHdr->dwFlags);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
		}
#endif /* DEBUG_OUTPUT_PARSELONG */
		LeaveCriticalSection(&mim_section);

		switch (uMsg) {
		case MODM_DATA:
			rtsyn_play_one_data(0, dwParam1, event_time);
			break;

		case MODM_LONGDATA:
			IIMidiHdr = (LPMIDIHDR) dwParam1;
			rtsyn_play_one_sysex(sysexbuffer, exlen, event_time);
			free(sysexbuffer);
			break;

		default:
			break;
		}
	} while (timsyn_buf_check());

	return played;
}
#endif /* defined(RTSYN_MULTITHREAD) || defined(RTSYN_THREAD) */

#if defined(RTSYN_MULTITHREAD)
static unsigned __stdcall threadfunc(LPVOID lpV)
{
#ifdef DEBUG_OUTPUT_STATUS
	{
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_STATUS, "a");
	if (logfile) {
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "into");
		fputs(" ", logfile);
		fputs("threadfunc()", logfile);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
	}
#endif /* DEBUG_OUTPUT_STATUS */

	while (stop_thread == 0) {
		Sleep(1);
		timsyn_play_some_data();
		rtsyn_play_calculate();
	}
	stop_thread = 0;
	_endthreadex(0);
	return 0;
}

static unsigned __stdcall threadfunc2(LPVOID lpV)
{
#ifdef DEBUG_OUTPUT_STATUS
	{
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_STATUS, "a");
	if (logfile) {
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "into");
		fputs(" ", logfile);
		fputs("threadfunc2()", logfile);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
	}
#endif /* DEBUG_OUTPUT_STATUS */

//	initialize_timiwp_main();

	while (stop_rtthread == 0) {
		Sleep(10);
	}

	rtsyn_stop_playing();
	rtsyn_close();
	timiwp_main_close();
	stop_rtthread = 0;
	_endthreadex(0);
	return 0;
}

#else /* RTSYN_MULTITHREAD */

static unsigned __stdcall threadfunc(LPVOID lpV)
{
#ifdef DEBUG_OUTPUT_STATUS
	{
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_STATUS, "a");
	if (logfile) {
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "into threadfunc()");
		fputs(" ", logfile);
		fputs("threadfunc()", logfile);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
	}
#endif /* DEBUG_OUTPUT_STATUS */

//	initialize_timiwp_main(); // modMessage() case MODM_OPEN: Əd c212

	while (stop_thread == 0) {
#if defined(RTSYN_THREAD)
		Sleep(1);
		timsyn_play_some_data();
		rtsyn_play_calculate();
#else
		Sleep(1);
		EnterCriticalSection(&mim_section);
		rtsyn_play_calculate();
		LeaveCriticalSection(&mim_section);
#endif
	}

	rtsyn_stop_playing();
	rtsyn_close();
	timiwp_main_close();
	stop_thread = 0;
	_endthreadex(0);
	return 0;
}

#endif /* RTSYN_MULTITHREAD */

static void modCallback(UINT uMsg, DWORD_PTR dwParam1, DWORD_PTR dwParam2)
{
//	DWORD_PTR dwUser, dwSend1, dwSend2;
	DWORD_PTR dwCallback = mid_desc.dwCallback;
	DWORD_PTR dwInstance = mid_desc.dwInstance;

	if (!dwCallback) {
	    return;
	}
/*
	switch (uMsg) {
	case MM_MOM_DONE:
	    dwUser = mid_desc.dwInstance;
	    dwSend1 = (DWORD_PTR)(mid_desc.hMidi);
	    dwSend2 = dwParam1;
	    break;
	default:
	    dwUser = mid_desc.dwInstance;
	    dwSend1 = (DWORD_PTR)(mid_desc.hMidi);
	    dwSend2 = 0;
	    break;
	}
*/

	switch (dwOpenFlags & CALLBACK_TYPEMASK) {
	case CALLBACK_NULL:
	    break;
	case CALLBACK_WINDOW:
	    {
//		HWND hWnd = (HWND)(mid_desc.dwCallback);
//		PostMessage(hWnd, uMsg, (WPARAM)(dwSend1), (LPARAM)(dwSend2));
		DriverCallback(dwCallback, DCB_WINDOW, hdrvrInstance, uMsg, dwInstance, dwParam1, dwParam2);
	    }
	    break;
	case CALLBACK_FUNCTION:
	    {
//		typedef void (CALLBACK *MIDIOUTPROC)(HMIDIOUT, UINT, DWORD_PTR, DWORD_PTR, DWORD_PTR);
//		MIDIOUTPROC MidiOutProc = (MIDIOUTPROC)(mid_desc.dwCallback);
//		(*MidiOutProc)((HMIDIOUT)mid_desc.hMidi, uMsg, mid_desc.dwInstance, dwSend1, dwSend2);
		DriverCallback(dwCallback, DCB_FUNCTION, hdrvrInstance, uMsg, dwInstance, dwParam1, dwParam2);
	    }
	    break;
	case CALLBACK_THREAD:
	    {
//		DWORD dwThread = (DWORD)(mid_desc.dwCallback);
//		PostThreadMessage(dwThread, uMsg, (WPARAM)(dwSend1), (LPARAM)(dwSend2));
		DriverCallback(dwCallback, DCB_TASK, hdrvrInstance, uMsg, dwInstance, dwParam1, dwParam2);
	    }
	    break;
	case CALLBACK_EVENT:
	    {
//		HANDLE hEvent = (HANDLE)(mid_desc.dwCallback);
//		SetEvent(hEvent);
		DriverCallback(dwCallback, DCB_EVENT, hdrvrInstance, uMsg, dwInstance, dwParam1, dwParam2);
	    }
	    break;
	default:
	    {
		/* not implemented */
	    }
	    break;
	}

	return;
}

STDAPI_(DWORD) modMessage(UINT uDeviceID, UINT uMsg, DWORD_PTR dwUser, DWORD_PTR dwParam1, DWORD_PTR dwParam2)
{
	MIDIHDR *IIMidiHdr;
	int exlen = 0;
	unsigned int thrdaddr;
#if defined(RTSYN_MULTITHREAD) || defined(RTSYN_THREAD)
	UINT evbpoint;
	BYTE *sysexbuffer = NULL;
#endif /* RTSYN_MULTITHREAD */

#ifdef DEBUG_OUTPUT_STATUS
	{
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_STATUS, "a");
	if (logfile) {
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "modmsg");
		fprintf(logfile, " %u %u %lu %lu %lu",
			uDeviceID, uMsg,
			(ULONG)dwUser, (ULONG)dwParam1, (ULONG)dwParam2);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
	}
#endif /* DEBUG_OUTPUT_STATUS */

	switch (uMsg) {

	case MODM_OPEN:
		OpenCount++;
		if (OpenCount == 1 && modm_closed  == 1) {
			ZeroMemory(&mid_desc, sizeof(MIDIOPENDESC));
			if (dwParam1) {
				CopyMemory(&mid_desc, (LPMIDIOPENDESC) dwParam1, sizeof(MIDIOPENDESC));
			}
			dwOpenFlags = (DWORD)dwParam2;

		//	processPriority = GetPriorityClass(GetCurrentProcess());
			SetPriorityClass(GetCurrentProcess(), processPriority);

#if defined(RTSYN_MULTITHREAD)
			hCalcThread = NULL;
			hRtsynThread = (HANDLE)_beginthreadex(NULL, 0, threadfunc2, 0, 0, &thrdaddr);
			if (!hRtsynThread) {
				OpenCount--;
				return MMSYSERR_NOMEM;
			}
#else
			if (!initialize_timiwp_main()) {
				OpenCount--;
				return MMSYSERR_NOTENABLED;
			}

			hRtsynThread = (HANDLE)_beginthreadex(NULL, 0, threadfunc, 0, 0, &thrdaddr);
			if (!hRtsynThread) {
				OpenCount--;
				return MMSYSERR_NOMEM;
			}
			SetThreadPriority(hRtsynThread, syn_ThreadPriority);
#endif /* RTSYN_MULTITHREAD */
			modCallback(MM_MOM_OPEN, dwParam1, dwParam2);
			modm_closed = 0;
		}
		SetPriorityClass(GetCurrentProcess(), processPriority);
		return MMSYSERR_NOERROR;
		break;

	case MODM_PREPARE:
		{
			MIDIHDR hdr;
			IIMidiHdr = (LPMIDIHDR) dwParam1;
			ZeroMemory(&hdr, sizeof(MIDIHDR));
			CopyMemory(&hdr, IIMidiHdr, min(dwParam2, sizeof(MIDIHDR)));
#ifdef DEBUG_OUTPUT_STATUS
			{
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_STATUS, "a");
	if (logfile) {
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "modm prepare");
		fprintf(logfile, " 0x%p %lu %lu %lu 0x%04x",
			hdr.lpData, hdr.dwBufferLength,
			hdr.dwBytesRecorded,
			(ULONG)hdr.dwUser, hdr.dwFlags);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
			}
#endif /* DEBUG_OUTPUT_STATUS */
#if 0
			IIMidiHdr->dwFlags &= ~MHDR_DONE;
			IIMidiHdr->dwFlags |= MHDR_PREPARED;
			return MMSYSERR_NOERROR;
#endif
		}
		return MMSYSERR_NOTSUPPORTED;
		break;

	case MODM_UNPREPARE:
		{
			MIDIHDR hdr;
			IIMidiHdr = (LPMIDIHDR) dwParam1;
			ZeroMemory(&hdr, sizeof(MIDIHDR));
			CopyMemory(&hdr, IIMidiHdr, min(dwParam2, sizeof(MIDIHDR)));
#ifdef DEBUG_OUTPUT_STATUS
			{
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_STATUS, "a");
	if (logfile) {
		fprintf(logfile, "[%.3f] %s :",
			get_current_calender_time(), "modm unprepare");
		fprintf(logfile, " 0x%p %lu %lu %lu 0x%04x",
			hdr.lpData, hdr.dwBufferLength,
			hdr.dwBytesRecorded,
			(ULONG)hdr.dwUser, hdr.dwFlags);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
			}
#endif /* DEBUG_OUTPUT_STATUS */
#if 0
			IIMidiHdr->dwFlags &= ~MHDR_PREPARED;
			return MMSYSERR_NOERROR;
#endif
		}
		return MMSYSERR_NOTSUPPORTED;
		break;

	case MODM_GETDEVCAPS:
		return modGetCaps((PVOID)dwParam1, dwParam2);
		break;

	case MODM_LONGDATA:
	    IIMidiHdr = (LPMIDIHDR)dwParam1;
	    if (!(IIMidiHdr->dwFlags & MHDR_PREPARED)) return MIDIERR_UNPREPARED;

	    exlen = (int)IIMidiHdr->dwBufferLength;
	    if (IIMidiHdr->dwBytesRecorded &&
		IIMidiHdr->dwBytesRecorded <= IIMidiHdr->dwBufferLength) {
		exlen = (int)IIMidiHdr->dwBytesRecorded;
	    }

#if defined(RTSYN_MULTITHREAD) || defined(RTSYN_THREAD)
	    IIMidiHdr->dwFlags &= ~MHDR_DONE;
	    IIMidiHdr->dwFlags |= MHDR_INQUEUE;

	    if (NULL == (sysexbuffer = (BYTE*) malloc(exlen))) {
		return MMSYSERR_NOMEM;
	    } else {
		CopyMemory(sysexbuffer, IIMidiHdr->lpData, exlen);
	    }
	    IIMidiHdr->dwFlags &= ~MHDR_INQUEUE;
	    IIMidiHdr->dwFlags |= MHDR_DONE;
	    modCallback(MM_MOM_DONE, dwParam1, dwParam2);

	    /* go to MODM_DATA block */
#else /* RTSYN_MULTITHREAD */
	    {
		const double event_time = get_current_calender_time();

		EnterCriticalSection(&mim_section);
#ifdef DEBUG_OUTPUT_PARSELONG
		if (exlen) {
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_PARSELONG, "a");
	if (logfile) {
		int i;
		fprintf(logfile, "[%.3f] %s :",
			event_time, "long");
		for (i = 0; i < exlen; i++)
			fprintf(logfile, " %02x",
				(BYTE)IIMidiHdr->lpData[i]);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
		}
#endif /* DEBUG_OUTPUT_PARSELONG */
		rtsyn_play_one_sysex(IIMidiHdr->lpData, exlen, event_time);
		LeaveCriticalSection(&mim_section);

		IIMidiHdr->dwFlags &= ~MHDR_INQUEUE;
		IIMidiHdr->dwFlags |= MHDR_DONE;
		modCallback(MM_MOM_DONE, dwParam1, dwParam2);
		return MMSYSERR_NOERROR;
		break;
	    }
#endif /* RTSYN_MULTITHREAD */

	case MODM_DATA:
	    EnterCriticalSection(&mim_section);
	    {
		const double event_time = get_current_calender_time();
#if defined(RTSYN_MULTITHREAD) || defined(RTSYN_THREAD)
		evbpoint = evbwpoint;
		if (++evbwpoint >= EVBUFF_SIZE)
		    evbwpoint -= EVBUFF_SIZE;
		evbuf[evbpoint].uMsg = uMsg;
		evbuf[evbpoint].event_time = event_time;
		evbuf[evbpoint].dwParam1 = dwParam1;
		evbuf[evbpoint].dwParam2 = dwParam2;
		evbuf[evbpoint].exlen = exlen;
		evbuf[evbpoint].sysexbuffer = sysexbuffer;
#else /* RTSYN_MULTITHREAD */
#ifdef DEBUG_OUTPUT_PARSESHRT
		{
	FILE *logfile;
	logfile = fopen(DEBUG_OUTPUT_PARSESHRT, "a");
	if (logfile) {
		fprintf(logfile, "[%.3f] %s :",
			event_time, "shrt");
		fprintf(logfile, " %lu %06x",
			uMsg, dwParam1);
		fprintf(logfile, "\n");
		fclose(logfile);
	}
		}
#endif /* DEBUG_OUTPUT_PARSESHRT */
		rtsyn_play_one_data(0, dwParam1, event_time);
#endif /* RTSYN_MULTITHREAD */
	    }
	    LeaveCriticalSection(&mim_section);
	    return MMSYSERR_NOERROR;
	    break;

	case MODM_GETNUMDEVS:
		return 0x1;
		break;

	case MODM_GETVOLUME:
		if (dwParam1 && !IsBadWritePtr((LPVOID) dwParam1, sizeof(DWORD))) {
			DWORD *result;
			WORD volume;
			volume = GetMidiVolume() * DIV_100 * (M_16BIT - 1);
			result = (DWORD*) dwParam1;
			*result = MAKELONG(volume, volume);
		}
		return MMSYSERR_NOERROR;
		break;

	case MODM_SETVOLUME:
		SetMidiVolume(LOWORD(dwParam1) * DIV_16BIT * 100); /* left vol */
		return MMSYSERR_NOERROR;
		break;

	case MODM_CLOSE:
		if (stop_thread != 0) return MIDIERR_STILLPLAYING;
#if defined(RTSYN_MULTITHREAD)
		if (stop_rtthread != 0) return MIDIERR_STILLPLAYING;
#endif /* RTSYN_MULTITHREAD */
		--OpenCount;
		if (OpenCount < 0) {
			OpenCount = 0;
			return MMSYSERR_NOTENABLED;
		}
		modCallback(MM_MOM_CLOSE, dwParam1, dwParam2);
		return MMSYSERR_NOERROR;
		break;

	case MODM_RESET:
		//rtsyn_normal_reset();
		return MMSYSERR_NOERROR;
		break;

	default:
		return MMSYSERR_NOERROR;
		break;
	}
}


