/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    audio_cnv.c

    Audio conversion for U-law, A-law, linear pcm 16-bit.
    Final update: Thu Feb 22 1996
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include "timidity.h"
#include "audio_cnv.h"

/* audio_cnv.c
 * audio U-law, A-law, linear pcm 16-bit conversions.
 *
 * Final update: Thu Feb 22 1996
 */

#define TABLE_SIZE8  256
#define TABLE_SIZE14 16384

#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable: 4310)  /* cast truncates constant value */
#endif

const char u2c_table[TABLE_SIZE8] = {
(char)0x82,	(char)0x86,	(char)0x8a,	(char)0x8e,	(char)0x92,	(char)0x96,	(char)0x9a,	(char)0x9e,
(char)0xa2,	(char)0xa6,	(char)0xaa,	(char)0xae,	(char)0xb2,	(char)0xb6,	(char)0xba,	(char)0xbe,
(char)0xc1,	(char)0xc3,	(char)0xc5,	(char)0xc7,	(char)0xc9,	(char)0xcb,	(char)0xcd,	(char)0xcf,
(char)0xd1,	(char)0xd3,	(char)0xd5,	(char)0xd7,	(char)0xd9,	(char)0xdb,	(char)0xdd,	(char)0xdf,
(char)0xe0,	(char)0xe1,	(char)0xe2,	(char)0xe3,	(char)0xe4,	(char)0xe5,	(char)0xe6,	(char)0xe7,
(char)0xe8,	(char)0xe9,	(char)0xea,	(char)0xeb,	(char)0xec,	(char)0xed,	(char)0xee,	(char)0xef,
(char)0xf0,	(char)0xf1,	(char)0xf1,	(char)0xf2,	(char)0xf2,	(char)0xf3,	(char)0xf3,	(char)0xf4,
(char)0xf4,	(char)0xf5,	(char)0xf5,	(char)0xf6,	(char)0xf6,	(char)0xf7,	(char)0xf7,	(char)0xf8,
(char)0xf8,	(char)0xf8,	(char)0xf9,	(char)0xf9,	(char)0xf9,	(char)0xf9,	(char)0xfa,	(char)0xfa,
(char)0xfa,	(char)0xfa,	(char)0xfb,	(char)0xfb,	(char)0xfb,	(char)0xfb,	(char)0xfc,	(char)0xfc,
(char)0xfc,	(char)0xfc,	(char)0xfc,	(char)0xfc,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,
(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,
(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,
(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,
(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,
(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0x00,
(char)0x7e,	(char)0x79,	(char)0x75,	(char)0x71,	(char)0x6d,	(char)0x69,	(char)0x65,	(char)0x61,
(char)0x5d,	(char)0x59,	(char)0x55,	(char)0x51,	(char)0x4d,	(char)0x49,	(char)0x45,	(char)0x41,
(char)0x3e,	(char)0x3c,	(char)0x3a,	(char)0x38,	(char)0x36,	(char)0x34,	(char)0x32,	(char)0x30,
(char)0x2e,	(char)0x2c,	(char)0x2a,	(char)0x28,	(char)0x26,	(char)0x24,	(char)0x22,	(char)0x20,
(char)0x1f,	(char)0x1e,	(char)0x1d,	(char)0x1c,	(char)0x1b,	(char)0x1a,	(char)0x19,	(char)0x18,
(char)0x17,	(char)0x16,	(char)0x15,	(char)0x14,	(char)0x13,	(char)0x12,	(char)0x11,	(char)0x10,
(char)0x0f,	(char)0x0e,	(char)0x0e,	(char)0x0d,	(char)0x0d,	(char)0x0c,	(char)0x0c,	(char)0x0b,
(char)0x0b,	(char)0x0a,	(char)0x0a,	(char)0x09,	(char)0x09,	(char)0x08,	(char)0x08,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00};

const char c2u_table[TABLE_SIZE8] = {
(char)0xf0,	(char)0xe0,	(char)0xd8,	(char)0xd0,	(char)0xcc,	(char)0xc8,	(char)0xc4,	(char)0xc0,
(char)0xbe,	(char)0xbc,	(char)0xba,	(char)0xb8,	(char)0xb6,	(char)0xb4,	(char)0xb2,	(char)0xb0,
(char)0xaf,	(char)0xae,	(char)0xad,	(char)0xac,	(char)0xab,	(char)0xaa,	(char)0xa9,	(char)0xa8,
(char)0xa7,	(char)0xa6,	(char)0xa5,	(char)0xa4,	(char)0xa3,	(char)0xa2,	(char)0xa1,	(char)0xa0,
(char)0x9f,	(char)0x9f,	(char)0x9e,	(char)0x9e,	(char)0x9d,	(char)0x9d,	(char)0x9c,	(char)0x9c,
(char)0x9b,	(char)0x9b,	(char)0x9a,	(char)0x9a,	(char)0x99,	(char)0x99,	(char)0x98,	(char)0x98,
(char)0x97,	(char)0x97,	(char)0x96,	(char)0x96,	(char)0x95,	(char)0x95,	(char)0x94,	(char)0x94,
(char)0x93,	(char)0x93,	(char)0x92,	(char)0x92,	(char)0x91,	(char)0x91,	(char)0x90,	(char)0x90,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x10,	(char)0x10,	(char)0x11,	(char)0x11,	(char)0x12,	(char)0x12,	(char)0x13,	(char)0x13,
(char)0x14,	(char)0x14,	(char)0x15,	(char)0x15,	(char)0x16,	(char)0x16,	(char)0x17,	(char)0x17,
(char)0x18,	(char)0x18,	(char)0x19,	(char)0x19,	(char)0x1a,	(char)0x1a,	(char)0x1b,	(char)0x1b,
(char)0x1c,	(char)0x1c,	(char)0x1d,	(char)0x1d,	(char)0x1e,	(char)0x1e,	(char)0x1f,	(char)0x1f,
(char)0x20,	(char)0x21,	(char)0x22,	(char)0x23,	(char)0x24,	(char)0x25,	(char)0x26,	(char)0x27,
(char)0x28,	(char)0x29,	(char)0x2a,	(char)0x2b,	(char)0x2c,	(char)0x2d,	(char)0x2e,	(char)0x2f,
(char)0x30,	(char)0x32,	(char)0x34,	(char)0x36,	(char)0x38,	(char)0x3a,	(char)0x3c,	(char)0x3d,
(char)0x3f,	(char)0x43,	(char)0x47,	(char)0x4b,	(char)0x4f,	(char)0x57,	(char)0x5f,	(char)0x6f};

const char c2a_table[TABLE_SIZE8] = {
(char)0xd5,	(char)0xc5,	(char)0xf5,	(char)0xfd,	(char)0xe5,	(char)0xe1,	(char)0xed,	(char)0xe9,
(char)0x95,	(char)0x97,	(char)0x91,	(char)0x93,	(char)0x9d,	(char)0x9f,	(char)0x99,	(char)0x9b,
(char)0x85,	(char)0x84,	(char)0x87,	(char)0x86,	(char)0x81,	(char)0x80,	(char)0x83,	(char)0x82,
(char)0x8d,	(char)0x8c,	(char)0x8f,	(char)0x8e,	(char)0x89,	(char)0x88,	(char)0x8b,	(char)0x8a,
(char)0xb5,	(char)0xb5,	(char)0xb4,	(char)0xb4,	(char)0xb7,	(char)0xb7,	(char)0xb6,	(char)0xb6,
(char)0xb1,	(char)0xb1,	(char)0xb0,	(char)0xb0,	(char)0xb3,	(char)0xb3,	(char)0xb2,	(char)0xb2,
(char)0xbd,	(char)0xbd,	(char)0xbc,	(char)0xbc,	(char)0xbf,	(char)0xbf,	(char)0xbe,	(char)0xbe,
(char)0xb9,	(char)0xb9,	(char)0xb8,	(char)0xb8,	(char)0xbb,	(char)0xbb,	(char)0xba,	(char)0xba,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x3a,	(char)0x3a,	(char)0x3b,	(char)0x3b,	(char)0x38,	(char)0x38,	(char)0x39,	(char)0x39,
(char)0x3e,	(char)0x3e,	(char)0x3f,	(char)0x3f,	(char)0x3c,	(char)0x3c,	(char)0x3d,	(char)0x3d,
(char)0x32,	(char)0x32,	(char)0x33,	(char)0x33,	(char)0x30,	(char)0x30,	(char)0x31,	(char)0x31,
(char)0x36,	(char)0x36,	(char)0x37,	(char)0x37,	(char)0x34,	(char)0x34,	(char)0x35,	(char)0x35,
(char)0x0a,	(char)0x0b,	(char)0x08,	(char)0x09,	(char)0x0e,	(char)0x0f,	(char)0x0c,	(char)0x0d,
(char)0x02,	(char)0x03,	(char)0x00,	(char)0x01,	(char)0x06,	(char)0x07,	(char)0x04,	(char)0x05,
(char)0x1a,	(char)0x18,	(char)0x1e,	(char)0x1c,	(char)0x12,	(char)0x10,	(char)0x16,	(char)0x14,
(char)0x6a,	(char)0x6e,	(char)0x62,	(char)0x66,	(char)0x7a,	(char)0x72,	(char)0x4a,	(char)0x5a};

const char a2c_table[TABLE_SIZE8] = {
(char)0xeb,	(char)0xec,	(char)0xe9,	(char)0xea,	(char)0xef,	(char)0xf0,	(char)0xed,	(char)0xee,
(char)0xe3,	(char)0xe4,	(char)0xe1,	(char)0xe2,	(char)0xe7,	(char)0xe8,	(char)0xe5,	(char)0xe6,
(char)0xf6,	(char)0xf6,	(char)0xf5,	(char)0xf5,	(char)0xf8,	(char)0xf8,	(char)0xf7,	(char)0xf7,
(char)0xf2,	(char)0xf2,	(char)0xf1,	(char)0xf1,	(char)0xf4,	(char)0xf4,	(char)0xf3,	(char)0xf3,
(char)0xaa,	(char)0xae,	(char)0xa2,	(char)0xa6,	(char)0xba,	(char)0xbe,	(char)0xb2,	(char)0xb6,
(char)0x8a,	(char)0x8e,	(char)0x82,	(char)0x86,	(char)0x9a,	(char)0x9e,	(char)0x92,	(char)0x96,
(char)0xd5,	(char)0xd7,	(char)0xd1,	(char)0xd3,	(char)0xdd,	(char)0xdf,	(char)0xd9,	(char)0xdb,
(char)0xc5,	(char)0xc7,	(char)0xc1,	(char)0xc3,	(char)0xcd,	(char)0xcf,	(char)0xc9,	(char)0xcb,
(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,
(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0xfb,	(char)0xfb,	(char)0xfb,	(char)0xfb,	(char)0xfc,	(char)0xfc,	(char)0xfc,	(char)0xfc,
(char)0xf9,	(char)0xf9,	(char)0xf9,	(char)0xf9,	(char)0xfa,	(char)0xfa,	(char)0xfa,	(char)0xfa,
(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,
(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,
(char)0x15,	(char)0x14,	(char)0x17,	(char)0x16,	(char)0x11,	(char)0x10,	(char)0x13,	(char)0x12,
(char)0x1d,	(char)0x1c,	(char)0x1f,	(char)0x1e,	(char)0x19,	(char)0x18,	(char)0x1b,	(char)0x1a,
(char)0x0a,	(char)0x0a,	(char)0x0b,	(char)0x0b,	(char)0x08,	(char)0x08,	(char)0x09,	(char)0x09,
(char)0x0e,	(char)0x0e,	(char)0x0f,	(char)0x0f,	(char)0x0c,	(char)0x0c,	(char)0x0d,	(char)0x0d,
(char)0x56,	(char)0x52,	(char)0x5e,	(char)0x5a,	(char)0x46,	(char)0x42,	(char)0x4e,	(char)0x4a,
(char)0x76,	(char)0x72,	(char)0x7e,	(char)0x7a,	(char)0x66,	(char)0x62,	(char)0x6e,	(char)0x6a,
(char)0x2b,	(char)0x29,	(char)0x2f,	(char)0x2d,	(char)0x23,	(char)0x21,	(char)0x27,	(char)0x25,
(char)0x3b,	(char)0x39,	(char)0x3f,	(char)0x3d,	(char)0x33,	(char)0x31,	(char)0x37,	(char)0x35,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03};

const short u2s_table[TABLE_SIZE8] = {
(short)0x8284,	(short)0x8684,	(short)0x8a84,	(short)0x8e84,	(short)0x9284,	(short)0x9684,	(short)0x9a84,	(short)0x9e84,
(short)0xa284,	(short)0xa684,	(short)0xaa84,	(short)0xae84,	(short)0xb284,	(short)0xb684,	(short)0xba84,	(short)0xbe84,
(short)0xc184,	(short)0xc384,	(short)0xc584,	(short)0xc784,	(short)0xc984,	(short)0xcb84,	(short)0xcd84,	(short)0xcf84,
(short)0xd184,	(short)0xd384,	(short)0xd584,	(short)0xd784,	(short)0xd984,	(short)0xdb84,	(short)0xdd84,	(short)0xdf84,
(short)0xe104,	(short)0xe204,	(short)0xe304,	(short)0xe404,	(short)0xe504,	(short)0xe604,	(short)0xe704,	(short)0xe804,
(short)0xe904,	(short)0xea04,	(short)0xeb04,	(short)0xec04,	(short)0xed04,	(short)0xee04,	(short)0xef04,	(short)0xf004,
(short)0xf0c4,	(short)0xf144,	(short)0xf1c4,	(short)0xf244,	(short)0xf2c4,	(short)0xf344,	(short)0xf3c4,	(short)0xf444,
(short)0xf4c4,	(short)0xf544,	(short)0xf5c4,	(short)0xf644,	(short)0xf6c4,	(short)0xf744,	(short)0xf7c4,	(short)0xf844,
(short)0xf8a4,	(short)0xf8e4,	(short)0xf924,	(short)0xf964,	(short)0xf9a4,	(short)0xf9e4,	(short)0xfa24,	(short)0xfa64,
(short)0xfaa4,	(short)0xfae4,	(short)0xfb24,	(short)0xfb64,	(short)0xfba4,	(short)0xfbe4,	(short)0xfc24,	(short)0xfc64,
(short)0xfc94,	(short)0xfcb4,	(short)0xfcd4,	(short)0xfcf4,	(short)0xfd14,	(short)0xfd34,	(short)0xfd54,	(short)0xfd74,
(short)0xfd94,	(short)0xfdb4,	(short)0xfdd4,	(short)0xfdf4,	(short)0xfe14,	(short)0xfe34,	(short)0xfe54,	(short)0xfe74,
(short)0xfe8c,	(short)0xfe9c,	(short)0xfeac,	(short)0xfebc,	(short)0xfecc,	(short)0xfedc,	(short)0xfeec,	(short)0xfefc,
(short)0xff0c,	(short)0xff1c,	(short)0xff2c,	(short)0xff3c,	(short)0xff4c,	(short)0xff5c,	(short)0xff6c,	(short)0xff7c,
(short)0xff88,	(short)0xff90,	(short)0xff98,	(short)0xffa0,	(short)0xffa8,	(short)0xffb0,	(short)0xffb8,	(short)0xffc0,
(short)0xffc8,	(short)0xffd0,	(short)0xffd8,	(short)0xffe0,	(short)0xffe8,	(short)0xfff0,	(short)0xfff8,	(short)0x0000,
(short)0x7d7c,	(short)0x797c,	(short)0x757c,	(short)0x717c,	(short)0x6d7c,	(short)0x697c,	(short)0x657c,	(short)0x617c,
(short)0x5d7c,	(short)0x597c,	(short)0x557c,	(short)0x517c,	(short)0x4d7c,	(short)0x497c,	(short)0x457c,	(short)0x417c,
(short)0x3e7c,	(short)0x3c7c,	(short)0x3a7c,	(short)0x387c,	(short)0x367c,	(short)0x347c,	(short)0x327c,	(short)0x307c,
(short)0x2e7c,	(short)0x2c7c,	(short)0x2a7c,	(short)0x287c,	(short)0x267c,	(short)0x247c,	(short)0x227c,	(short)0x207c,
(short)0x1efc,	(short)0x1dfc,	(short)0x1cfc,	(short)0x1bfc,	(short)0x1afc,	(short)0x19fc,	(short)0x18fc,	(short)0x17fc,
(short)0x16fc,	(short)0x15fc,	(short)0x14fc,	(short)0x13fc,	(short)0x12fc,	(short)0x11fc,	(short)0x10fc,	(short)0x0ffc,
(short)0x0f3c,	(short)0x0ebc,	(short)0x0e3c,	(short)0x0dbc,	(short)0x0d3c,	(short)0x0cbc,	(short)0x0c3c,	(short)0x0bbc,
(short)0x0b3c,	(short)0x0abc,	(short)0x0a3c,	(short)0x09bc,	(short)0x093c,	(short)0x08bc,	(short)0x083c,	(short)0x07bc,
(short)0x075c,	(short)0x071c,	(short)0x06dc,	(short)0x069c,	(short)0x065c,	(short)0x061c,	(short)0x05dc,	(short)0x059c,
(short)0x055c,	(short)0x051c,	(short)0x04dc,	(short)0x049c,	(short)0x045c,	(short)0x041c,	(short)0x03dc,	(short)0x039c,
(short)0x036c,	(short)0x034c,	(short)0x032c,	(short)0x030c,	(short)0x02ec,	(short)0x02cc,	(short)0x02ac,	(short)0x028c,
(short)0x026c,	(short)0x024c,	(short)0x022c,	(short)0x020c,	(short)0x01ec,	(short)0x01cc,	(short)0x01ac,	(short)0x018c,
(short)0x0174,	(short)0x0164,	(short)0x0154,	(short)0x0144,	(short)0x0134,	(short)0x0124,	(short)0x0114,	(short)0x0104,
(short)0x00f4,	(short)0x00e4,	(short)0x00d4,	(short)0x00c4,	(short)0x00b4,	(short)0x00a4,	(short)0x0094,	(short)0x0084,
(short)0x0078,	(short)0x0070,	(short)0x0068,	(short)0x0060,	(short)0x0058,	(short)0x0050,	(short)0x0048,	(short)0x0040,
(short)0x0038,	(short)0x0030,	(short)0x0028,	(short)0x0020,	(short)0x0018,	(short)0x0010,	(short)0x0008,	(short)0x0000};

const char s2u_table[TABLE_SIZE14] = {
(char)0xff,	(char)0xfe,	(char)0xfe,	(char)0xfd,	(char)0xfd,	(char)0xfc,	(char)0xfc,	(char)0xfb,
(char)0xfb,	(char)0xfa,	(char)0xfa,	(char)0xf9,	(char)0xf9,	(char)0xf8,	(char)0xf8,	(char)0xf7,
(char)0xf7,	(char)0xf6,	(char)0xf6,	(char)0xf5,	(char)0xf5,	(char)0xf4,	(char)0xf4,	(char)0xf3,
(char)0xf3,	(char)0xf2,	(char)0xf2,	(char)0xf1,	(char)0xf1,	(char)0xf0,	(char)0xf0,	(char)0xef,
(char)0xef,	(char)0xef,	(char)0xef,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xed,
(char)0xed,	(char)0xed,	(char)0xed,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xeb,
(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xe9,
(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe7,
(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe5,
(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe3,
(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe1,
(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xdf,
(char)0xdf,	(char)0xdf,	(char)0xdf,	(char)0xdf,	(char)0xdf,	(char)0xdf,	(char)0xdf,	(char)0xde,
(char)0xde,	(char)0xde,	(char)0xde,	(char)0xde,	(char)0xde,	(char)0xde,	(char)0xde,	(char)0xdd,
(char)0xdd,	(char)0xdd,	(char)0xdd,	(char)0xdd,	(char)0xdd,	(char)0xdd,	(char)0xdd,	(char)0xdc,
(char)0xdc,	(char)0xdc,	(char)0xdc,	(char)0xdc,	(char)0xdc,	(char)0xdc,	(char)0xdc,	(char)0xdb,
(char)0xdb,	(char)0xdb,	(char)0xdb,	(char)0xdb,	(char)0xdb,	(char)0xdb,	(char)0xdb,	(char)0xda,
(char)0xda,	(char)0xda,	(char)0xda,	(char)0xda,	(char)0xda,	(char)0xda,	(char)0xda,	(char)0xd9,
(char)0xd9,	(char)0xd9,	(char)0xd9,	(char)0xd9,	(char)0xd9,	(char)0xd9,	(char)0xd9,	(char)0xd8,
(char)0xd8,	(char)0xd8,	(char)0xd8,	(char)0xd8,	(char)0xd8,	(char)0xd8,	(char)0xd8,	(char)0xd7,
(char)0xd7,	(char)0xd7,	(char)0xd7,	(char)0xd7,	(char)0xd7,	(char)0xd7,	(char)0xd7,	(char)0xd6,
(char)0xd6,	(char)0xd6,	(char)0xd6,	(char)0xd6,	(char)0xd6,	(char)0xd6,	(char)0xd6,	(char)0xd5,
(char)0xd5,	(char)0xd5,	(char)0xd5,	(char)0xd5,	(char)0xd5,	(char)0xd5,	(char)0xd5,	(char)0xd4,
(char)0xd4,	(char)0xd4,	(char)0xd4,	(char)0xd4,	(char)0xd4,	(char)0xd4,	(char)0xd4,	(char)0xd3,
(char)0xd3,	(char)0xd3,	(char)0xd3,	(char)0xd3,	(char)0xd3,	(char)0xd3,	(char)0xd3,	(char)0xd2,
(char)0xd2,	(char)0xd2,	(char)0xd2,	(char)0xd2,	(char)0xd2,	(char)0xd2,	(char)0xd2,	(char)0xd1,
(char)0xd1,	(char)0xd1,	(char)0xd1,	(char)0xd1,	(char)0xd1,	(char)0xd1,	(char)0xd1,	(char)0xd0,
(char)0xd0,	(char)0xd0,	(char)0xd0,	(char)0xd0,	(char)0xd0,	(char)0xd0,	(char)0xd0,	(char)0xcf,
(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,
(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xce,
(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,
(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,	(char)0xcd,
(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,
(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcc,
(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,
(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcb,
(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,
(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xca,
(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,
(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,	(char)0xc9,
(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,
(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc8,
(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,
(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc7,
(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,
(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc6,
(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,
(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc5,
(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,
(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc4,
(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,
(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc3,
(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,
(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc2,
(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,
(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc1,
(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,
(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc0,
(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,
(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x40,	(char)0x40,	(char)0x40,	(char)0x40,	(char)0x40,	(char)0x40,
(char)0x40,	(char)0x40,	(char)0x40,	(char)0x40,	(char)0x40,	(char)0x40,	(char)0x40,	(char)0x40,
(char)0x40,	(char)0x40,	(char)0x41,	(char)0x41,	(char)0x41,	(char)0x41,	(char)0x41,	(char)0x41,
(char)0x41,	(char)0x41,	(char)0x41,	(char)0x41,	(char)0x41,	(char)0x41,	(char)0x41,	(char)0x41,
(char)0x41,	(char)0x41,	(char)0x42,	(char)0x42,	(char)0x42,	(char)0x42,	(char)0x42,	(char)0x42,
(char)0x42,	(char)0x42,	(char)0x42,	(char)0x42,	(char)0x42,	(char)0x42,	(char)0x42,	(char)0x42,
(char)0x42,	(char)0x42,	(char)0x43,	(char)0x43,	(char)0x43,	(char)0x43,	(char)0x43,	(char)0x43,
(char)0x43,	(char)0x43,	(char)0x43,	(char)0x43,	(char)0x43,	(char)0x43,	(char)0x43,	(char)0x43,
(char)0x43,	(char)0x43,	(char)0x44,	(char)0x44,	(char)0x44,	(char)0x44,	(char)0x44,	(char)0x44,
(char)0x44,	(char)0x44,	(char)0x44,	(char)0x44,	(char)0x44,	(char)0x44,	(char)0x44,	(char)0x44,
(char)0x44,	(char)0x44,	(char)0x45,	(char)0x45,	(char)0x45,	(char)0x45,	(char)0x45,	(char)0x45,
(char)0x45,	(char)0x45,	(char)0x45,	(char)0x45,	(char)0x45,	(char)0x45,	(char)0x45,	(char)0x45,
(char)0x45,	(char)0x45,	(char)0x46,	(char)0x46,	(char)0x46,	(char)0x46,	(char)0x46,	(char)0x46,
(char)0x46,	(char)0x46,	(char)0x46,	(char)0x46,	(char)0x46,	(char)0x46,	(char)0x46,	(char)0x46,
(char)0x46,	(char)0x46,	(char)0x47,	(char)0x47,	(char)0x47,	(char)0x47,	(char)0x47,	(char)0x47,
(char)0x47,	(char)0x47,	(char)0x47,	(char)0x47,	(char)0x47,	(char)0x47,	(char)0x47,	(char)0x47,
(char)0x47,	(char)0x47,	(char)0x48,	(char)0x48,	(char)0x48,	(char)0x48,	(char)0x48,	(char)0x48,
(char)0x48,	(char)0x48,	(char)0x48,	(char)0x48,	(char)0x48,	(char)0x48,	(char)0x48,	(char)0x48,
(char)0x48,	(char)0x48,	(char)0x49,	(char)0x49,	(char)0x49,	(char)0x49,	(char)0x49,	(char)0x49,
(char)0x49,	(char)0x49,	(char)0x49,	(char)0x49,	(char)0x49,	(char)0x49,	(char)0x49,	(char)0x49,
(char)0x49,	(char)0x49,	(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4a,
(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4a,
(char)0x4a,	(char)0x4a,	(char)0x4b,	(char)0x4b,	(char)0x4b,	(char)0x4b,	(char)0x4b,	(char)0x4b,
(char)0x4b,	(char)0x4b,	(char)0x4b,	(char)0x4b,	(char)0x4b,	(char)0x4b,	(char)0x4b,	(char)0x4b,
(char)0x4b,	(char)0x4b,	(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4c,
(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4c,
(char)0x4c,	(char)0x4c,	(char)0x4d,	(char)0x4d,	(char)0x4d,	(char)0x4d,	(char)0x4d,	(char)0x4d,
(char)0x4d,	(char)0x4d,	(char)0x4d,	(char)0x4d,	(char)0x4d,	(char)0x4d,	(char)0x4d,	(char)0x4d,
(char)0x4d,	(char)0x4d,	(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4e,
(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4e,
(char)0x4e,	(char)0x4e,	(char)0x4f,	(char)0x4f,	(char)0x4f,	(char)0x4f,	(char)0x4f,	(char)0x4f,
(char)0x4f,	(char)0x4f,	(char)0x4f,	(char)0x4f,	(char)0x4f,	(char)0x4f,	(char)0x4f,	(char)0x4f,
(char)0x4f,	(char)0x4f,	(char)0x50,	(char)0x50,	(char)0x50,	(char)0x50,	(char)0x50,	(char)0x50,
(char)0x50,	(char)0x50,	(char)0x51,	(char)0x51,	(char)0x51,	(char)0x51,	(char)0x51,	(char)0x51,
(char)0x51,	(char)0x51,	(char)0x52,	(char)0x52,	(char)0x52,	(char)0x52,	(char)0x52,	(char)0x52,
(char)0x52,	(char)0x52,	(char)0x53,	(char)0x53,	(char)0x53,	(char)0x53,	(char)0x53,	(char)0x53,
(char)0x53,	(char)0x53,	(char)0x54,	(char)0x54,	(char)0x54,	(char)0x54,	(char)0x54,	(char)0x54,
(char)0x54,	(char)0x54,	(char)0x55,	(char)0x55,	(char)0x55,	(char)0x55,	(char)0x55,	(char)0x55,
(char)0x55,	(char)0x55,	(char)0x56,	(char)0x56,	(char)0x56,	(char)0x56,	(char)0x56,	(char)0x56,
(char)0x56,	(char)0x56,	(char)0x57,	(char)0x57,	(char)0x57,	(char)0x57,	(char)0x57,	(char)0x57,
(char)0x57,	(char)0x57,	(char)0x58,	(char)0x58,	(char)0x58,	(char)0x58,	(char)0x58,	(char)0x58,
(char)0x58,	(char)0x58,	(char)0x59,	(char)0x59,	(char)0x59,	(char)0x59,	(char)0x59,	(char)0x59,
(char)0x59,	(char)0x59,	(char)0x5a,	(char)0x5a,	(char)0x5a,	(char)0x5a,	(char)0x5a,	(char)0x5a,
(char)0x5a,	(char)0x5a,	(char)0x5b,	(char)0x5b,	(char)0x5b,	(char)0x5b,	(char)0x5b,	(char)0x5b,
(char)0x5b,	(char)0x5b,	(char)0x5c,	(char)0x5c,	(char)0x5c,	(char)0x5c,	(char)0x5c,	(char)0x5c,
(char)0x5c,	(char)0x5c,	(char)0x5d,	(char)0x5d,	(char)0x5d,	(char)0x5d,	(char)0x5d,	(char)0x5d,
(char)0x5d,	(char)0x5d,	(char)0x5e,	(char)0x5e,	(char)0x5e,	(char)0x5e,	(char)0x5e,	(char)0x5e,
(char)0x5e,	(char)0x5e,	(char)0x5f,	(char)0x5f,	(char)0x5f,	(char)0x5f,	(char)0x5f,	(char)0x5f,
(char)0x5f,	(char)0x5f,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x61,	(char)0x61,
(char)0x61,	(char)0x61,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x63,	(char)0x63,
(char)0x63,	(char)0x63,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x65,	(char)0x65,
(char)0x65,	(char)0x65,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x67,	(char)0x67,
(char)0x67,	(char)0x67,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x69,	(char)0x69,
(char)0x69,	(char)0x69,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6b,	(char)0x6b,
(char)0x6b,	(char)0x6b,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6d,	(char)0x6d,
(char)0x6d,	(char)0x6d,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6f,	(char)0x6f,
(char)0x6f,	(char)0x6f,	(char)0x70,	(char)0x70,	(char)0x71,	(char)0x71,	(char)0x72,	(char)0x72,
(char)0x73,	(char)0x73,	(char)0x74,	(char)0x74,	(char)0x75,	(char)0x75,	(char)0x76,	(char)0x76,
(char)0x77,	(char)0x77,	(char)0x78,	(char)0x78,	(char)0x79,	(char)0x79,	(char)0x7a,	(char)0x7a,
(char)0x7b,	(char)0x7b,	(char)0x7c,	(char)0x7c,	(char)0x7d,	(char)0x7d,	(char)0x7e,	(char)0x7e};

const short a2s_table[TABLE_SIZE8] = {
(short)0xea80,	(short)0xeb80,	(short)0xe880,	(short)0xe980,	(short)0xee80,	(short)0xef80,	(short)0xec80,	(short)0xed80,
(short)0xe280,	(short)0xe380,	(short)0xe080,	(short)0xe180,	(short)0xe680,	(short)0xe780,	(short)0xe480,	(short)0xe580,
(short)0xf540,	(short)0xf5c0,	(short)0xf440,	(short)0xf4c0,	(short)0xf740,	(short)0xf7c0,	(short)0xf640,	(short)0xf6c0,
(short)0xf140,	(short)0xf1c0,	(short)0xf040,	(short)0xf0c0,	(short)0xf340,	(short)0xf3c0,	(short)0xf240,	(short)0xf2c0,
(short)0xaa00,	(short)0xae00,	(short)0xa200,	(short)0xa600,	(short)0xba00,	(short)0xbe00,	(short)0xb200,	(short)0xb600,
(short)0x8a00,	(short)0x8e00,	(short)0x8200,	(short)0x8600,	(short)0x9a00,	(short)0x9e00,	(short)0x9200,	(short)0x9600,
(short)0xd500,	(short)0xd700,	(short)0xd100,	(short)0xd300,	(short)0xdd00,	(short)0xdf00,	(short)0xd900,	(short)0xdb00,
(short)0xc500,	(short)0xc700,	(short)0xc100,	(short)0xc300,	(short)0xcd00,	(short)0xcf00,	(short)0xc900,	(short)0xcb00,
(short)0xfea8,	(short)0xfeb8,	(short)0xfe88,	(short)0xfe98,	(short)0xfee8,	(short)0xfef8,	(short)0xfec8,	(short)0xfed8,
(short)0xfe28,	(short)0xfe38,	(short)0xfe08,	(short)0xfe18,	(short)0xfe68,	(short)0xfe78,	(short)0xfe48,	(short)0xfe58,
(short)0xffa8,	(short)0xffb8,	(short)0xff88,	(short)0xff98,	(short)0xffe8,	(short)0xfff8,	(short)0xffc8,	(short)0xffd8,
(short)0xff28,	(short)0xff38,	(short)0xff08,	(short)0xff18,	(short)0xff68,	(short)0xff78,	(short)0xff48,	(short)0xff58,
(short)0xfaa0,	(short)0xfae0,	(short)0xfa20,	(short)0xfa60,	(short)0xfba0,	(short)0xfbe0,	(short)0xfb20,	(short)0xfb60,
(short)0xf8a0,	(short)0xf8e0,	(short)0xf820,	(short)0xf860,	(short)0xf9a0,	(short)0xf9e0,	(short)0xf920,	(short)0xf960,
(short)0xfd50,	(short)0xfd70,	(short)0xfd10,	(short)0xfd30,	(short)0xfdd0,	(short)0xfdf0,	(short)0xfd90,	(short)0xfdb0,
(short)0xfc50,	(short)0xfc70,	(short)0xfc10,	(short)0xfc30,	(short)0xfcd0,	(short)0xfcf0,	(short)0xfc90,	(short)0xfcb0,
(short)0x1580,	(short)0x1480,	(short)0x1780,	(short)0x1680,	(short)0x1180,	(short)0x1080,	(short)0x1380,	(short)0x1280,
(short)0x1d80,	(short)0x1c80,	(short)0x1f80,	(short)0x1e80,	(short)0x1980,	(short)0x1880,	(short)0x1b80,	(short)0x1a80,
(short)0x0ac0,	(short)0x0a40,	(short)0x0bc0,	(short)0x0b40,	(short)0x08c0,	(short)0x0840,	(short)0x09c0,	(short)0x0940,
(short)0x0ec0,	(short)0x0e40,	(short)0x0fc0,	(short)0x0f40,	(short)0x0cc0,	(short)0x0c40,	(short)0x0dc0,	(short)0x0d40,
(short)0x5600,	(short)0x5200,	(short)0x5e00,	(short)0x5a00,	(short)0x4600,	(short)0x4200,	(short)0x4e00,	(short)0x4a00,
(short)0x7600,	(short)0x7200,	(short)0x7e00,	(short)0x7a00,	(short)0x6600,	(short)0x6200,	(short)0x6e00,	(short)0x6a00,
(short)0x2b00,	(short)0x2900,	(short)0x2f00,	(short)0x2d00,	(short)0x2300,	(short)0x2100,	(short)0x2700,	(short)0x2500,
(short)0x3b00,	(short)0x3900,	(short)0x3f00,	(short)0x3d00,	(short)0x3300,	(short)0x3100,	(short)0x3700,	(short)0x3500,
(short)0x0158,	(short)0x0148,	(short)0x0178,	(short)0x0168,	(short)0x0118,	(short)0x0108,	(short)0x0138,	(short)0x0128,
(short)0x01d8,	(short)0x01c8,	(short)0x01f8,	(short)0x01e8,	(short)0x0198,	(short)0x0188,	(short)0x01b8,	(short)0x01a8,
(short)0x0058,	(short)0x0048,	(short)0x0078,	(short)0x0068,	(short)0x0018,	(short)0x0008,	(short)0x0038,	(short)0x0028,
(short)0x00d8,	(short)0x00c8,	(short)0x00f8,	(short)0x00e8,	(short)0x0098,	(short)0x0088,	(short)0x00b8,	(short)0x00a8,
(short)0x0560,	(short)0x0520,	(short)0x05e0,	(short)0x05a0,	(short)0x0460,	(short)0x0420,	(short)0x04e0,	(short)0x04a0,
(short)0x0760,	(short)0x0720,	(short)0x07e0,	(short)0x07a0,	(short)0x0660,	(short)0x0620,	(short)0x06e0,	(short)0x06a0,
(short)0x02b0,	(short)0x0290,	(short)0x02f0,	(short)0x02d0,	(short)0x0230,	(short)0x0210,	(short)0x0270,	(short)0x0250,
(short)0x03b0,	(short)0x0390,	(short)0x03f0,	(short)0x03d0,	(short)0x0330,	(short)0x0310,	(short)0x0370,	(short)0x0350};

const char s2a_table[TABLE_SIZE14] = {
(char)0xd5,	(char)0xd5,	(char)0xd5,	(char)0xd5,	(char)0xd4,	(char)0xd4,	(char)0xd4,	(char)0xd4,
(char)0xd7,	(char)0xd7,	(char)0xd7,	(char)0xd7,	(char)0xd6,	(char)0xd6,	(char)0xd6,	(char)0xd6,
(char)0xd1,	(char)0xd1,	(char)0xd1,	(char)0xd1,	(char)0xd0,	(char)0xd0,	(char)0xd0,	(char)0xd0,
(char)0xd3,	(char)0xd3,	(char)0xd3,	(char)0xd3,	(char)0xd2,	(char)0xd2,	(char)0xd2,	(char)0xd2,
(char)0xdd,	(char)0xdd,	(char)0xdd,	(char)0xdd,	(char)0xdc,	(char)0xdc,	(char)0xdc,	(char)0xdc,
(char)0xdf,	(char)0xdf,	(char)0xdf,	(char)0xdf,	(char)0xde,	(char)0xde,	(char)0xde,	(char)0xde,
(char)0xd9,	(char)0xd9,	(char)0xd9,	(char)0xd9,	(char)0xd8,	(char)0xd8,	(char)0xd8,	(char)0xd8,
(char)0xdb,	(char)0xdb,	(char)0xdb,	(char)0xdb,	(char)0xda,	(char)0xda,	(char)0xda,	(char)0xda,
(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc5,	(char)0xc4,	(char)0xc4,	(char)0xc4,	(char)0xc4,
(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc7,	(char)0xc6,	(char)0xc6,	(char)0xc6,	(char)0xc6,
(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc1,	(char)0xc0,	(char)0xc0,	(char)0xc0,	(char)0xc0,
(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc3,	(char)0xc2,	(char)0xc2,	(char)0xc2,	(char)0xc2,
(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcd,	(char)0xcc,	(char)0xcc,	(char)0xcc,	(char)0xcc,
(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xcf,	(char)0xce,	(char)0xce,	(char)0xce,	(char)0xce,
(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc9,	(char)0xc8,	(char)0xc8,	(char)0xc8,	(char)0xc8,
(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xcb,	(char)0xca,	(char)0xca,	(char)0xca,	(char)0xca,
(char)0xf5,	(char)0xf5,	(char)0xf5,	(char)0xf5,	(char)0xf5,	(char)0xf5,	(char)0xf5,	(char)0xf5,
(char)0xf4,	(char)0xf4,	(char)0xf4,	(char)0xf4,	(char)0xf4,	(char)0xf4,	(char)0xf4,	(char)0xf4,
(char)0xf7,	(char)0xf7,	(char)0xf7,	(char)0xf7,	(char)0xf7,	(char)0xf7,	(char)0xf7,	(char)0xf7,
(char)0xf6,	(char)0xf6,	(char)0xf6,	(char)0xf6,	(char)0xf6,	(char)0xf6,	(char)0xf6,	(char)0xf6,
(char)0xf1,	(char)0xf1,	(char)0xf1,	(char)0xf1,	(char)0xf1,	(char)0xf1,	(char)0xf1,	(char)0xf1,
(char)0xf0,	(char)0xf0,	(char)0xf0,	(char)0xf0,	(char)0xf0,	(char)0xf0,	(char)0xf0,	(char)0xf0,
(char)0xf3,	(char)0xf3,	(char)0xf3,	(char)0xf3,	(char)0xf3,	(char)0xf3,	(char)0xf3,	(char)0xf3,
(char)0xf2,	(char)0xf2,	(char)0xf2,	(char)0xf2,	(char)0xf2,	(char)0xf2,	(char)0xf2,	(char)0xf2,
(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,	(char)0xfd,
(char)0xfc,	(char)0xfc,	(char)0xfc,	(char)0xfc,	(char)0xfc,	(char)0xfc,	(char)0xfc,	(char)0xfc,
(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,	(char)0xff,
(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,	(char)0xfe,
(char)0xf9,	(char)0xf9,	(char)0xf9,	(char)0xf9,	(char)0xf9,	(char)0xf9,	(char)0xf9,	(char)0xf9,
(char)0xf8,	(char)0xf8,	(char)0xf8,	(char)0xf8,	(char)0xf8,	(char)0xf8,	(char)0xf8,	(char)0xf8,
(char)0xfb,	(char)0xfb,	(char)0xfb,	(char)0xfb,	(char)0xfb,	(char)0xfb,	(char)0xfb,	(char)0xfb,
(char)0xfa,	(char)0xfa,	(char)0xfa,	(char)0xfa,	(char)0xfa,	(char)0xfa,	(char)0xfa,	(char)0xfa,
(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,
(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,	(char)0xe5,
(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,
(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,	(char)0xe4,
(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,
(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,	(char)0xe7,
(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,
(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,	(char)0xe6,
(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,
(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,	(char)0xe1,
(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,
(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,	(char)0xe0,
(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,
(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,	(char)0xe3,
(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,
(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,	(char)0xe2,
(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,
(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,	(char)0xed,
(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,
(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,	(char)0xec,
(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,
(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,	(char)0xef,
(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,
(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,	(char)0xee,
(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,
(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,	(char)0xe9,
(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,
(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,	(char)0xe8,
(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,
(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,	(char)0xeb,
(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,
(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,	(char)0xea,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,	(char)0x95,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,	(char)0x94,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,	(char)0x97,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,	(char)0x96,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,	(char)0x91,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,	(char)0x90,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,	(char)0x93,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,	(char)0x92,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,	(char)0x9d,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,	(char)0x9c,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,	(char)0x9f,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,	(char)0x9e,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,	(char)0x99,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,	(char)0x98,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,	(char)0x9b,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,	(char)0x9a,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,	(char)0x85,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,	(char)0x84,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,	(char)0x87,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,	(char)0x86,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,	(char)0x81,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,	(char)0x80,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,	(char)0x83,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,	(char)0x82,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,	(char)0x8d,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,	(char)0x8c,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,	(char)0x8f,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,	(char)0x8e,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,	(char)0x89,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,	(char)0x88,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,	(char)0x8b,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,	(char)0x8a,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,	(char)0xb5,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,	(char)0xb4,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,	(char)0xb7,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,	(char)0xb6,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,	(char)0xb1,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,	(char)0xb0,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,	(char)0xb3,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,	(char)0xb2,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,	(char)0xbd,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,	(char)0xbc,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,	(char)0xbf,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,	(char)0xbe,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,	(char)0xb9,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,	(char)0xb8,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,	(char)0xbb,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,	(char)0xba,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,	(char)0xa5,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,	(char)0xa4,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,	(char)0xa7,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,	(char)0xa6,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,	(char)0xa1,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,	(char)0xa0,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,	(char)0xa3,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,	(char)0xa2,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,	(char)0xad,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,	(char)0xac,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,	(char)0xaf,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,	(char)0xae,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,	(char)0xa9,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,	(char)0xa8,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,	(char)0xab,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,	(char)0xaa,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,	(char)0x2a,
(char)0x2a,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,	(char)0x2b,
(char)0x2b,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,	(char)0x28,
(char)0x28,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,	(char)0x29,
(char)0x29,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,	(char)0x2e,
(char)0x2e,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,	(char)0x2f,
(char)0x2f,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,	(char)0x2c,
(char)0x2c,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,	(char)0x2d,
(char)0x2d,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,	(char)0x22,
(char)0x22,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,	(char)0x23,
(char)0x23,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,	(char)0x20,
(char)0x20,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,	(char)0x21,
(char)0x21,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,	(char)0x26,
(char)0x26,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,	(char)0x27,
(char)0x27,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,	(char)0x24,
(char)0x24,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,	(char)0x25,
(char)0x25,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,	(char)0x3a,
(char)0x3a,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,	(char)0x3b,
(char)0x3b,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,	(char)0x38,
(char)0x38,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,	(char)0x39,
(char)0x39,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,	(char)0x3e,
(char)0x3e,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,	(char)0x3f,
(char)0x3f,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,	(char)0x3c,
(char)0x3c,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,	(char)0x3d,
(char)0x3d,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,	(char)0x32,
(char)0x32,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,	(char)0x33,
(char)0x33,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,	(char)0x30,
(char)0x30,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,	(char)0x31,
(char)0x31,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,	(char)0x36,
(char)0x36,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,	(char)0x37,
(char)0x37,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,	(char)0x34,
(char)0x34,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,	(char)0x35,
(char)0x35,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,	(char)0x0a,
(char)0x0a,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,	(char)0x0b,
(char)0x0b,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,	(char)0x08,
(char)0x08,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,	(char)0x09,
(char)0x09,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,	(char)0x0e,
(char)0x0e,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,	(char)0x0f,
(char)0x0f,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,	(char)0x0c,
(char)0x0c,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,	(char)0x0d,
(char)0x0d,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,	(char)0x02,
(char)0x02,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,	(char)0x03,
(char)0x03,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,	(char)0x00,
(char)0x00,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,	(char)0x01,
(char)0x01,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,	(char)0x06,
(char)0x06,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,	(char)0x07,
(char)0x07,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,	(char)0x04,
(char)0x04,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,	(char)0x05,
(char)0x05,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,	(char)0x1a,
(char)0x1a,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,	(char)0x1b,
(char)0x1b,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,	(char)0x18,
(char)0x18,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,	(char)0x19,
(char)0x19,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,	(char)0x1e,
(char)0x1e,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,	(char)0x1f,
(char)0x1f,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,	(char)0x1c,
(char)0x1c,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,	(char)0x1d,
(char)0x1d,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,	(char)0x12,
(char)0x12,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,	(char)0x13,
(char)0x13,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,	(char)0x10,
(char)0x10,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,	(char)0x11,
(char)0x11,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,	(char)0x16,
(char)0x16,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,	(char)0x17,
(char)0x17,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,	(char)0x14,
(char)0x14,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,	(char)0x15,
(char)0x15,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,
(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,	(char)0x6a,
(char)0x6a,	(char)0x6b,	(char)0x6b,	(char)0x6b,	(char)0x6b,	(char)0x6b,	(char)0x6b,	(char)0x6b,
(char)0x6b,	(char)0x6b,	(char)0x6b,	(char)0x6b,	(char)0x6b,	(char)0x6b,	(char)0x6b,	(char)0x6b,
(char)0x6b,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,
(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,	(char)0x68,
(char)0x68,	(char)0x69,	(char)0x69,	(char)0x69,	(char)0x69,	(char)0x69,	(char)0x69,	(char)0x69,
(char)0x69,	(char)0x69,	(char)0x69,	(char)0x69,	(char)0x69,	(char)0x69,	(char)0x69,	(char)0x69,
(char)0x69,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,
(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,	(char)0x6e,
(char)0x6e,	(char)0x6f,	(char)0x6f,	(char)0x6f,	(char)0x6f,	(char)0x6f,	(char)0x6f,	(char)0x6f,
(char)0x6f,	(char)0x6f,	(char)0x6f,	(char)0x6f,	(char)0x6f,	(char)0x6f,	(char)0x6f,	(char)0x6f,
(char)0x6f,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,
(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,	(char)0x6c,
(char)0x6c,	(char)0x6d,	(char)0x6d,	(char)0x6d,	(char)0x6d,	(char)0x6d,	(char)0x6d,	(char)0x6d,
(char)0x6d,	(char)0x6d,	(char)0x6d,	(char)0x6d,	(char)0x6d,	(char)0x6d,	(char)0x6d,	(char)0x6d,
(char)0x6d,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,
(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,	(char)0x62,
(char)0x62,	(char)0x63,	(char)0x63,	(char)0x63,	(char)0x63,	(char)0x63,	(char)0x63,	(char)0x63,
(char)0x63,	(char)0x63,	(char)0x63,	(char)0x63,	(char)0x63,	(char)0x63,	(char)0x63,	(char)0x63,
(char)0x63,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,
(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,	(char)0x60,
(char)0x60,	(char)0x61,	(char)0x61,	(char)0x61,	(char)0x61,	(char)0x61,	(char)0x61,	(char)0x61,
(char)0x61,	(char)0x61,	(char)0x61,	(char)0x61,	(char)0x61,	(char)0x61,	(char)0x61,	(char)0x61,
(char)0x61,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,
(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,	(char)0x66,
(char)0x66,	(char)0x67,	(char)0x67,	(char)0x67,	(char)0x67,	(char)0x67,	(char)0x67,	(char)0x67,
(char)0x67,	(char)0x67,	(char)0x67,	(char)0x67,	(char)0x67,	(char)0x67,	(char)0x67,	(char)0x67,
(char)0x67,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,
(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,	(char)0x64,
(char)0x64,	(char)0x65,	(char)0x65,	(char)0x65,	(char)0x65,	(char)0x65,	(char)0x65,	(char)0x65,
(char)0x65,	(char)0x65,	(char)0x65,	(char)0x65,	(char)0x65,	(char)0x65,	(char)0x65,	(char)0x65,
(char)0x65,	(char)0x7a,	(char)0x7a,	(char)0x7a,	(char)0x7a,	(char)0x7a,	(char)0x7a,	(char)0x7a,
(char)0x7a,	(char)0x7b,	(char)0x7b,	(char)0x7b,	(char)0x7b,	(char)0x7b,	(char)0x7b,	(char)0x7b,
(char)0x7b,	(char)0x78,	(char)0x78,	(char)0x78,	(char)0x78,	(char)0x78,	(char)0x78,	(char)0x78,
(char)0x78,	(char)0x79,	(char)0x79,	(char)0x79,	(char)0x79,	(char)0x79,	(char)0x79,	(char)0x79,
(char)0x79,	(char)0x7e,	(char)0x7e,	(char)0x7e,	(char)0x7e,	(char)0x7e,	(char)0x7e,	(char)0x7e,
(char)0x7e,	(char)0x7f,	(char)0x7f,	(char)0x7f,	(char)0x7f,	(char)0x7f,	(char)0x7f,	(char)0x7f,
(char)0x7f,	(char)0x7c,	(char)0x7c,	(char)0x7c,	(char)0x7c,	(char)0x7c,	(char)0x7c,	(char)0x7c,
(char)0x7c,	(char)0x7d,	(char)0x7d,	(char)0x7d,	(char)0x7d,	(char)0x7d,	(char)0x7d,	(char)0x7d,
(char)0x7d,	(char)0x72,	(char)0x72,	(char)0x72,	(char)0x72,	(char)0x72,	(char)0x72,	(char)0x72,
(char)0x72,	(char)0x73,	(char)0x73,	(char)0x73,	(char)0x73,	(char)0x73,	(char)0x73,	(char)0x73,
(char)0x73,	(char)0x70,	(char)0x70,	(char)0x70,	(char)0x70,	(char)0x70,	(char)0x70,	(char)0x70,
(char)0x70,	(char)0x71,	(char)0x71,	(char)0x71,	(char)0x71,	(char)0x71,	(char)0x71,	(char)0x71,
(char)0x71,	(char)0x76,	(char)0x76,	(char)0x76,	(char)0x76,	(char)0x76,	(char)0x76,	(char)0x76,
(char)0x76,	(char)0x77,	(char)0x77,	(char)0x77,	(char)0x77,	(char)0x77,	(char)0x77,	(char)0x77,
(char)0x77,	(char)0x74,	(char)0x74,	(char)0x74,	(char)0x74,	(char)0x74,	(char)0x74,	(char)0x74,
(char)0x74,	(char)0x75,	(char)0x75,	(char)0x75,	(char)0x75,	(char)0x75,	(char)0x75,	(char)0x75,
(char)0x75,	(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4a,	(char)0x4b,	(char)0x4b,	(char)0x4b,
(char)0x4b,	(char)0x48,	(char)0x48,	(char)0x48,	(char)0x48,	(char)0x49,	(char)0x49,	(char)0x49,
(char)0x49,	(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4e,	(char)0x4f,	(char)0x4f,	(char)0x4f,
(char)0x4f,	(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4c,	(char)0x4d,	(char)0x4d,	(char)0x4d,
(char)0x4d,	(char)0x42,	(char)0x42,	(char)0x42,	(char)0x42,	(char)0x43,	(char)0x43,	(char)0x43,
(char)0x43,	(char)0x40,	(char)0x40,	(char)0x40,	(char)0x40,	(char)0x41,	(char)0x41,	(char)0x41,
(char)0x41,	(char)0x46,	(char)0x46,	(char)0x46,	(char)0x46,	(char)0x47,	(char)0x47,	(char)0x47,
(char)0x47,	(char)0x44,	(char)0x44,	(char)0x44,	(char)0x44,	(char)0x45,	(char)0x45,	(char)0x45,
(char)0x45,	(char)0x5a,	(char)0x5a,	(char)0x5a,	(char)0x5a,	(char)0x5b,	(char)0x5b,	(char)0x5b,
(char)0x5b,	(char)0x58,	(char)0x58,	(char)0x58,	(char)0x58,	(char)0x59,	(char)0x59,	(char)0x59,
(char)0x59,	(char)0x5e,	(char)0x5e,	(char)0x5e,	(char)0x5e,	(char)0x5f,	(char)0x5f,	(char)0x5f,
(char)0x5f,	(char)0x5c,	(char)0x5c,	(char)0x5c,	(char)0x5c,	(char)0x5d,	(char)0x5d,	(char)0x5d,
(char)0x5d,	(char)0x52,	(char)0x52,	(char)0x52,	(char)0x52,	(char)0x53,	(char)0x53,	(char)0x53,
(char)0x53,	(char)0x50,	(char)0x50,	(char)0x50,	(char)0x50,	(char)0x51,	(char)0x51,	(char)0x51,
(char)0x51,	(char)0x56,	(char)0x56,	(char)0x56,	(char)0x56,	(char)0x57,	(char)0x57,	(char)0x57,
(char)0x57,	(char)0x54,	(char)0x54,	(char)0x54,	(char)0x54,	(char)0x55,	(char)0x55,	(char)0x55};

const char u2a_table[TABLE_SIZE8] = {
(char)0x2a,   (char)0x2b,   (char)0x28,   (char)0x29,   (char)0x2e,   (char)0x2f,   (char)0x2c,   (char)0x2d,
(char)0x22,   (char)0x23,   (char)0x20,   (char)0x21,   (char)0x26,   (char)0x27,   (char)0x24,   (char)0x25,
(char)0x3a,   (char)0x3b,   (char)0x38,   (char)0x39,   (char)0x3e,   (char)0x3f,   (char)0x3c,   (char)0x3d,
(char)0x32,   (char)0x33,   (char)0x30,   (char)0x31,   (char)0x36,   (char)0x37,   (char)0x34,   (char)0x35,
(char)0x0a,   (char)0x0b,   (char)0x08,   (char)0x09,   (char)0x0e,   (char)0x0f,   (char)0x0c,   (char)0x0d,
(char)0x02,   (char)0x03,   (char)0x00,   (char)0x01,   (char)0x06,   (char)0x07,   (char)0x04,   (char)0x05,
(char)0x1b,   (char)0x18,   (char)0x19,   (char)0x1e,   (char)0x1f,   (char)0x1c,   (char)0x1d,   (char)0x12,
(char)0x13,   (char)0x10,   (char)0x11,   (char)0x16,   (char)0x17,   (char)0x14,   (char)0x15,   (char)0x6a,
(char)0x68,   (char)0x69,   (char)0x6e,   (char)0x6f,   (char)0x6c,   (char)0x6d,   (char)0x62,   (char)0x63,
(char)0x60,   (char)0x61,   (char)0x66,   (char)0x67,   (char)0x64,   (char)0x65,   (char)0x7a,   (char)0x78,
(char)0x7e,   (char)0x7f,   (char)0x7c,   (char)0x7d,   (char)0x72,   (char)0x73,   (char)0x70,   (char)0x71,
(char)0x76,   (char)0x77,   (char)0x74,   (char)0x75,   (char)0x4b,   (char)0x49,   (char)0x4f,   (char)0x4d,
(char)0x42,   (char)0x43,   (char)0x40,   (char)0x41,   (char)0x46,   (char)0x47,   (char)0x44,   (char)0x45,
(char)0x5a,   (char)0x5b,   (char)0x58,   (char)0x59,   (char)0x5e,   (char)0x5f,   (char)0x5c,   (char)0x5d,
(char)0x52,   (char)0x52,   (char)0x53,   (char)0x53,   (char)0x50,   (char)0x50,   (char)0x51,   (char)0x51,
(char)0x56,   (char)0x56,   (char)0x57,   (char)0x57,   (char)0x54,   (char)0x54,   (char)0x55,   (char)0x55,
(char)0xaa,   (char)0xab,   (char)0xa8,   (char)0xa9,   (char)0xae,   (char)0xaf,   (char)0xac,   (char)0xad,
(char)0xa2,   (char)0xa3,   (char)0xa0,   (char)0xa1,   (char)0xa6,   (char)0xa7,   (char)0xa4,   (char)0xa5,
(char)0xba,   (char)0xbb,   (char)0xb8,   (char)0xb9,   (char)0xbe,   (char)0xbf,   (char)0xbc,   (char)0xbd,
(char)0xb2,   (char)0xb3,   (char)0xb0,   (char)0xb1,   (char)0xb6,   (char)0xb7,   (char)0xb4,   (char)0xb5,
(char)0x8a,   (char)0x8b,   (char)0x88,   (char)0x89,   (char)0x8e,   (char)0x8f,   (char)0x8c,   (char)0x8d,
(char)0x82,   (char)0x83,   (char)0x80,   (char)0x81,   (char)0x86,   (char)0x87,   (char)0x84,   (char)0x85,
(char)0x9b,   (char)0x98,   (char)0x99,   (char)0x9e,   (char)0x9f,   (char)0x9c,   (char)0x9d,   (char)0x92,
(char)0x93,   (char)0x90,   (char)0x91,   (char)0x96,   (char)0x97,   (char)0x94,   (char)0x95,   (char)0xea,
(char)0xe8,   (char)0xe9,   (char)0xee,   (char)0xef,   (char)0xec,   (char)0xed,   (char)0xe2,   (char)0xe3,
(char)0xe0,   (char)0xe1,   (char)0xe6,   (char)0xe7,   (char)0xe4,   (char)0xe5,   (char)0xfa,   (char)0xf8,
(char)0xfe,   (char)0xff,   (char)0xfc,   (char)0xfd,   (char)0xf2,   (char)0xf3,   (char)0xf0,   (char)0xf1,
(char)0xf6,   (char)0xf7,   (char)0xf4,   (char)0xf5,   (char)0xcb,   (char)0xc9,   (char)0xcf,   (char)0xcd,
(char)0xc2,   (char)0xc3,   (char)0xc0,   (char)0xc1,   (char)0xc6,   (char)0xc7,   (char)0xc4,   (char)0xc5,
(char)0xda,   (char)0xdb,   (char)0xd8,   (char)0xd9,   (char)0xde,   (char)0xdf,   (char)0xdc,   (char)0xdd,
(char)0xd2,   (char)0xd2,   (char)0xd3,   (char)0xd3,   (char)0xd0,   (char)0xd0,   (char)0xd1,   (char)0xd1,
(char)0xd6,   (char)0xd6,   (char)0xd7,   (char)0xd7,   (char)0xd4,   (char)0xd4,   (char)0xd5,   (char)0xd5};

const char a2u_table[TABLE_SIZE8] = {
(char)0x2a,	(char)0x2b,	(char)0x28,	(char)0x29,	(char)0x2e,	(char)0x2f,	(char)0x2c,	(char)0x2d,
(char)0x22,	(char)0x23,	(char)0x20,	(char)0x21,	(char)0x26,	(char)0x27,	(char)0x24,	(char)0x25,
(char)0x39,	(char)0x3a,	(char)0x37,	(char)0x38,	(char)0x3d,	(char)0x3e,	(char)0x3b,	(char)0x3c,
(char)0x31,	(char)0x32,	(char)0x30,	(char)0x30,	(char)0x35,	(char)0x36,	(char)0x33,	(char)0x34,
(char)0x0a,	(char)0x0b,	(char)0x08,	(char)0x09,	(char)0x0e,	(char)0x0f,	(char)0x0c,	(char)0x0d,
(char)0x02,	(char)0x03,	(char)0x00,	(char)0x01,	(char)0x06,	(char)0x07,	(char)0x04,	(char)0x05,
(char)0x1a,	(char)0x1b,	(char)0x18,	(char)0x19,	(char)0x1e,	(char)0x1f,	(char)0x1c,	(char)0x1d,
(char)0x12,	(char)0x13,	(char)0x10,	(char)0x11,	(char)0x16,	(char)0x17,	(char)0x14,	(char)0x15,
(char)0x62,	(char)0x63,	(char)0x60,	(char)0x61,	(char)0x66,	(char)0x67,	(char)0x64,	(char)0x65,
(char)0x5d,	(char)0x5d,	(char)0x5c,	(char)0x5c,	(char)0x5f,	(char)0x5f,	(char)0x5e,	(char)0x5e,
(char)0x74,	(char)0x76,	(char)0x70,	(char)0x72,	(char)0x7c,	(char)0x7e,	(char)0x78,	(char)0x7a,
(char)0x6a,	(char)0x6b,	(char)0x68,	(char)0x69,	(char)0x6e,	(char)0x6f,	(char)0x6c,	(char)0x6d,
(char)0x48,	(char)0x49,	(char)0x46,	(char)0x47,	(char)0x4c,	(char)0x4d,	(char)0x4a,	(char)0x4b,
(char)0x40,	(char)0x41,	(char)0x3f,	(char)0x3f,	(char)0x44,	(char)0x45,	(char)0x42,	(char)0x43,
(char)0x56,	(char)0x57,	(char)0x54,	(char)0x55,	(char)0x5a,	(char)0x5b,	(char)0x58,	(char)0x59,
(char)0x4f,	(char)0x4f,	(char)0x4e,	(char)0x4e,	(char)0x52,	(char)0x53,	(char)0x50,	(char)0x51,
(char)0xaa,	(char)0xab,	(char)0xa8,	(char)0xa9,	(char)0xae,	(char)0xaf,	(char)0xac,	(char)0xad,
(char)0xa2,	(char)0xa3,	(char)0xa0,	(char)0xa1,	(char)0xa6,	(char)0xa7,	(char)0xa4,	(char)0xa5,
(char)0xb9,	(char)0xba,	(char)0xb7,	(char)0xb8,	(char)0xbd,	(char)0xbe,	(char)0xbb,	(char)0xbc,
(char)0xb1,	(char)0xb2,	(char)0xb0,	(char)0xb0,	(char)0xb5,	(char)0xb6,	(char)0xb3,	(char)0xb4,
(char)0x8a,	(char)0x8b,	(char)0x88,	(char)0x89,	(char)0x8e,	(char)0x8f,	(char)0x8c,	(char)0x8d,
(char)0x82,	(char)0x83,	(char)0x80,	(char)0x81,	(char)0x86,	(char)0x87,	(char)0x84,	(char)0x85,
(char)0x9a,	(char)0x9b,	(char)0x98,	(char)0x99,	(char)0x9e,	(char)0x9f,	(char)0x9c,	(char)0x9d,
(char)0x92,	(char)0x93,	(char)0x90,	(char)0x91,	(char)0x96,	(char)0x97,	(char)0x94,	(char)0x95,
(char)0xe2,	(char)0xe3,	(char)0xe0,	(char)0xe1,	(char)0xe6,	(char)0xe7,	(char)0xe4,	(char)0xe5,
(char)0xdd,	(char)0xdd,	(char)0xdc,	(char)0xdc,	(char)0xdf,	(char)0xdf,	(char)0xde,	(char)0xde,
(char)0xf4,	(char)0xf6,	(char)0xf0,	(char)0xf2,	(char)0xfc,	(char)0xfe,	(char)0xf8,	(char)0xfa,
(char)0xea,	(char)0xeb,	(char)0xe8,	(char)0xe9,	(char)0xee,	(char)0xef,	(char)0xec,	(char)0xed,
(char)0xc8,	(char)0xc9,	(char)0xc6,	(char)0xc7,	(char)0xcc,	(char)0xcd,	(char)0xca,	(char)0xcb,
(char)0xc0,	(char)0xc1,	(char)0xbf,	(char)0xbf,	(char)0xc4,	(char)0xc5,	(char)0xc2,	(char)0xc3,
(char)0xd6,	(char)0xd7,	(char)0xd4,	(char)0xd5,	(char)0xda,	(char)0xdb,	(char)0xd8,	(char)0xd9,
(char)0xcf,	(char)0xcf,	(char)0xce,	(char)0xce,	(char)0xd2,	(char)0xd3,	(char)0xd0,	(char)0xd1};

#ifdef _MSC_VER
#pragma warning(pop)
#endif

void convert_u2c(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
    }
}

void convert_c2u(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
    }
}

void convert_a2c(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
    }
}

void convert_c2a(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
    }
}

void convert_u2s(const char *src, short *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
    }
}

void convert_s2u(const short *src, char *tar, int n)
{
    const short *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
    }
}

void convert_a2s(const char *src, short *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
    }
}

void convert_s2a(const short *src, char *tar, int n)
{
    const short *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
    }
}

void convert_u2a(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
    }
}

void convert_a2u(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
    }
}
