#ifndef kbstrH
#define kbstrH

extern BYTE g_byLeadByteTable[256];
extern BYTE g_byToLowerTable[256];
extern BYTE g_byToUpperTable[256];

#define kbIsLeadByte(X) g_byLeadByteTable[(BYTE)(X)]
#define kbToLower(X)    g_byToLowerTable[(BYTE)(X)]
#define kbToUpper(X)    g_byToUpperTable[(BYTE)(X)]

//e[u
//gpOɕKPxĂяo
void __fastcall kbStr_Initialize(void);
//
//֌W

int __fastcall kbStrLen(const char *cszString);
//
// cszSrc  szDest  nBufSize oCgRs[
// ̒Ȃꍇ nBufSize-1 oCgRs[ďI[ \0 t
// I[r؂Ă悤ȏꍇɂΉ
// cszSrc ̒(strlen(cszSrc)Ԃ
// ߂l >= nBufSize ̏ꍇA؂̂ĂƂӖ
int __fastcall kbStrLCpy(char *szDest, const char *cszSrc, int nBufSize);

// cszSrc  szDest ɘA
// nBufSize  szDest ̃TCYiI[ '\0' ܂ށj
// I[r؂Ă悤ȏꍇɂΉ
// strlen(cszSrc) + min(strlen(szDest) + nBufSize) Ԃ
// ߂l >= nBufSize ̏ꍇAA؂̂ĂƂӖ
int __fastcall kbStrLCat(char *szDest, const char *cszSrc, int nBufSize);

char* __fastcall kbStrTrimRight(char* szString);//I[̋󔒕
char* __fastcall kbStrTrimLeft(char* szString); //擪̋󔒕
char* __fastcall kbStrTrim(char* szString);     //擪ƏI[̋󔒕
char* __fastcall kbCRLFtoSpace(char* szString); //sƃ^uXy[Xɕϊ

int __fastcall kbStrCmp(const char *cszStr1, const char *cszStr2);
int __fastcall kbStrCmpI(const char *cszStr1, const char *cszStr2);
int __fastcall kbStrNCmp(const char *cszStr1, const char *cszStr2, int nLen);
int __fastcall kbStrNCmpI(const char *cszStr1, const char *cszStr2, int nLen);

// cszString   cFind AŏɌւ̃|C^Ԃ
//Ȃꍇ NULL Ԃ
const char* __fastcall kbStrChr(const char *cszString, char cFind);
inline char *__fastcall kbStrChr(char *szString, char cFind)
{
    return (char*) kbStrChr((const char*) szString, cFind);
}
// cszString   cFind AŌɌւ̃|C^Ԃ
//Ȃꍇ NULL Ԃ
const char* __fastcall kbStrRChr(const char *cszString, char cFind);
inline char *__fastcall kbStrRChr(char *szString, char cFind)
{
    return (char*) kbStrRChr((const char*) szString, cFind);
}

const char* __fastcall kbStrStr(const char *cszString, const char *cszSearch);
inline char *__fastcall kbStrStr(char *szString, const char *cszSearch)
{
    return (char*) kbStrStr((const char*) szString, cszSearch);
}
const char* __fastcall kbStrStrI(const char *cszString, const char *cszSearch);
inline char *__fastcall kbStrStrI(char *szString, const char *cszSearch)
{
    return (char*) kbStrStrI((const char*) szString, cszSearch);
}

char* __fastcall kbStrUpr(char *pszString);
char* __fastcall kbStrLwr(char *pszString);

char* __fastcall kbStrTok(char *pszString, const char *cszDelimiter, char **ppszNext);

int  __fastcall  kbStrToIntDef(const char* cszStr, int nDefault);
double __fastcall kbStrToDoubleDef(const char* cszStr, double nDefault);

// src  old_pattern  new_pattern ɒu
//size  dst ̃obt@TCY
//old_pattern == "" i󕶎j̏ꍇAkbStrLCat(dst, size, new_pattern) Ɠ
//obt@TCYȂꍇ́Asize-1 oCg܂Œu
//SuꂽƂƂ̒̕Ԃ
//߂l >= size ̏ꍇAu̕񂪈ꕔ؂̂ĂꂽƂӖ
int __fastcall kbStringReplace(char *dst,
                               int size,
                               const char *src,
                               const char *old_pattern,
                               const char *new_pattern);

int __fastcall kbMultiByteToWideChar(const char *cszMultiByte,
                                     wchar_t* wszWideChar,
                                     int cchWideChar);
int __fastcall kbWideCharToMultiByte(const wchar_t *wcszWideChar,
                                     char *szMultiByte,
                                     int cchMultiByte);
//
//t@C֌W
//
//cszSrc ̊gqւ̃|C^Ԃ
//gqȂꍇ͋󕶎Ԃ
//i߂l NULL łȂƂۏ؂j
const char* __fastcall kbExtractFileExt(const char* cszSrc);

//cszFileName pX菜́it@Cj̃|C^Ԃ
const char* __fastcall kbExtractFileName(const char* cszFileName);

//cszFileName pX擾ă|C^Ԃ
char* __fastcall kbExtractFilePath(char *szDest, const char* cszFileName, int nSize);

//Ƀt@C̃t@CpX菜̂Ԃ
//PFC:\hoge\hoge.lzh>test.mid ̖߂l = test.mid
//QFC:\hoge\hoge.lzh>test/test2.mid ̖߂ltest2.mid
//RFC:\hoge\hoge.lzh>test/testzip.zip>test3.mid ̖߂l = test3.mid
//SFC:\hoge\hoge.lzh>test/testzip.zip>test/test4.mid ̖߂l = test4.mid
const char* __fastcall kbExtractFileNameInArc(const char *cszFileName);

//Ƀt@C̃t@Ct@C菜̂Ԃ
//PFC:\hoge\hoge.lzh>test.mid ̖߂l = C:\hoge\hoge.lzh>
//QFC:\hoge\hoge.lzh>test/test2.mid ̖߂l = C:\hoge\hoge.lzh>test/
//RFC:\hoge\hoge.lzh>test/testzip.zip>test3.mid ̖߂l = C:\hoge\hoge.lzh>test/testzip.zip>
//SFC:\hoge\hoge.lzh>test/testzip.zip>test/test4.mid ̖߂l = C:\hoge\hoge.lzh>test/testzip.zip>test/
const char* __fastcall kbExtractFilePathInArc(char *szDest, const char *cszFileName);

//cszFileName ̊gq cszExt ɒu szDest ɃRs[
char* __fastcall kbExtractReplacedFileExt(char *szDest,
                                          const char *cszFileName,
                                          const char *cszExt);

void __fastcall  kbAddPathDelimiter(char *szPath);
void __fastcall  kbRemovePathDelimiter(char *szPath);
void __fastcall  kbCombinePath(char *szDest, const char *cszSrc,
                               const char *cszAdd, int nDestSize);

#endif

