/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___AUDRIV_H_
#define ___AUDRIV_H_

#ifndef Bool
#define Bool int
#endif

#ifndef False
#define False 0
#endif

#ifndef True
#define True 1
#endif

extern char audriv_errmsg[BUFSIZ];
/* G[ꍇ́CG[bZ[Wݒ肳܂D
 * 퓮삵Ăꍇ́CύX܂D
 */

/* I[fBI̓o͐l */
enum audriv_ports
{
    AUDRIV_OUTPUT_SPEAKER,
    AUDRIV_OUTPUT_HEADPHONE,
    AUDRIV_OUTPUT_LINE_OUT
};


extern Bool audriv_setup_audio(void);
/* I[fBȈs܂D
 * ꍇ True Csꍇ False Ԃ܂D
 */

extern void audriv_free_audio(void);
/* audio ̌㏈s܂D
 */

extern Bool audriv_play_open(void);
/* audio tpɊJCł audriv_write() ɂ艉t\
 * Ԃɂ܂DɊJĂꍇ͂Ȃɂs܂D
 * ꍇ True Csꍇ False Ԃ܂D
 */

extern void audriv_play_close(void);
/* tpɃI[vꂽ audio ܂DłɕĂ
 * ꍇ͂Ȃɂs܂D
 */

extern long audriv_play_stop(void);
/* t𑦍ɒ~C~ÕTvԂ܂D
 * audriv_play_stop() ̌ĂяoɂāCaudio ͕܂D
 * audio ɕĂꍇ audriv_play_stop() Ăяoꍇ 0 
 * Ԃ܂D
 * G[̏ꍇ -1 Ԃ܂D
 */

extern Bool audriv_is_play_open(void);
/* audio tŃI[vĂꍇ True,
 * Ăꍇ False Ԃ܂D
 */

extern Bool audriv_set_play_volume(int volume);
/* tʂ 0 ? 255 ͈͓̔Őݒ肵܂D0 ͖C255 ͍ő剹ʁD
 * 0  0C255 𒴂l 255 ɓD
 * ꍇ True Csꍇ False Ԃ܂D
 */

extern int audriv_get_play_volume(void);
/* tʂ 0 ? 255 œ܂D0 ͖C255 ͍ő剹ʁD
 * s -1 ԂCłȂꍇ 0 ? 255 ̉ʂԂ܂D
 */

extern Bool audriv_set_play_output(int port);
/* audio ̏o͐ port w肵܂Dport ɂ͈ȉ̂ǂꂩw肵܂D
 *
 *     AUDRIV_OUTPUT_SPEAKER	Xs[JɏóD
 *     AUDRIV_OUTPUT_HEADPHONE	wbhzɏóD
 *     AUDRIV_OUTPUT_LINE_OUT	CAEgɏóD
 *
 * ꍇ True Csꍇ False Ԃ܂D
 */

extern int audriv_get_play_output(void);
/* audio ̏o͐ port 𓾂܂D
 * s -1 ԂCƈȉ̂ꂩ̒lԂ܂D
 *
 *     AUDRIV_OUTPUT_SPEAKER	Xs[JɏóD
 *     AUDRIV_OUTPUT_HEADPHONE	wbhzɏóD
 *     AUDRIV_OUTPUT_LINE_OUT	CAEgɏóD
 *
 */

extern int audriv_write(char *buff, int n);
/* audio  buff  n oCg݂܂D
 * audriv_set_noblock_write() ŔubNE[hݒ肳ꂽ
 * ꍇ́C̊֐̌Ăяo͑ɏԂ܂D
 * Ԃl͎ۂɗ܂ꂽoCgłCubNE[hݒ
 * Ăꍇ́C n 菭Ȃꍇ܂D
 * s -1 ԂCƁCۂɗ܂ꂽoCgԂ܂D
 */

extern Bool audriv_set_noblock_write(Bool noblock);
/* noblock  True w肷ƁCaudriv_write() ĂяoŃubN܂D
 * False w肷ƁCftHg̏Ԃɖ߂܂D
 * ɐ True Cs False Ԃ܂D
 */

extern int audriv_play_active(void);
/* tȂ 1CtłȂȂ 0, G[Ȃ -1 Ԃ܂D
 */

extern long audriv_play_samples(void);
/* ݉t̃TvʒuԂ܂D
 */

extern long audriv_get_filled(void);
/* I[fBIobt@̃oCgԂ܂B
 * G[̏ꍇ -1 Ԃ܂B
 */

extern const long *audriv_available_encodings(int *n_ret);
/* }VT|[gĂ邷ׂĂ̕XgԂ܂Dn_ret ɂ
 * ̎ނ̐CԂ܂D킷萔l
 * aenc.h ɒ`ĂlłD
 * Ԃl free Ă͂Ȃ܂D
 */

extern const long *audriv_available_sample_rates(int *n_ret);
/* }VT|[gĂ邷ׂẴTv[g̃XgԂ܂D
 * Ԃl̃Tv[g͒ႢɂȂł܂D
 * n_ret ɂ͂̎ނ̐CԂ܂D
 * Ԃl free Ă͂Ȃ܂D
 */

extern const long *audriv_available_channels(int *n_ret);
/* }VT|[gĂ邷ׂẴ`l̃XgԂ܂D
 * n_ret ɂ͂̎ނ̐CԂ܂D
 * Ԃl free Ă͂Ȃ܂D
 */

extern Bool audriv_set_play_encoding(long encoding);
/* audio t̕w肵܂D
 * ꍇ True Csꍇ False Ԃ܂D
 */

extern Bool audriv_set_play_sample_rate(long sample_rate);
/* audio t̃Tv[gw肵܂D
 * ꍇ True Csꍇ False Ԃ܂D
 */

extern Bool audriv_set_play_channels(long channels);
/* tp̃`lݒ肵܂D
 * s False ԂC True Ԃ܂D
 */

extern void (* audriv_error_handler)(const char *errmsg);
/* NULL łȂ΁CG[ꍇĂяo܂D
 */

extern void audriv_wait_play(void);
/* CPU p[QȂ悤ɂ邽߂ɁCꎞIɒ~܂D*/

#endif /* ___AUDRIV_H_ */
