#!/bin/bash
: <<.
/*
 * From BitVisor 1.0.1 boot/loader/install.sh
 */
/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2015 Yuichi Watanabe
 */
.

dir=`dirname $0`
first=0
uefiloader="$dir/loadvmm.efi"
vmm="$dir/../../vmm.elf"
cmdline=
module1=

printhelp(){
	echo "usage: $0 [-f] [-c cmd] [-l uefiloader] [-v vmm] [-m module1] partition"
	echo '  -f         first time (do not check existing data)'
	echo '  -c         cmdline boot parameters to vmm'
	echo "  -l uefiloader     a path to uefiloader (default: $uefiloader)"
	echo "  -v vmm     a path to vmm.elf (default: $vmm)"
	echo '  -m module1 a path to guest bios (default: none)'
	echo '  partition  partition to write (ex. /dev/sdc1)'
}

arg=.
uefiinstall(){
	if [ -e tmp-mnt ]; then
		echo "tmp-mnt is already exists."
		exit 1;
	fi
	mkdir tmp-mnt
	mount "$partition" tmp-mnt
	if [ $? -ne 0 ]; then
		rmdir tmp-mnt
		exit 1;
	fi
	if [ $first -eq 1 ]; then
		mkdir -p "tmp-mnt/EFI/BOOT"
	fi
	if ! [ -d "tmp-mnt/EFI/BOOT" ]; then
		umount tmp-mnt
		rmdir tmp-mnt
		echo "EFI/BOOT does not exist."
		exit 1
	fi
	cp "$vmm" "tmp-mnt/EFI/BOOT/vmm.elf"
	cp "$uefiloader" "tmp-mnt/EFI/BOOT/BOOTX64.EFI"
	if [ -n "$cmdline" ]; then
		echo -n "$cmdline" > "tmp-mnt/EFI/BOOT/param.txt"
	else
		rm -f "tmp-mnt/EFI/BOOT/param.txt"
	fi
	if [ -n "$module1" ]; then
		cp "$module1" "tmp-mnt/EFI/BOOT/module.bin"
	else
		rm -f "tmp-mnt/EFI/BOOT/module.bin"
	fi
	umount tmp-mnt
	rmdir tmp-mnt
}

while test $# -gt 0
do
	case "$1" in
	-f)	first=1;;
	-c)
		shift;
		cmdline=$1;;
	-l)
		shift;
		uefiloader=$1;;
	-v)
		shift;
		vmm=$1;;
	-m)
		shift;
		module1=$1;;
	-*)	echo "unrecognized option \`$1'" >&2
		exit 1;;
	*)	case $arg in
		.)		partition="$1";;
		..)		echo "extra operand \`$1'" >&2
				exit 1;;
		esac
		arg=.$arg;;
	esac
	shift
done

case $arg in
.)	printhelp
	exit 1;;
esac

if [ ! -e "$partition" ]; then
	echo "$partition not found."
	exit 1
fi

uefiinstall
