/*
 * Copyright (c) 2010-2014 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CORE_VM_H
#define _CORE_VM_H

#include <common/list.h>
#include <core/cpu.h>
#include <core/rm.h>
#include <core/spinlock.h>
#include <core/types.h>
#include <core/vm.h>
#include <core/wait.h>
#include "cpu.h"
#include "gmm_trans.h"
#include "io_io.h"
#include "mm.h"
#include "mmio.h"
#include "svm.h"
#include "vcpu.h"
#include "int.h"
#include "vt.h"
#include "localapic.h"

struct vm {
	LIST2_DEFINE(struct vm, vm_list);

	spinlock_t vcpu_list_lock;
	LIST2_DEFINE_HEAD(vcpu_list, struct vcpu, vcpu_list); /* protected by
								 vcpu_list_lock */
	unsigned int vcpu_count; /* protected by vcpu_list_lock */
	apic_id_t vbsp_apic_id;

	char name[VM_NAME_BUF_SIZE];
	u32 id;

	struct io_io_data io;
	struct mmio_vm_data mmio;
	struct acpi_vm_data acpi;
	struct localapic_vm_data localapic;
	struct resource resource[MAXNUM_OF_SYSMEMMAP];
	int resource_count;
	struct gmm_trans gmm_trans;

	union {
		struct vt_vm_data vt;
		struct svm_vm_data svm;
	} u;

	bool iommu_enabled;
	volatile bool resetting;
	struct wait wait;
	volatile bool shutdown;

	u64 driver_data[]; /* variable length array */
};

void vm_create_all(void);
struct vm *vm_find(void);
struct vm *vm_find_by_name(char *name);
bool vm_current_is_vbsp(void);
void vm_dump(void);
bool vm_resetting(void);
void vm_wait_other_cpus(void);
int vm0_boot_method(u8 bios_boot_drive, u8 *boot_drive);

#endif /* _CORE_VM_H */
