/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CORE_CPU_MMU_SPT_H
#define _CORE_CPU_MMU_SPT_H

#include <common/list.h>
#include <core/spinlock.h>
#include <core/types.h>

#define NUM_OF_SPTTBL 1024

struct spt_page {
	LIST2_DEFINE (struct spt_page, list);
	phys_t phys;
	void *virt;
	u64 *pte_virt;
};

struct cpu_mmu_spt_data {
	void *cr3tbl;
	u64 cr3tbl_phys;
	LIST2_DEFINE_HEAD(struct spt_page, shadow_free);
	LIST2_DEFINE_HEAD(struct spt_page, shadow_l1);
	LIST2_DEFINE_HEAD(struct spt_page, shadow_lu);
	int levels;
	struct spt_page spt_page[NUM_OF_SPTTBL];
	bool tlbflash;
};

struct vcpu;

bool cpu_mmu_spt_tlbflush (void);
void cpu_mmu_spt_updatecr3 (void);
void cpu_mmu_spt_invalidate (ulong virtual_addr);
void cpu_mmu_spt_pagefault (ulong err, ulong cr2);
void cpu_mmu_spt_init(void);

#endif
