/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2013 Yuichi Watanabe
 */

#ifndef _CORE_VCPU_H
#define _CORE_VCPU_H

#include <common/list.h>
#include <core/cpu.h>
#include <core/types.h>
#include "constants.h"
#include "cpu.h"
#include "cpu_mmu_spt.h"
#include "extint.h"
#include "svm.h"
#include "vm.h"
#include "vmctl.h"
#include "vt.h"

struct apic_data {
	spinlock_t lock;
	volatile bool wait_for_sipi;
	volatile vector_t sipi_vector;
	volatile bool sipi_pending;
	volatile bool fake_sipi;
	u32 ldr;
	u32 icr_low;
	u32 icr_high;
};

#define MSR_DATA_PAT_COUNT 8

struct msr_data {
	u64 pat_reg;
	u8 pat_to_cache_flag[MSR_DATA_PAT_COUNT];
};

struct vcpu {
	LIST2_DEFINE(struct vcpu, vcpu_list);
	struct vm *vm;
	union {
		struct vt vt;
		struct svm svm;
	} u;
	struct cpu_mmu_spt_data spt;
	struct msr_data msr_data;
	struct extint_data extint;
	struct apic_data apic_data;
	struct pcpu *pcpu;
	struct vmctl_func vmctl;
	struct int_hook int_hook[NUM_OF_INT];
	bool initialized;
	bool vbsp;
	bool halt;
	u64 tsc_offset;
	bool updateip;
	apic_id_t apic_id;
};

void vcpu_list_foreach (struct vm *vm, bool (*func) (struct vcpu *p, void *q), void *q);
struct vcpu *find_vcpu_with_apic_id (struct vm *vm, apic_id_t apic_id);
struct vcpu *new_vcpu (struct vm *vm, bool vbsp);
struct vcpu *vcpu_next (struct vm *vm, struct vcpu *vcpu);
void vcpu_reset(void);

inline static bool vcpu_is_bsp (struct vcpu *vcpu)
{
	return vcpu->vbsp;
}

#endif
