/*
 * Copyright (c) 2007, 2008 University of Tsukuba
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the University of Tsukuba nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * Copyright (c) 2010-2014 Yuichi Watanabe
 */

#ifndef _CORE_SERIAL_REG_H
#define _CORE_SERIAL_REG_H

#define SERIAL_PORT1		0x3F8 /* COM1, ttyS0 */
#define SERIAL_NUM_OF_IOPORT	8
#define PORT_DATA		0x0
#define PORT_RATELSB		0x0
#define PORT_RATEMSB		0x1
#define PORT_INTRCTL		0x1
#define PORT_INTRSTAT		0x2
#define PORT_FIFOCTL		0x2
#define PORT_LINECTL		0x3
#define PORT_MODECTL		0x4
#define PORT_LINESTAT		0x5
#define PORT_MODESTAT		0x6
#define PORT_USER		0x7

#define RATELSB_115200		0x1
#define RATELSB_57600		0x2
#define RATELSB_38400		0x3
#define RATELSB_19200		0x6
#define RATELSB_9600		0xC
#define RATELSB_4800		0x18
#define RATELSB_2400		0x30
#define RATELSB_1200		0x60
#define RATELSB_600		0xC0
#define INTRCTL_ETBREI_BIT	0x02 /* Enable TBR empty interrupt */
#define INTRSTAT_INT_NO_PENDING	0x01 /* 0 if interrupt pending */
#define INTRSTAT_TBR_EMPTY_INTR	0x02 /* TBR empty interrupt */
#define INTRSTAT_FIFO_ENABLED	0xc0
#define FIFOCTL_ENABLE		0x01
#define LINECTL_DATA8BIT	0x3
#define LINECTL_STOP2BIT	0x4
#define LINECTL_PARITY_ENABLE	0x8
#define LINECTL_PARITY_EVEN_BIT	0x10
#define LINECTL_PARITY		0x20
#define LINECTL_BREAK_BIT	0x40
#define LINECTL_DLAB_BIT	0x80
#define LINESTAT_RX_BIT		0x1
#define LINESTAT_OVERRUN_BIT	0x2
#define LINESTAT_PARITY_BIT	0x4
#define LINESTAT_FRAMING_BIT	0x8
#define LINESTAT_BREAK_BIT	0x10
#define LINESTAT_TXSTART_BIT	0x20
#define LINESTAT_TX_BIT		0x40
#define LINESTAT_RXFIFO_BIT	0x80
#define MODESTAT_CTS_BIT	0x10	/* Clear to send */

void serial_putchar (unsigned char c);
void serial_out(unsigned char c);

#endif /* _CORE_SERIAL_REG_H */
