/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mssql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultTableDefinitionChangesPredicate;
import org.apache.ddlutils.platform.PlatformImplBase;
import org.apache.ddlutils.platform.mssql.MSSqlBuilder;
import org.apache.ddlutils.platform.mssql.MSSqlModelComparator;
import org.apache.ddlutils.platform.mssql.MSSqlModelReader;

public class MSSqlPlatform
extends PlatformImplBase {
    public static final String DATABASENAME = "MsSql";
    public static final String JDBC_DRIVER = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public static final String JDBC_DRIVER_NEW = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String JDBC_SUBPROTOCOL = "microsoft:sqlserver";
    public static final String JDBC_SUBPROTOCOL_NEW = "sqlserver";
    public static final String JDBC_SUBPROTOCOL_INTERNAL = "sqljdbc";

    public MSSqlPlatform() {
        PlatformInfo info = this.getPlatformInfo();
        info.setMaxIdentifierLength(128);
        info.setPrimaryKeyColumnAutomaticallyRequired(true);
        info.setIdentityColumnAutomaticallyRequired(true);
        info.setMultipleIdentityColumnsSupported(false);
        info.setSupportedOnUpdateActions(new CascadeActionEnum[]{CascadeActionEnum.CASCADE, CascadeActionEnum.NONE});
        info.addEquivalentOnUpdateActions(CascadeActionEnum.NONE, CascadeActionEnum.RESTRICT);
        info.setSupportedOnDeleteActions(new CascadeActionEnum[]{CascadeActionEnum.CASCADE, CascadeActionEnum.NONE});
        info.addEquivalentOnDeleteActions(CascadeActionEnum.NONE, CascadeActionEnum.RESTRICT);
        info.addNativeTypeMapping(2003, "IMAGE", -4);
        info.addNativeTypeMapping(-5, "DECIMAL(19,0)");
        info.addNativeTypeMapping(2004, "IMAGE", -4);
        info.addNativeTypeMapping(16, "BIT", -7);
        info.addNativeTypeMapping(2005, "TEXT", -1);
        info.addNativeTypeMapping(70, "IMAGE", -4);
        info.addNativeTypeMapping(91, "DATETIME", 93);
        info.addNativeTypeMapping(2001, "IMAGE", -4);
        info.addNativeTypeMapping(8, "FLOAT", 6);
        info.addNativeTypeMapping(4, "INT");
        info.addNativeTypeMapping(2000, "IMAGE", -4);
        info.addNativeTypeMapping(-4, "IMAGE");
        info.addNativeTypeMapping(-1, "TEXT");
        info.addNativeTypeMapping(0, "IMAGE", -4);
        info.addNativeTypeMapping(1111, "IMAGE", -4);
        info.addNativeTypeMapping(2006, "IMAGE", -4);
        info.addNativeTypeMapping(2002, "IMAGE", -4);
        info.addNativeTypeMapping(92, "DATETIME", 93);
        info.addNativeTypeMapping(93, "DATETIME");
        info.addNativeTypeMapping(-6, "SMALLINT", 5);
        info.setDefaultSize(1, 254);
        info.setDefaultSize(12, 254);
        info.setDefaultSize(-2, 254);
        info.setDefaultSize(-3, 254);
        this.setSqlBuilder(new MSSqlBuilder(this));
        this.setModelReader(new MSSqlModelReader(this));
    }

    @Override
    public String getName() {
        return DATABASENAME;
    }

    private boolean useIdentityOverrideFor(Table table) {
        return this.isIdentityOverrideOn() && this.getPlatformInfo().isIdentityOverrideAllowed() && table.getAutoIncrementColumns().length > 0;
    }

    @Override
    protected void beforeInsert(Connection connection, Table table) throws SQLException {
        if (this.useIdentityOverrideFor(table)) {
            MSSqlBuilder builder = (MSSqlBuilder)this.getSqlBuilder();
            connection.createStatement().execute(builder.getEnableIdentityOverrideSql(table));
        }
    }

    @Override
    protected void afterInsert(Connection connection, Table table) throws SQLException {
        if (this.useIdentityOverrideFor(table)) {
            MSSqlBuilder builder = (MSSqlBuilder)this.getSqlBuilder();
            connection.createStatement().execute(builder.getDisableIdentityOverrideSql(table));
        }
    }

    @Override
    protected void beforeUpdate(Connection connection, Table table) throws SQLException {
        this.beforeInsert(connection, table);
    }

    @Override
    protected void afterUpdate(Connection connection, Table table) throws SQLException {
        this.afterInsert(connection, table);
    }

    @Override
    protected ModelComparator getModelComparator() {
        return new MSSqlModelComparator(this.getPlatformInfo(), this.getTableDefinitionChangesPredicate(), this.isDelimitedIdentifierModeOn());
    }

    @Override
    protected TableDefinitionChangesPredicate getTableDefinitionChangesPredicate() {
        return new DefaultTableDefinitionChangesPredicate(){

            @Override
            protected boolean isSupported(Table intermediateTable, TableChange change) {
                if (change instanceof RemoveColumnChange || change instanceof AddPrimaryKeyChange || change instanceof PrimaryKeyChange || change instanceof RemovePrimaryKeyChange) {
                    return true;
                }
                if (change instanceof AddColumnChange) {
                    AddColumnChange addColumnChange = (AddColumnChange)change;
                    return addColumnChange.getNextColumn() == null && (!addColumnChange.getNewColumn().isRequired() || addColumnChange.getNewColumn().isAutoIncrement() || !StringUtils.isEmpty((String)addColumnChange.getNewColumn().getDefaultValue()));
                }
                if (change instanceof ColumnDefinitionChange) {
                    ColumnDefinitionChange colDefChange = (ColumnDefinitionChange)change;
                    Column curColumn = intermediateTable.findColumn(colDefChange.getChangedColumn(), MSSqlPlatform.this.isDelimitedIdentifierModeOn());
                    Column newColumn = colDefChange.getNewColumn();
                    return curColumn.isAutoIncrement() == colDefChange.getNewColumn().isAutoIncrement() && (curColumn.isRequired() || curColumn.isRequired() == newColumn.isRequired()) && !ColumnDefinitionChange.isSizeReduced(MSSqlPlatform.this.getPlatformInfo(), curColumn, newColumn);
                }
                return false;
            }
        };
    }

    @Override
    protected Database processChanges(Database model, Collection changes, CreationParameters params) throws IOException, DdlUtilsException {
        if (!changes.isEmpty()) {
            ((MSSqlBuilder)this.getSqlBuilder()).turnOnQuotation();
        }
        return super.processChanges(model, changes, params);
    }

    public void processChange(Database currentModel, CreationParameters params, RemoveColumnChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column removedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        ((MSSqlBuilder)this.getSqlBuilder()).dropColumn(changedTable, removedColumn);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, RemovePrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        ((MSSqlBuilder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }

    public void processChange(Database currentModel, CreationParameters params, ColumnDefinitionChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        Column changedColumn = changedTable.findColumn(change.getChangedColumn(), this.isDelimitedIdentifierModeOn());
        ((MSSqlBuilder)this.getSqlBuilder()).recreateColumn(changedTable, changedColumn, change.getNewColumn());
    }

    public void processChange(Database currentModel, CreationParameters params, PrimaryKeyChange change) throws IOException {
        Table changedTable = this.findChangedTable(currentModel, change);
        String[] newPKColumnNames = change.getNewPrimaryKeyColumns();
        Column[] newPKColumns = new Column[newPKColumnNames.length];
        int colIdx = 0;
        while (colIdx < newPKColumnNames.length) {
            newPKColumns[colIdx] = changedTable.findColumn(newPKColumnNames[colIdx], this.isDelimitedIdentifierModeOn());
            ++colIdx;
        }
        ((MSSqlBuilder)this.getSqlBuilder()).dropPrimaryKey(changedTable);
        this.getSqlBuilder().createPrimaryKey(changedTable, newPKColumns);
        change.apply(currentModel, this.isDelimitedIdentifierModeOn());
    }
}

