/*
 * Decompiled with CFR 0.152.
 */
package org.grlea.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.grlea.log.DebugLevel;
import org.grlea.log.SimpleLog;
import org.grlea.log.SimpleLogger;
import org.grlea.log.rollover.RolloverManager;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SimpleLog {
    private static final String CONFIG_PROPERTY = "simplelog.configuration";
    private static final String DEV_DEBUG_PROPERTY = "simplelog.dev.debug";
    private static final String DEV_STACKTRACES_PROPERTY = "simplelog.dev.printStackTraces";
    private static final String FILE_CONFIG_PREFIX = "file:";
    private static final String CLASSPATH_CONFIG_PREFIX = "classpath:";
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "simplelog.properties";
    private static final String KEY_PREFIX = "simplelog.";
    private static final String KEY_IMPORT = "simplelog.import";
    private static final String KEY_FORMAT_PREFIX = "simplelog.format.";
    private static final String KEY_FORMAT_INSTANCE_SUFFIX = ".instance";
    private static final String KEY_FORMAT_DB = "simplelog.format.debug";
    private static final String KEY_FORMAT_DBO = "simplelog.format.debugObject";
    private static final String KEY_FORMAT_DBE = "simplelog.format.debugException";
    private static final String KEY_FORMAT_ENTRY = "simplelog.format.entry";
    private static final String KEY_FORMAT_EXIT = "simplelog.format.exit";
    private static final String KEY_RELOADING = "simplelog.reloading";
    private static final String RELOADING_DEFAULT = "false";
    private static final String KEY_LOG_FILE = "simplelog.logFile";
    private static final String KEY_INTERPRET_NAME = "simplelog.logFile.interpretName";
    private static final boolean INTREPRET_NAME_DEFAULT = true;
    private static final String KEY_APPEND = "simplelog.logFile.append";
    private static final boolean APPEND_DEFAULT = true;
    private static final String KEY_PIPE_TO_CONSOLE = "simplelog.logFile.andConsole";
    private static final boolean PIPE_TO_CONSOLE_DEFAULT = false;
    private static final String KEY_DEFAULT_LEVEL = "simplelog.defaultLevel";
    private static final String KEY_DEFAULT_TRACE = "simplelog.defaultTrace";
    private static final String KEY_DATE_FORMAT = "simplelog.dateFormat";
    private static final String DATE_FORMAT_DEFAULT = "EEE yyyy/MM/dd HH:mm:ss.SSS";
    private static final String KEY_PRINT_STACK_TRACES = "simplelog.printStackTraces";
    private static final String PRINT_STACK_TRACES_DEFAULT = "true";
    private static final String KEY_ROLLOVER_STRATEGY = "simplelog.rollover";
    private static final int RELOAD_FILE_CHECK_PERIOD = 20000;
    private static final int RELOAD_URL_CHECK_PERIOD = 60000;
    private static final String TRACE_SUFFIX = "#trace";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String ROLLOVER_WRITER_CLASS = "org.grlea.log.rollover.RolloverManager";
    private static final String DEFAULT_FORMAT_STRING_DB = "{0}|   |{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_DBO = "{0}|---|{1}|{2}|{5}|{6}";
    private static final String DEFAULT_FORMAT_STRING_DBE = "{0}|***|{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_ENTRY = "{0}|>>>|{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_EXIT = "{0}|<<<|{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_DB_INSTANCE = "{0}|   |{1}|{2}[{3}]|{5}";
    private static final String DEFAULT_FORMAT_STRING_DBO_INSTANCE = "{0}|---|{1}|{2}[{3}]|{5}|{6}";
    private static final String DEFAULT_FORMAT_STRING_DBE_INSTANCE = "{0}|***|{1}|{2}[{3}]|{5}";
    private static final String DEFAULT_FORMAT_STRING_ENTRY_INSTANCE = "{0}|>>>|{1}|{2}[{3}]|{5}";
    private static final String DEFAULT_FORMAT_STRING_EXIT_INSTANCE = "{0}|<<<|{1}|{2}[{3}]|{5}";
    private static final int DEFAULT_FORMAT_EXCEPTION_INDEX = 5;
    private static final int DEFAULT_FORMAT_EXCEPTION_INDEX_INSTANCE = 5;
    private static SimpleLog defaultInstance = null;
    private static final Object defaultInstanceLock = new Object();
    private static boolean devDebug = false;
    private final URL configurationSource;
    private final Properties properties;
    private PrintWriter out;
    private Writer currentWriter;
    private boolean outputSetProgramatically = false;
    private String logFile;
    private boolean printWriterGoesToConsole = true;
    private boolean pipingOutputToConsole = false;
    private DebugLevel defaultLevel = DebugLevel.L4_INFO;
    private boolean defaultTracing = false;
    private final List loggers = new ArrayList(32);
    private final List instanceLoggerReferences = new ArrayList(16);
    private ReferenceQueue instanceLoggersReferenceQueue = null;
    private final Object LOGGERS_LOCK = new Object();
    private DateFormat dateFormat;
    private MessageFormat dbFormat;
    private MessageFormat dboFormat;
    private MessageFormat dbeFormat;
    private MessageFormat entryFormat;
    private MessageFormat exitFormat;
    private MessageFormat dbFormat4Instance;
    private MessageFormat dboFormat4Instance;
    private MessageFormat dbeFormat4Instance;
    private MessageFormat entryFormat4Instance;
    private MessageFormat exitFormat4Instance;
    static /* synthetic */ Class class$org$grlea$log$SimpleLog;

    public SimpleLog(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null.");
        }
        this.configurationSource = null;
        this.properties = properties;
        this.out = new PrintWriter(System.err, true);
        this.readSettingsFromProperties();
    }

    public SimpleLog(URL uRL) throws IOException {
        this.configurationSource = uRL;
        this.properties = new Properties();
        this.out = new PrintWriter(System.err, true);
        this.loadProperties();
        this.readSettingsFromProperties();
        String string = this.properties.getProperty("simplelog.reloading", "false");
        boolean bl = Boolean.valueOf(string);
        if (bl) {
            int n;
            TimerTask timerTask;
            SimpleLog.printDebugIfEnabled("Configuration reloading enabled");
            Timer timer = new Timer(true);
            if (uRL.getProtocol() != null && "file".equals(uRL.getProtocol().toLowerCase())) {
                timerTask = new FileConfigurationReloader();
                n = 20000;
            } else {
                timerTask = new UrlConfigurationReloader();
                n = 60000;
            }
            timer.schedule(timerTask, n, (long)n);
        } else {
            SimpleLog.printDebugIfEnabled("Configuration reloading is disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() throws IOException {
        Object object;
        String[] stringArray;
        if (this.properties == null) {
            return;
        }
        SimpleLog.printDebugIfEnabled("Loading properties");
        InputStream inputStream = this.configurationSource.openStream();
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        String string = properties.getProperty("simplelog.import");
        if (string != null && (string = string.trim()).length() > 0 && (stringArray = string.split(",")) != null && stringArray.length != 0) {
            object = this.configurationSource.toExternalForm();
            int n = ((String)object).lastIndexOf(47);
            object = ((String)object).substring(0, ++n);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                URL uRL = new URL((String)object + string2);
                InputStream inputStream2 = null;
                try {
                    SimpleLog.printDebugIfEnabled("Importing file", uRL);
                    inputStream2 = uRL.openStream();
                    properties.load(inputStream2);
                    continue;
                }
                catch (IOException iOException) {
                    SimpleLog.printError("Error importing properties file: " + string2 + "(" + uRL + ")", iOException, true);
                    continue;
                }
                finally {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
            }
        }
        if (devDebug) {
            stringArray = properties.entrySet();
            SimpleLog.printDebugIfEnabled("_____ Properties List START _____");
            object = stringArray.iterator();
            while (object.hasNext()) {
                Map.Entry<Object, Object> entry = object.next();
                SimpleLog.printDebugIfEnabled((String)entry.getKey(), entry.getValue());
            }
            SimpleLog.printDebugIfEnabled("______ Properties List END ______");
        }
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    private void readSettingsFromProperties() {
        Object object;
        String string;
        String string2;
        String string3;
        block17: {
            if (!this.outputSetProgramatically) {
                try {
                    string3 = this.properties.getProperty("simplelog.rollover");
                    boolean bl = string3 != null && string3.trim().length() != 0;
                    Writer writer = bl ? this.configureRolloverWriter() : this.configureFileWriter();
                    if (writer == this.currentWriter) break block17;
                    this.out = new PrintWriter(writer, true);
                    if (this.currentWriter != null) {
                        try {
                            this.currentWriter.close();
                        }
                        catch (IOException iOException) {
                            SimpleLog.printError("Error while closing log file", iOException, true);
                        }
                    }
                    this.currentWriter = writer;
                }
                catch (IOException iOException) {
                    SimpleLog.printError("Error opening log file for writing", iOException, true);
                }
            }
        }
        string3 = this.properties.getProperty("simplelog.logFile.andConsole");
        this.pipingOutputToConsole = false;
        if (string3 != null) {
            this.pipingOutputToConsole = string3.trim().equalsIgnoreCase("true");
        }
        if ((string2 = this.properties.getProperty("simplelog.defaultLevel")) != null) {
            string2 = string2.trim();
            try {
                int n = Integer.parseInt(string2);
                this.defaultLevel = DebugLevel.fromInt(n);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.defaultLevel = DebugLevel.fromName(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SimpleLog.printError("Error parsing debug level for 'simplelog.defaultLevel'", numberFormatException, true);
                    SimpleLog.printError("Error parsing debug level for 'simplelog.defaultLevel'", illegalArgumentException, false);
                }
            }
        }
        if ((string = this.properties.getProperty("simplelog.defaultTrace")) != null) {
            this.defaultTracing = Boolean.valueOf(string);
        }
        String string4 = this.properties.getProperty("simplelog.dateFormat", "EEE yyyy/MM/dd HH:mm:ss.SSS");
        try {
            this.dateFormat = new SimpleDateFormat(string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SimpleLog.printError("Error parsing date format", illegalArgumentException, false);
        }
        this.dbFormat = this.readFormat("simplelog.format.debug", "{0}|   |{1}|{2}|{5}");
        this.dboFormat = this.readFormat("simplelog.format.debugObject", "{0}|---|{1}|{2}|{5}|{6}");
        this.dbeFormat = this.readFormat("simplelog.format.debugException", "{0}|***|{1}|{2}|{5}");
        this.entryFormat = this.readFormat("simplelog.format.entry", "{0}|>>>|{1}|{2}|{5}");
        this.exitFormat = this.readFormat("simplelog.format.exit", "{0}|<<<|{1}|{2}|{5}");
        this.dbFormat4Instance = this.readFormat("simplelog.format.debug.instance", "{0}|   |{1}|{2}[{3}]|{5}");
        this.dboFormat4Instance = this.readFormat("simplelog.format.debugObject.instance", "{0}|---|{1}|{2}[{3}]|{5}|{6}");
        this.dbeFormat4Instance = this.readFormat("simplelog.format.debugException.instance", "{0}|***|{1}|{2}[{3}]|{5}");
        this.entryFormat4Instance = this.readFormat("simplelog.format.entry.instance", "{0}|>>>|{1}|{2}[{3}]|{5}");
        this.exitFormat4Instance = this.readFormat("simplelog.format.exit.instance", "{0}|<<<|{1}|{2}[{3}]|{5}");
        this.updateDateFormats();
        String string5 = this.properties.getProperty("simplelog.printStackTraces", "true");
        boolean bl = Boolean.valueOf(string5);
        if (bl) {
            object = new ExceptionFormat();
            this.dbeFormat.setFormatByArgumentIndex(5, (Format)object);
            this.dbeFormat4Instance.setFormatByArgumentIndex(5, (Format)object);
        }
        object = this.properties.propertyNames();
        Properties properties = new Properties();
        while (object.hasMoreElements()) {
            String string6 = (String)object.nextElement();
            if (string6.indexOf(36) == -1) continue;
            properties.put(string6.replace('$', '.'), this.properties.getProperty(string6));
        }
        this.properties.putAll((Map<?, ?>)properties);
    }

    private Writer configureFileWriter() throws IOException {
        Writer writer;
        boolean bl;
        boolean bl2;
        String string = this.properties.getProperty("simplelog.logFile");
        boolean bl3 = true;
        String string2 = this.properties.getProperty("simplelog.logFile.interpretName");
        if (string2 != null) {
            bl3 = !string2.trim().equalsIgnoreCase("false");
        }
        boolean bl4 = string != null;
        boolean bl5 = bl2 = bl4 && string.indexOf(123) != -1;
        if (bl4 && bl2 && bl3) {
            try {
                MessageFormat messageFormat = new MessageFormat(string);
                string = messageFormat.format(new Object[]{new Date()});
            }
            catch (Exception exception) {
                SimpleLog.printError("Error generating log file name", exception, true);
                string = null;
            }
        }
        boolean bl6 = this.logFile == null != (string == null);
        bl6 |= this.logFile != null && bl4 && !string.equals(this.logFile);
        boolean bl7 = bl = this.currentWriter != null && this.currentWriter.getClass().getName().equals("org.grlea.log.rollover.RolloverManager");
        if (bl6 |= bl) {
            if (string == null) {
                writer = new OutputStreamWriter(System.err);
                this.printWriterGoesToConsole = true;
            } else {
                File file = new File(string).getAbsoluteFile();
                if (file.isDirectory()) {
                    throw new IOException("The specified log file name already exists as a directory.");
                }
                File file2 = file.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                boolean bl8 = true;
                String string3 = this.properties.getProperty("simplelog.logFile.append");
                if (string3 != null) {
                    bl8 = !string3.trim().equalsIgnoreCase("false");
                }
                writer = new FileWriter(file, bl8);
                this.printWriterGoesToConsole = false;
            }
            this.logFile = string;
        } else {
            writer = this.currentWriter;
        }
        return writer;
    }

    private Writer configureRolloverWriter() throws IOException {
        Writer writer;
        try {
            Class.forName("org.grlea.log.rollover.RolloverManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("The RolloverManager class is not available: " + classNotFoundException);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.currentWriter != null && this.currentWriter.getClass().getName().equals("org.grlea.log.rollover.RolloverManager")) {
            ((RolloverManager)this.currentWriter).configure(this.properties);
            writer = this.currentWriter;
        } else {
            writer = RolloverManager.createRolloverManager((Properties)this.properties, (RolloverManager.ErrorReporter)ErrorReporter.access$100());
        }
        this.printWriterGoesToConsole = false;
        return writer;
    }

    public void reloadProperties() {
        try {
            if (this.configurationSource != null) {
                this.loadProperties();
            }
            this.readSettingsFromProperties();
            this.reconfigureAllLoggers();
        }
        catch (Exception exception) {
            SimpleLog.printError("Falied to reload properties", exception, true);
        }
    }

    private MessageFormat readFormat(String string, String string2) {
        MessageFormat messageFormat;
        String string3 = this.properties.getProperty(string, string2);
        try {
            messageFormat = new MessageFormat(string3);
        }
        catch (Exception exception) {
            SimpleLog.printError("Error reading format string from " + string, exception, false);
            messageFormat = new MessageFormat(string2);
        }
        return messageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleLog defaultInstance() {
        Object object = defaultInstanceLock;
        synchronized (object) {
            if (defaultInstance == null) {
                SimpleLog.printDebugIfEnabled("Creating default SimpleLog instance");
                URL uRL = SimpleLog.getPropertiesUrl();
                if (uRL != null) {
                    SimpleLog.printDebugIfEnabled("Attempting to configure using properties at", uRL);
                    try {
                        defaultInstance = new SimpleLog(uRL);
                    }
                    catch (Exception exception) {
                        SimpleLog.printError("Error while attempting to load default properties", exception, true);
                    }
                }
                if (defaultInstance == null) {
                    SimpleLog.printDebugIfEnabled("");
                    SimpleLog.printDebugIfEnabled("FAILED to load any SimpleLog configuration.");
                    SimpleLog.printDebugIfEnabled("");
                    SimpleLog.printDebugIfEnabled("NO LOG OUTPUT WILL BE GENERATED.");
                    defaultInstance = new SimpleLog(new Properties());
                    defaultInstance.setWriter(null);
                }
            }
        }
        return defaultInstance;
    }

    private static URL getPropertiesUrl() {
        String string = null;
        try {
            string = System.getProperty("simplelog.configuration");
        }
        catch (SecurityException securityException) {
            SimpleLog.printError("SecurityException while trying to read system property", securityException, true);
        }
        SimpleLog.printDebugIfEnabled("System property 'simplelog.configuration'", string);
        URL uRL = null;
        if (string != null) {
            String string2;
            if (string.startsWith("file:")) {
                string2 = string.substring("file:".length());
                File file = new File(string2);
                if (file.exists()) {
                    try {
                        uRL = file.toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        SimpleLog.printError("Error creating URL from filename '" + string2 + "'", malformedURLException, false);
                    }
                } else {
                    SimpleLog.printError("Properties file not found at '" + string2 + "'");
                }
            } else if (string.startsWith("classpath:")) {
                string2 = string.substring("classpath:".length());
                uRL = (class$org$grlea$log$SimpleLog == null ? (class$org$grlea$log$SimpleLog = SimpleLog.class$("org.grlea.log.SimpleLog")) : class$org$grlea$log$SimpleLog).getClassLoader().getResource(string2);
                if (uRL == null) {
                    SimpleLog.printError("Properties not found in classpath at '" + string2 + "'");
                }
            } else {
                SimpleLog.printError("simplelog.configuration property must begin with 'file:' or 'classpath:' ('" + string + "')");
            }
        }
        if (uRL == null) {
            SimpleLog.printDebugIfEnabled("Attempting to load default properties (simplelog.properties) from classpath");
            uRL = (class$org$grlea$log$SimpleLog == null ? (class$org$grlea$log$SimpleLog = SimpleLog.class$("org.grlea.log.SimpleLog")) : class$org$grlea$log$SimpleLog).getClassLoader().getResource("simplelog.properties");
        }
        if (uRL != null && uRL.toExternalForm().indexOf(32) != -1) {
            try {
                uRL = new URL(uRL.toString().replaceAll(" ", "%20"));
            }
            catch (MalformedURLException malformedURLException) {
                SimpleLog.printError("Failed to encode spaces in properties URL", malformedURLException, true);
            }
        }
        return uRL;
    }

    void println(String string) {
        if (this.out != null) {
            this.out.println(string);
            if (!this.printWriterGoesToConsole && this.pipingOutputToConsole) {
                System.err.println(string);
            }
        }
    }

    void configure(SimpleLogger simpleLogger) {
        simpleLogger.setDebugLevel(this.getDebugLevel(simpleLogger));
        simpleLogger.setTracing(this.getTracingFlag(simpleLogger));
    }

    private DebugLevel getDebugLevel(SimpleLogger simpleLogger) {
        if (this.properties == null) {
            return this.defaultLevel;
        }
        String string = simpleLogger.getConfigName();
        int n = string.length();
        DebugLevel debugLevel = null;
        do {
            String string2;
            if ((string2 = this.properties.getProperty(string = string.substring(0, n))) != null) {
                string2 = string2.trim();
                try {
                    int n2 = Integer.parseInt(string2);
                    debugLevel = DebugLevel.fromInt(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        debugLevel = DebugLevel.fromName(string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        SimpleLog.printError("Error parsing debug level for '" + string + "'", numberFormatException, true);
                        SimpleLog.printError("Error parsing debug level for '" + string + "'", illegalArgumentException, false);
                    }
                }
            }
            n = string.lastIndexOf(46);
        } while (debugLevel == null && n != -1);
        if (debugLevel == null) {
            debugLevel = this.defaultLevel;
        }
        return debugLevel;
    }

    private boolean getTracingFlag(SimpleLogger simpleLogger) {
        if (this.properties == null) {
            return this.defaultTracing;
        }
        String string = simpleLogger.getConfigName();
        int n = string.length();
        boolean bl = this.defaultTracing;
        do {
            String string2;
            if ((string2 = this.properties.getProperty((string = string.substring(0, n)) + "#trace")) == null) continue;
            bl = Boolean.valueOf(string2);
            break;
        } while ((n = string.lastIndexOf(46)) != -1);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(SimpleLogger simpleLogger) {
        Object object = this.LOGGERS_LOCK;
        synchronized (object) {
            if (!simpleLogger.isInstanceDebugger()) {
                this.loggers.add(simpleLogger);
            } else {
                if (this.instanceLoggersReferenceQueue == null) {
                    this.createInstanceLoggersReferenceQueue();
                }
                this.instanceLoggerReferences.add(new WeakReference<SimpleLogger>(simpleLogger, this.instanceLoggersReferenceQueue));
            }
        }
        this.configure(simpleLogger);
    }

    private void createInstanceLoggersReferenceQueue() {
        this.instanceLoggersReferenceQueue = new ReferenceQueue();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.yield();
                            Reference reference = SimpleLog.this.instanceLoggersReferenceQueue.remove();
                            Object object = SimpleLog.this.LOGGERS_LOCK;
                            synchronized (object) {
                                SimpleLog.this.instanceLoggerReferences.remove(reference);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        }, "SimpleLog Instance Logger Cleaner");
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconfigureAllLoggers() {
        Object object = this.LOGGERS_LOCK;
        synchronized (object) {
            SimpleLog.printDebugIfEnabled("Re-configuring all loggers");
            Iterator iterator = this.loggers.iterator();
            while (iterator.hasNext()) {
                this.configure((SimpleLogger)iterator.next());
            }
            iterator = this.instanceLoggerReferences.iterator();
            while (iterator.hasNext()) {
                Reference reference = (Reference)iterator.next();
                SimpleLogger simpleLogger = (SimpleLogger)reference.get();
                if (simpleLogger == null) continue;
                this.configure(simpleLogger);
            }
        }
    }

    private static void printDebugIfEnabled(String string) {
        if (devDebug) {
            System.err.println("SimpleLog [dev.debug]: " + string);
        }
    }

    private static void printDebugIfEnabled(String string, Object object) {
        if (devDebug) {
            System.err.println("SimpleLog [dev.debug]: " + string + ": " + object);
        }
    }

    private static void printError(String string) {
        SimpleLog.printError(string, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printError(String string, Throwable throwable, boolean bl) {
        Object object;
        boolean bl2 = false;
        try {
            object = System.getProperty("simplelog.dev.printStackTraces");
            bl2 = object != null && ((String)object).trim().equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object = System.err;
        synchronized (object) {
            System.err.println();
            System.err.print("   SimpleLog ERROR: ");
            System.err.print(string);
            if (throwable != null) {
                System.err.print(": ");
                if (bl) {
                    System.err.println(throwable);
                } else {
                    System.err.println(throwable.getMessage());
                }
                if (bl2) {
                    try {
                        System.err.println();
                        throwable.printStackTrace(System.err);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                System.err.println();
            } else {
                System.err.println();
                System.err.println();
            }
        }
    }

    public DebugLevel getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(DebugLevel debugLevel) {
        if (debugLevel == null) {
            throw new IllegalArgumentException("defaultLevel cannot be null.");
        }
        this.defaultLevel = debugLevel;
        this.reconfigureAllLoggers();
    }

    public boolean isDefaultTracing() {
        return this.defaultTracing;
    }

    public void setDefaultTracing(boolean bl) {
        this.defaultTracing = bl;
        this.reconfigureAllLoggers();
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat == null ? new SimpleDateFormat("EEE yyyy/MM/dd HH:mm:ss.SSS") : dateFormat;
        this.updateDateFormats();
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public void setWriter(PrintWriter printWriter) {
        this.out = printWriter;
        this.outputSetProgramatically = true;
    }

    boolean isOutputting() {
        return this.out != null;
    }

    private void updateDateFormats() {
        this.dbFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.dboFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.dbeFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.entryFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.exitFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.dbFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.dboFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.dbeFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.entryFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.exitFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
    }

    MessageFormat getDebugFormat() {
        return this.dbFormat;
    }

    MessageFormat getDebugInstanceFormat() {
        return this.dbFormat4Instance;
    }

    MessageFormat getDebugObjectFormat() {
        return this.dboFormat;
    }

    MessageFormat getDebugObjectInstanceFormat() {
        return this.dboFormat4Instance;
    }

    MessageFormat getDebugExceptionFormat() {
        return this.dbeFormat;
    }

    MessageFormat getDebugExceptionInstanceFormat() {
        return this.dbeFormat4Instance;
    }

    MessageFormat getEntryFormat() {
        return this.entryFormat;
    }

    MessageFormat getEntryInstanceFormat() {
        return this.entryFormat4Instance;
    }

    MessageFormat getExitFormat() {
        return this.exitFormat;
    }

    MessageFormat getExitInstanceFormat() {
        return this.exitFormat4Instance;
    }

    public boolean isPipingOutputToConsole() {
        return this.pipingOutputToConsole;
    }

    public void setPipingOutputToConsole(boolean bl) {
        this.pipingOutputToConsole = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$800(String string, Throwable throwable, boolean bl) {
        SimpleLog.printError(string, throwable, bl);
    }

    static {
        try {
            String string = System.getProperty("simplelog.dev.debug");
            if (string != null && "true".equalsIgnoreCase(string.trim())) {
                devDebug = true;
                SimpleLog.printDebugIfEnabled("Simple Log DEV Debugging enabled (-Dsimplelog.dev.debug)");
            }
        }
        catch (Exception exception) {
            SimpleLog.printError("Exception while reading system property 'simplelog.dev.debug'", exception, true);
        }
    }

    private final class UrlConfigurationReloader
    extends TimerTask {
        private long previousLastModified;

        public UrlConfigurationReloader() {
            try {
                URLConnection uRLConnection = SimpleLog.this.configurationSource.openConnection();
                this.previousLastModified = uRLConnection.getLastModified();
            }
            catch (IOException iOException) {
                this.previousLastModified = 0L;
            }
        }

        public void run() {
            long l;
            Object object;
            try {
                object = SimpleLog.this.configurationSource.openConnection();
                l = ((URLConnection)object).getLastModified();
            }
            catch (IOException iOException) {
                l = 0L;
            }
            if (l == 0L) {
                object = new Properties();
                try {
                    InputStream inputStream = SimpleLog.this.configurationSource.openStream();
                    ((Properties)object).load(inputStream);
                    if (!((Properties)object).equals(SimpleLog.this.properties)) {
                        SimpleLog.this.reloadProperties();
                    }
                }
                catch (IOException iOException) {}
            } else if (this.previousLastModified != l) {
                SimpleLog.this.reloadProperties();
                this.previousLastModified = l;
            }
        }
    }

    private final class FileConfigurationReloader
    extends TimerTask {
        private final File configurationFile;
        private long previousLastModified;

        public FileConfigurationReloader() {
            try {
                URI uRI = new URI(SimpleLog.this.configurationSource.toExternalForm());
                this.configurationFile = new File(uRI);
                this.previousLastModified = this.configurationFile.lastModified();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Failed to create URI from URL due to " + uRISyntaxException);
            }
        }

        public void run() {
            long l = this.configurationFile.lastModified();
            if (this.previousLastModified != l) {
                SimpleLog.this.reloadProperties();
                this.previousLastModified = l;
            }
        }
    }

    private static final class ExceptionFormat
    extends Format {
        private ExceptionFormat() {
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            if (!(object instanceof Throwable)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only formats Throwables.");
            }
            Throwable throwable = (Throwable)object;
            stringBuffer.append(throwable);
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(LINE_SEP).append(stringWriter.toString());
            return stringBuffer;
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            throw new UnsupportedOperationException();
        }
    }
}

