/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;

public class BasicMarker
implements Marker {
    final String name;
    List children;
    final IMarkerFactory factory;

    BasicMarker(String string, IMarkerFactory iMarkerFactory) {
        this.name = string;
        this.factory = iMarkerFactory;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(Marker marker) {
        if (marker == null) {
            throw new NullPointerException("Null children cannot be added to a Marker.");
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(marker);
    }

    public synchronized boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public synchronized Iterator iterator() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public synchronized boolean remove(Marker marker) {
        if (this.children == null) {
            return false;
        }
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Marker marker2 = (Marker)this.children.get(i);
            if (marker2 != marker) continue;
            return false;
        }
        return false;
    }

    public boolean contains(Marker marker) {
        if (marker == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this == marker) {
            return true;
        }
        if (this.hasChildren()) {
            for (int i = 0; i < this.children.size(); ++i) {
                Marker marker2 = (Marker)this.children.get(i);
                if (!marker2.contains(marker)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        if (this.factory.exists(string)) {
            Marker marker = this.factory.getMarker(string);
            return this.contains(marker);
        }
        return false;
    }
}

