/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ddlutils.io.DdlUtilsXMLException;

public class PrettyPrintingXmlWriter {
    private static final String INDENT_STRING = "  ";
    private XMLStreamWriter _writer;
    private String _encoding;
    private boolean _prettyPrinting = true;

    public PrettyPrintingXmlWriter(OutputStream output) throws DdlUtilsXMLException {
        this(output, "UTF-8");
    }

    public PrettyPrintingXmlWriter(OutputStream output, String encoding) throws DdlUtilsXMLException {
        BufferedOutputStream bufferedOutput = output instanceof BufferedOutputStream ? (BufferedOutputStream)output : new BufferedOutputStream(output);
        this._encoding = encoding == null || encoding.length() == 0 ? "UTF-8" : encoding;
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this._writer = factory.createXMLStreamWriter(bufferedOutput, this._encoding);
        }
        catch (XMLStreamException ex) {
            this.throwException(ex);
        }
    }

    public PrettyPrintingXmlWriter(Writer output, String encoding) throws DdlUtilsXMLException {
        BufferedWriter bufferedWriter = output instanceof BufferedWriter ? (BufferedWriter)output : new BufferedWriter(output);
        this._encoding = encoding;
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this._writer = factory.createXMLStreamWriter(bufferedWriter);
        }
        catch (XMLStreamException ex) {
            this.throwException(ex);
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    protected void throwException(Exception baseEx) throws DdlUtilsXMLException {
        throw new DdlUtilsXMLException(baseEx);
    }

    public boolean isPrettyPrinting() {
        return this._prettyPrinting;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this._prettyPrinting = prettyPrinting;
    }

    public void setDefaultNamespace(String uri) throws DdlUtilsXMLException {
        try {
            this._writer.setDefaultNamespace(uri);
        }
        catch (XMLStreamException ex) {
            this.throwException(ex);
        }
    }

    public void printlnIfPrettyPrinting() throws DdlUtilsXMLException {
        if (this._prettyPrinting) {
            try {
                this._writer.writeCharacters("\n");
            }
            catch (XMLStreamException ex) {
                this.throwException(ex);
            }
        }
    }

    public void indentIfPrettyPrinting(int level) throws DdlUtilsXMLException {
        if (this._prettyPrinting) {
            try {
                int idx = 0;
                while (idx < level) {
                    this._writer.writeCharacters(INDENT_STRING);
                    ++idx;
                }
            }
            catch (XMLStreamException ex) {
                this.throwException(ex);
            }
        }
    }

    public void writeDocumentStart() throws DdlUtilsXMLException {
        try {
            this._writer.writeStartDocument(this._encoding, "1.0");
            this.printlnIfPrettyPrinting();
        }
        catch (XMLStreamException ex) {
            this.throwException(ex);
        }
    }

    public void writeDocumentEnd() throws DdlUtilsXMLException {
        try {
            this._writer.writeEndDocument();
            this._writer.flush();
            this._writer.close();
        }
        catch (XMLStreamException ex) {
            this.throwException(ex);
        }
    }

    public void writeNamespace(String prefix, String namespaceUri) throws DdlUtilsXMLException {
        try {
            if (prefix == null || prefix.length() == 0) {
                this._writer.writeDefaultNamespace(namespaceUri);
            } else {
                this._writer.writeNamespace(prefix, namespaceUri);
            }
        }
        catch (XMLStreamException ex) {
            this.throwException(ex);
        }
    }

    public void writeElementStart(String namespaceUri, String localPart) throws DdlUtilsXMLException {
        try {
            if (namespaceUri == null) {
                this._writer.writeStartElement(localPart);
            } else {
                this._writer.writeStartElement(namespaceUri, localPart);
            }
        }
        catch (XMLStreamException ex) {
            this.throwException(ex);
        }
    }

    public void writeElementEnd() throws DdlUtilsXMLException {
        try {
            this._writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            this.throwException(ex);
        }
    }

    public void writeAttribute(String namespaceUri, String localPart, String value) throws DdlUtilsXMLException {
        if (value != null) {
            try {
                if (namespaceUri == null) {
                    this._writer.writeAttribute(localPart, value);
                } else {
                    this._writer.writeAttribute(namespaceUri, localPart, value);
                }
            }
            catch (XMLStreamException ex) {
                this.throwException(ex);
            }
        }
    }

    public void writeCData(String data) throws DdlUtilsXMLException {
        if (data != null) {
            try {
                this._writer.writeCData(data);
            }
            catch (XMLStreamException ex) {
                this.throwException(ex);
            }
        }
    }

    public void writeCharacters(String data) throws DdlUtilsXMLException {
        if (data != null) {
            try {
                this._writer.writeCharacters(data);
            }
            catch (XMLStreamException ex) {
                this.throwException(ex);
            }
        }
    }
}

