/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.mssql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.AddForeignKeyChange;
import org.apache.ddlutils.alteration.AddIndexChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.ModelComparator;
import org.apache.ddlutils.alteration.RemoveForeignKeyChange;
import org.apache.ddlutils.alteration.RemoveIndexChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.TableDefinitionChangesPredicate;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;

public class MSSqlModelComparator
extends ModelComparator {
    public MSSqlModelComparator(PlatformInfo platformInfo, TableDefinitionChangesPredicate tableDefChangePredicate, boolean caseSensitive) {
        super(platformInfo, tableDefChangePredicate, caseSensitive);
        this.setGeneratePrimaryKeyChanges(false);
        this.setCanDropPrimaryKeyColumns(false);
    }

    protected List checkForPrimaryKeyChanges(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        List changes = super.checkForPrimaryKeyChanges(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable);
        if (changes.isEmpty()) {
            List columns = this.getRelevantChangedColumns(sourceTable, targetTable);
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                Column targetColumn = (Column)it.next();
                if (!targetColumn.isPrimaryKey()) continue;
                changes.add(new RemovePrimaryKeyChange(sourceTable.getName()));
                changes.add(new AddPrimaryKeyChange(sourceTable.getName(), sourceTable.getPrimaryKeyColumnNames()));
                break;
            }
        }
        return changes;
    }

    protected List checkForRemovedIndexes(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        List columns;
        List changes = super.checkForRemovedIndexes(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable);
        Index[] targetIndexes = targetTable.getIndices();
        ArrayList<RemoveIndexChange> additionalChanges = new ArrayList<RemoveIndexChange>();
        if (targetIndexes.length > 0 && !(columns = this.getRelevantChangedColumns(sourceTable, targetTable)).isEmpty()) {
            int indexIdx = 0;
            while (indexIdx < targetIndexes.length) {
                Index sourceIndex = this.findCorrespondingIndex(sourceTable, targetIndexes[indexIdx]);
                if (sourceIndex != null) {
                    Iterator columnIt = columns.iterator();
                    while (columnIt.hasNext()) {
                        Column targetColumn = (Column)columnIt.next();
                        if (!targetIndexes[indexIdx].hasColumn(targetColumn)) continue;
                        additionalChanges.add(new RemoveIndexChange(intermediateTable.getName(), targetIndexes[indexIdx]));
                        break;
                    }
                }
                ++indexIdx;
            }
            Iterator changeIt = additionalChanges.iterator();
            while (changeIt.hasNext()) {
                ((RemoveIndexChange)changeIt.next()).apply(intermediateModel, this.isCaseSensitive());
            }
            changes.addAll(additionalChanges);
        }
        return changes;
    }

    protected List checkForAddedIndexes(Database sourceModel, Table sourceTable, Database intermediateModel, Table intermediateTable, Database targetModel, Table targetTable) {
        List changes = super.checkForAddedIndexes(sourceModel, sourceTable, intermediateModel, intermediateTable, targetModel, targetTable);
        Index[] targetIndexes = targetTable.getIndices();
        ArrayList<AddIndexChange> additionalChanges = new ArrayList<AddIndexChange>();
        if (targetIndexes.length > 0) {
            int indexIdx = 0;
            while (indexIdx < targetIndexes.length) {
                Index sourceIndex = this.findCorrespondingIndex(sourceTable, targetIndexes[indexIdx]);
                Index intermediateIndex = this.findCorrespondingIndex(intermediateTable, targetIndexes[indexIdx]);
                if (sourceIndex != null && intermediateIndex == null) {
                    additionalChanges.add(new AddIndexChange(intermediateTable.getName(), targetIndexes[indexIdx]));
                }
                ++indexIdx;
            }
            Iterator changeIt = additionalChanges.iterator();
            while (changeIt.hasNext()) {
                ((AddIndexChange)changeIt.next()).apply(intermediateModel, this.isCaseSensitive());
            }
            changes.addAll(additionalChanges);
        }
        return changes;
    }

    protected List checkForRemovedForeignKeys(Database sourceModel, Database intermediateModel, Database targetModel) {
        List changes = super.checkForRemovedForeignKeys(sourceModel, intermediateModel, targetModel);
        ArrayList<RemoveForeignKeyChange> additionalChanges = new ArrayList<RemoveForeignKeyChange>();
        int tableIdx = 0;
        while (tableIdx < targetModel.getTableCount()) {
            List columns;
            Table targetTable = targetModel.getTable(tableIdx);
            Table sourceTable = sourceModel.findTable(targetTable.getName(), this.isCaseSensitive());
            if (sourceTable != null && !(columns = this.getRelevantChangedColumns(sourceTable, targetTable)).isEmpty()) {
                int fkIdx = 0;
                while (fkIdx < targetTable.getForeignKeyCount()) {
                    ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
                    ForeignKey sourceFk = this.findCorrespondingForeignKey(sourceTable, targetFk);
                    if (sourceFk != null) {
                        Iterator columnIt = columns.iterator();
                        while (columnIt.hasNext()) {
                            Column targetColumn = (Column)columnIt.next();
                            if (!targetFk.hasLocalColumn(targetColumn) && !targetFk.hasForeignColumn(targetColumn)) continue;
                            additionalChanges.add(new RemoveForeignKeyChange(sourceTable.getName(), targetFk));
                            break;
                        }
                    }
                    ++fkIdx;
                }
            }
            ++tableIdx;
        }
        Iterator changeIt = additionalChanges.iterator();
        while (changeIt.hasNext()) {
            ((RemoveForeignKeyChange)changeIt.next()).apply(intermediateModel, this.isCaseSensitive());
        }
        changes.addAll(additionalChanges);
        return changes;
    }

    protected List checkForAddedForeignKeys(Database sourceModel, Database intermediateModel, Database targetModel) {
        List changes = super.checkForAddedForeignKeys(sourceModel, intermediateModel, targetModel);
        ArrayList<AddForeignKeyChange> additionalChanges = new ArrayList<AddForeignKeyChange>();
        int tableIdx = 0;
        while (tableIdx < targetModel.getTableCount()) {
            Table targetTable = targetModel.getTable(tableIdx);
            Table sourceTable = sourceModel.findTable(targetTable.getName(), this.isCaseSensitive());
            Table intermediateTable = intermediateModel.findTable(targetTable.getName(), this.isCaseSensitive());
            if (sourceTable != null) {
                int fkIdx = 0;
                while (fkIdx < targetTable.getForeignKeyCount()) {
                    ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
                    ForeignKey sourceFk = this.findCorrespondingForeignKey(sourceTable, targetFk);
                    ForeignKey intermediateFk = this.findCorrespondingForeignKey(intermediateTable, targetFk);
                    if (sourceFk != null && intermediateFk == null) {
                        additionalChanges.add(new AddForeignKeyChange(intermediateTable.getName(), targetFk));
                    }
                    ++fkIdx;
                }
            }
            ++tableIdx;
        }
        Iterator changeIt = additionalChanges.iterator();
        while (changeIt.hasNext()) {
            ((AddForeignKeyChange)changeIt.next()).apply(intermediateModel, this.isCaseSensitive());
        }
        changes.addAll(additionalChanges);
        return changes;
    }

    private List getRelevantChangedColumns(Table sourceTable, Table targetTable) {
        ArrayList<Column> result = new ArrayList<Column>();
        int columnIdx = 0;
        while (columnIdx < targetTable.getColumnCount()) {
            int targetTypeCode;
            Column targetColumn = targetTable.getColumn(columnIdx);
            Column sourceColumn = sourceTable.findColumn(targetColumn.getName(), this.isCaseSensitive());
            if (sourceColumn != null && ((targetTypeCode = this.getPlatformInfo().getTargetJdbcType(targetColumn.getTypeCode())) != sourceColumn.getTypeCode() || ColumnDefinitionChange.isSizeChanged(this.getPlatformInfo(), sourceColumn, targetColumn))) {
                result.add(targetColumn);
            }
            ++columnIdx;
        }
        return result;
    }
}

