/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ModelHelper;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.task.DatabaseTaskBase;
import org.apache.ddlutils.task.DropTablesCommand;
import org.apache.ddlutils.task.TaskHelper;
import org.apache.ddlutils.task.WriteDataToDatabaseCommand;
import org.apache.ddlutils.task.WriteDataToFileCommand;
import org.apache.ddlutils.task.WriteDtdToFileCommand;
import org.apache.ddlutils.task.WriteSchemaSqlToFileCommand;
import org.apache.ddlutils.task.WriteSchemaToFileCommand;
import org.apache.tools.ant.BuildException;

public class DatabaseToDdlTask
extends DatabaseTaskBase {
    private String _tableTypes;
    private String _modelName = "unnamed";
    private String[] _includeTableNames;
    private String _includeTableNameRegExp;
    private String[] _excludeTableNames;
    private String _excludeTableNameRegExp;

    public void setTableTypes(String tableTypes) {
        this._tableTypes = tableTypes;
    }

    public void setModelName(String modelName) {
        this._modelName = modelName;
    }

    public void setIncludeTables(String tableNameList) {
        this._includeTableNames = new TaskHelper().parseCommaSeparatedStringList(tableNameList);
    }

    public void setIncludeTableFilter(String tableNameRegExp) {
        this._includeTableNameRegExp = tableNameRegExp;
    }

    public void setExcludeTables(String tableNameList) {
        this._excludeTableNames = new TaskHelper().parseCommaSeparatedStringList(tableNameList);
    }

    public void setExcludeTableFilter(String tableNameRegExp) {
        this._excludeTableNameRegExp = tableNameRegExp;
    }

    public void addWriteDtdToFile(WriteDtdToFileCommand command) {
        this.addCommand(command);
    }

    public void addWriteSchemaToFile(WriteSchemaToFileCommand command) {
        this.addCommand(command);
    }

    public void addWriteSchemaSqlToFile(WriteSchemaSqlToFileCommand command) {
        this.addCommand(command);
    }

    public void addWriteDataToDatabase(WriteDataToDatabaseCommand command) {
        this.addCommand(command);
    }

    public void addWriteDataToFile(WriteDataToFileCommand command) {
        this.addCommand(command);
    }

    public void addDropTables(DropTablesCommand command) {
        this.addCommand(command);
    }

    private String[] getTableTypes() {
        if (this._tableTypes == null || this._tableTypes.length() == 0) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(this._tableTypes, ",");
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    protected Database readModel() {
        if (this.getDataSource() == null) {
            throw new BuildException("No database specified.");
        }
        try {
            Database model = this.getPlatform().readModelFromDatabase(this._modelName, this.getPlatformConfiguration().getCatalogPattern(), this.getPlatformConfiguration().getSchemaPattern(), this.getTableTypes());
            if (this._includeTableNames != null || this._includeTableNameRegExp != null || this._excludeTableNames != null || this._excludeTableNameRegExp != null) {
                Table[] tables;
                ModelHelper helper = new ModelHelper();
                if (this._includeTableNames != null) {
                    tables = model.findTables(this._includeTableNames, this.getPlatformConfiguration().isUseDelimitedSqlIdentifiers());
                    helper.checkForForeignKeysToAndFromTables(model, tables);
                    model.removeAllTablesExcept(tables);
                } else if (this._includeTableNameRegExp != null) {
                    tables = model.findTables(this._includeTableNameRegExp, this.getPlatformConfiguration().isUseDelimitedSqlIdentifiers());
                    helper.checkForForeignKeysToAndFromTables(model, tables);
                    model.removeAllTablesExcept(tables);
                }
                if (this._excludeTableNames != null) {
                    tables = model.findTables(this._excludeTableNames, this.getPlatformConfiguration().isUseDelimitedSqlIdentifiers());
                    helper.checkForForeignKeysToAndFromTables(model, tables);
                    model.removeTables(tables);
                } else if (this._excludeTableNameRegExp != null) {
                    tables = model.findTables(this._excludeTableNameRegExp, this.getPlatformConfiguration().isUseDelimitedSqlIdentifiers());
                    helper.checkForForeignKeysToAndFromTables(model, tables);
                    model.removeTables(tables);
                }
            }
            return model;
        }
        catch (Exception ex) {
            throw new BuildException("Could not read the schema from the specified database: " + ex.getLocalizedMessage(), (Throwable)ex);
        }
    }
}

