/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.Table;

public class AddIndexChange
extends TableChangeImplBase {
    private Index _newIndex;

    public AddIndexChange(String tableName, Index newIndex) {
        super(tableName);
        this._newIndex = newIndex;
    }

    public Index getNewIndex() {
        return this._newIndex;
    }

    public void apply(Database model, boolean caseSensitive) {
        Table table = this.findChangedTable(model, caseSensitive);
        table.addIndex(this._newIndex);
        int idx = 0;
        while (idx < this._newIndex.getColumnCount()) {
            IndexColumn idxColumn = this._newIndex.getColumn(idx);
            Column tmpColumn = idxColumn.getColumn();
            idxColumn.setColumn(table.findColumn(tmpColumn.getName(), caseSensitive));
            ++idx;
        }
    }
}

