/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import java.io.IOException;
import java.io.Writer;
import java.rmi.server.UID;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.DefaultValueHelper;
import org.apache.ddlutils.util.StringUtilsExt;

public abstract class SqlBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    protected static final String SIZE_PLACEHOLDER = "{0}";
    protected final Log _log;
    private Platform _platform;
    private Writer _writer;
    private String _indent;
    private String _valueLocale;
    private DateFormat _valueDateFormat;
    private DateFormat _valueTimeFormat;
    private NumberFormat _valueNumberFormat;
    private DefaultValueHelper _defaultValueHelper;
    private Map _charSequencesToEscape;
    static /* synthetic */ Class class$0;

    public SqlBuilder(Platform platform) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.ddlutils.platform.SqlBuilder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((Class)clazz);
        this._indent = "    ";
        this._defaultValueHelper = new DefaultValueHelper();
        this._charSequencesToEscape = new ListOrderedMap();
        this._platform = platform;
    }

    public Platform getPlatform() {
        return this._platform;
    }

    public PlatformInfo getPlatformInfo() {
        return this._platform.getPlatformInfo();
    }

    public Writer getWriter() {
        return this._writer;
    }

    public void setWriter(Writer writer) {
        this._writer = writer;
    }

    public DefaultValueHelper getDefaultValueHelper() {
        return this._defaultValueHelper;
    }

    public String getIndent() {
        return this._indent;
    }

    public void setIndent(String indent) {
        this._indent = indent;
    }

    public String getValueLocale() {
        return this._valueLocale;
    }

    public void setValueLocale(String localeStr) {
        if (localeStr != null) {
            int sepPos = localeStr.indexOf(95);
            String language = null;
            String country = null;
            String variant = null;
            if (sepPos > 0) {
                language = localeStr.substring(0, sepPos);
                country = localeStr.substring(sepPos + 1);
                if ((sepPos = country.indexOf(95)) > 0) {
                    variant = country.substring(sepPos + 1);
                    country = country.substring(0, sepPos);
                }
            } else {
                language = localeStr;
            }
            if (language != null) {
                Locale locale = null;
                locale = variant != null ? new Locale(language, country, variant) : (country != null ? new Locale(language, country) : new Locale(language));
                this._valueLocale = localeStr;
                this.setValueDateFormat(DateFormat.getDateInstance(3, locale));
                this.setValueTimeFormat(DateFormat.getTimeInstance(3, locale));
                this.setValueNumberFormat(NumberFormat.getNumberInstance(locale));
                return;
            }
        }
        this._valueLocale = null;
        this.setValueDateFormat(null);
        this.setValueTimeFormat(null);
        this.setValueNumberFormat(null);
    }

    protected DateFormat getValueDateFormat() {
        return this._valueDateFormat;
    }

    protected void setValueDateFormat(DateFormat format) {
        this._valueDateFormat = format;
    }

    protected DateFormat getValueTimeFormat() {
        return this._valueTimeFormat;
    }

    protected void setValueTimeFormat(DateFormat format) {
        this._valueTimeFormat = format;
    }

    protected NumberFormat getValueNumberFormat() {
        return this._valueNumberFormat;
    }

    protected void setValueNumberFormat(NumberFormat format) {
        this._valueNumberFormat = format;
    }

    protected void addEscapedCharSequence(String charSequence, String escapedVersion) {
        this._charSequencesToEscape.put(charSequence, escapedVersion);
    }

    public int getMaxTableNameLength() {
        return this.getPlatformInfo().getMaxTableNameLength();
    }

    public int getMaxColumnNameLength() {
        return this.getPlatformInfo().getMaxColumnNameLength();
    }

    public int getMaxConstraintNameLength() {
        return this.getPlatformInfo().getMaxConstraintNameLength();
    }

    public int getMaxForeignKeyNameLength() {
        return this.getPlatformInfo().getMaxForeignKeyNameLength();
    }

    public void createTables(Database database) throws IOException {
        this.createTables(database, null, true);
    }

    public void createTables(Database database, boolean dropTables) throws IOException {
        this.createTables(database, null, dropTables);
    }

    public void createTables(Database database, CreationParameters params, boolean dropTables) throws IOException {
        if (dropTables) {
            this.dropTables(database);
        }
        int idx = 0;
        while (idx < database.getTableCount()) {
            Table table = database.getTable(idx);
            this.writeTableComment(table);
            this.createTable(database, table, params == null ? null : params.getParametersFor(table));
            ++idx;
        }
        this.createForeignKeys(database);
    }

    protected void createTemporaryTable(Database database, Table table, Map parameters) throws IOException {
        this.createTable(database, table, parameters);
    }

    protected void dropTemporaryTable(Database database, Table table) throws IOException {
        this.dropTable(table);
    }

    protected void copyData(Table sourceTable, Table targetTable) throws IOException {
        ListOrderedMap columns = new ListOrderedMap();
        int idx = 0;
        while (idx < sourceTable.getColumnCount()) {
            Column sourceColumn = sourceTable.getColumn(idx);
            Column targetColumn = targetTable.findColumn(sourceColumn.getName(), this.getPlatform().isDelimitedIdentifierModeOn());
            if (targetColumn != null) {
                columns.put((Object)sourceColumn, (Object)targetColumn);
            }
            ++idx;
        }
        this.print("INSERT INTO ");
        this.printIdentifier(this.getTableName(targetTable));
        this.print(" (");
        Iterator columnIt = columns.keySet().iterator();
        while (columnIt.hasNext()) {
            this.printIdentifier(this.getColumnName((Column)columnIt.next()));
            if (!columnIt.hasNext()) continue;
            this.print(",");
        }
        this.print(") SELECT ");
        Iterator columnsIt = columns.entrySet().iterator();
        while (columnsIt.hasNext()) {
            Map.Entry entry = (Map.Entry)columnsIt.next();
            this.writeCastExpression((Column)entry.getKey(), (Column)entry.getValue());
            if (!columnsIt.hasNext()) continue;
            this.print(",");
        }
        this.print(" FROM ");
        this.printIdentifier(this.getTableName(sourceTable));
        this.printEndOfStatement();
    }

    protected void writeCastExpression(Column sourceColumn, Column targetColumn) throws IOException {
        this.printIdentifier(this.getColumnName(sourceColumn));
    }

    protected boolean areEqual(String string1, String string2, boolean caseMatters) {
        return caseMatters && string1.equals(string2) || !caseMatters && string1.equalsIgnoreCase(string2);
    }

    public void createTable(Database database, Table table) throws IOException {
        this.createTable(database, table, null);
    }

    public void createTable(Database database, Table table, Map parameters) throws IOException {
        this.writeTableCreationStmt(database, table, parameters);
        this.writeTableCreationStmtEnding(table, parameters);
        if (!this.getPlatformInfo().isPrimaryKeyEmbedded()) {
            this.createPrimaryKey(table, table.getPrimaryKeyColumns());
        }
        if (!this.getPlatformInfo().isIndicesEmbedded()) {
            this.createIndexes(table);
        }
    }

    public void createPrimaryKey(Table table, Column[] primaryKeyColumns) throws IOException {
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.print("ALTER TABLE ");
            this.printlnIdentifier(this.getTableName(table));
            this.printIndent();
            this.print("ADD CONSTRAINT ");
            this.printIdentifier(this.getConstraintName(null, table, "PK", null));
            this.print(" ");
            this.writePrimaryKeyStmt(table, primaryKeyColumns);
            this.printEndOfStatement();
        }
    }

    public void createIndexes(Table table) throws IOException {
        int idx = 0;
        while (idx < table.getIndexCount()) {
            Index index = table.getIndex(idx);
            if (!index.isUnique() && !this.getPlatformInfo().isIndicesSupported()) {
                throw new ModelException("Platform does not support non-unique indices");
            }
            this.createIndex(table, index);
            ++idx;
        }
    }

    public void createIndex(Table table, Index index) throws IOException {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            throw new DdlUtilsException("This platform does not support indexes");
        }
        if (index.getName() == null) {
            this._log.warn((Object)("Cannot write unnamed index " + index));
        } else {
            this.print("CREATE");
            if (index.isUnique()) {
                this.print(" UNIQUE");
            }
            this.print(" INDEX ");
            this.printIdentifier(this.getIndexName(index));
            this.print(" ON ");
            this.printIdentifier(this.getTableName(table));
            this.print(" (");
            int idx = 0;
            while (idx < index.getColumnCount()) {
                IndexColumn idxColumn = index.getColumn(idx);
                Column col = table.findColumn(idxColumn.getName());
                if (col == null) {
                    throw new ModelException("Invalid column '" + idxColumn.getName() + "' on index " + index.getName() + " for table " + table.getName());
                }
                if (idx > 0) {
                    this.print(", ");
                }
                this.printIdentifier(this.getColumnName(col));
                ++idx;
            }
            this.print(")");
            this.printEndOfStatement();
        }
    }

    public void createForeignKeys(Database database) throws IOException {
        int idx = 0;
        while (idx < database.getTableCount()) {
            this.createForeignKeys(database, database.getTable(idx));
            ++idx;
        }
    }

    public void createForeignKeys(Database database, Table table) throws IOException {
        int idx = 0;
        while (idx < table.getForeignKeyCount()) {
            this.createForeignKey(database, table, table.getForeignKey(idx));
            ++idx;
        }
    }

    public void createForeignKey(Database database, Table table, ForeignKey foreignKey) throws IOException {
        if (this.getPlatformInfo().isForeignKeysEmbedded()) {
            throw new DdlUtilsException("This platform does not supported the external creation of foreign keys");
        }
        if (foreignKey.getForeignTableName() == null) {
            this._log.warn((Object)("Foreign key table is null for key " + foreignKey));
        } else {
            this.writeTableAlterStmt(table);
            this.print("ADD CONSTRAINT ");
            this.printIdentifier(this.getForeignKeyName(table, foreignKey));
            this.print(" FOREIGN KEY (");
            this.writeLocalReferences(foreignKey);
            this.print(") REFERENCES ");
            this.printIdentifier(this.getTableName(database.findTable(foreignKey.getForeignTableName())));
            this.print(" (");
            this.writeForeignReferences(foreignKey);
            this.print(")");
            this.writeForeignKeyOnDeleteAction(table, foreignKey);
            this.writeForeignKeyOnUpdateAction(table, foreignKey);
            this.printEndOfStatement();
        }
    }

    public void addColumn(Database model, Table table, Column newColumn) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("ADD COLUMN ");
        this.writeColumn(table, newColumn);
        this.printEndOfStatement();
    }

    public void dropTables(Database database) throws IOException {
        Table table;
        int idx = database.getTableCount() - 1;
        while (idx >= 0) {
            table = database.getTable(idx);
            if (table.getName() != null && table.getName().length() > 0) {
                this.dropForeignKeys(table);
            }
            --idx;
        }
        idx = database.getTableCount() - 1;
        while (idx >= 0) {
            table = database.getTable(idx);
            if (table.getName() != null && table.getName().length() > 0) {
                this.writeTableComment(table);
                this.dropTable(table);
            }
            --idx;
        }
    }

    public void dropTable(Database database, Table table) throws IOException {
        int idx = database.getTableCount() - 1;
        while (idx >= 0) {
            Table otherTable = database.getTable(idx);
            ForeignKey[] fks = otherTable.getForeignKeys();
            int fkIdx = 0;
            while (fks != null && fkIdx < fks.length) {
                if (fks[fkIdx].getForeignTable().equals(table)) {
                    this.dropForeignKey(otherTable, fks[fkIdx]);
                }
                ++fkIdx;
            }
            --idx;
        }
        this.dropForeignKeys(table);
        this.writeTableComment(table);
        this.dropTable(table);
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.printEndOfStatement();
    }

    public void dropForeignKeys(Table table) throws IOException {
        int idx = 0;
        while (idx < table.getForeignKeyCount()) {
            this.dropForeignKey(table, table.getForeignKey(idx));
            ++idx;
        }
    }

    public void dropForeignKey(Table table, ForeignKey foreignKey) throws IOException {
        this.writeTableAlterStmt(table);
        this.print("DROP CONSTRAINT ");
        this.printIdentifier(this.getForeignKeyName(table, foreignKey));
        this.printEndOfStatement();
    }

    public String getInsertSql(Table table, Map columnValues, boolean genPlaceholders) {
        Column column;
        StringBuffer buffer = new StringBuffer("INSERT INTO ");
        boolean addComma = false;
        buffer.append(this.getDelimitedIdentifier(this.getTableName(table)));
        buffer.append(" (");
        int idx = 0;
        while (idx < table.getColumnCount()) {
            column = table.getColumn(idx);
            if (columnValues.containsKey(column.getName())) {
                if (addComma) {
                    buffer.append(", ");
                }
                buffer.append(this.getDelimitedIdentifier(column.getName()));
                addComma = true;
            }
            ++idx;
        }
        buffer.append(") VALUES (");
        if (genPlaceholders) {
            addComma = false;
            idx = 0;
            while (idx < columnValues.size()) {
                if (addComma) {
                    buffer.append(", ");
                }
                buffer.append("?");
                addComma = true;
                ++idx;
            }
        } else {
            addComma = false;
            idx = 0;
            while (idx < table.getColumnCount()) {
                column = table.getColumn(idx);
                if (columnValues.containsKey(column.getName())) {
                    if (addComma) {
                        buffer.append(", ");
                    }
                    buffer.append(this.getValueAsString(column, columnValues.get(column.getName())));
                    addComma = true;
                }
                ++idx;
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String getUpdateSql(Table table, Map columnValues, boolean genPlaceholders) {
        Column column;
        StringBuffer buffer = new StringBuffer("UPDATE ");
        boolean addSep = false;
        buffer.append(this.getDelimitedIdentifier(this.getTableName(table)));
        buffer.append(" SET ");
        int idx = 0;
        while (idx < table.getColumnCount()) {
            column = table.getColumn(idx);
            if (!column.isPrimaryKey() && columnValues.containsKey(column.getName())) {
                if (addSep) {
                    buffer.append(", ");
                }
                buffer.append(this.getDelimitedIdentifier(column.getName()));
                buffer.append(" = ");
                if (genPlaceholders) {
                    buffer.append("?");
                } else {
                    buffer.append(this.getValueAsString(column, columnValues.get(column.getName())));
                }
                addSep = true;
            }
            ++idx;
        }
        buffer.append(" WHERE ");
        addSep = false;
        idx = 0;
        while (idx < table.getColumnCount()) {
            column = table.getColumn(idx);
            if (column.isPrimaryKey() && columnValues.containsKey(column.getName())) {
                if (addSep) {
                    buffer.append(" AND ");
                }
                buffer.append(this.getDelimitedIdentifier(column.getName()));
                buffer.append(" = ");
                if (genPlaceholders) {
                    buffer.append("?");
                } else {
                    buffer.append(this.getValueAsString(column, columnValues.get(column.getName())));
                }
                addSep = true;
            }
            ++idx;
        }
        return buffer.toString();
    }

    public String getUpdateSql(Table table, Map oldColumnValues, Map newColumnValues, boolean genPlaceholders) {
        Column column;
        StringBuffer buffer = new StringBuffer("UPDATE ");
        boolean addSep = false;
        buffer.append(this.getDelimitedIdentifier(this.getTableName(table)));
        buffer.append(" SET ");
        int idx = 0;
        while (idx < table.getColumnCount()) {
            column = table.getColumn(idx);
            if (newColumnValues.containsKey(column.getName())) {
                if (addSep) {
                    buffer.append(", ");
                }
                buffer.append(this.getDelimitedIdentifier(column.getName()));
                buffer.append(" = ");
                if (genPlaceholders) {
                    buffer.append("?");
                } else {
                    buffer.append(this.getValueAsString(column, newColumnValues.get(column.getName())));
                }
                addSep = true;
            }
            ++idx;
        }
        buffer.append(" WHERE ");
        addSep = false;
        idx = 0;
        while (idx < table.getColumnCount()) {
            column = table.getColumn(idx);
            if (oldColumnValues.containsKey(column.getName())) {
                if (addSep) {
                    buffer.append(" AND ");
                }
                buffer.append(this.getDelimitedIdentifier(column.getName()));
                buffer.append(" = ");
                if (genPlaceholders) {
                    buffer.append("?");
                } else {
                    buffer.append(this.getValueAsString(column, oldColumnValues.get(column.getName())));
                }
                addSep = true;
            }
            ++idx;
        }
        return buffer.toString();
    }

    public String getDeleteSql(Table table, Map pkValues, boolean genPlaceholders) {
        StringBuffer buffer = new StringBuffer("DELETE FROM ");
        boolean addSep = false;
        buffer.append(this.getDelimitedIdentifier(this.getTableName(table)));
        if (pkValues != null && !pkValues.isEmpty()) {
            buffer.append(" WHERE ");
            Column[] pkCols = table.getPrimaryKeyColumns();
            int pkColIdx = 0;
            while (pkColIdx < pkCols.length) {
                Column column = pkCols[pkColIdx];
                if (pkValues.containsKey(column.getName())) {
                    if (addSep) {
                        buffer.append(" AND ");
                    }
                    buffer.append(this.getDelimitedIdentifier(column.getName()));
                    buffer.append(" = ");
                    if (genPlaceholders) {
                        buffer.append("?");
                    } else {
                        buffer.append(this.getValueAsString(column, pkValues.get(column.getName())));
                    }
                    addSep = true;
                }
                ++pkColIdx;
            }
        }
        return buffer.toString();
    }

    protected String getValueAsString(Column column, Object value) {
        if (value == null) {
            return "NULL";
        }
        StringBuffer result = new StringBuffer();
        switch (column.getTypeCode()) {
            case 91: {
                result.append(this.getPlatformInfo().getValueQuoteToken());
                if (!(value instanceof String) && this.getValueDateFormat() != null) {
                    result.append(this.getValueDateFormat().format(value));
                } else {
                    result.append(value.toString());
                }
                result.append(this.getPlatformInfo().getValueQuoteToken());
                break;
            }
            case 92: {
                result.append(this.getPlatformInfo().getValueQuoteToken());
                if (!(value instanceof String) && this.getValueTimeFormat() != null) {
                    result.append(this.getValueTimeFormat().format(value));
                } else {
                    result.append(value.toString());
                }
                result.append(this.getPlatformInfo().getValueQuoteToken());
                break;
            }
            case 93: {
                result.append(this.getPlatformInfo().getValueQuoteToken());
                result.append(value.toString());
                result.append(this.getPlatformInfo().getValueQuoteToken());
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                result.append(this.getPlatformInfo().getValueQuoteToken());
                if (!(value instanceof String) && this.getValueNumberFormat() != null) {
                    result.append(this.getValueNumberFormat().format(value));
                } else {
                    result.append(value.toString());
                }
                result.append(this.getPlatformInfo().getValueQuoteToken());
                break;
            }
            default: {
                result.append(this.getPlatformInfo().getValueQuoteToken());
                result.append(this.escapeStringValue(value.toString()));
                result.append(this.getPlatformInfo().getValueQuoteToken());
            }
        }
        return result.toString();
    }

    public String getSelectLastIdentityValues(Table table) {
        return null;
    }

    public String shortenName(String name, int desiredLength) {
        if (name == null) {
            return null;
        }
        int originalLength = name.length();
        if (desiredLength <= 0 || originalLength <= desiredLength) {
            return name;
        }
        int delta = originalLength - desiredLength;
        int startCut = desiredLength / 2;
        StringBuffer result = new StringBuffer();
        result.append(name.substring(0, startCut));
        if (!(startCut != 0 && name.charAt(startCut - 1) == '_' || startCut + delta + 1 != originalLength && name.charAt(startCut + delta + 1) == '_')) {
            result.append("_");
        }
        result.append(name.substring(startCut + delta + 1, originalLength));
        return result.toString();
    }

    public String getTableName(Table table) {
        return this.shortenName(table.getName(), this.getMaxTableNameLength());
    }

    protected void writeTableComment(Table table) throws IOException {
        this.printComment("-----------------------------------------------------------------------");
        this.printComment(this.getTableName(table));
        this.printComment("-----------------------------------------------------------------------");
        this.println();
    }

    protected void writeTableAlterStmt(Table table) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
    }

    protected void writeTableCreationStmt(Database database, Table table, Map parameters) throws IOException {
        this.print("CREATE TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.println("(");
        this.writeColumns(table);
        if (this.getPlatformInfo().isPrimaryKeyEmbedded()) {
            this.writeEmbeddedPrimaryKeysStmt(table);
        }
        if (this.getPlatformInfo().isForeignKeysEmbedded()) {
            this.writeEmbeddedForeignKeysStmt(database, table);
        }
        if (this.getPlatformInfo().isIndicesEmbedded()) {
            this.writeEmbeddedIndicesStmt(table);
        }
        this.println();
        this.print(")");
    }

    protected void writeTableCreationStmtEnding(Table table, Map parameters) throws IOException {
        this.printEndOfStatement();
    }

    protected void writeColumns(Table table) throws IOException {
        int idx = 0;
        while (idx < table.getColumnCount()) {
            this.printIndent();
            this.writeColumn(table, table.getColumn(idx));
            if (idx < table.getColumnCount() - 1) {
                this.println(",");
            }
            ++idx;
        }
    }

    protected String getColumnName(Column column) throws IOException {
        return this.shortenName(column.getName(), this.getMaxColumnNameLength());
    }

    protected void writeColumn(Table table, Column column) throws IOException {
        this.printIdentifier(this.getColumnName(column));
        this.print(" ");
        this.print(this.getSqlType(column));
        this.writeColumnDefaultValueStmt(table, column);
        if (column.isRequired()) {
            this.print(" ");
            this.writeColumnNotNullableStmt();
        } else if (this.getPlatformInfo().isNullAsDefaultValueRequired() && this.getPlatformInfo().hasNullDefault(column.getTypeCode())) {
            this.print(" ");
            this.writeColumnNullableStmt();
        }
        if (column.isAutoIncrement() && !this.getPlatformInfo().isDefaultValueUsedForIdentitySpec()) {
            if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() && !column.isPrimaryKey()) {
                throw new ModelException("Column " + column.getName() + " in table " + table.getName() + " is auto-incrementing but not a primary key column, which is not supported by the platform");
            }
            this.print(" ");
            this.writeColumnAutoIncrementStmt(table, column);
        }
    }

    protected String getSqlType(Column column) {
        return this.getSqlType(column, this.getNativeType(column));
    }

    protected String getSqlType(Column column, String nativeType) {
        int sizePos = nativeType.indexOf(SIZE_PLACEHOLDER);
        StringBuffer sqlType = new StringBuffer();
        sqlType.append(sizePos >= 0 ? nativeType.substring(0, sizePos) : nativeType);
        String sizeSpec = this.getSizeSpec(column);
        if (!StringUtilsExt.isEmpty((String)sizeSpec)) {
            sqlType.append("(");
            sqlType.append(sizeSpec);
            sqlType.append(")");
        }
        sqlType.append(sizePos >= 0 ? nativeType.substring(sizePos + SIZE_PLACEHOLDER.length()) : "");
        return sqlType.toString();
    }

    protected String getNativeType(Column column) {
        String nativeType = this.getPlatformInfo().getNativeType(column.getTypeCode());
        return nativeType == null ? column.getType() : nativeType;
    }

    protected String getBareNativeType(Column column) {
        String nativeType = this.getNativeType(column);
        int sizePos = nativeType.indexOf(SIZE_PLACEHOLDER);
        return sizePos >= 0 ? nativeType.substring(0, sizePos) : nativeType;
    }

    protected String getSizeSpec(Column column) {
        StringBuffer result = new StringBuffer();
        Object sizeSpec = column.getSize();
        if (sizeSpec == null) {
            sizeSpec = this.getPlatformInfo().getDefaultSize(column.getTypeCode());
        }
        if (sizeSpec != null) {
            if (this.getPlatformInfo().hasSize(column.getTypeCode())) {
                result.append(sizeSpec.toString());
            } else if (this.getPlatformInfo().hasPrecisionAndScale(column.getTypeCode())) {
                result.append(column.getSizeAsInt());
                result.append(",");
                result.append(column.getScale());
            }
        }
        return result.toString();
    }

    protected String getNativeDefaultValue(Column column) {
        return column.getDefaultValue();
    }

    protected String escapeStringValue(String value) {
        String result = value;
        Iterator it = this._charSequencesToEscape.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result = StringUtils.replace((String)result, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        return result;
    }

    protected boolean isValidDefaultValue(String defaultSpec, int typeCode) {
        return defaultSpec != null && (defaultSpec.length() > 0 || !TypeMap.isNumericType(typeCode) && !TypeMap.isDateTimeType(typeCode));
    }

    protected void writeColumnDefaultValueStmt(Table table, Column column) throws IOException {
        Object parsedDefault = column.getParsedDefaultValue();
        if (parsedDefault != null) {
            if (!(this.getPlatformInfo().isDefaultValuesForLongTypesSupported() || column.getTypeCode() != -4 && column.getTypeCode() != -1)) {
                throw new ModelException("The platform does not support default values for LONGVARCHAR or LONGVARBINARY columns");
            }
            if (this.isValidDefaultValue(column.getDefaultValue(), column.getTypeCode())) {
                this.print(" DEFAULT ");
                this.writeColumnDefaultValue(table, column);
            }
        } else if (this.getPlatformInfo().isDefaultValueUsedForIdentitySpec() && column.isAutoIncrement()) {
            this.print(" DEFAULT ");
            this.writeColumnDefaultValue(table, column);
        }
    }

    protected void writeColumnDefaultValue(Table table, Column column) throws IOException {
        this.printDefaultValue(this.getNativeDefaultValue(column), column.getTypeCode());
    }

    protected void printDefaultValue(Object defaultValue, int typeCode) throws IOException {
        if (defaultValue != null) {
            boolean shouldUseQuotes;
            boolean bl = shouldUseQuotes = !TypeMap.isNumericType(typeCode);
            if (shouldUseQuotes) {
                this.print(this.getPlatformInfo().getValueQuoteToken());
                this.print(this.escapeStringValue(defaultValue.toString()));
                this.print(this.getPlatformInfo().getValueQuoteToken());
            } else {
                this.print(defaultValue.toString());
            }
        }
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        this.print("IDENTITY");
    }

    protected void writeColumnNullableStmt() throws IOException {
        this.print("NULL");
    }

    protected void writeColumnNotNullableStmt() throws IOException {
        this.print("NOT NULL");
    }

    protected boolean columnsDiffer(Column currentColumn, Column desiredColumn) {
        boolean sizeMatters;
        String desiredDefault = desiredColumn.getDefaultValue();
        String currentDefault = currentColumn.getDefaultValue();
        boolean defaultsEqual = desiredDefault == null || desiredDefault.equals(currentDefault);
        boolean bl = sizeMatters = this.getPlatformInfo().hasSize(currentColumn.getTypeCode()) && desiredColumn.getSize() != null;
        return this.getPlatformInfo().getTargetJdbcType(desiredColumn.getTypeCode()) != currentColumn.getTypeCode() || desiredColumn.isRequired() != currentColumn.isRequired() || sizeMatters && !StringUtils.equals((String)desiredColumn.getSize(), (String)currentColumn.getSize()) || !defaultsEqual;
    }

    public String getForeignKeyName(Table table, ForeignKey fk) {
        boolean needsName;
        String fkName = fk.getName();
        boolean bl = needsName = fkName == null || fkName.length() == 0;
        if (needsName) {
            StringBuffer name = new StringBuffer();
            int idx = 0;
            while (idx < fk.getReferenceCount()) {
                name.append(fk.getReference(idx).getLocalColumnName());
                name.append("_");
                ++idx;
            }
            name.append(fk.getForeignTableName());
            fkName = this.getConstraintName(null, table, "FK", name.toString());
        }
        fkName = this.shortenName(fkName, this.getMaxForeignKeyNameLength());
        if (needsName) {
            this._log.warn((Object)("Encountered a foreign key in table " + table.getName() + " that has no name. " + "DdlUtils will use the auto-generated and shortened name " + fkName + " instead."));
        }
        return fkName;
    }

    public String getConstraintName(String prefix, Table table, String secondPart, String suffix) {
        StringBuffer result = new StringBuffer();
        if (prefix != null) {
            result.append(prefix);
            result.append("_");
        }
        result.append(table.getName());
        result.append("_");
        result.append(secondPart);
        if (suffix != null) {
            result.append("_");
            result.append(suffix);
        }
        return this.shortenName(result.toString(), this.getMaxConstraintNameLength());
    }

    protected void writeEmbeddedPrimaryKeysStmt(Table table) throws IOException {
        Column[] primaryKeyColumns = table.getPrimaryKeyColumns();
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.printStartOfEmbeddedStatement();
            this.writePrimaryKeyStmt(table, primaryKeyColumns);
        }
    }

    protected boolean shouldGeneratePrimaryKeys(Column[] primaryKeyColumns) {
        return true;
    }

    protected void writePrimaryKeyStmt(Table table, Column[] primaryKeyColumns) throws IOException {
        this.print("PRIMARY KEY (");
        int idx = 0;
        while (idx < primaryKeyColumns.length) {
            this.printIdentifier(this.getColumnName(primaryKeyColumns[idx]));
            if (idx < primaryKeyColumns.length - 1) {
                this.print(", ");
            }
            ++idx;
        }
        this.print(")");
    }

    public String getIndexName(Index index) {
        return this.shortenName(index.getName(), this.getMaxConstraintNameLength());
    }

    protected void writeEmbeddedIndicesStmt(Table table) throws IOException {
        if (this.getPlatformInfo().isIndicesSupported()) {
            int idx = 0;
            while (idx < table.getIndexCount()) {
                this.printStartOfEmbeddedStatement();
                this.writeEmbeddedIndexCreateStmt(table, table.getIndex(idx));
                ++idx;
            }
        }
    }

    protected void writeEmbeddedIndexCreateStmt(Table table, Index index) throws IOException {
        if (index.getName() != null && index.getName().length() > 0) {
            this.print(" CONSTRAINT ");
            this.printIdentifier(this.getIndexName(index));
        }
        if (index.isUnique()) {
            this.print(" UNIQUE");
        } else {
            this.print(" INDEX ");
        }
        this.print(" (");
        int idx = 0;
        while (idx < index.getColumnCount()) {
            IndexColumn idxColumn = index.getColumn(idx);
            Column col = table.findColumn(idxColumn.getName());
            if (col == null) {
                throw new ModelException("Invalid column '" + idxColumn.getName() + "' on index " + index.getName() + " for table " + table.getName());
            }
            if (idx > 0) {
                this.print(", ");
            }
            this.printIdentifier(this.getColumnName(col));
            ++idx;
        }
        this.print(")");
    }

    public void dropIndex(Table table, Index index) throws IOException {
        if (this.getPlatformInfo().isAlterTableForDropUsed()) {
            this.writeTableAlterStmt(table);
        }
        this.print("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index));
        if (!this.getPlatformInfo().isAlterTableForDropUsed()) {
            this.print(" ON ");
            this.printIdentifier(this.getTableName(table));
        }
        this.printEndOfStatement();
    }

    protected void writeEmbeddedForeignKeysStmt(Database database, Table table) throws IOException {
        int idx = 0;
        while (idx < table.getForeignKeyCount()) {
            ForeignKey foreignKey = table.getForeignKey(idx);
            if (foreignKey.getForeignTableName() == null) {
                this._log.warn((Object)("Foreign key table is null for key " + foreignKey));
            } else {
                this.printStartOfEmbeddedStatement();
                if (this.getPlatformInfo().isEmbeddedForeignKeysNamed()) {
                    this.print("CONSTRAINT ");
                    this.printIdentifier(this.getForeignKeyName(table, foreignKey));
                    this.print(" ");
                }
                this.print("FOREIGN KEY (");
                this.writeLocalReferences(foreignKey);
                this.print(") REFERENCES ");
                this.printIdentifier(this.getTableName(database.findTable(foreignKey.getForeignTableName())));
                this.print(" (");
                this.writeForeignReferences(foreignKey);
                this.print(")");
                this.writeForeignKeyOnDeleteAction(table, foreignKey);
                this.writeForeignKeyOnUpdateAction(table, foreignKey);
            }
            ++idx;
        }
    }

    protected void writeLocalReferences(ForeignKey key) throws IOException {
        int idx = 0;
        while (idx < key.getReferenceCount()) {
            if (idx > 0) {
                this.print(", ");
            }
            this.printIdentifier(key.getReference(idx).getLocalColumnName());
            ++idx;
        }
    }

    protected void writeForeignReferences(ForeignKey key) throws IOException {
        int idx = 0;
        while (idx < key.getReferenceCount()) {
            if (idx > 0) {
                this.print(", ");
            }
            this.printIdentifier(key.getReference(idx).getForeignColumnName());
            ++idx;
        }
    }

    protected void writeForeignKeyOnDeleteAction(Table table, ForeignKey foreignKey) throws IOException {
        CascadeActionEnum action = foreignKey.getOnDelete();
        if (!this.getPlatformInfo().isActionSupportedForOnDelete(action)) {
            if (this.getPlatform().isDefaultOnDeleteActionUsedIfUnsupported()) {
                this._log.info((Object)("The platform does not support the " + (Object)((Object)action) + " action for onDelete; using " + (Object)((Object)this.getPlatformInfo().getDefaultOnDeleteAction()) + " instead"));
                action = this.getPlatformInfo().getDefaultOnDeleteAction();
            } else {
                throw new ModelException("The platform does not support the action '" + (Object)((Object)action) + "' for onDelete in foreign key in table " + table.getName());
            }
        }
        if (action != this.getPlatformInfo().getDefaultOnDeleteAction()) {
            this.print(" ON DELETE ");
            switch (action.getValue()) {
                case 1: {
                    this.print("CASCADE");
                    break;
                }
                case 2: {
                    this.print("SET NULL");
                    break;
                }
                case 3: {
                    this.print("SET DEFAULT");
                    break;
                }
                case 4: {
                    this.print("RESTRICT");
                    break;
                }
                case 5: {
                    this.print("NO ACTION");
                    break;
                }
                default: {
                    throw new ModelException("Unsupported cascade value '" + (Object)((Object)action) + "' for onDelete in foreign key in table " + table.getName());
                }
            }
        }
    }

    protected void writeForeignKeyOnUpdateAction(Table table, ForeignKey foreignKey) throws IOException {
        CascadeActionEnum action = foreignKey.getOnUpdate();
        if (!this.getPlatformInfo().isActionSupportedForOnUpdate(action)) {
            if (this.getPlatform().isDefaultOnUpdateActionUsedIfUnsupported()) {
                this._log.info((Object)("The platform does not support the " + (Object)((Object)action) + " action for onUpdate; using " + (Object)((Object)this.getPlatformInfo().getDefaultOnUpdateAction()) + " instead"));
                action = this.getPlatformInfo().getDefaultOnUpdateAction();
            } else {
                throw new ModelException("The platform does not support the action '" + (Object)((Object)action) + "' for onUpdate in foreign key in table " + table.getName());
            }
        }
        if (action != this.getPlatformInfo().getDefaultOnUpdateAction()) {
            this.print(" ON UPDATE ");
            switch (action.getValue()) {
                case 1: {
                    this.print("CASCADE");
                    break;
                }
                case 2: {
                    this.print("SET NULL");
                    break;
                }
                case 3: {
                    this.print("SET DEFAULT");
                    break;
                }
                case 4: {
                    this.print("RESTRICT");
                    break;
                }
                case 5: {
                    this.print("NO ACTION");
                    break;
                }
                default: {
                    throw new ModelException("Unsupported cascade value '" + (Object)((Object)action) + "' for onUpdate in foreign key in table " + table.getName());
                }
            }
        }
    }

    protected void printComment(String text) throws IOException {
        if (this.getPlatform().isSqlCommentsOn()) {
            this.print(this.getPlatformInfo().getCommentPrefix());
            this.print(" ");
            this.print(text);
            this.print(" ");
            this.print(this.getPlatformInfo().getCommentSuffix());
            this.println();
        }
    }

    protected void printStartOfEmbeddedStatement() throws IOException {
        this.println(",");
        this.printIndent();
    }

    protected void printEndOfStatement() throws IOException {
        this.println(this.getPlatformInfo().getSqlCommandDelimiter());
        this.println();
    }

    protected void println() throws IOException {
        this.print(LINE_SEPARATOR);
    }

    protected void print(String text) throws IOException {
        this._writer.write(text);
    }

    protected String getDelimitedIdentifier(String identifier) {
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            return String.valueOf(this.getPlatformInfo().getDelimiterToken()) + identifier + this.getPlatformInfo().getDelimiterToken();
        }
        return identifier;
    }

    protected void printIdentifier(String identifier) throws IOException {
        this.print(this.getDelimitedIdentifier(identifier));
    }

    protected void printlnIdentifier(String identifier) throws IOException {
        this.println(this.getDelimitedIdentifier(identifier));
    }

    protected void println(String text) throws IOException {
        this.print(text);
        this.println();
    }

    protected void printIndent() throws IOException {
        this.print(this.getIndent());
    }

    protected String createUniqueIdentifier() {
        return new UID().toString().replace(':', '_').replace('-', '_');
    }
}

