/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.h2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.DatabaseMetaDataWrapper;
import org.apache.ddlutils.platform.JdbcModelReader;

public class H2ModelReader
extends JdbcModelReader {
    public H2ModelReader(Platform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
    }

    protected Table readTable(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        Table table = super.readTable(metaData, values);
        if (table != null) {
            this.determineAutoIncrementColumns(table);
        }
        return table;
    }

    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null && defaultValue.startsWith("(NEXT VALUE FOR ")) {
            column.setAutoIncrement(true);
            column.setDefaultValue(null);
            defaultValue = null;
        }
        if (TypeMap.isTextType(column.getTypeCode()) && defaultValue != null) {
            column.setDefaultValue(this.unescape(defaultValue, "'", "''"));
        }
        return column;
    }

    protected boolean isInternalForeignKeyIndex(DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, Index index) {
        String name = index.getName();
        return name != null && name.startsWith(String.valueOf(fk.getName()) + "_INDEX_");
    }

    protected boolean isInternalPrimaryKeyIndex(DatabaseMetaDataWrapper metaData, Table table, Index index) {
        String name = index.getName();
        return name != null && name.startsWith("PRIMARY_KEY_");
    }

    protected void determineAutoIncrementColumns(Table table) throws SQLException {
        String query = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_CATALOG = ? AND TABLE_SCHEMA = ? AND TABLE_NAME = ? AND SEQUENCE_NAME IS NOT NULL";
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement(query);
            stmt.setString(1, table.getCatalog());
            stmt.setString(2, table.getSchema());
            stmt.setString(3, table.getName());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                String colName = rs.getString(1).trim();
                Column column = table.findColumn(colName, this.getPlatform().isDelimitedIdentifierModeOn());
                if (column == null) continue;
                column.setAutoIncrement(true);
            }
        }
        finally {
            this.closeStatement(stmt);
        }
    }
}

