/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.sqlite3;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;
import org.apache.ddlutils.platform.CreationParameters;
import org.apache.ddlutils.platform.SqlBuilder;

public class SQLite3Builder
extends SqlBuilder {
    public SQLite3Builder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    public void createTables(Database database, CreationParameters params, boolean dropTables) throws IOException {
        if (dropTables) {
            this.dropTables(database);
        }
        int idx = 0;
        while (idx < database.getTableCount()) {
            Table table = database.getTable(idx);
            this.writeTableComment(table);
            this.createTable(database, table, params == null ? null : params.getParametersFor(table));
            ++idx;
        }
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE IF EXISTS ");
        this.printIdentifier(this.getTableName(table));
        this.printEndOfStatement();
    }

    public void dropIndex(Table table, Index index) throws IOException {
        this.print("DROP INDEX IF EXISTS ");
        this.printIdentifier(this.getIndexName(index));
        this.printEndOfStatement();
    }

    public void createTable(Database database, Table table, Map parameters) throws IOException {
        int idx = 0;
        while (idx < table.getColumnCount()) {
            Column column = table.getColumn(idx);
            ++idx;
        }
        super.createTable(database, table, parameters);
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column) throws IOException {
        if (!column.isPrimaryKey()) {
            this.print("PRIMARY KEY AUTOINCREMENT");
        }
    }

    public String getSelectLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        result.append("SELECT ");
        int idx = 0;
        while (idx < columns.length) {
            if (idx > 0) {
                result.append(", ");
            }
            result.append("currval('");
            result.append(this.getDelimitedIdentifier(this.getConstraintName(null, table, columns[idx].getName(), "seq")));
            result.append("') AS ");
            result.append(this.getDelimitedIdentifier(columns[idx].getName()));
            ++idx;
        }
        return result.toString();
    }

    public void dropColumn(Table table, Column column) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(table));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(column));
        this.printEndOfStatement();
    }

    public void dropForeignKey(Table table, ForeignKey foreignKey) throws IOException {
    }

    protected void writeColumnDefaultValueStmt(Table table, Column column) throws IOException {
        Object parsedDefault = column.getParsedDefaultValue();
        if (parsedDefault != null) {
            if (!(this.getPlatformInfo().isDefaultValuesForLongTypesSupported() || column.getTypeCode() != -4 && column.getTypeCode() != -1)) {
                throw new ModelException("The platform does not support default values for LONGVARCHAR or LONGVARBINARY columns");
            }
            if (this.isValidDefaultValue(column.getDefaultValue(), column.getTypeCode())) {
                this.print(" DEFAULT ");
                this.writeColumnDefaultValue(table, column);
            }
        } else if (this.getPlatformInfo().isDefaultValueUsedForIdentitySpec() && column.isAutoIncrement()) {
            this.print(" DEFAULT ");
            this.writeColumnDefaultValue(table, column);
        } else if (!StringUtils.isBlank((String)column.getDefaultValue())) {
            this.print(" DEFAULT ");
            this.writeColumnDefaultValue(table, column);
        }
    }

    protected void printDefaultValue(Object defaultValue, int typeCode) throws IOException {
        if (defaultValue != null) {
            boolean shouldUseQuotes;
            String defaultValueStr = defaultValue.toString();
            boolean bl = shouldUseQuotes = !TypeMap.isNumericType(typeCode) && !defaultValueStr.startsWith("TO_DATE(") && !defaultValue.equals("CURRENT_TIMESTAMP") && !defaultValue.equals("CURRENT_TIME") && !defaultValue.equals("CURRENT_DATE");
            if (shouldUseQuotes) {
                this.print(this.getPlatformInfo().getValueQuoteToken());
                this.print(this.escapeStringValue(defaultValueStr));
                this.print(this.getPlatformInfo().getValueQuoteToken());
            } else {
                this.print(defaultValueStr);
            }
        }
    }
}

