#pragma once
#include "Runner.h"

namespace ecrobot{

class Motor;
class GyroSensor;
class Nxt;

class ETBalanceRunner : public Runner
{
	Motor& m_motorL;
	Motor& m_motorR;
	GyroSensor& m_gyro;
	Nxt& m_nxt;
	bool m_bInitialized;
	int m_gyrooffset;
	bool m_bException;
	int m_msec;

public:
	ETBalanceRunner(Motor& motorL, Motor& motorR, GyroSensor& gyro, Nxt& nxt);
	virtual ~ETBalanceRunner(void);
	//
	virtual void Run(int forward, int turn);
	virtual bool IsException() const;
	virtual void Stop();
	virtual void Reset();
	void SetGyroOffset(int offset);
private:
	void JudgeException(int l,int r);
};

}
