/*
 *  TOPPERS/SSP Kernel
 *      Smallest Set Profile Kernel
 *
 *  Copyright (C) 2010 by Naoki Saito
 *             Nagoya Municipal Industrial Research Institute, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEEρE
 *  ĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒쌠
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[X
 *      R[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎgp
 *      ł`ōĔzzꍇɂ́CĔzzɔhLgip҃}
 *      jAȂǁjɁCL̒쌠\C̗pщL̖
 *      ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎgp
 *      łȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        \C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNgɕ
 *        邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹Q
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD܂C
 *      {\tgEFÃ[U܂̓Gh[ÛȂ闝RɊ
 *      CL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړIɑ΂
 *  K܂߂āCȂۏ؂sȂD܂C{\tgEFA̗p
 *  ɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC
 *  ȂD
 * 
 */

#ifndef TOPPERS_PRC_INTERRUPT_H
#define TOPPERS_PRC_INTERRUPT_H


/*
 *  ݔԍ͈̔͂̔
 */
#define VALID_INTNO(intno)	((intno) < INHNO_MAX)
#define VALID_INTNO_DISINT(intno)	VALID_INTNO(intno)
#define VALID_INTNO_CFGINT(intno)	VALID_INTNO(intno)

/*
 *  IPL犄ݐ䃌WX^ł̕\ɕϊ}N
 */
#define IPL2ILVL(ipl)	(-(ipl))


/*
 *  ݐ䃌WX^֘A̒`
 */
#define INTC_LVLMASK	(0x07U)
#define INTC_IRMASK		(0x08U)
#define INTC_POLMASK	(0x10U)		/* INT݂̂ */
#define INTC_LVSMASK	(0x20U)		/* INT݂̂ */

#define INTC_POLHIGH	(0x10U)		/* INT݂̂ */
#define INTC_POLLOW		(0x00U)		/* INT݂̂ */
#define INTC_LVSEDGE	(0x00U)		/* INT݂̂ */
#define INTC_LVSLVL		(0x20U)		/* INT݂̂ */



#ifndef TOPPERS_MACRO_ONLY

/*
 *  ݃Rg[WX^̃AhXe[u
 */
extern volatile uint8_t * const intc_reg[];

/*
 *  ݗṽx`e[u
 *  (tfɂo)
 */
extern const PRI intpri_table[];


/*
 *  ݗv֎~tÕZbg
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tOZbg悤Ƃꍇɂ́CFALSEԂD
 */
Inline bool_t
x_disable_int(INTNO intno)
{
	/* x`0łꍇCFG_INTĂȂ */
	if(intpri_table[intno] == 0U)
	{
		return (false);
	}
	*intc_reg[intno] &= ~INTC_LVLMASK;
	
	return(true);
}

#define t_disable_int(intno)	x_disable_int(intno)
#define i_disable_int(intno)	x_disable_int(intno)

/*
 *  ݗv֎~tÕNA
 *
 *  ݑݒ肳ĂȂݗvCɑ΂Ċݗv֎~
 *  tONA悤Ƃꍇɂ́CFALSEԂD
 */
Inline bool_t
x_enable_int(INTNO intno)
{
	/* x`0łꍇCFG_INTĂȂ */
	if(intpri_table[intno] == 0u)
	{
		return (false);
	}
	/* ݃xɖ߂ */
	*intc_reg[intno] = (*intc_reg[intno] & ~INTC_LVLMASK) | IPL2ILVL(intpri_table[intno]);
	
	return(true);
}

#define t_enable_int(intno)		x_enable_int(intno)
#define i_enable_int(intno)		x_enable_int(intno)


/*
 *  ݗṽNA
 */
Inline void
x_clear_int(INTNO intno)
{
	*(intc_reg[intno]) &= ~INTC_IRMASK;
}

#define t_clear_int(intno)		x_clear_int(intno)
#define i_clear_int(intno)		x_clear_int(intno)


/*
 *  ݗṽ`FbN
 */
Inline bool_t
x_probe_int(INTNO intno)
{
	return (((*intc_reg[intno] & INTC_IRMASK) == INTC_IRMASK)? true : false);
}

#define t_probe_int(intno)		x_probe_int(intno)
#define i_probe_int(intno)		x_probe_int(intno)


/*
 *  ݗvC̑̐ݒ
 */
extern void	x_config_int(INTNO intno, ATR intatr, PRI intpri);

#endif /* TOPPERS_MACRO_ONLY */




/*
 *  ݃nh̓̐}N
 */
#define _INT_ENTRY(inhno, inthdr)				_kernel_##inthdr##_##inhno##_entry
#define INT_ENTRY(inhno, inthdr)				_INT_ENTRY(inhno , inthdr)

#define _INTHDR_ENTRY(inhno, inhno_num ,inthdr)	\
		extern _kernel_##inthdr##_##inhno##_entry(void);
#define INTHDR_ENTRY(inhno, inhno_num ,inthdr)	_INTHDR_ENTRY(inhno, inhno_num ,inthdr)


#ifndef TOPPERS_MACRO_ONLY

/*
 *  ݃nh̓ŕKvIRC
 *
 */
Inline void
i_begin_int(INTNO intno)
{
	/* ɍsׂ͂Ȃ */
}

/*
 *  ݃nh̏oŕKvIRC
 *
 */
Inline void
i_end_int(INTNO intno)
{
	/* ɍsׂ͂Ȃ */
}


/*
 *  ݃nh̐ݒ
 *
 *  M32CROMɊ݃xN^zu邽߁C{֐͋֐ŎD
 */
Inline void
x_define_inh(INHNO inhno, FP inthdr)
{
}


#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_PRC_INTERRUPT_H */
