/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: interrupt.h 96 2012-03-03 06:30:56Z nagasima $
 */

/*
 *		݊Ǘ@\
 */

#ifndef TOPPERS_INTERRUPT_H
#define TOPPERS_INTERRUPT_H

/*
 *  ݃T[rX[`ubN
 */
typedef struct isr_initialization_block {
	ATR			isratr;			/* ݃T[rX[` */
	intptr_t	exinf;			/* ݃T[rX[`̊g */
	INTNO		intno;			/* ݃T[rX[`o^銄ݔԍ */
	QUEUE		*p_isr_queue;	/* o^抄݃T[rX[`L[̔Ԓn */
	ISR			isr;			/* ݃T[rX[`̐擪Ԓn */
	PRI			isrpri;			/* ݃T[rX[`Dx */
} ISRINIB;

/*
 *  ݃T[rX[`ǗubN
 */
typedef struct isr_control_block {
	QUEUE		isr_queue;		/* ݃T[rX[`ďoL[ */
	const ISRINIB *p_isrinib;	/* ubNւ̃|C^ */
} ISRCB;

/*
 *  ݃T[rX[`ďoL[邽߂̃f[^\
 */
typedef struct {
	INTNO		intno;			/* ݔԍ */
	QUEUE		*p_isr_queue;	/* ݃T[rX[`ďoL[ */
} ISR_ENTRY;

/*
 *  ݃T[rX[`L[̃Ggikernel_cfg.cj
 */
extern const uint_t tnum_isr_queue;

/*
 *  ݃T[rX[`L[Xgikernel_cfg.cj
 */
extern const ISR_ENTRY isr_queue_list[];

/*
 *  ݃T[rX[`L[̃GAikernel_cfg.cj
 */
extern QUEUE isr_queue_table[];

/*
 *  gpĂȂ݃T[rX[`ǗubÑXg
 */
extern QUEUE	free_isrcb;

/*
 *  ݃T[rX[`ID̍őlikernel_cfg.cj
 *
 *  ÓIɐ銄݃T[rX[`IDԍȂ߁C
 *  tmax_isrid͓Iɐ銄݃T[rX[`IDԍ̍ől
 *  łDÓIɐ銄݃T[rX[`̐́Ctnum_sisrɕ
 *  D
 */
extern const ID		tmax_isrid;
extern const uint_t	tnum_sisr;

/*
 *  ݃T[rX[`ubÑGAikernel_cfg.cj
 */
extern const ISRINIB	sisrinib_table[];
extern ISRINIB			aisrinib_table[];

/*
 *  ݃T[rX[`ǗubÑGAikernel_cfg.cj
 */
extern ISRCB	isrcb_table[];

/*
 *  ݃T[rX[`ǗubN犄݃T[rX[`ID
 *  o߂̃}N
 */
#define	ISRID(p_isrcb)	((ID)(((p_isrcb) - isrcb_table) \
										- tnum_sisr + TMIN_ISRID))

/*
 *  ݃T[rX[`@\̏
 */
extern void initialize_isr(void);

/*
 *  ݃T[rX[`̌ďo
 */
extern void call_isr(QUEUE *p_isr_queue);

#ifndef OMIT_INITIALIZE_INTERRUPT

/*
 *  ݃nhubN
 */
typedef struct interrupt_handler_initialization_block {
	INHNO		inhno;			/* ݃nhԍ */
	ATR			inhatr;			/* ݃nh */
	FP			int_entry;		/* ݃nh̏o̔Ԓn */
} INHINIB;

/*
 *  ݗvCubN
 */
typedef struct interrupt_request_initialization_block {
	INTNO		intno;			/* ݔԍ */
	ATR			intatr;			/* ݑ */
	PRI			intpri;			/* ݗDx */
} INTINIB;

/*
 *  ݃nhԍ̐ikernel_cfg.cj
 */
extern const uint_t	tnum_inhno;

/*
 *  ݃nhubÑGAikernel_cfg.cj
 */
extern const INHINIB	inhinib_table[];

/*
 *  ݗvC̐ikernel_cfg.cj
 */
extern const uint_t	tnum_intno;

/*
 *  ݗvCubÑGAikernel_cfg.cj
 */
extern const INTINIB	intinib_table[];

#endif /* OMIT_INITIALIZE_INTERRUPT */

/*
 *  ݊Ǘ@\̏
 */
extern void	initialize_interrupt(void);

#endif /* TOPPERS_INTERRUPT_H */
