﻿//------------------------------------------------------------------------------
// C# ConsoleView Control
// Copyright (C) 2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: EastAsianWidthInfo.cs 88 2011-04-05 11:03:57Z nagasima $
using System;
using System.Collections.Generic;
using System.Text;

namespace ConsoleView
{
	public enum EastAsianWidth
	{
		/// <summary>中立</summary>
		Neutral,
		/// <summary>全角</summary>
		Fullwidth,
		/// <summary>半角</summary>
		Halfwidth,
		/// <summary>広</summary>
		Wide,
		/// <summary>狭</summary>
		Narrow,
		/// <summary>曖昧</summary>
		Ambiguous,
	}

	public class EastAsianWidthInfo
	{
		private int Start;
		private int End;
		private EastAsianWidth EastAsianWidth;

		// 参照：http://www.unicode.org/Public/UNIDATA/EastAsianWidth.txt
		// 参照：http://ja.wikipedia.org/wiki/%E6%9D%B1%E3%82%A2%E3%82%B8%E3%82%A2%E3%81%AE%E6%96%87%E5%AD%97%E5%B9%85
		public static readonly EastAsianWidthInfo[] EastAsianWidthInfos = {
			new EastAsianWidthInfo(0x0020, 0x007E, EastAsianWidth.Narrow),
			new EastAsianWidthInfo(0x00A1, 0x00A1, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00A2, 0x00A3, EastAsianWidth.Narrow),
			new EastAsianWidthInfo(0x00A4, 0x00A4, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00A5, 0x00A6, EastAsianWidth.Narrow),
			new EastAsianWidthInfo(0x00A7, 0x00A8, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00AA, 0x00AA, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00AC, 0x00AC, EastAsianWidth.Narrow),
			new EastAsianWidthInfo(0x00AD, 0x00AE, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00AF, 0x00AF, EastAsianWidth.Narrow),
			new EastAsianWidthInfo(0x00B0, 0x00B4, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00B6, 0x00BA, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00BC, 0x00BF, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00C6, 0x00C6, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00D0, 0x00D0, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00D7, 0x00D8, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00DE, 0x00E1, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00E6, 0x00E6, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00E8, 0x00EA, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00EC, 0x00ED, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00F0, 0x00F0, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00F2, 0x00F3, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00F7, 0x00FA, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00FC, 0x00FC, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x00FE, 0x00FE, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0101, 0x0101, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0111, 0x0111, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0113, 0x0113, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x011B, 0x011B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0126, 0x0127, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x012B, 0x012B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0131, 0x0133, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0138, 0x0138, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x013F, 0x0142, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0144, 0x0144, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0148, 0x014B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x014D, 0x014D, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0152, 0x0153, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0166, 0x0167, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x016B, 0x016B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x01CE, 0x01CE, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x01D0, 0x01D0, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x01D2, 0x01D2, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x01D4, 0x01D4, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x01D6, 0x01D6, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x01D8, 0x01D8, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x01DA, 0x01DA, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x01DC, 0x01DC, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0251, 0x0251, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0261, 0x0261, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x02C4, 0x02C4, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x02C7, 0x02C7, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x02C9, 0x02CB, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x02CD, 0x02CD, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x02D0, 0x02D0, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x02D8, 0x02DB, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x02DD, 0x02DD, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x02DF, 0x02DF, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0300, 0x036F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0391, 0x03A1, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x03A3, 0x03A9, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x03B1, 0x03C1, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x03C3, 0x03C9, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0401, 0x0401, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0410, 0x044F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x0451, 0x0451, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x1100, 0x115F, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x11A3, 0x11A7, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x11FA, 0x11FF, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2010, 0x2010, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2013, 0x2016, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2018, 0x2019, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x201C, 0x201D, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2020, 0x2022, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2024, 0x2027, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2030, 0x2030, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2032, 0x2033, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2035, 0x2035, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x203B, 0x203B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x203E, 0x203E, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2074, 0x2074, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x207F, 0x207F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2081, 0x2084, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x20A9, 0x20A9, EastAsianWidth.Halfwidth),
			new EastAsianWidthInfo(0x20AC, 0x20AC, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2103, 0x2103, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2105, 0x2105, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2109, 0x2109, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2113, 0x2113, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2116, 0x2116, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2121, 0x2122, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2126, 0x2126, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x212B, 0x212B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2153, 0x2154, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x215B, 0x215E, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2160, 0x216B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2170, 0x2179, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2189, 0x2189, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2190, 0x2199, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x21B8, 0x21B9, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x21D2, 0x21D2, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x21D4, 0x21D4, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x21E7, 0x21E7, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2200, 0x2200, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2202, 0x2203, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2207, 0x2208, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x220B, 0x220B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x220F, 0x220F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2211, 0x2211, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2215, 0x2215, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x221A, 0x221A, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x221D, 0x2220, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2223, 0x2223, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2225, 0x2225, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2227, 0x222C, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x222E, 0x222E, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2234, 0x2237, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x223C, 0x223D, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2248, 0x2248, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x224C, 0x224C, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2252, 0x2252, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2260, 0x2261, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2264, 0x2267, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x226A, 0x226B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x226E, 0x226F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2282, 0x2283, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2286, 0x2287, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2295, 0x2295, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2299, 0x2299, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x22A5, 0x22A5, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x22BF, 0x22BF, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2312, 0x2312, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2329, 0x232A, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2460, 0x24E9, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x24EB, 0x254B, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2550, 0x2573, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2580, 0x258F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2592, 0x2595, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25A0, 0x25A1, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25A3, 0x25A9, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25B2, 0x25B3, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25B6, 0x25B7, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25BC, 0x25BD, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25C0, 0x25C1, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25C6, 0x25C8, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25CB, 0x25CB, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25CE, 0x25D1, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25E2, 0x25E5, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x25EF, 0x25EF, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2605, 0x2606, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2609, 0x2609, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x260E, 0x260F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2614, 0x2615, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x261C, 0x261C, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x261E, 0x261E, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2640, 0x2640, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2642, 0x2642, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2660, 0x2661, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2663, 0x2665, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2667, 0x266A, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x266C, 0x266D, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x266F, 0x266F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x269E, 0x269F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x26BE, 0x26BF, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x26C4, 0x26CD, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x26CF, 0x26E1, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x26E3, 0x26E3, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x26E8, 0x26FF, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x273D, 0x273D, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2757, 0x2757, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2776, 0x277F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x27E6, 0x27ED, EastAsianWidth.Narrow),
			new EastAsianWidthInfo(0x2985, 0x2986, EastAsianWidth.Narrow),
			new EastAsianWidthInfo(0x2B55, 0x2B59, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x2E80, 0x2E99, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2E9B, 0x2EF3, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2F00, 0x2FD5, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2FF0, 0x2FFB, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3000, 0x3000, EastAsianWidth.Fullwidth),
			new EastAsianWidthInfo(0x3001, 0x303E, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3041, 0x3096, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3099, 0x30FF, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3105, 0x312D, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3131, 0x318E, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3190, 0x31BA, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x31C0, 0x31E3, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x31F0, 0x321E, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3220, 0x3247, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3248, 0x324F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x3250, 0x32FE, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3300, 0x33FF, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x3400, 0x4DB5, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x4DB6, 0x4DBF, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x4E00, 0x9FCB, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x9FCC, 0x9FFF, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xA000, 0xA48C, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xA490, 0xA4C6, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xA960, 0xA97C, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xAC00, 0xD7A3, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xD7B0, 0xD7C6, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xD7CB, 0xD7FB, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xE000, 0xF8FF, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0xF900, 0xFA2D, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFA2E, 0xFA2F, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFA30, 0xFA6D, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFA6E, 0xFA6F, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFA70, 0xFAD9, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFADA, 0xFAFF, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFE00, 0xFE0F, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0xFE10, 0xFE19, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFE30, 0xFE52, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFE54, 0xFE66, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFE68, 0xFE6B, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xFF01, 0xFF60, EastAsianWidth.Fullwidth),
			new EastAsianWidthInfo(0xFF61, 0xFFBE, EastAsianWidth.Halfwidth),
			new EastAsianWidthInfo(0xFFC2, 0xFFC7, EastAsianWidth.Halfwidth),
			new EastAsianWidthInfo(0xFFCA, 0xFFCF, EastAsianWidth.Halfwidth),
			new EastAsianWidthInfo(0xFFD2, 0xFFD7, EastAsianWidth.Halfwidth),
			new EastAsianWidthInfo(0xFFDA, 0xFFDC, EastAsianWidth.Halfwidth),
			new EastAsianWidthInfo(0xFFE0, 0xFFE6, EastAsianWidth.Fullwidth),
			new EastAsianWidthInfo(0xFFE8, 0xFFEE, EastAsianWidth.Halfwidth),
			new EastAsianWidthInfo(0xFFFD, 0xFFFD, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x1B000, 0x1B001, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x1F100, 0x1F10A, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x1F110, 0x1F12D, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x1F130, 0x1F169, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x1F170, 0x1F19A, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x1F200, 0x1F202, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x1F210, 0x1F23A, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x1F240, 0x1F248, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x1F250, 0x1F251, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x20000, 0x2A6D6, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2A6D7, 0x2A6FF, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2A700, 0x2B734, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2B735, 0x2F73F, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2B740, 0x2B81D, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2B81E, 0x2F7FF, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2F800, 0x2FA1D, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x2FA1E, 0x2FFFD, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0x30000, 0x3FFFD, EastAsianWidth.Wide),
			new EastAsianWidthInfo(0xE0100, 0xE01EF, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0xF0000, 0xFFFFD, EastAsianWidth.Ambiguous),
			new EastAsianWidthInfo(0x100000, 0x10FFFD, EastAsianWidth.Ambiguous),
		};

		public EastAsianWidthInfo(int start, int end, EastAsianWidth eastAsianWidth)
		{
			Start = start;
			End = end;
			EastAsianWidth = eastAsianWidth;
		}

		public static EastAsianWidth GetEastAsianWidth(int c)
		{
			foreach (EastAsianWidthInfo info in EastAsianWidthInfos)
			{
				if (c < info.Start)
					break;

				if (c <= info.End)
					return info.EastAsianWidth;
			}
			return EastAsianWidth.Neutral;
		}
	}
}
