/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: main.c 96 2012-03-03 06:30:56Z nagasima $
 */

/* 
 *  TvvO(1)̖{
 *
 *  ASPJ[l̊{IȓmF邽߂̃TvvOD
 *
 *  vO̊Tv:
 *
 *  [UC^tF[X󂯎C^XNi^XNID: MAIN_TASKCD
 *  x: MAIN_PRIORITYjƁC3̕s^XNi^XNID:
 *  TASK1`TASK3CDx: MID_PRIORITYjō\D܂CN
 *  2b̎nhinhID: CYCHDR1jpD
 *
 *  s^XŃCtask_loop󃋁[vsxɁC^XN
 *  sł邱Ƃ킷bZ[W\D
 *
 *  nh́CO̗DxiHIGH_PRIORITYCMID_PRIORITYC
 *  LOW_PRIORITYj̃fBL[]DvŐŃC
 *  nh͒~ԂɂȂĂD
 *
 *  C^XŃCVAI/O|[g͂̕si͂
 *  ҂ĂԂ́Cs^XNsĂjC͂ꂽ
 *  ɑΉsD͂ꂽƏ̊֌W͎̒ʂD
 *  Control-C܂'Q'͂ƁCvOID
 *
 *  '1' : Ώۃ^XNTASK1ɐ؂芷iݒjD
 *  '2' : Ώۃ^XNTASK2ɐ؂芷D
 *  '3' : Ώۃ^XNTASK3ɐ؂芷D
 *  'a' : Ώۃ^XNact_tskɂND
 *  'A' : Ώۃ^XNɑ΂Nvcan_actɂLZD
 *  'e' : Ώۃ^XNext_tskĂяoCID
 *  't' : Ώۃ^XNter_tskɂ苭ID
 *  '>' : Ώۃ^XN̗DxHIGH_PRIORITYɂD
 *  '=' : Ώۃ^XN̗DxMID_PRIORITYɂD
 *  '<' : Ώۃ^XN̗DxLOW_PRIORITYɂD
 *  'G' : Ώۃ^XN̗Dxget_priœǂݏoD
 *  's' : Ώۃ^XNslp_tskĂяoCN҂ɂD
 *  'S' : Ώۃ^XNtslp_tsk(10b)ĂяoCN҂ɂD
 *  'w' : Ώۃ^XNwup_tskɂND
 *  'W' : Ώۃ^XNɑ΂Nvcan_wupɂLZD
 *  'l' : Ώۃ^XNrel_waiɂ苭Iɑ҂ɂD
 *  'u' : Ώۃ^XNsus_tskɂ苭҂ԂɂD
 *  'm' : Ώۃ^XN̋҂Ԃrsm_tskɂD
 *  'd' : Ώۃ^XNdly_tsk(10b)ĂяoCԌoߑ҂ɂD
 *  'x' : Ώۃ^XNɗOp^[0x0001̗OvD
 *  'X' : Ώۃ^XNɗOp^[0x0002̗OvD
 *  'y' : Ώۃ^XNdis_texĂяoC^XNO֎~D
 *  'Y' : Ώۃ^XNena_texĂяoC^XNOD
 *  'r' : 3̗DxiHIGH_PRIORITYCMID_PRIORITYCLOW_PRIORITYj̃
 *        fBL[]D
 *  'c' : nh𓮍JnD
 *  'C' : nh𓮍~D
 *  'b' : A[nh5bɋN悤JnD
 *  'B' : A[nh𓮍~D
 *  'z' : Ώۃ^XNCPUO𔭐i^XNIjD
 *  'Z' : Ώۃ^XNCPUbNԂCPUO𔭐ivO
 *        IjD
 *  '@' : ^XN3acre_tskɂ萶Cdef_texɂ^XNO
 *        [`ݒ肷D
 *  '!' : Ώۃ^XNdel_tskɂ폜D
 *  'V' : get_utmŐ\]pVXe2ǂށD
 *  'v' : sVXeR[\iftHgjD
 *  'q' : sVXeR[\ȂD
 */

#include <kernel.h>
#include <t_syslog.h>
#include <t_stdlib.h>
#include "syssvc/serial.h"
#include "syssvc/syslog.h"
#include "kernel_cfg.h"
#include "main.h"

/*
 *  T[rXR[̃G[̃Oo
 */
Inline void
svc_perror(const char *file, int_t line, const char *expr, ER ercd)
{
	if (ercd < 0) {
		t_perror(LOG_ERROR, file, line, expr, ercd);
	}
}

#define	SVC_PERROR(expr)	svc_perror(__FILE__, __LINE__, #expr, (expr))

/*
 *  ss^XNւ̃bZ[Ẅ
 */
char_t	message[3];

/*
 *  [v
 */
ulong_t	task_loop;		/* ^XNł̃[v */
ulong_t	tex_loop;		/* O[`ł̃[v */

/*
 *  ss^XN
 */
void task(intptr_t exinf)
{
	volatile ulong_t	i;
	int_t		n = 0;
	int_t		tskno = (int_t) exinf;
	const char	*graph[] = { "|", "  +", "    *" };
	char_t		c;

	SVC_PERROR(ena_tex());
	while (1) {
		syslog(LOG_NOTICE, "task%d is running (%03d).   %s",
										tskno, ++n, graph[tskno-1]);
		for (i = 0; i < task_loop; i++);
		c = message[tskno-1];
		message[tskno-1] = 0;
		switch (c) {
		case 'e':
			syslog(LOG_INFO, "#%d#ext_tsk()", tskno);
			SVC_PERROR(ext_tsk());
			assert(0);
		case 's':
			syslog(LOG_INFO, "#%d#slp_tsk()", tskno);
			SVC_PERROR(slp_tsk());
			break;
		case 'S':
			syslog(LOG_INFO, "#%d#tslp_tsk(10000)", tskno);
			SVC_PERROR(tslp_tsk(10000));
			break;
		case 'd':
			syslog(LOG_INFO, "#%d#dly_tsk(10000)", tskno);
			SVC_PERROR(dly_tsk(10000));
			break;
		case 'y':
			syslog(LOG_INFO, "#%d#dis_tex()", tskno);
			SVC_PERROR(dis_tex());
			break;
		case 'Y':
			syslog(LOG_INFO, "#%d#ena_tex()", tskno);
			SVC_PERROR(ena_tex());
			break;
#ifdef CPUEXC1
		case 'z':
			syslog(LOG_NOTICE, "#%d#raise CPU exception", tskno);
			RAISE_CPU_EXCEPTION;
			break;
		case 'Z':
			SVC_PERROR(loc_cpu());
			syslog(LOG_NOTICE, "#%d#raise CPU exception", tskno);
			RAISE_CPU_EXCEPTION;
			SVC_PERROR(unl_cpu());
			break;
#endif /* CPUEXC1 */
		default:
			break;
		}
	}
}

/*
 *  sĎs^XNp̃^XNO[`
 */
void tex_routine(TEXPTN texptn, intptr_t exinf)
{
	volatile ulong_t	i;
	int_t	tskno = (int_t) exinf;

	syslog(LOG_NOTICE, "task%d receives exception 0x%04x.", tskno, texptn);
	for (i = 0; i < tex_loop; i++);

	if ((texptn & 0x8000U) != 0U) {
		syslog(LOG_INFO, "#%d#ext_tsk()", tskno);
		SVC_PERROR(ext_tsk());
		assert(0);
	}
}

/*
 *  CPUOnh
 */
#ifdef CPUEXC1

void
cpuexc_handler(void *p_excinf)
{
	ID		tskid;

	syslog(LOG_NOTICE, "CPU exception handler (p_excinf = %08p).", p_excinf);
	if (sns_ctx() != true) {
		syslog(LOG_WARNING,
					"sns_ctx() is not true in CPU exception handler.");
	}
	if (sns_dpn() != true) {
		syslog(LOG_WARNING,
					"sns_dpn() is not true in CPU exception handler.");
	}
	syslog(LOG_INFO, "sns_loc = %d sns_dsp = %d sns_tex = %d",
									sns_loc(), sns_dsp(), sns_tex());
	syslog(LOG_INFO, "xsns_dpn = %d xsns_xpn = %d",
									xsns_dpn(p_excinf), xsns_xpn(p_excinf));

	if (xsns_xpn(p_excinf)) {
		syslog(LOG_NOTICE, "Sample program ends with exception.");
		SVC_PERROR(ext_ker());
		assert(0);
	}

	SVC_PERROR(iget_tid(&tskid));
	SVC_PERROR(iras_tex(tskid, 0x8000U));
}

#endif /* CPUEXC1 */

/*
 *  nh
 *
 *  HIGH_PRIORITYCMID_PRIORITYCLOW_PRIORITY ̊eDx̃fBL[
 *  ]D
 */
void cyclic_handler(intptr_t exinf)
{
	SVC_PERROR(irot_rdq(HIGH_PRIORITY));
	SVC_PERROR(irot_rdq(MID_PRIORITY));
	SVC_PERROR(irot_rdq(LOW_PRIORITY));
}

/*
 *  A[nh
 *
 *  HIGH_PRIORITYCMID_PRIORITYCLOW_PRIORITY ̊eDx̃fBL[
 *  ]D
 */
void alarm_handler(intptr_t exinf)
{
	SVC_PERROR(irot_rdq(HIGH_PRIORITY));
	SVC_PERROR(irot_rdq(MID_PRIORITY));
	SVC_PERROR(irot_rdq(LOW_PRIORITY));
}

/*
 *  C^XN
 */
void main_task(intptr_t exinf)
{
	char_t	c;
	ID		tskid = TASK1;
	int_t	tskno = 1;
	ER_UINT	ercd;
	PRI		tskpri;
#ifndef TASK_LOOP
	volatile ulong_t	i;
	SYSTIM	stime1, stime2;
#endif /* TASK_LOOP */
#ifdef TOPPERS_SUPPORT_GET_UTM
	SYSUTM	utime1, utime2;
#endif /* TOPPERS_SUPPORT_GET_UTM */
	T_CTSK	ctsk;
	T_DTEX	dtex;
	ID		TASK3 = -1;

	SVC_PERROR(syslog_msk_log(LOG_UPTO(LOG_INFO), LOG_UPTO(LOG_EMERG)));
	syslog(LOG_NOTICE, "Sample program starts (exinf = %d).", (int_t) exinf);

	/*
	 *  VA|[g̏
	 *
	 *  VXeO^XNƓVA|[ggꍇȂǁCVA
	 *  |[gI[vς݂̏ꍇɂ͂E_OBJG[ɂȂ邪Cx
	 *  ȂD
	 */
	ercd = serial_opn_por(TASK_PORTID);
	if (ercd < 0 && MERCD(ercd) != E_OBJ) {
		syslog(LOG_ERROR, "%s (%d) reported by `serial_opn_por'.",
									itron_strerror(ercd), SERCD(ercd));
	}
	SVC_PERROR(serial_ctl_por(TASK_PORTID,
							(IOCTL_CRLF | IOCTL_FCSND | IOCTL_FCRCV)));

	/*
 	 *  [v񐔂̐ݒ
	 *
	 *  TASK_LOOP}N`ĂꍇC肹ɁCTASK_LOOPɒ
	 *  `ꂽlC^XNł̃[v񐔂ƂD
	 *
	 *  MEASURE_TWICE}N`ĂꍇC1ڂ̑茋ʂ̂
	 *  āC2ڂ̑茋ʂgD1ڂ̑͒߂̎Ԃo邽߁D
	 */
#ifdef TASK_LOOP
	task_loop = TASK_LOOP;
#else /* TASK_LOOP */

#ifdef MEASURE_TWICE
	task_loop = LOOP_REF;
	SVC_PERROR(get_tim(&stime1));
	for (i = 0; i < task_loop; i++);
	SVC_PERROR(get_tim(&stime2));
#endif /* MEASURE_TWICE */

	task_loop = LOOP_REF;
	SVC_PERROR(get_tim(&stime1));
	for (i = 0; i < task_loop; i++);
	SVC_PERROR(get_tim(&stime2));
	task_loop = LOOP_REF * 400UL / (stime2 - stime1);

#endif /* TASK_LOOP */
	tex_loop = task_loop / 5;

	/*
 	 *  ^XN̋N
	 */
	SVC_PERROR(act_tsk(TASK1));
	SVC_PERROR(act_tsk(TASK2));

	/*
 	 *  C[v
	 */
	do {
		SVC_PERROR(serial_rea_dat(TASK_PORTID, &c, 1));
		switch (c) {
		case 'e':
		case 's':
		case 'S':
		case 'd':
		case 'y':
		case 'Y':
		case 'z':
		case 'Z':
			message[tskno-1] = c;
			break;
		case '1':
			tskno = 1;
			tskid = TASK1;
			break;
		case '2':
			tskno = 2;
			tskid = TASK2;
			break;
		case '3':
			tskno = 3;
			tskid = TASK3;
			break;
		case 'a':
			syslog(LOG_INFO, "#act_tsk(%d)", tskno);
			SVC_PERROR(act_tsk(tskid));
			break;
		case 'A':
			syslog(LOG_INFO, "#can_act(%d)", tskno);
			SVC_PERROR(ercd = can_act(tskid));
			if (ercd >= 0) {
				syslog(LOG_NOTICE, "can_act(%d) returns %d", tskno, ercd);
			}
			break;
		case 't':
			syslog(LOG_INFO, "#ter_tsk(%d)", tskno);
			SVC_PERROR(ter_tsk(tskid));
			break;
		case '>':
			syslog(LOG_INFO, "#chg_pri(%d, HIGH_PRIORITY)", tskno);
			SVC_PERROR(chg_pri(tskid, HIGH_PRIORITY));
			break;
		case '=':
			syslog(LOG_INFO, "#chg_pri(%d, MID_PRIORITY)", tskno);
			SVC_PERROR(chg_pri(tskid, MID_PRIORITY));
			break;
		case '<':
			syslog(LOG_INFO, "#chg_pri(%d, LOW_PRIORITY)", tskno);
			SVC_PERROR(chg_pri(tskid, LOW_PRIORITY));
			break;
		case 'G':
			syslog(LOG_INFO, "#get_pri(%d, &tskpri)", tskno);
			SVC_PERROR(ercd = get_pri(tskid, &tskpri));
			if (ercd >= 0) {
				syslog(LOG_NOTICE, "priority of task %d is %d", tskno, tskpri);
			}
			break;
		case 'w':
			syslog(LOG_INFO, "#wup_tsk(%d)", tskno);
			SVC_PERROR(wup_tsk(tskid));
			break;
		case 'W':
			syslog(LOG_INFO, "#can_wup(%d)", tskno);
			SVC_PERROR(ercd = can_wup(tskid));
			if (ercd >= 0) {
				syslog(LOG_NOTICE, "can_wup(%d) returns %d", tskno, ercd);
			}
			break;
		case 'l':
			syslog(LOG_INFO, "#rel_wai(%d)", tskno);
			SVC_PERROR(rel_wai(tskid));
			break;
		case 'u':
			syslog(LOG_INFO, "#sus_tsk(%d)", tskno);
			SVC_PERROR(sus_tsk(tskid));
			break;
		case 'm':
			syslog(LOG_INFO, "#rsm_tsk(%d)", tskno);
			SVC_PERROR(rsm_tsk(tskid));
			break;
		case 'x':
			syslog(LOG_INFO, "#ras_tex(%d, 0x0001U)", tskno);
			SVC_PERROR(ras_tex(tskid, 0x0001U));
			break;
		case 'X':
			syslog(LOG_INFO, "#ras_tex(%d, 0x0002U)", tskno);
			SVC_PERROR(ras_tex(tskid, 0x0002U));
			break;
		case 'r':
			syslog(LOG_INFO, "#rot_rdq(three priorities)");
			SVC_PERROR(rot_rdq(HIGH_PRIORITY));
			SVC_PERROR(rot_rdq(MID_PRIORITY));
			SVC_PERROR(rot_rdq(LOW_PRIORITY));
			break;
		case 'c':
			syslog(LOG_INFO, "#sta_cyc(1)");
			SVC_PERROR(sta_cyc(CYCHDR1));
			break;
		case 'C':
			syslog(LOG_INFO, "#stp_cyc(1)");
			SVC_PERROR(stp_cyc(CYCHDR1));
			break;
		case 'b':
			syslog(LOG_INFO, "#sta_alm(1, 5000)");
			SVC_PERROR(sta_alm(ALMHDR1, 5000));
			break;
		case 'B':
			syslog(LOG_INFO, "#stp_alm(1)");
			SVC_PERROR(stp_alm(ALMHDR1));
			break;
		case '@':
			ctsk.tskatr = TA_NULL;
			ctsk.exinf = 3;
			ctsk.task = task;
			ctsk.itskpri = MID_PRIORITY;
			ctsk.stksz = STACK_SIZE;
			ctsk.stk = NULL;
			SVC_PERROR(TASK3 = acre_tsk(&ctsk));

			dtex.texatr = TA_NULL;
			dtex.texrtn = tex_routine;
			SVC_PERROR(def_tex(TASK3, &dtex));

			syslog(LOG_NOTICE, "task3 is created with tskid = %d.",
														(int_t) TASK3);
			break;
		case '!':
			syslog(LOG_INFO, "#del_tsk(%d)", tskno);
			SVC_PERROR(del_tsk(tskid));
			break;
		case 'V':
#ifdef TOPPERS_SUPPORT_GET_UTM
			SVC_PERROR(get_utm(&utime1));
			SVC_PERROR(get_utm(&utime2));
			syslog(LOG_NOTICE, "utime1 = %ld, utime2 = %ld",
										(ulong_t) utime1, (ulong_t) utime2);
#else /* TOPPERS_SUPPORT_GET_UTM */
			syslog(LOG_NOTICE, "get_utm is not supported.");
#endif /* TOPPERS_SUPPORT_GET_UTM */
			break;
		case 'v':
			SVC_PERROR(syslog_msk_log(LOG_UPTO(LOG_INFO),
										LOG_UPTO(LOG_EMERG)));
			break;
		case 'q':
			SVC_PERROR(syslog_msk_log(LOG_UPTO(LOG_NOTICE),
										LOG_UPTO(LOG_EMERG)));
			break;
#ifdef BIT_KERNEL
		case ' ':
			SVC_PERROR(loc_cpu());
			{
				extern ER	bit_kernel(void);

				SVC_PERROR(ercd = bit_kernel());
				if (ercd >= 0) {
					syslog(LOG_NOTICE, "bit_kernel passed.");
				}
			}
			SVC_PERROR(unl_cpu());
			break;
#endif /* BIT_KERNEL */
		default:
			break;
		}
	} while (c != '\003' && c != 'Q');

	message[0] = 'e';
	message[1] = 'e';
	message[2] = 'e';

	chg_pri(TASK1, HIGH_PRIORITY);
	chg_pri(TASK2, HIGH_PRIORITY);
	chg_pri(TASK3, HIGH_PRIORITY);
	chg_pri(MAIN_TASK, LOW_PRIORITY);

	syslog(LOG_NOTICE, "Sample program ends.");

	SVC_PERROR(ext_ker());
	assert(0);
}
