//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2013 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: UnitSim.cs 115 2013-02-11 02:13:05Z nagasima $
#ifndef SifUARTBH
#define SifUARTBH

//---------------------------------------------------------------------------
#include "Kernel.h"
#include "V850ESJX3EReg.h"
#include "SIFLayer.h"

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
#pragma pack(push, 1)
struct TUARTBDataNode
{
	int Size;
	unsigned char Data[1];
};
#pragma pack(pop)

typedef list<TUARTBDataNode *> CUARTBDataQueue;

enum TUARTBTerm
{
	ubtIdle,
	ubtSending,
	ubtWait,
	ubtFlush,
};

//------------------------------------------------------------------------------
// ɂUARTB NX
//------------------------------------------------------------------------------
class CSifUARTB : public ISysTimerSync
{
public:
	CSifUARTB(TUartBPort *reg, int txIntNo, int rxIntNo, int devNo);
	virtual ~CSifUARTB();
private:
	TUartBPort *m_Reg;
	int m_TxIntNo;
	int m_RxIntNo;
	int m_DevNo;
	unsigned char m_SendBuf[256];
	int m_SendBufPos;
	CRITICAL_SECTION m_Lock;
	CUARTBDataQueue m_RecvQueue;
	TUARTBDataNode *m_RecvBuf;
	int m_RecvBufPos;
	TUARTBTerm m_Term;
	LONG m_Send;
	__int64 m_Timer;
	__int64 CalcTimer(__int64 Frequency);
protected:
	void Lock() { EnterCriticalSection(&m_Lock); }
	void Unlock() { LeaveCriticalSection(&m_Lock); }
public:
	unsigned char GetByte2(intptr_t Index);
	void SetByte2(intptr_t Index, unsigned char Value);
public:
	__int64 GetTimer();
	void Progress(__int64 Timer);
	void CallTimeOut(__int64 Frequency);
	void Receive(const void *Data, int Size);
};

//---------------------------------------------------------------------------
#endif // SifUARTBH
