﻿//------------------------------------------------------------------------------
// Embedded Software Simulation Base Classes
// Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: CommandButtonInfo.cs 88 2011-04-05 11:03:57Z nagasima $
using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using NU.OJL.MPRTOS.TLV.Base;
using System.Reflection;

namespace SimBase
{
	public class CommandButtonInfo
	{
		private string m_Name;
		private Type m_CommandType;
		private string m_Text;
		private bool m_CheckOnClick;
		private ToolStripItemDisplayStyle m_DisplayStyle;
		private Image m_Image;
		private Color m_ImageTransparentColor;

		public CommandButtonInfo(string name, Type commandType, string text, bool checkOnClick,
			ToolStripItemDisplayStyle displayStyle)
			: this(name, commandType, text, checkOnClick, displayStyle, null, Color.Empty)
		{
		}

		public CommandButtonInfo(string name, Type commandType, string text, bool checkOnClick,
			ToolStripItemDisplayStyle displayStyle, Image image, Color imageTransparentColor)
		{
			m_Name = name;
			m_CommandType = commandType;
			m_Text = text;
			m_CheckOnClick = checkOnClick;
			m_DisplayStyle = displayStyle;
			m_Image = image;
			m_ImageTransparentColor = imageTransparentColor;
		}

		public string Name { get { return m_Name; } }

		public string Text { get { return m_Text; } }

		public bool CheckOnClick { get { return m_CheckOnClick; } }

		public ToolStripItemDisplayStyle DisplayStyle { get { return m_DisplayStyle; } }

		public Image Image { get { return m_Image; } }

		public Color ImageTransparentColor { get { return m_ImageTransparentColor; } }

		public ToolStripButton CreateToolStripButton(CommandManager manager)
		{
			ToolStripButton btn = new ToolStripButton();
			btn.CheckOnClick = m_CheckOnClick;
			btn.DisplayStyle = m_DisplayStyle;
			btn.Image = m_Image;
			btn.ImageTransparentColor = m_ImageTransparentColor;
			btn.Name = m_Name;
			btn.Tag = manager;
			btn.Text = m_Text;
			btn.Click += new EventHandler(Button_Click);
			return btn;
		}

		void Button_Click(object sender, EventArgs e)
		{
			ToolStripButton btn = (ToolStripButton)sender;
			CommandManager manager = (CommandManager)btn.Tag;
			ConstructorInfo ctor = m_CommandType.GetConstructor(new Type[] { typeof(object), typeof(CommandButtonInfo), typeof(CommandManager) });
			ICommand command = (ICommand)ctor.Invoke(new object[] { sender, this, manager });
			manager.Do(command);
		}
	}
}
