/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: prc_sil.h 92 2011-08-07 05:57:30Z nagasima $
 */

/*
 *   sil.h̃vZbTˑiV850pj
 */

#ifndef TOPPERS_PRC_SIL_H
#define TOPPERS_PRC_SIL_H

#define PSW_ID_BITPTN	(1U << 5)

#ifndef TOPPERS_MACRO_ONLY

#include "prc_insn.h"

/*
 *  NMIׂĂ݂̊̋֎~
 */
Inline uint32_t
TOPPERS_disint(void)
{
	/* ݂PSW擾CIDrbgZbg */
	volatile uint32_t psw = current_psw();
	set_psw(psw | PSW_ID_BITPTN);
	
    return(psw);
}

/*
 *  NMIׂĂ݂̊̋
 */
Inline void
TOPPERS_enaint(uint32_t TOPPERS_psw)
{
	if((TOPPERS_psw & PSW_ID_BITPTN) == 0u)
	{
		set_psw(current_psw() & ~PSW_ID_BITPTN);
	}
}

/*
 *  S݃bNԂ̐
 */
#define SIL_PRE_LOC     volatile uint32_t TOPPERS_psw
#define SIL_LOC_INT()   TOPPERS_psw = TOPPERS_disint()
#define SIL_UNL_INT()   TOPPERS_enaint(TOPPERS_psw)

/*
 *  vZbT̃GfBA`
 */

#define SIL_ENDIAN_LITTLE		/* gGfBA */

#endif /* TOPPERS_MACRO_ONLY */

#endif	/* TOPPERS_PRC_SIL_H */
