/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 *
 *  Copyright (C) 2010-2011 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	vZbTˑW[ AZuꕔiV850pj
 */

#include "v850asm.inc"

#define	TOPPERS_MACRO_ONLY
#define UINT_C(val)			(val)		/* uint_t^̒萔}N */
#define ULONG_C(val)		(val)		/* ulong_t^̒萔}N */
#define CAST(type, val)		(val)		/* ^LXgs}N */
#define TOPPERS_LABEL_ASM
#include "kernel_impl.h"
#include "offset.h"

/* OQƐ錾 */
	.globl	_set_intpri
	.globl	_call_texrtn
	.globl	_ipmflg
	
/*
 *	fBXpb`̊Jn
 *
 *	݋֎~ԁClock_flag = truełւ͂Ă邪C
 *	݃}XNx0ł邽߁CCPUbNԂ
 *	ݒ肵čŏ̃fBXpb`ɈڂD
 *	
 */
	.globl	_start_dispatch
_start_dispatch:
	/* ݃}XNxCPUbNԂ̒lɐݒ */
	mov		INTPRI_LOCK , r6
	jarl	_set_intpri , lp
	/* ݋֎~Ԃ */
	ei
	/* fBXpb`{̂ */
	br		dispatcher

/*
 *  ^XNfBXpb`
 */
 	.globl	_dispatch
 	.globl	_exit_and_dispatch
_dispatch:
	/*
	 * ReLXg̑ޔ 
	 */
	addi	-60, sp, sp
	st.w	ep , 0[sp]
	mov		sp, ep
	sst.w	r2,  56[ep]
	sst.w	r10, 52[ep]
	sst.w	r11, 48[ep]
	sst.w	r20, 44[ep]
	sst.w	r21, 40[ep]
	sst.w	r22, 36[ep]
	sst.w	r23, 32[ep]
	sst.w	r24, 28[ep]
	sst.w	r25, 24[ep]
	sst.w	r26, 20[ep]
	sst.w	r27, 16[ep]
	sst.w	r28, 12[ep]
	sst.w	r29,  8[ep]
	sst.w	r31,  4[ep]
	
	/* X^bNƎ̋NԒnۑ */
	Lea		_p_runtsk, ep
	sld.w	0[ep], ep
	sst.w	sp, TCB_sp[ep]
	Lea		dispatch_r, r10
	sst.w	r10, TCB_pc[ep]
	
	/*
	 *  ^XNfBXpb`
	 *  
	 *  CPUbNԁCfBXpb`ȌPʂ
	 *  ReLXgޔς݂ԂŗKv.
	 */
_exit_and_dispatch:
dispatcher:
	Lea		_p_runtsk, r21
#ifdef LOG_DSP_ENTER
	ld.w		0[r21] , r6		/* p_runtskw */
	jarl	_log_dsp_enter , lp
#endif	/* LOG_DSP_ENTER */
	Lea		_p_schedtsk, r20
	ld.w	0[r20], r22
	st.w	r22, 0[r21]
	cmp		r22 , r0
	be		pre_idle
	/* X^bNƎ̋NԒn𕜋A */
	mov		r22, ep
	sld.w	TCB_pc[ep], r20
	sld.w	TCB_sp[ep], sp
#ifdef LOG_DSP_LEAVE
	ld.w	0[r21] , r6	/* p_runtskw */
	jarl	_log_dsp_leave , lp
#endif	/* LOG_DSP_LEAVE */
	jmp		r20

	/*
	 * ACh[v
	 */
pre_idle:
	/* 荞݃X^bNɐ؂ւ */
	Lea		STACKTOP, sp
	/* CPUbNԂ̉ */
	Lea		_lock_flag , r10
	st.w	r0 , 0[r10]
	di
	mov		INTPRI_ENAALL , r6
	jarl	_set_intpri , lp
	/* intnest1ɂ */
	mov		1, r10
	Lea		_intnest, r11
	st.b	r10, 0[r11]
	/* reqflg̃AhX[h */
	Lea		_reqflg , r20
idle_loop:	
	/* 荞ݑ҂ */
	ei
	nop
	di
	
	/* reqflg̃`FbN */
	ld.w	0[r20], r10
	cmp		r10 , r0
	be		idle_loop
	
	/* reqflg̃NA */
	st.w	r0 , 0[r20]
	
	/* intnestNA */
	Lea		_intnest, r10
	st.b	r0, 0[r10]
	/* CPUbNԂֈڍs */
	di
	mov		INTPRI_LOCK , r6
	jarl	_set_intpri , lp
	ei
	/* fBXpb` */
	br	dispatcher
	
	/* fBXpb`̕A[` */
dispatch_r:
	Lea		_p_runtsk, r10
	ld.w	0[r10], r10
	ld.w	TCB_enatex[r10], r11
	mov		(1 << TCB_enatex_bit) , r12
	tst		r11 , r12
	bz		ret_to_task
	ld.w	TCB_texptn[r10], r11
	cmp		r0, r11
	be		ret_to_task
	Lea		_ipmflg , r10
	ld.w	0[r10] , r10
	cmp		r0 , r10
	be		ret_to_task

	/* ^XNǑĂяo */
	jarl	_call_texrtn, lp
ret_to_task:
	mov		sp, ep
	sld.w	56[ep], r2
	sld.w	52[ep], r10
	sld.w	48[ep], r11
	sld.w	44[ep], r20
	sld.w	40[ep], r21
	sld.w	36[ep], r22
	sld.w	32[ep], r23
	sld.w	28[ep], r24
	sld.w	24[ep], r25
	sld.w	20[ep], r26
	sld.w	16[ep], r27
	sld.w	12[ep], r28
	sld.w	 8[ep], r29
	sld.w	 4[ep], r31
	addi	60, ep, sp
	ld.w	0[sp], ep
	jmp		lp

/*
 *  ^XNN
 */
 	.globl _start_r
_start_r:
	/* ݃}XNxCPUAbNԂ̒lɐݒ */
	di
	mov		INTPRI_ENAALL , r6
	jarl	_set_intpri , lp
	Lea		_lock_flag , r6
	st.w	r0 , 0[r6]
	
	Lea		_p_runtsk, ep
	ld.w	0[ep], ep
	ld.w	TCB_p_tinib[ep], ep
	ld.w	TINIB_exinf[ep], r6
	ld.w	TINIB_task[ep], r10
	Lea		_ext_tsk, lp
	
	/* ^XN{̂ */
	ei		/* ݋֎~Ԃ */
	jmp		r10

/*
 *  ݃nh
 *
 *  ̎_ŃX^bN80bytemۂĂCWX^Ɋ݃nh
 *  i[ĂD
 *
 *  - r10F݃nhAhX
 *  - r11F荞ݗDx(\)
 *  - r12F݃nhԍ
 *
 *  X^bN̍\͈ȉ̂ƂD
 *
 *    |----------------|<- ݔSP
 * 76 | current_intpri |
 *    |----------------|
 * 72 |       r1       |
 *    |----------------|
 * 68 |       r6       |
 *    |----------------|
 * 64 |       r7       |
 *    |----------------|
 * 60 |       r8       |
 *    |----------------|
 * 56 |       r9       |
 *    |----------------|
 * 52 |      r10       |
 *    |----------------|
 * 48 |      r11       |
 *    |----------------|
 * 44 |      r12       |
 *    |----------------|
 * 40 |      r13       |
 *    |----------------|
 * 36 |      r14       |
 *    |----------------|
 * 32 |      r15       |
 *    |----------------|
 * 28 |      r16       |
 *    |----------------|
 * 24 |      r17       |
 *    |----------------|
 * 20 |      r18       |
 *    |----------------|
 * 16 |      r19       |
 *    |----------------|
 * 12 |      r30       |
 *    |----------------|
 *  8 |      r31       |
 *    |----------------|
 *  4 |      EIPC      |
 *    |----------------|
 *  0 |     EIPSW      |
 *    |----------------|<- ݔSP - 80
 */
	.globl interrupt
interrupt:
	/*
	 *  c̃WX^ޔC EPł̃ANZXɐ؂ւčs
	 *  (r10-r12͑ޔς)
	 */
	st.w	ep,   12[sp]
	mov		sp ,  ep 
	sst.w	r1 ,  72[ep]
	sst.w	r6 ,  68[ep]
	sst.w	r7 ,  64[ep]
	sst.w	r8 ,  60[ep]
	sst.w	r9 ,  56[ep]
	sst.w	r13 , 40[ep]
	sst.w	r14 , 36[ep]
	sst.w	r15 , 32[ep]
	sst.w	r16 , 28[ep]
	sst.w	r17 , 24[ep]
	sst.w	r18 , 20[ep]
	sst.w	r19 , 16[ep]
	sst.w	r31 ,  8[ep]
	/* d݂̂߁C݂EIPCEIPSWۑ */
	stsr	eipc,   r6
	sst.w	r6 ,   4[ep]
	stsr	eipsw,  r6
	sst.w	r6 ,   0[ep]
	
	Lea		_lock_flag , r7
	ld.w	0[r7] , r7
	
	/* ݔO̊݃xۑC̊݃x(r11)ɏ */
	Lea		_current_intpri , r13
	ld.bu	0[r13] , r14
	sst.w	r14 , 76[ep]
	st.b	r11 , 0[r13]
	
	/* d荞݃`FbNƃlXgJE^CNg */
	Lea		_intnest, r13
	ld.bu	0[r13], r6
	add		1, r6
	st.b	r6, 0[r13]
	cmp		1 , r6
	bne		call_int_handler
save_tsksp:
	/* 񊄍݂ł΃X^bNJ[lX^bN֐؂ւ */
	mov		sp , r13
	mov		STACKTOP , sp
	add		-4 , sp
	st.w	r13 , 0[sp]
call_int_handler:
#ifdef LOG_INH_ENTER
	/* ݃nhAhXCݗDxCݔԍޔ */
	add		-8 , sp
	st.w	r10 , 0[sp]
	st.w	r12 , 4[sp]
	mov		r12 , r6
	jarl	_log_inh_enter , lp
	ld.w	0[sp] , r10
	ld.w	4[sp] , r12
	add		8 , sp
#endif	/* LOG_INH_ENTER */
#ifdef LOG_INH_LEAVE
	add		-4 , sp
	st.w	r12 , 0[sp]
#endif	/* LOG_INH_LEAVE */
	Lea		end_int_handler, lp
	/* 荞݋ */
	ei
	/* nhN */
	jmp		r10
end_int_handler:
	/* 荞݋֎~ */
	di
#ifdef LOG_INH_LEAVE
	ld.w	0[sp] , r6
	add		4 , sp
	jarl	_log_inh_leave , lp
#endif	/* LOG_INH_LEAVE */
	/* CPUbNԂAbNԂɖ߂ */
	Lea		_lock_flag , r10
	st.w	r0 , 0[r10]
	/* intnestfNg */
	Lea		_intnest, r11
	ld.bu	0[r11], r10
	add		-1 , r10
	st.b	r10, 0[r11]
	cmp		r0 , r10
	be		return_to_task
return_from_int:
	/*
	 * WX^A 
	 */
	mov		sp , ep	/* EP֐؂ւ */
	Lea		_current_intpri , r10
	sld.w	76[ep] , r6
	st.b	r6 , 0[r10]
	di
	jarl	_set_intpri , lp
	ei
	sld.w	 4[ep] , r10
	ldsr	r10 , eipc
	sld.w    0[ep] , r10
	ldsr    r10 , eipsw
	sld.w	72[ep] , r1
	sld.w	68[ep] , r6
	sld.w	64[ep] , r7
	sld.w	60[ep] , r8
	sld.w	56[ep] , r9
	sld.w	52[ep] , r10
	sld.w	48[ep] , r11
	sld.w	44[ep] , r12
	sld.w	40[ep] , r13
	sld.w	36[ep] , r14
	sld.w	32[ep] , r15
	sld.w	28[ep] , r16
	sld.w	24[ep] , r17
	sld.w	20[ep] , r18
	sld.w	16[ep] , r19
	sld.w	 8[ep] , r31
	addi	80 , ep, sp
	sld.w	12[ep] , r30
	
	reti	/* ݌ */

return_to_task:
	/* X^bN̕A */
	ld.w	0[sp], sp
	
	/* xfBXpb`yу^XNȌv邩`FbN */
	Lea		_reqflg, r10
	ld.w	0[r10], r11
	cmp		r0, r11
	be		return_from_int
	st.w	r0, 0[r10]			/* reqflg̃NA */
	
	/* fBXpb`\Ԃ`FbN */
	Lea		_dspflg , r10
	ld.w	0[r10], r10
	cmp		r0, r10
	bz		check_texrtn_cond
	
	/* ݑSԃtÕ`FbN */
	Lea		_ipmflg , r10
	ld.w	0[r10], r10
	cmp		r0, r10
	bz		check_texrtn_cond
	
	/* ^XN؂ւ̕Kv邩`FbN */
	Lea		_p_schedtsk, r10
	ld.w	0[r10], r10
	Lea		_p_runtsk, r11
	ld.w	0[r11], r11
	cmp		r10,r11
	bne		ret_int
	br		check_texrtn_cond_1
	
check_texrtn_cond:
	/* s^XN[h */
	Lea		_p_runtsk, r11
	ld.w	0[r11], r11

check_texrtn_cond_1:
	/* ^XNOĂ邩̃`FbNƃ^XNO[`̎s */
	ld.w	TCB_enatex[r11] , r13
	mov		(1 << TCB_enatex_bit) , r12
	tst		r12 , r13
	bz		return_from_int
	ld.w	TCB_texptn[r11] , r11
	cmp		r0, r11
	bz		return_from_int
	jarl	_call_texrtn , lp
	br		return_from_int

/*
 *  ɔXNb`WX^ޔ
 *
 *    |------------------|<- ݔSP - 80
 * 40 |        r2        |
 *    |------------------|
 * 36 |       r20        |
 *    |------------------|
 * 32 |       r21        |
 *    |------------------|
 * 28 |       r22        |
 *    |------------------|
 * 24 |       r23        |
 *    |------------------|
 * 20 |       r24        |
 *    |------------------|
 * 16 |       r25        |
 *    |------------------|
 * 12 |       r26        |
 *    |------------------|
 *  8 |       r27        |
 *    |------------------|
 *  4 |       r28        |
 *    |------------------|
 *  0 |       r29        |
 *    |------------------|<- ݔSP - 80 - 44
 */      
	.globl	ret_int
ret_int:
	addi	-44, sp, sp
	mov		sp , ep
	sst.w	r2 ,  40[ep]
	sst.w	r20 , 36[ep]
	sst.w	r21 , 32[ep]
	sst.w	r22 , 28[ep]
	sst.w	r23 , 24[ep]
	sst.w	r24 , 20[ep]
	sst.w	r25 , 16[ep]
	sst.w	r26 , 12[ep]
	sst.w	r27 ,  8[ep]
	sst.w	r28 ,  4[ep]
	sst.w	r29 , 0[ep]
	
	/* TCBɕȀݒ */
	Lea		_p_runtsk, r10
	ld.w	0[r10], r10
	st.w	sp , TCB_sp[r10]
	Lea		ret_int_r, r11
	st.w	r11 , TCB_pc[r10]
	
	/* CPUbNԂɐݒ */
	mov		INTPRI_LOCK , r6
	jarl	_set_intpri , lp
	Lea		_current_intpri , r6	/* ݂̉z̊ݗDx0 */
	st.b	r0 , 0[r6]
	mov		1 , r7
	Lea		_lock_flag , r6			/* bNtOtrue */
	st.w	r7 , 0[r6]
	
	/* fBXpb` */
	ldsr	r0, eipsw	/* ݂͋Ԃł悢 */
	Lea		dispatcher, r10
	ldsr	r10, eipc
	reti

	.globl ret_int_r
ret_int_r:
	/* CPUbNtỎ */
	Lea		_lock_flag , r6
	st.w	r0 , 0[r6]
ret_int_r_1:
	/* XNb`WX^̕A */
	mov		sp, ep
	sld.w	40[ep], r2
	sld.w	36[ep], r20
	sld.w	32[ep], r21
	sld.w	28[ep], r22
	sld.w	24[ep], r23
	sld.w	20[ep], r24
	sld.w	16[ep], r25
	sld.w	12[ep], r26
	sld.w	 8[ep], r27
	sld.w	 4[ep], r28
	sld.w	 0[ep], r29
	addi	44 , ep, sp
	
	/* Ƃ̕A֔΂ */
	br		check_texrtn_cond

/*
 *  CPUO
 *
 *  CPUOp_excinfɊi[͈ȉ̒ʂD
 *  Eoffset:0 CPUOPC
 *  Eoffset:4 CPUOSP
 *  Eoffset:8 CPUOPSW
 *  Eoffset:12 OR[h
 */

	.globl	exception
exception:
	/*
	 *  c̃WX^ޔC EPł̃ANZXɐ؂ւčs
	 *  (r10-r12͑ޔς)
	 */
	st.w	ep,   16[sp]
	mov		sp ,  ep 
	sst.w	r1 ,  72[ep]
	sst.w	r6 ,  68[ep]
	sst.w	r7 ,  64[ep]
	sst.w	r8 ,  60[ep]
	sst.w	r9 ,  56[ep]
	sst.w	r13 , 40[ep]
	sst.w	r14 , 36[ep]
	sst.w	r15 , 32[ep]
	sst.w	r16 , 28[ep]
	sst.w	r17 , 24[ep]
	sst.w	r18 , 20[ep]
	sst.w	r19 , 12[ep]
	sst.w	r31 ,  8[ep]
	/* dÔ߁C݂EIPCEIPSWۑ */
	stsr	eipc,   r6
	sst.w	r6 ,   4[ep]
	stsr	eipsw,  r6
	sst.w	r6 ,   0[ep]
	/* ݔO̊݃xۑ */
	Lea		_current_intpri , r13
	ld.bu	0[r13] , r14
	sst.w	r14 , 76[ep]
	
	/* d/O`FbNƃlXgJE^CNg */
	Lea		_intnest, r13
	ld.bu	0[r13], r6
	add		1, r6
	st.b	r6, 0[r13]
	cmp		1 , r6
	bne		set_excinf
	
exc_save_tsksp:
	/* 񊄍݂ł΃X^bNJ[lX^bN֐؂ւ */
	mov		sp , r13
	mov		STACKTOP , sp
	add		-4 , sp
	st.w	r13 , 0[sp]
	
set_excinf:
	/* CPUOX^bNɊi[ */
	addi	-20 , sp , sp
	mov		sp , r6
	stsr	0 , r13				/* CPUOEIPC */
	st.w	r13 , 0[r6]
	stsr	1 , r13				/* CPUOEIPSW */
	st.w	r13 , 8[r6]
	stsr	4 , r13
	mov		0x0000ffff , r14	/* CPUOEICC(ECR̉16bit) */
	and		r14 , r13
	st.w	r13 , 12[r6]
	st.w	r11 , 4[r6]			/* CPUOsp */
	Lea		_lock_flag , r14
	ld.w	0[r14] , r13
	st.w	r13 , 16[r6]		/* CPUÕbNtO */
	
	/* CPUOCPUbNԂȂAbN */
	cmp 	r0 , r13
	be		call_exc_handler
	/*
	 *  TIPM_ENAALLŐݒ肷Ɗ݃nhŔCPUO
	 *  Dxt]邽߁C݂͌̊ݗDx}XNp
	 */
	st.w	r0 , 0[r14]
	add		-8 , sp
	st.w	r10 , 4[sp]
	st.w	r6 , 0[sp]
	Lea		_current_intpri , r6
	ld.bu	0[r6] , r6
	jarl	_set_intpri , lp
	ld.w	4[sp] , r10
	ld.w	0[sp] , r6
	add		8 , sp
call_exc_handler:
#ifdef LOG_EXC_ENTER
	/* CPUOnhAhXCOSPCCPUOԍޔ */
	add		-12 , sp
	st.w	r10 , 0[sp]
	st.w	r6 , 4[sp]
	st.w	r12 , 8[sp]
	mov		r12 , r6
	jarl	_log_exc_enter , lp
	ld.w	0[sp] , r10
	ld.w	4[sp] , r6
	ld.w	8[sp] , r12
	add		12 , sp
#endif	/* LOG_EXC_ENTER */
#ifdef LOG_EXC_LEAVE
	add		-4 , sp
	st.w	r12 , 0[sp]
#endif	/* LOG_EXC_LEAVE */
	Lea		end_exc_handler , lp
	/* nhN */
	ei
	jmp		r10
end_exc_handler:
	di
#ifdef LOG_EXC_LEAVE
	ld.w	0[sp] , r6
	add		4 , sp
	jarl	_log_exc_leave , lp
#endif	/* LOG_EXC_LEAVE */
	
	/*
	 *  CPUbNԂCPUOȌԂɖ߂
	 */
	ld.w	16[sp] , r10
	Lea		_lock_flag , r11
	st.w	r10 , 0[r11]
	cmp		r0 , r10
	bz		end_exc_handler_1
	mov		INTPRI_LOCK , r6
	jarl	_set_intpri , lp
	
end_exc_handler_1:
	/* CPUȌԂi[̈j */
	addi	20 , sp , sp
	/* intnestfNg */
	Lea		_intnest, r11
	ld.bu	0[r11], r10
	add		-1 , r10
	st.b	r10, 0[r11]
	cmp		r0 , r10	
	/* ȍ~͋ʏ */
	be		return_to_task
	br		return_from_int

/*
 *  J[l̏Ǐďo
 */
	.globl _call_exit_kernel
_call_exit_kernel:
	/* ^XNReLXgɐ؂ւ */
	mov		STACKTOP , sp
	jarl	_exit_kernel , lp
	/* ߂Ă邱Ƃ͂ȂC߂Ăꍇ̂ߖ[v */
	di
_call_exit_kernel_loop:
	br		_call_exit_kernel_loop


