/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 * 
 *  Copyright (C) 2010 by Meika Sugimoto
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

#define	TOPPERS_MACRO_ONLY
#include "kernel_impl.h"
#include "v850asm.inc"

	.section	".text" , "ax"
	.align	4

/*
 *	V850pX^[gAbvt@C
 */
	.global	hardware_init_hook
	
	.globl	_start
_start:
	di

	/*
	 * e|C^̏(SP/TP/EP/GP/CTBP)
	 */
	mov	STACKTOP, r3
	Lea		__text , tp
	Lea		__ep , ep
	Lea 	__gp , gp
	Lea		__ctbp , r6
	ldsr	r6 , 20
	
	/*
	 *  hardware_init_hook ̌ďoi0 łȂꍇj
	 *
	 *  ^[Qbgn[hEFAɈˑĕKvȏꍇ
	 *  ́Chardware_init_hook Ƃ֐pӂD
	 */

	Lea		hardware_init_hook, r1
	cmp		r0, r1
	be		hardware_init_hook_end
	jarl	hardware_init_hook, lp
hardware_init_hook_end:
	
	/*
	 *  bssZNṼNA
	 *   ACĂ̂4s
	 */
	Lea		__bss_start, ep
	Lea		__bss_end, r6
bss_clear_start:
	cmp		ep, r6
	be		bss_clear_end
	sst.w	r0, 0[ep]
	add		4, ep
	br		bss_clear_start
bss_clear_end:

	/*
	 *  dataZNV̏iROMΉj
	 *
	 *  __idata_start  __idata_end ܂łC__data_start ȍ~
	 *  Rs[D
	 */
	Lea		__idata_start, r6
	Lea		__idata_end,   r7
	Lea		__data_start,  r8
data_init_start:
	cmp		r6, r7
	be		data_init_end
	ld.w	0[r6], r9
	st.w	r9, 0[r8]
	add		4, r6
	add		4, r8
	br		data_init_start
data_init_end:

	/*
	 *  software_init_hook ďoi0 łȂꍇj
	 *
	 *  \tgEFAiɃCujɈˑĕKvȏ
	 *  ꍇ́Csoftware_init_hook Ƃ֐pӂ
	 *  悢D
	 */

	Lea		software_init_hook, r1
	cmp		r0, r1
	be		software_init_hook_end
	jarl	software_init_hook, r31
software_init_hook_end:

	/*
	 *  J[lND
	 */
	.globl	_sta_ker
	jarl	_sta_ker, r31
	halt

	.end
