/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005 by Freelines CO.,Ltd
 *
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

#include "kernel_impl.h"
#include "target_serial.h"

#define TNUM_SIOP	(3)

/*
 *  VA|[g̏ubN
 */
typedef struct sio_port_initialization_block {
	uint8_t		tx_intno;	/* M݂̊ݔԍ */
	uint8_t		rx_intno;	/* M݂̊ݔԍ */
} SIOPINIB;

/*
 *  VA|[g̐ubN
 */
struct sio_port_control_block {
	const SIOPINIB	*p_siopinib;	/* ubN */
	intptr_t	exinf;				/* g */
	bool_t		openflag;			/* I[vς݃tO */
	int_t		port_id;			/* |[gԍ(0`) */
	bool_t		received;			/* MLtO */
};

SIOPCB siopcb_table[TNUM_SIOP];

/*
 *  SIO ID ǗubNւ̕ϊ}N
 */

#define INDEX_SIO(sioid)	((uint_t)((sioid) - 1))
#define get_siopcb(sioid)	(&(siopcb_table[INDEX_SIO(sioid)]))

/*
 *  VA|[g̃n[hEFAˑ̒`
 */

#define SERIAL_CLKDIV			(0x01)
#define SERIAL_COMPAREVALUE		(0x82)

/* VA֘AWX^ */
#define UAnCTL0(x)  ((uintptr_t)UA0CTL0 + ((x) * 0x10))
#define UAnCTL1(x)  ((uintptr_t)UA0CTL1 + ((x) * 0x10))
#define UAnCTL2(x)  ((uintptr_t)UA0CTL2 + ((x) * 0x10))
#define UAnOPT0(x)  ((uintptr_t)UA0OPT0 + ((x) * 0x10))
#define UAnSTR(x)   ((uintptr_t)UA0STR  + ((x) * 0x10))
#define UAnRX(x)    ((uintptr_t)UA0RX   + ((x) * 0x10))
#define UAnTX(x)    ((uintptr_t)UA0TX   + ((x) * 0x10))
#define UAnRIC(x)	((uintptr_t)UA0RIC  + ((x) * 0x10))
#define UAnTIC(x)	((uintptr_t)UA0TIC  + ((x) * 0x10))

/*
 *	VAubN
 */
const SIOPINIB siopinib_table[TNUM_SIOP] =
{
	{ 80u , 79u } , 	/* UART0 */
	{ 78u , 77u } , 	/* UART1 */
	{ 96u , 95u }	 	/* UART2 */
};


/*
 *  sio_initialize -- VA|[ghCȍ
 */
void
sio_initialize(intptr_t exinf)
{
	uint_t	i;
	
	/*
	 *  VAI/O|[gǗubN̏
	 */
	for (i = 0; i < TNUM_SIOP; i++)
	{
		siopcb_table[i].p_siopinib = &(siopinib_table[i]);
		siopcb_table[i].openflag = false;
		siopcb_table[i].received = false;
	}
}

/*
 *  sio_opn_por -- |[g̃I[v
 */
SIOPCB *
sio_opn_por(ID siopid, intptr_t exinf)
{
	SIOPCB	*siopcb = get_siopcb(siopid);
	
	if(siopcb->openflag == false)
	{
		siopcb->exinf = exinf;
		siopcb->openflag = true;
		siopcb->port_id = siopid - 1;
		
		/* UARTLɂ */
		sil_wrb_mem((uint8_t *)UAnCTL0(siopcb->port_id), 0x80);	/* UART enable */
		
		/* {[[g̏ */
		sil_wrb_mem((uint8_t *)UAnCTL1(siopcb->port_id), SERIAL_CLKDIV);
		sil_wrb_mem((uint8_t *)UAnCTL2(siopcb->port_id), SERIAL_COMPAREVALUE);
		
		/* [hݒ */
		sil_wrb_mem((uint8_t *)UAnCTL0(siopcb->port_id), 
			sil_reb_mem((uint8_t *)UAnCTL0(siopcb->port_id)) | 0x12);
		
		/* M */
		sil_wrb_mem((uint8_t *)UAnCTL0(siopcb->port_id), 
			sil_reb_mem((uint8_t *)UAnCTL0(siopcb->port_id)) | 0x60);
		
		/* MݗL */
		(void)ena_int(siopcb->p_siopinib->tx_intno);
		(void)ena_int(siopcb->p_siopinib->rx_intno);
	}
	
	return siopcb;
}

/*
 *  sio_snd_chr -- M
 */
bool_t
sio_snd_chr(SIOPCB *siopcb, char_t chr)
{
	bool_t	result = false;
	
	/* M\`FbN */
	if((sil_reb_mem((uint8_t *)UAnSTR(siopcb->port_id)) & 0x80) == 0)
	{
		sil_wrb_mem((uint8_t *)UAnTX(siopcb->port_id), chr);
		result = true;
	}
	
	return result;
}

/*
 *  sio_rcv_chr -- M
 */
int_t sio_rcv_chr(SIOPCB *siopcb)
{
	int_t chr = -1;
	
	if(siopcb->received == true)
	{
		chr = (int_t)sil_reb_mem((uint8_t *)UAnRX(siopcb->port_id));
		siopcb->port_id = false;
	}
	
	return chr;
}

/*
 *  sio_ena_cbr -- VA I/O ̃R[obN̋
 */
void
sio_ena_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
		case SIO_RDY_SND:
			ena_int(siopcb->p_siopinib->tx_intno);
			break;
		case SIO_RDY_RCV:
			ena_int(siopcb->p_siopinib->rx_intno);
			break;
		default:
			assert(1);
			break;
	}
}

/*
 *  sio_dis_cbr -- VA I/O ̃R[obN̋֎~
 */
void
sio_dis_cbr(SIOPCB *siopcb, uint_t cbrtn)
{
	switch (cbrtn) {
		case SIO_RDY_SND:
			dis_int(siopcb->p_siopinib->tx_intno);
			break;
		case SIO_RDY_RCV:
			dis_int(siopcb->p_siopinib->rx_intno);
			break;
		default:
			assert(1);
			break;
	}
}

/*
 *  sio_cls_por -- |[g̃N[Y
 */
void
sio_cls_por(SIOPCB *siopcb)
{
	/* UART̒~ */
	sil_wrb_mem((uint8_t *)UAnCTL0(siopcb->port_id) , 
		(sil_reb_mem((uint8_t *)UAnCTL0(siopcb->port_id)) & ~0x80));
	
	/* ݂̋֎~ */
	dis_int(siopcb->p_siopinib->tx_intno);
	dis_int(siopcb->p_siopinib->rx_intno);
	
	/* tO̐ݒ */
	siopcb->openflag = false;
	siopcb->received = false;
}

void
sio_tx_isr(intptr_t exinf)
{
	SIOPCB	*siopcb = get_siopcb(exinf);
	if(!siopcb->openflag)
		return;
	
	/* R[obNĂяo */
	sio_irdy_snd(siopcb->exinf);
}

void
sio_rx_isr(intptr_t exinf)
{
	SIOPCB	*siopcb = get_siopcb(exinf);
	
	/* Mς݃tOZbg */
	siopcb->received = true;
	/* R[obNĂяo */
	sio_irdy_rcv(siopcb->exinf);
}

