/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 */

#ifndef TARGET_TIMER_H
#define TARGET_TIMER_H

#include <sil.h>
#include "tk_v850_jh3e.h"


#define TIMER_CLOCK ((PCLOCK/4u) / 1000)

/*
 *  ^C}݃nho^̂߂̒萔
 */
#define INHNO_TIMER 	67		/* ݃nhԍ */
#define INTNO_TIMER 	67	 	/* ݔԍ */
#define INTPRI_TIMER	(-6)	/* ݗDx */
#define INTATR_TIMER	TA_NULL	/* ݑ */


/*
 *  ^C}l̓\̌^
 */
typedef uint16_t    CLOCK;

/*
 *  ^C}l̓\ƃʕbPʂƂ̕ϊ
 *
 */
#define TO_USEC(clock)          ((((SYSUTM) clock) * 1000000U) / 0x8000)

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define MAX_CLOCK    ((CLOCK) 0x7fffU)

#ifndef TOPPERS_MACRO_ONLY
/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
extern void target_timer_initialize(intptr_t exinf);

/*
 *  ^C}̒~
 *
 *  ^C}̓~D
 */
extern void target_timer_terminate(intptr_t exinf);

/*
 *  ^C}̌ݒl̓Ǐo
 */
Inline CLOCK
target_timer_get_current(void)
{
	CLOCK count = (CLOCK)sil_reh_mem((uint16_t *)RC1SUBC);
	/* RC1SUBC0`0x7FFFA␳ꍇ0x8000ȏ̂Ƃ */
	if(count > MAX_CLOCK)
		count = MAX_CLOCK;

	return count;
}

/*
 *  ^C}ݗṽ`FbN
 */
Inline bool_t target_timer_probe_int(void)
{
	return x_probe_int(INTNO_TIMER);
}

/*
 *  ^C}݃nh
 */
extern void target_timer_handler(void);

#endif	/* TOPPERS_MACRO_ONLY */

#endif	/* TARGET_TIMER_H */
