/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: $
 */

#ifndef _TINET_TARGET_CONFIG_H_
#define _TINET_TARGET_CONFIG_H_

/*
 *  TCP/IP Ɋւ`
 */

/* TCP Ɋւ` */

/*
 *  MAX_TCP_SND_SEG: MZOgTCY̍ől
 *
 *    肩 MSS IvVŃZOgTCYw肳ĂA
 *    ̒lŁAZOgTCY𐧌łB
 */

#ifndef MAX_TCP_SND_SEG
#define MAX_TCP_SND_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))
#endif	/* of #ifndef MAX_TCP_SND_SEG */

/*
 *  DEF_TCP_RCV_SEG: MZOgTCY̋Kl
 */

#ifndef DEF_TCP_RCV_SEG
#define DEF_TCP_RCV_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))
#endif	/* of #ifndef DEF_TCP_RCV_SEG */

/* 
 *  ZOg̏ԂւƂɐVɃlbg[Nobt@ĂāA
 *  f[^Rs[TCŶl
 */
#define MAX_TCP_REALLOC_SIZE	1024	

#define TCP_CFG_OPT_MSS		/* RlNVJݎɁAZOgTCYIvVđMB*/
#define TCP_CFG_DELAY_ACK	/* ACK x点Ƃ̓RgOB			*/
#define TCP_CFG_ALWAYS_KEEP	/* ɃL[vACu鎞̓RgOB		*/

/* UDP Ɋւ` */

#define UDP_CFG_IN_CHECKSUM	/* UDP ̓̓`FbNTsꍇ̓RgOB	*/
#define UDP_CFG_OUT_CHECKSUM	/* UDP ̏o̓`FbNTsꍇ̓RgOB	*/

/* ICMPv4/v6 Ɋւ` */

#define ICMP_REPLY_ERROR		/* ICMP G[bZ[W𑗐Mꍇ̓RgOB*/

/* IPv4 Ɋւ` */

//#define IP4_CFG_FRAGMENT		/* f[^O̕Eč\sꍇ̓RgOB	*/
#define NUM_IP4_FRAG_QUEUE	2	/* f[^Oč\L[TCY			*/
#define IP4_CFG_FRAG_REASSM_SIZE	4096	/* IPv4 č\obt@TCY			*/

/* IPv6 Ɋւ` */

#define NUM_IP6_DAD_COUNT	1	/* dAhXoőMߗחv̉񐔁A		*/
					/*  0 w肷ƁAdAhXosȂB	*/
#define NUM_ND6_CACHE_ENTRY	10	/* ߗ׃LbṼGg			*/

/*
 *  IPv6 pzXgLbṼGgB
 *  0 w肷IPv6 pzXgLbVg܂ȂB
 */
#define NUM_IN6_HOSTCACHE_ENTRY	4

#ifdef SUPPORT_ETHER

#define IP6_CFG_AUTO_LINKLOCAL		/* N[JAhX̎ݒsꍇ̓RgOB*/

/*
 *  fBtHg[^XgɊւ`
 */

/*
 *  fBtHg[^Xg̃GgB
 *  ől 16A0 w肷ƃ[^ʒmMȂB
 */
#define NUM_ND6_DEF_RTR_ENTRY		4

/*
 *  vtBbNXXgɊւ`B
 *  ől 16B
 */
#define NUM_ND6_PREFIX_ENTRY		4	/*  vtBbNXXg̃Gg			*/

/*
 *  Ñ[^vo͉񐔁B
 *  0 w肷ƃ[^vo͂ȂB
 */
#define NUM_ND6_RTR_SOL_RETRY	3	

#define IP6_CFG_FRAGMENT		/* f[^O̕Eč\sꍇ̓RgOB	*/
#define NUM_IP6_FRAG_QUEUE	2	/* f[^Oč\L[TCY			*/
#define IP6_CFG_FRAG_REASSM_SIZE	4096	/* IPv6 č\obt@TCY			*/

#endif	/* of #ifdef SUPPORT_ETHER */

/*
 *  f[^Nw (lbg[NC^tF[X) Ɋւ`
 */

/*
 *  PPPAfɊւ`
 */

#define MODEM_CFG_DIAL		"ATD"	/* _CAR}h			*/
#define MODEM_CFG_RETRY_CNT	3	/* _CAgC			*/
#define MODEM_CFG_RETRY_WAIT	10000	/* _CAgC܂ł̑҂ [ms]	*/

/*
 *  PPPAHDLC Ɋւ`
 */

#define DEF_LOCAL_ACCM		ULONG_C(0x000a0000)	/*  ACCMAXON  XOFF ̂ݕϊ	*/
#define DEF_REMOTE_ACCM		ULONG_C(0xffffffff)	/*  ACCMAl͑Sĕϊ		*/

/*
 *  PPPALCP Ɋւ`
 */

#define LCP_CFG_MRU		UINT_C(0x0001)	/* MRU					*/
#define LCP_CFG_ACCM		UINT_C(0x0002)	/* ACCM					*/
#define LCP_CFG_MAGIC		UINT_C(0x0004)	/* }WbNԍ				*/
#define LCP_CFG_PCOMP		UINT_C(0x0008)	/* vgRk@\			*/
#define LCP_CFG_ACCOMP		UINT_C(0x0010)	/* AhXE䕔k			*/
#define LCP_CFG_PAP		UINT_C(0x0020)	/* PAP					*/
/*#define LCP_CFG_CHAP		UINT_C(0x0040)	   CHAP ͎\			*/

#ifdef LCP_CFG_MAGIC

#define LCP_ECHO_INTERVAL	(20*NET_TIMER_HZ)	/* C^[o		*/
#define LCP_ECHO_FAILS		9			/* s臒l			*/

#endif	/* of #ifdef LCP_CFG_MAGIC */

/*
 *  PPPAPAP Ɋւ`
 */

#define DEF_PAP_TIMEOUT		(3*NET_TIMER_HZ)
#define DEF_PAP_REQTIME		(30*NET_TIMER_HZ)	/* ^CAEgsƂ̓RgOB*/
#define MAX_PAP_REXMT		10			/* Fؗv̍őđ	*/

/*
 *  NIC (NE2000 ݊) Ɋւ`
 */

/* : 16 rbg[h͖ */
#ifdef IF_V850EC_CFG_16BIT

#define NUM_IF_V850EC_TXBUF		2	/* Mobt@			*/

#else	/* of #ifdef IF_V850EC_CFG_16BIT */

#define NUM_IF_V850EC_TXBUF		1	/* Mobt@			*/

#endif	/* of #ifdef IF_V850EC_CFG_16BIT */

#define TMO_IF_V850EC_GET_NET_BUF	1	/* [ms]AMp net_buf l^CAEg	*/
					/* [s]A M^CAEg			*/
#define TMO_IF_V850EC_XMIT		(2*IF_TIMER_HZ)

/*#define IF_V850EC_CFG_ACCEPT_ALL		 }`LXgAG[t[MƂ̓RgOB*/

/*
 *  C[Tlbgo͎ɁANIC  net_buf JꍇɎw肷B
 *
 *  : ȉ̎ẃAwłAif_v850ec ł́A
 *        JȂ̂ŁAȉ̃RgOĂ͂ȂȂB
 */

/*#define ETHER_NIC_CFG_RELEASE_NET_BUF*/

/*
 *  V850 Ethernet Controller Ɋւ`
 */

#define V850EC_BASE_ADDRESS		ULONG_C(0x00200000)	/* NIC ̃WX^x[XAhX */

#define INHNO_IF_V850EC_RX	101			/* pPbgM */
#define INTNO_IF_V850EC_RX	101			/* pPbgM */
#define INTATR_IF_V850EC_RX	(TA_NULL)	/* ݑ	*/
#define INTPRI_IF_V850EC_RX	(-1)		/* ݗDx	*/

#define INHNO_IF_V850EC_TX	102			/* pPbgM */
#define INTNO_IF_V850EC_TX	102			/* pPbgM */
#define INTATR_IF_V850EC_TX	(TA_NULL)	/* ݑ	*/
#define INTPRI_IF_V850EC_TX	(-1)		/* ݗDx	*/

/*
 *  ARP Ɋւ`
 */

#define NUM_ARP_ENTRY		10			/* ARP LbVGg	*/

/*
 *  DHCP Ɋւ`
 *
 *    E: TINET ́ADHCP ĂȂBpvOŁA
 *            DHCP bZ[WM邽߂̒`łB
 *            ܂A݂ IPv4 ̂ݗLłB
 */

/*#define DHCP_CFG					 DHCP ꍇ̓RgOB*/

/*
 *  Ethernet Ɋւ`
 */

/*#define ETHER_CFG_ACCEPT_ALL		 }`LXgAG[t[MƂ̓RgOB	*/
/*#define ETHER_CFG_UNEXP_WARNING	 T|[gt[̌x\Ƃ̓RgOB		*/
/*#define ETHER_CFG_802_WARNING		 IEEE 802.3 t[̌x\Ƃ̓RgOB		*/
/*#define ETHER_CFG_MCAST_WARNING	 }`LXǧx\Ƃ̓RgOB		*/

/*
 *  AhXXgɊւ`B
 */
#define NUM_IN6_IFADDR_ENTRY		5	/*  C^tF[X̃AhXXg̃Gg		*/

/*
 *  ėplbg[NɊւ`
 */

/*
 *  lbg[Nobt@Ɋւ`
 */

/* lbg[Nobt@ */

#ifdef SUPPORT_PPP

/*
 *  PPP ł́AMp lbg[Nobt@ PDU (1502) TCY
 *  蓖ĂȂ΂ȂȂ̂ PDU TCY𑽂߂ɊmۂB
 */

#ifndef NUM_MPF_NET_BUF_CSEG
#define NUM_MPF_NET_BUF_CSEG	2	/* IF + IP + TCPA2 ȏ*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_CSEG */

#ifndef NUM_MPF_NET_BUF_64
#define NUM_MPF_NET_BUF_64	0	/* 64 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_64 */

#ifndef NUM_MPF_NET_BUF_128
#define NUM_MPF_NET_BUF_128	0	/* 128 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_128 */

#ifndef NUM_MPF_NET_BUF_256
#define NUM_MPF_NET_BUF_256	0	/* 256 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_256 */

#ifndef NUM_MPF_NET_BUF_512
#define NUM_MPF_NET_BUF_512	0	/* 512 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_512 */

#ifndef NUM_MPF_NET_BUF_1024
#define NUM_MPF_NET_BUF_1024	0	/* 1024 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_1024 */

#ifndef NUM_MPF_NET_BUF_IF_PDU
#define NUM_MPF_NET_BUF_IF_PDU	2	/* IF ő PDU TCY	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IF_PDU */

#ifndef NUM_MPF_NET_BUF4_REASSM

#if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT)
#define NUM_MPF_NET_BUF4_REASSM	2	/* IPv4 č\obt@TCY	*/
#else
#define NUM_MPF_NET_BUF4_REASSM	0	/* IPv4 č\obt@TCY	*/
#endif

#endif	/* of #ifndef NUM_MPF_NET_BUF4_REASSM */

#ifndef NUM_MPF_NET_BUF6_REASSM

#if defined(SUPPORT_INET6) && defined(IP6_CFG_FRAGMENT)
#define NUM_MPF_NET_BUF6_REASSM	2	/* IPv6 č\obt@TCY	*/
#else
#define NUM_MPF_NET_BUF6_REASSM	0	/* IPv6 č\obt@TCY	*/
#endif

#endif	/* of #ifndef NUM_MPF_NET_BUF6_REASSM */

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_ETHER

/*
 *  C[Tlbg̏ꍇ̃lbg[Nobt@̊蓖
 */

/*
 *  !!
 *
 *  NE2000 ݊ NIC ̃fBoCXhCoiif_v850ecj̍ŒኄĒ
 *  60iAC 62jINebĝ IF + IP +TCP 
 *  64 INebg̃lbg[Nobt@̕œKłB
 */

#ifndef NUM_MPF_NET_BUF_CSEG
#define NUM_MPF_NET_BUF_CSEG	0	/* IF + IP + TCP	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_CSEG */

#ifndef NUM_MPF_NET_BUF_64
#define NUM_MPF_NET_BUF_64	2	/* 64 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_64 */

#ifndef NUM_MPF_NET_BUF_128
#define NUM_MPF_NET_BUF_128	0	/* 128 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_128 */

#ifndef NUM_MPF_NET_BUF_256
#define NUM_MPF_NET_BUF_256	0	/* 256 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_256 */

#ifndef NUM_MPF_NET_BUF_512
#define NUM_MPF_NET_BUF_512	0	/* 512 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_512 */

#if defined(SUPPORT_INET4)

#ifndef NUM_MPF_NET_BUF_IP_MSS
#define NUM_MPF_NET_BUF_IP_MSS	0	/* IF + 576 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IP_MSS */

#endif	/* of #if defined(SUPPORT_INET4) */

#ifndef NUM_MPF_NET_BUF_1024
#define NUM_MPF_NET_BUF_1024	0	/* 1024 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_1024 */

#if defined(SUPPORT_INET6)

#ifndef NUM_MPF_NET_BUF_IPV6_MMTU
#define NUM_MPF_NET_BUF_IPV6_MMTU	0	/* IF + 1280	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IPV6_MMTU */

#endif	/* of #if defined(SUPPORT_INET6) */

#ifndef NUM_MPF_NET_BUF_IF_PDU
#define NUM_MPF_NET_BUF_IF_PDU	4	/* IF ő PDU TCY	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IF_PDU */

#ifndef NUM_MPF_NET_BUF4_REASSM

#if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT)
#define NUM_MPF_NET_BUF4_REASSM	2	/* IPv4 č\obt@TCY	*/
#else
#define NUM_MPF_NET_BUF4_REASSM	0	/* IPv4 č\obt@TCY	*/
#endif

#endif	/* of #ifndef NUM_MPF_NET_BUF4_REASSM */

#ifndef NUM_MPF_NET_BUF6_REASSM

#if defined(SUPPORT_INET6) && defined(IP6_CFG_FRAGMENT)
#define NUM_MPF_NET_BUF6_REASSM	2	/* IPv6 č\obt@TCY	*/
#else
#define NUM_MPF_NET_BUF6_REASSM	0	/* IPv6 č\obt@TCY	*/
#endif

#endif	/* of #ifndef NUM_MPF_NET_BUF6_REASSM */

#endif	/* of #ifdef SUPPORT_ETHER */

#ifdef SUPPORT_LOOP

#ifndef NUM_MPF_NET_BUF_CSEG
#define NUM_MPF_NET_BUF_CSEG	2	/* IF + IP + TCP	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_CSEG */

#ifndef NUM_MPF_NET_BUF_64
#define NUM_MPF_NET_BUF_64	0	/* 64 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_64 */

#ifndef NUM_MPF_NET_BUF_128
#define NUM_MPF_NET_BUF_128	0	/* 128 INebgA2 ȏ	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_128 */

#ifndef NUM_MPF_NET_BUF_256
#define NUM_MPF_NET_BUF_256	0	/* 256 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_256 */

#ifndef NUM_MPF_NET_BUF_512
#define NUM_MPF_NET_BUF_512	0	/* 512 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_512 */

#ifndef NUM_MPF_NET_BUF_1024
#define NUM_MPF_NET_BUF_1024	0	/* 1024 INebg	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_1024 */

#ifndef NUM_MPF_NET_BUF_IF_PDU
#define NUM_MPF_NET_BUF_IF_PDU	4	/* IF ő PDU TCY	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IF_PDU */

#endif	/* of #ifdef SUPPORT_PPP */

/*
 *  lbg[Nv̌v
 *
 *  lbg[Nv̌vsꍇ́Atinet/include/net/net.h
 *  Œ`ĂvgRʃtOw肷B
 */

#if 1

#ifdef SUPPORT_INET4

#define NET_COUNT_ENABLE	(0			\
				| PROTO_FLG_PPP_HDLC	\
				| PROTO_FLG_PPP_PAP	\
				| PROTO_FLG_PPP_LCP	\
				| PROTO_FLG_PPP_IPCP	\
				| PROTO_FLG_PPP		\
				| PROTO_FLG_LOOP	\
				| PROTO_FLG_ETHER_NIC	\
				| PROTO_FLG_ETHER	\
				| PROTO_FLG_ARP		\
				| PROTO_FLG_IP4		\
				| PROTO_FLG_ICMP4	\
				| PROTO_FLG_UDP		\
				| PROTO_FLG_TCP		\
				| PROTO_FLG_NET_BUF	\
				)

#endif	/* of #ifdef SUPPORT_INET4 */

#ifdef SUPPORT_INET6

#define NET_COUNT_ENABLE	(0			\
				| PROTO_FLG_PPP_HDLC	\
				| PROTO_FLG_PPP_PAP	\
				| PROTO_FLG_PPP_LCP	\
				| PROTO_FLG_PPP_IPCP	\
				| PROTO_FLG_PPP		\
				| PROTO_FLG_LOOP	\
				| PROTO_FLG_ETHER_NIC	\
				| PROTO_FLG_ETHER	\
				| PROTO_FLG_IP6		\
				| PROTO_FLG_ICMP6	\
				| PROTO_FLG_ND6		\
				| PROTO_FLG_UDP		\
				| PROTO_FLG_TCP		\
				| PROTO_FLG_NET_BUF	\
				)

#endif	/* of #ifdef SUPPORT_INET6 */

#else	/* of #if 0 */

#define NET_COUNT_ENABLE	(0			\
				)

#endif	/* of #if 0 */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ֐
 */

extern void v850ec_bus_init (void);
extern void v850ec_inter_init (void);

#endif	/* of #ifndef TOPPERS_MACRO_ONLY */

#endif /* _TINET_TARGET_CONFIG_H_ */
