/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ppp_ipcp.c,v 1.5 2009/12/24 05:42:40 abe Exp abe $
 */

/*
 * ipcp.c - PPP IP Control Protocol.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 *	PPP IP Control Protocol (IPCP) Module
 *
 *	    Written by Toshiharu OHNO (tony-o@iij.ad.jp)
 *
 *   Copyright (C) 1993, Internet Initiative Japan, Inc. All rights reserverd.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the Internet Initiative Japan, Inc.  The name of the
 * IIJ may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $FreeBSD: src/usr.sbin/ppp/ipcp.c,v 1.90.2.4 2000/08/19 09:30:03 brian Exp $
 *
 *	TODO:
 *		o Support IPADDRS properly
 *		o Validate the length in IpcpDecodeConfig
 */

#include <string.h>

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/net.h>
#include <net/net_buf.h>
#include <net/net_count.h>
#include <net/ppp.h>
#include <net/ppp_var.h>
#include <net/ppp_fsm.h>
#include <net/ppp_lcp.h>
#include <net/ppp_ipcp.h>
#include <net/ppp_modem.h>

#include <netinet/in.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/udp_var.h>

#include <net/if_var.h>

#ifdef SUPPORT_PPP

/*
 *  ֐
 */

static void ipcp_init (void);
static void ipcp_input (T_NET_BUF *input);
static void ipcp_protrej (void);
static void ipcp_lowerup (void);
static void ipcp_lowerdown (void);
static void ipcp_open (void);
static void ipcp_close (void);

/*
 * FSM ďoR[obN
 */

static void  ipcp_resetci(T_PPP_FSM *fsm);	/* \ZbgB	*/
static int_t ipcp_cilen	(T_PPP_FSM *fsm);	/* \̒ԂB		*/
static void  ipcp_addci	(T_PPP_FSM *fsm, T_NET_BUF *output);
						/* \ǉB		*/
static bool_t  ipcp_ackci	(T_PPP_FSM *fsm, T_NET_BUF *input);
						/* ACK MƂ̏	*/
static bool_t  ipcp_nakci	(T_PPP_FSM *fsm, T_NET_BUF *input);
						/* NAK MƂ̏	*/
static bool_t  ipcp_rejci	(T_PPP_FSM *fsm, T_NET_BUF *input);
						/* REJ MƂ̏	*/
static int_t ipcp_reqci	(T_PPP_FSM *fsm, T_NET_BUF *input, T_NET_BUF *output);
						/* ̍\mFB	*/
static void ipcp_up	(T_PPP_FSM *fsm);	/* NڑmB		*/
static void ipcp_down	(T_PPP_FSM *fsm);	/* NڑB		*/
static void ipcp_finished(T_PPP_FSM *fsm);	/* ʑwIB		*/

/*
 *  ϐ
 */

static T_IFNET ipcp_local_def_cfg = {		/* \̋Kl		*/
	NULL,
	{
		IPV4_ADDR_LOCAL,		/* IP AhX			*/
		UINT_C(0),			/* Tulbg}XN		*/
	},
};

static T_IFNET ipcp_remote_def_cfg = {		/* ̍\̋Kl	*/
	NULL,
	{
		IPV4_ADDR_REMOTE,		/* IP AhX			*/
		UINT_C(0),			/* Tulbg}XN		*/
	}
};

static T_IFNET ipcp_local_neg_cfg;		/* lS̎\		*/

static T_IFNET ipcp_remote_neg_cfg;		/* lS̑̍\		*/

/*
 *  Sϐ
 */

T_PPP_FSM_CALLBACKS ipcp_callbacks = {
	ipcp_resetci,			/* \ZbgB	*/
	ipcp_cilen,			/* \̒ԂB		*/
	ipcp_addci,			/* \ǉB		*/
	ipcp_ackci,			/* ACK MƂ̏	*/
	ipcp_nakci,			/* NAK MƂ̏	*/
	ipcp_rejci,			/* REJ MƂ̏	*/
	ipcp_reqci,			/* ̍\mFB	*/
	ipcp_up,			/* NڑmB		*/
	ipcp_down,			/* NڑB		*/
	NULL,				/* ʑwJnB		*/
	ipcp_finished,			/* ʑwIB		*/
	NULL,				/* đB			*/
	NULL,				/* s CP MƂ̏	*/
};

T_PPP_FSM ipcp_fsm = {
	&ipcp_callbacks,		/* R[obN֐		*/
	PPP_IPCP,			/* vgR			*/
};

T_PPP_PROTENT ipcp_protent = {
	PPP_IPCP,
	ipcp_init,			/* 			*/
	ipcp_input,			/* 				*/
	ipcp_protrej,			/* Proto-REJ M		*/
	ipcp_lowerup,			/* ʑwN		*/
	ipcp_lowerdown,			/* ʑw~		*/
	ipcp_open,			/* I[v			*/
	ipcp_close,			/* N[Y			*/
	ip_input,			/* f[^́AIP 		*/
};

T_IFNET ipcp_local_ack_cfg;		/* ɋꂽ̎\	*/
T_IFNET ipcp_remote_ack_cfg;		/* ɋ\	*/

/*
 *  ppp_get_ifnet -- lbg[NC^tF[X\̂ԂB
 */

T_IFNET *
ppp_get_ifnet (void)
{
	return &ipcp_local_ack_cfg;
}

/*
 *  wait_ipcp -- IP ڑ܂ő҂B
 *
 *	߂l: ڑɎs E_OBJ ԂB
 */

ER
wait_ipcp (void)
{
#ifdef PPP_CFG_MODEM
	ER error;
#endif	/* of #ifdef PPP_CFG_MODEM */

	if (ipcp_fsm.state <= PPP_FSM_STOPPED) {

#ifdef PPP_CFG_MODEM

		/* f̐ڑ܂ő҂B*/
		if ((error = wait_modem()) != E_OK)
			return error;

#else	/* of #ifdef PPP_CFG_MODEM */

		/*
		 * 󓮃I[vA肩̐ڑ҂Ȃ LCP xN[YA
		 * \I[vԂŁAăI[vB
		 */
		lcp_close();
		lcp_open(PPP_OPEN_ACTIVE);

#endif	/* of #ifdef PPP_CFG_MODEM */

	}

	if (ipcp_fsm.state != PPP_FSM_OPENED) {
		/* IP ڑ܂ő҂B*/
		wai_sem(SEM_IPCP_READY);
		if (ipcp_fsm.state != PPP_FSM_OPENED)
			return E_OBJ;
	}

	return E_OK;
}

/*
 *  ipcp_init -- IPCP W[̏
 */

static void
ipcp_init (void)
{
	fsm_init(&ipcp_fsm);
}

/*
 *  ipcp_input -- IPCP 
 */

static void
ipcp_input (T_NET_BUF *input)
{
	NET_COUNT_PPP_IPCP(net_count_ppp_ipcp_in_octets,  input->len);
	NET_COUNT_PPP_IPCP(net_count_ppp_ipcp_in_packets, 1);
	fsm_input(&ipcp_fsm, input);
}

/*
 *  ipcp_resetci -- IPCP̍\ZbgB
 */

static void
ipcp_resetci (T_PPP_FSM *fsm)
{
	/* \̏ݒ */
	ipcp_local_neg_cfg = ipcp_local_def_cfg;
	memset((void*)&ipcp_local_ack_cfg, 0, sizeof(T_IFNET));

	/* ̍\̏ݒ */
	ipcp_remote_neg_cfg = ipcp_remote_def_cfg;
	memset((void*)&ipcp_remote_ack_cfg, 0, sizeof(T_IFNET));
}

/*
 *  ipcp_cilen -- \̒ԂB
 */

static int_t
ipcp_cilen (T_PPP_FSM *fsm)
{
	int_t cilen = 0;

	cilen += sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);	/* IP AhX */

	return cilen;
}

/*
 *  ipcp_addci -- IPCP̍\ǉB
 */

static void
ipcp_addci (T_PPP_FSM *fsm, T_NET_BUF *output)
{
	uint8_t *buf;

	buf = output->buf + sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);

	/* IP AhXIvVǉB */
	*buf ++ = IPCP_CIT_ADDR;
	*buf ++ = sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
	ahtonl(buf, ipcp_local_neg_cfg.in_ifaddr.addr);
	buf += sizeof(uint32_t);
}

/*
 *  ipcp_ackci -- ACK MƂ̏
 *
 *	߂l:	true  ACK ͐
 *		false ACK ُ͈
 */

static bool_t
ipcp_ackci (T_PPP_FSM *fsm, T_NET_BUF *input)
{
	uint8_t		*buf;
	uint16_t	len;

	buf = input->buf +  sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
	len = input->len - (sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));

	/*
	 *  \͑MɊSɈvȂ΂ȂȂB
	 *  ]āAipcp_addci ō쐬ɉ͂B
	 */

	/* ADDR IvV͂B */
	if (len < sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)	||
	    *buf ++ != IPCP_CIT_ADDR			||
	    *buf ++ != sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)||
	    nahcmpl(buf, ipcp_local_neg_cfg.in_ifaddr.addr))
		return false;
	buf += sizeof(uint32_t);
	len -= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);

	return true;
}

/*
 *  ipcp_nakci -- NAK MƂ̏
 *
 *	߂l:	1  NAK ͐
 *		0  NAK ُ͈
 */

static int_t
ipcp_nakci (T_PPP_FSM *fsm, T_NET_BUF *input)
{
	T_IFNET		new_cfg;
	uint32_t	cilong;
	uint16_t	len;
	uint8_t		*buf, cilen;

	buf = input->buf +  sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
	len = input->len - (sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));

	new_cfg = ipcp_local_neg_cfg;

	/* ADDR IvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)		&&
	    * buf      == IPCP_CIT_ADDR				&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)) {
	    	ntoahl(cilong, buf + 2);
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		new_cfg.in_ifaddr.addr = cilong;
	}

	/* ͖B*/
	while (len > sizeof(T_PPP_CI_HDR)) {
		cilen = *(buf + 1);
		if (len < cilen)
			return 0;
		buf += cilen;
		len -= cilen;
	}

	/*  0 łȂ΃G[ */
	if (len != 0)
		return 0;

	/* VIvVݒ肷B*/
	if (fsm->state != PPP_FSM_OPENED)
		ipcp_local_neg_cfg = new_cfg;
               		
	return 1;
}

/*
 *  ipcp_rejci -- REJ MƂ̏
 *
 *	߂l:	1  REJ ͐
 *		0  REJ ُ͈
 */

static int_t
ipcp_rejci (T_PPP_FSM *fsm, T_NET_BUF *input)
{
	T_IFNET		new_cfg;
	uint8_t		*buf;
	uint16_t	len;

	buf = input->buf +  sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
	len = input->len - (sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));

	new_cfg = ipcp_local_neg_cfg;

	/* ADDR IvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)		&&
	    * buf      == IPCP_CIT_ADDR				&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)) {
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		new_cfg.in_ifaddr.addr = 0;
	}

	/*  0 łȂ΃G[ */
	if (len != 0)
		return 0;

	/* VIvVݒ肷B*/
	if (fsm->state != PPP_FSM_OPENED)
		ipcp_local_neg_cfg = new_cfg;

	return 1;
}

/*
 *  ipcp_reqci -- ̍\͂B
 */

static int_t
ipcp_reqci (T_PPP_FSM *fsm, T_NET_BUF *input, T_NET_BUF *output)
{
	uint32_t	addr;
	uint16_t	code, final, len, cilen;
	uint8_t		*np, *rp, *ap, *cp, type = 0;

	rp = ap = input->buf +  sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
				/* rp: REJAap: ACK  CI ̃|C^	*/
				/* ۂꍇ́A buf ɏ㏑B	*/
	len   = input->len - (sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));
	np    = output->buf + sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
	final = PPP_CONFACK;	/* ŏIIɑMR[h */
	while (len > 0) {
		code = PPP_CONFACK;
		cp   = ap;	/* cp: ݏ CI	*/

		if (len < sizeof(T_PPP_CI_HDR)) {

			/* c肪 CI wb_Z */
			syslog(LOG_NOTICE, "[PPP/IPCP] bad CI len: %d.", len);
			cilen = len;	/* f[^ُ̏ꍇ̏u	*/
			len  = 0;	/* [v甲B		*/
			code  = PPP_CONFREJ;
			goto endswitch;
		}

		type  = *ap ++;	/* CI ̌^		*/
		cilen = *ap ++;	/* CI ̒		*/
		if (len < cilen) {

			/* c肪 CI Z */
			syslog(LOG_NOTICE, "[PPP/IPCP] bad CI len: %d.", cilen);
			cilen = len;	/* f[^ُ̏ꍇ̏u	*/
			len  = 0;	/* [v甲B		*/
			code  = PPP_CONFREJ;
			goto endswitch;
		}
		len -= sizeof(T_PPP_CI_HDR);

		/* CI ̌^ɂ蕪򂷂B*/
		switch (type) {

		case IPCP_CIT_ADDR:	/* IP AhX */

		 	/* CI Awb_ + 4 INebgłȂ΃G[ */
		 	if (cilen != sizeof(T_PPP_CI_HDR) + sizeof(uint32_t))
				code = PPP_CONFREJ;
			else {
				ntoahl(addr, ap);
				if (addr != ipcp_remote_neg_cfg.in_ifaddr.addr &&
				    (addr == 0 || ipcp_remote_neg_cfg.in_ifaddr.addr != 0)) {
					*np ++ = IPCP_CIT_ADDR;
					*np ++ = sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
					ahtonl(np, ipcp_remote_neg_cfg.in_ifaddr.addr);
					np  += sizeof(uint32_t);
					code = PPP_CONFNAK;
				}
#if 1	/* vmF */
				else if (addr == 0 && ipcp_remote_neg_cfg.in_ifaddr.addr == 0)
#else
				else if (addr == 0 || ipcp_remote_neg_cfg.in_ifaddr.addr == 0)
#endif
					code = PPP_CONFREJ;
				else
					ipcp_remote_neg_cfg.in_ifaddr.addr = addr;
			}
			break;

		default:
			syslog(LOG_INFO, "[PPP/IPCP] unexp opt: %d.", type);
			code = PPP_CONFREJ;
			break;
		}
endswitch:

		if (code == PPP_CONFNAK) {
			/* CI ̌^ Magic Number ̏ꍇāANAK ̉񐔂	*/
			/* ől MAX_PPP_FAILURES  𒴂狑ۂB	*/
			if (fsm->failures >= MAX_PPP_FAILURES)
				code = PPP_CONFREJ;
			else if (final != PPP_CONFREJ)
				final = PPP_CONFNAK;
		}

		/*  CI ۂ */
		if (code == PPP_CONFREJ) {
			if (rp < cp)		/* Oɋl߂B*/
				memcpy(rp, cp, cilen);
			rp += cilen;
			final = PPP_CONFREJ;
		}

		ap   += cilen - sizeof(T_PPP_CI_HDR);
		len  -= cilen - sizeof(T_PPP_CI_HDR);
	}

	/* ŏIIȒ𒲐B*/
	switch (final) {
	case PPP_CONFNAK:
		output->len = np - output->buf;
		memcpy(output->buf, input->buf, sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));
		break;
	case PPP_CONFREJ:
		memcpy(output->buf, input->buf, output->len = rp - input->buf);
		break;
	case PPP_CONFACK:
		memcpy(output->buf, input->buf, input->len);
		break;
	}

	return final;
}

/*
 *  ipcp_up -- NڑmB
 */

static void
ipcp_up (T_PPP_FSM *fsm)
{
	/* \̏ݒ */
	ipcp_local_ack_cfg = ipcp_local_neg_cfg;

	/*
	 *  Tulbg}XN
	 *  [JEu[hLXg IP AhXݒ肷B
	 */
	ipcp_local_ack_cfg.in_ifaddr.mask = MAKE_IPV4_LOCAL_MASK(ipcp_local_neg_cfg.in_ifaddr.addr);

	/* ̍\̏ݒ */
	ipcp_remote_ack_cfg = ipcp_remote_neg_cfg;

	/*
	 *  Tulbg}XN
	 *  [JEu[hLXg IP AhXݒ肷B
	 */
	ipcp_remote_ack_cfg.in_ifaddr.mask = MAKE_IPV4_LOCAL_MASK(ipcp_remote_neg_cfg.in_ifaddr.addr);

	sig_sem(SEM_IPCP_READY);

	syslog(LOG_NOTICE, "[PPP/IPCP] up, Local IP Addr: %s, Remote IP Addr: %s.",
	                   ip2str(NULL, &ipcp_local_neg_cfg.in_ifaddr.addr),
	                   ip2str(NULL, &ipcp_remote_neg_cfg.in_ifaddr.addr));
}

/*
 *  ipcp_down -- NڑB
 */

static void
ipcp_down (T_PPP_FSM *fsm)
{
	sig_sem(SEM_IPCP_READY);
	syslog(LOG_NOTICE, "[PPP/IPCP] down.");
}

/*
 *  ipcp_finished -- ʑwIB
 */

static void
ipcp_finished (T_PPP_FSM *fsm)
{
}

/*
 *  ipcp_protrej -- Proto-REJ MƂ̏
 */

static void
ipcp_protrej (void)
{
	fsm_lowerdown(&ipcp_fsm);
}

/*
 *  ipcp_lowerup -- IPCP ʑwNB
 */

static void
ipcp_lowerup (void)
{
	fsm_lowerup(&ipcp_fsm);
}

/*
 *  ipcp_lowerdown -- IPCP ʑw~B
 */

static void
ipcp_lowerdown (void)
{
	fsm_lowerdown(&ipcp_fsm);
}

/*
 *  ipcp_open -- IPCP ̃I[v
 */

static void
ipcp_open (void)
{
	fsm_open(&ipcp_fsm);
}

/*
 *  ipcp_close -- IPCP ̃N[Y
 */

static void
ipcp_close (void)
{
	fsm_close(&ipcp_fsm);
}

#endif	/* fo #ifdef SUPPORT_PPP */
