/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ip6.h,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*	$FreeBSD: src/sys/netinet/ip6.h,v 1.2.2.2 2001/07/03 11:01:46 ume Exp $	*/
/*	$KAME: ip6.h,v 1.18 2001/03/29 05:34:30 itojun Exp $	*/

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)ip.h	8.1 (Berkeley) 6/10/93
 */
 
#ifndef _IP6_H_
#define _IP6_H_

#ifdef SUPPORT_INET6

/*
 *  IPv6 ̒`ARFC2460 Q
 */

#define IPV6_VERSION	6

/*
 *  IPv6 wb_̒`
 */

typedef struct t_ip6_hdr {
	uint32_t	vcf;		/* Version:        4 bit		*/
					/* Traffic Class:  8 bit		*/
					/* Flow Label:    20 bit		*/
	uint16_t	plen;		/* Payload Length			*/
	uint8_t		next;		/* Next Header				*/
	uint8_t		hlim;		/* Hop Limit				*/
	T_IN6_ADDR 	src;		/* Source Address			*/
	T_IN6_ADDR 	dst;		/* Destination Address			*/
} T_IP6_HDR;

#define IP6_HDR_SIZE		(sizeof(T_IP6_HDR))

/*
 *  IPv6 wb_\̃oANZX}N
 */

#define IP6_MAKE_VCF(v,cf)	(((uint32_t)(v)<<28)|(cf))
#define IP6_VCF_V(vcf)		((uint32_t)(vcf)>>28)
#define IP6_VCF_C(vcf)		(((uint32_t)(vcf)>>20)&ULONG_C(0xff))
#define IP6_VCF_F(vcf)		((uint32_t)(vcf)&ULONG_C(0x000fffff))
#define IP6_VCF_CF(vcf)		((uint32_t)(vcf)&ULONG_C(0x0fffffff))

/*
 *  gwb_
 */

typedef struct t_ip6_ext_hdr {
	uint8_t		next;		/* Next Header			*/
	uint8_t		len;		/* 8 INebgPʂ̒	*/
} T_IP6_EXT_HDR;

/*
 *  p_ (Hop-by-Hop) IvVwb_
 */

typedef struct t_ip6_hbh_hdr {
	uint8_t		next;		/* Next Header			*/
	uint8_t		len;		/* 8 INebgPʂ̒BA
					 * ̃IvVwb_Ŝ̃INebg
					 * 8 Ŋl - 1 B
					 */
} T_IP6_HBH_HDR;

/*
 *  I_ (Destination) IvVwb_
 */

typedef struct t_ip6_dest_hdr {
	uint8_t		next;		/* Next Header			*/
	uint8_t		len;		/* 8 INebgPʂ̒BA
					 * ̃IvVwb_Ŝ̃INebg
					 * 8 Ŋl - 1 B
					 */
} T_IP6_DEST_HDR;

/* p_ (Hop-by-Hop) IvV */

#define IP6OPT_PAD1		UINT_C(0x00)	/* 00 0 00000 */
#define IP6OPT_PADN		UINT_C(0x01)	/* 00 0 00001 */
#define IP6OPT_JUMBO		UINT_C(0xc2)	/* 11 0 00010 */
#define IP6OPT_NSAP_ADDR	UINT_C(0xc3)	/* 11 0 00011 */
#define IP6OPT_TUNNEL_LIMIT	UINT_C(0x04)	/* 00 0 00100 */
#define IP6OPT_RTR_ALERT	UINT_C(0x05)	/* 00 0 00101 */

#define IP6OPT_MINLEN		2	/* IvV̍ŒZ		*/

/* m̃IvV̏̎w */

#define IP6OPT_TYPE_SKIP	UINT_C(0x00)	/* B			*/
#define IP6OPT_TYPE_DISCARD	UINT_C(0x40)	/* f[^OjB	*/
#define IP6OPT_TYPE_FORCEICMP	UINT_C(0x80)	/* jāAICMP ԑB	*/
#define IP6OPT_TYPE_ICMP	UINT_C(0xc0)
		/* jāA}`LXgłȂ ICMP ԑB	*/

#define IP6OPT_TYPE(o)		((o)&UINT_C(0xc0))

/*
 *  oHwb_
 */

typedef struct t_ip6_rt_hdr {
	uint8_t		next;		/* Next Header			*/
	uint8_t		len;		/* 8 INebgPʂ̒BA
					 * ̃IvVwb_Ŝ̃INebg
					 * 8 Ŋl - 1 B
					 */
	uint8_t		type;		/* oH^Cv		*/
	uint8_t		segleft;	/* ZOg̎c		*/
} T_IP6_RT_HDR;

/*
 *  ^Cv 0 oHwb_
 */

typedef struct t_ip6_rt0_hdr {
	uint8_t		next;		/* Next Header			*/
	uint8_t		len;		/* 8 INebgPʂ̒BA
					 * ̃IvVwb_Ŝ̃INebg
					 * 8 Ŋl - 1 B
					 */
	uint8_t		type;		/* oH^Cv		*/
	uint8_t		segleft;	/* ZOg̎c		*/
	uint32_t	reserved;	/* \				*/
} T_IP6_RT0_HDR;

/*
 *  fЃwb_
 */

typedef struct t_ip6_frag_hdr {
	uint8_t		next;		/* Next Header			*/
	uint8_t		reserved;
	uint16_t	off_flag;	/* ItZbgƃtO		*/
	uint32_t	ident;		/* ʎq			*/
} T_IP6_FRAG_HDR;

/* fЃwb_̃ItZbgƃtO */

#ifdef SIL_ENDIAN

#if SIL_ENDIAN == SIL_ENDIAN_BIG

#define IP6F_OFF_MASK		UINT_C(0xfff8)		/* ItZbgo}XN	*/
#define IP6F_RESERVED_MASK	UINT_C(0x0006)		/* \o}XN		*/
#define IP6F_MORE_FRAG		UINT_C(0x0001)		/* ԃtOg		*/

#elif SIL_ENDIAN == SIL_ENDIAN_LITTLE

#define IP6F_OFF_MASK		UINT_C(0xf8ff)		/* ItZbgo}XN	*/
#define IP6F_RESERVED_MASK	UINT_C(0x0600)		/* \o}XN		*/
#define IP6F_MORE_FRAG		UINT_C(0x0100)		/* ԃtOg		*/

#endif	/* #if SIL_ENDIAN == SIL_ENDIAN_BIG */

#endif	/* of #ifdef SIL_ENDIAN */

/*
 *  l
 */

#define IPV6_MAXHLIM	UINT_C(255)	/* zbv~bg̍ől				*/
#define IPV6_DEFHLIM	UINT_C(64)	/* zbv~bg̋Kl				*/
#define IPV6_FRAGTTL	UINT_C(60)	/* ꂽf[^O̐ԁibj	*/
#define IPV6_MMTU	UINT_C(1280)	/* ŏ MTUByC[h (1024) + wb_ (256)	*/
#define IPV6_MAXPACKET	UINT_C(65535)	/* W{yC[hőpPbgTCY	*/

/*
 *  IPv4  IPv6 RpCɑI邽߂̃}N
 */

/*
 *  zbv~bg̋KĺA[^ʒmɂύX邱Ƃ
 */

#if NUM_ND6_DEF_RTR_ENTRY > 0

/* [^ʒmMꍇ́Aʒmꂽl */

#define IP_DEFTTL	ip6_defhlim

#else	/* #if NUM_ND6_DEF_RTR_ENTRY > 0 */

/* [^ʒmMȂꍇ̒l͊l */

#define IP_DEFTTL	IPV6_DEFHLIM

#endif	/* #if NUM_ND6_DEF_RTR_ENTRY > 0 */

#define IP_HDR_SIZE	IP6_HDR_SIZE
#define T_IP_HDR	T_IP6_HDR

#endif	/* of #ifdef SUPPORT_INET6 */

#endif	/* of #ifndef _IP6_H_ */
