/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tcp_output.c,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*
 * Copyright (c) 1982, 1986, 1988, 1990, 1993, 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tcp_output.c	8.4 (Berkeley) 5/24/95
 * $FreeBSD: src/sys/netinet/tcp_output.c,v 1.32.2.2 1999/08/29 16:29:55 peter Exp $
 */

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>
#include "kernel_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>
#include <net/net.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet6/in6.h>
#include <netinet/in_var.h>
#include <netinet/in_itron.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet6/in6_var.h>
#include <netinet/ip6.h>
#include <netinet6/ip6_var.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/tcp_fsm.h>
#include <netinet/tcp_seq.h>

#ifdef SUPPORT_TCP

/*
 *  ֐
 */

static ER send_segment (bool_t *sendalot, T_TCP_CEP *cep, uint_t doff, uint_t win, uint_t len, uint8_t flags);
static void tcp_output (T_TCP_CEP *cep);

/*
 *  ϐ
 */

/* õ͎tO FSM ԂɂI邽߂̕\ */

const static uint8_t tcp_outflags[] = {
	TCP_FLG_RST | TCP_FLG_ACK,	/*  0, N[Y				*/
	0,				/*  1, 󓮃I[v			*/
	TCP_FLG_SYN,			/*  2, \I[vASYN Mς	*/
	TCP_FLG_SYN | TCP_FLG_ACK,	/*  3, SYM MASYN Mς	*/
	TCP_FLG_ACK,			/*  4, RlNVJ݊		*/
	TCP_FLG_ACK,			/*  5, FIN MAN[Y҂		*/
	TCP_FLG_FIN | TCP_FLG_ACK,	/*  6, IāAFIN Mς		*/
	TCP_FLG_FIN | TCP_FLG_ACK,	/*  7, IAFIN ς݁AACK ҂	*/
	TCP_FLG_FIN | TCP_FLG_ACK,	/*  8, FIN MAIAACK ҂		*/
	TCP_FLG_ACK,			/*  9, IAFIN `BmFMAFIN҂	*/
	TCP_FLG_ACK,			/* 10, IAԑ҂			*/
};

/*
 *  send_segment -- TCP o͏
 */

static ER
send_segment (bool_t *sendalot, T_TCP_CEP *cep, uint_t doff, uint_t win, uint_t len, uint8_t flags)
{
	T_NET_BUF	*output;
	T_TCP_HDR	*tcph;
	uint_t		optlen;
	ER		error;

#ifdef TCP_CFG_OPT_MSS

	uint8_t		*optp;

	if (flags & TCP_FLG_SYN)
		optlen = TCP_OPT_LEN_MAXSEG;
	else
		optlen = 0;

#else/* of #ifdef TCP_CFG_OPT_MSS */

	optlen = 0;

#endif/* of #ifdef TCP_CFG_OPT_MSS */

	NET_COUNT_TCP(net_count_tcp[NC_TCP_SEND_SEGS], 1);
	NET_COUNT_MIB(tcp_stats.tcpOutSegs, 1);

	/*
	 *  ZOgA̍őMZOgɒB
	 *  AĂꍇ́AőMB
	 *  ̂߁AFIN rbgNAB
	 *
	 *  IWił́At_maxopd 𐧌ɂĂ邪A
	 *  {ł́A̍őMZOgɂB
	 */
	if (len + optlen > cep->maxseg) {
		flags &= ~TCP_FLG_FIN;
		len = cep->maxseg - optlen;
		*sendalot = true;
	}

	/*
	 *  Mobt@ɂȂƂ PUSH tOݒ肷B
	 */
	if (len && doff + len >= cep->swbuf_count)
		flags |= TCP_FLG_PUSH;

#if defined(TCP_CFG_SWBUF_CSAVE_ONLY)
		
	if (len > 0 && ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_SEND_READY ||
	                (cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_SENT)) {

		/*
		 *  MEChobt@JȂ悤ɂāA
		 *  lbg[Nobt@o͂ɈڂB
		 */
		cep->swbufq->flags |= NB_FLG_NOREL_IFOUT;
		output = cep->swbufq; 
	}
	else {

		/*
		 *  ACK ԂŁÅ֐Ăяo邱ƂB
		 *  ̎́Alen  0 ɂāApB
		 */
		len = 0;
		if ((error = tcp_get_segment(&output, cep, optlen,
	                                    len, (uint_t)(net_buf_max_siz() - IF_IP_TCP_HDR_SIZE),
	                                    NBA_SEARCH_ASCENT, TMO_TCP_GET_NET_BUF)) != E_OK) {
			if (cep->timer[TCP_TIM_REXMT] == 0)
				cep->timer[TCP_TIM_REXMT] = cep->rxtcur;
			goto err_ret;
		}
	}

#elif defined(TCP_CFG_SWBUF_CSAVE)	/* of #if defined(TCP_CFG_SWBUF_CSAVE_ONLY) */

	if (IS_PTR_DEFINED(cep->sbuf)) {
		if ((error = tcp_get_segment(&output, cep, optlen,
		                             len, (uint_t)(net_buf_max_siz() - IF_IP_TCP_HDR_SIZE),
		                             NBA_SEARCH_ASCENT, TMO_TCP_GET_NET_BUF)) != E_OK) {
			if (cep->timer[TCP_TIM_REXMT] == 0)
				cep->timer[TCP_TIM_REXMT] = cep->rxtcur;
			goto err_ret;
		}
	}
	else if (len > 0 && ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_SEND_READY ||
	                     (cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_SENT)) {

		/*
		 *  MEChobt@JȂ悤ɂāA
		 *  lbg[Nobt@o͂ɈڂB
		 */
		cep->swbufq->flags |= NB_FLG_NOREL_IFOUT;
		output = cep->swbufq; 
	}
	else {

		/*
		 *  ACK ԂŁÅ֐Ăяo邱ƂB
		 *  ̎́Alen  0 ɂāApB
		 */
		len = 0;
		if ((error = tcp_get_segment(&output, cep, optlen,
	                                    len, (uint_t)(net_buf_max_siz() - IF_IP_TCP_HDR_SIZE),
	                                    NBA_SEARCH_ASCENT, TMO_TCP_GET_NET_BUF)) != E_OK) {
			if (cep->timer[TCP_TIM_REXMT] == 0)
				cep->timer[TCP_TIM_REXMT] = cep->rxtcur;
			goto err_ret;
		}
	}

#else	/* of #if defined(TCP_CFG_SWBUF_CSAVE_ONLY) */

	if ((error = tcp_get_segment(&output, cep, optlen,
	                             len, (uint_t)(net_buf_max_siz() - IF_IP_TCP_HDR_SIZE),
	                             NBA_SEARCH_ASCENT, TMO_TCP_GET_NET_BUF)) != E_OK) {
		if (cep->timer[TCP_TIM_REXMT] == 0)
			cep->timer[TCP_TIM_REXMT] = cep->rxtcur;
		goto err_ret;
	}

#endif	/* of #if defined(TCP_CFG_SWBUF_CSAVE_ONLY) */

	/*
	 *  TCP IvV̐ݒsB
	 *  {ł́AőZOgTCŶݐݒ肷B
	 */
	if (flags & TCP_FLG_SYN) {
		cep->snd_nxt = cep->iss;

#ifdef TCP_CFG_OPT_MSS

		optp = GET_TCP_OPT(output, IF_IP_TCP_HDR_OFFSET);
		*optp ++ = TCP_OPT_MAXSEG;
		*optp ++ = TCP_OPT_LEN_MAXSEG;
		*(uint16_t*)optp = htons(DEF_TCP_RCV_SEG);

#endif/* of #ifdef TCP_CFG_OPT_MSS */

	}

	/* TCP SDU ɑMf[^Rs[B*/

	if (len > 0) {
		if (SEQ_LT(cep->snd_nxt, cep->snd_max)) {
			NET_COUNT_TCP(net_count_tcp[NC_TCP_SEND_REXMIT_SEGS], 1);
			NET_COUNT_MIB(tcp_stats.tcpRetransSegs, 1);
		}
		TCP_READ_SWBUF(cep, output, len, doff);
	}
	else {
		if (cep->flags & TCP_CEP_FLG_ACK_NOW)
			NET_COUNT_TCP(net_count_tcp[NC_TCP_SEND_ACKS], 1);
		if (flags & (TCP_FLG_FIN | TCP_FLG_SYN | TCP_FLG_RST))
			NET_COUNT_TCP(net_count_tcp[NC_TCP_SEND_CNTL_SEGS],  1);


#ifdef TCP_CFG_EXTENTIONS

		if (SEQ_LT(cep->snd_up, cep->snd_una))
			NET_COUNT_TCP(net_count_tcp[NC_TCP_SEND_URG_SEGS], 1);

#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

	}

	/*
	 * snd_max: Mő SEQ
	 * snd_nxt: ɑM SEQ
	 *
	 *  肩 FIN MA܂ FIN 𑗐MĂȂA
	 *  f[^ȂƂ́AFIN 𑊎ɓ͂邽߁A
	 *  ZOg𑗐M邪ASEQ ͐i߂ȂB
	 */
	if ((flags & TCP_FLG_FIN) && (cep->flags & TCP_CEP_FLG_SENT_FIN) &&
	    cep->snd_nxt == cep->snd_max) {
		cep->snd_nxt --;
	}

	tcph = GET_TCP_HDR(output, IF_IP_TCP_HDR_OFFSET);

	/*
	 *  SEQAACKAtO̐ݒB
	 */
	if (len > 0 || (flags & (TCP_FLG_SYN | TCP_FLG_FIN)) || cep->timer[TCP_TIM_PERSIST] != 0)
		tcph->seq = htonl(cep->snd_nxt);
	else
		tcph->seq = htonl(cep->snd_max);

	/*
	 *  rcv_nxt: M҂Ăŏ SEQ
	 */
	tcph->ack   = htonl(cep->rcv_nxt);
	tcph->flags = flags;

	/*
	 *  MEBȟvZ
	 *
	 *  rbufsz: Mpobt@TCY
	 *  maxseg: ̍őMZOgTCY	
	 */
	if (win < (cep->rbufsz / 4) && win < cep->maxseg)
		win = 0;

	/*
	 *  rcv_nxt: M҂Ăŏ SEQ
	 *  rcv_adv: M҂Ăő SEQ
	 */
	if ((int32_t)win < (int32_t)(cep->rcv_adv - cep->rcv_nxt))
		win = (uint_t)(cep->rcv_adv - cep->rcv_nxt);

	tcph->win = htons(win);

#ifdef TCP_CFG_EXTENTIONS

	/*
	 *  ً}|C^̐ݒ
	 */
	if (SEQ_GT(cep->snd_up, cep->snd_nxt)) {
		if (TCP_CFG_URG_OFFSET)
			tcph->urp    = htons((uint16_t)(cep->snd_up - cep->snd_nxt));
		else
			tcph->urp    = htons((uint16_t)(cep->snd_up - cep->snd_nxt - 1));
		tcph->flags |= TCP_FLG_URG;
	}
	else
		cep->snd_up  = cep->snd_una;

#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

	/*
	 *  `FbNTݒ肷B
	 */
	tcph->sum = 0;
	tcph->sum = IN_CKSUM(output, IPPROTO_TCP, (uint_t)GET_TCP_HDR_OFFSET(output),
		             GET_TCP_HDR_SIZE2(output, IF_IP_TCP_HDR_OFFSET) + len);

	/* lbg[Nobt@𒲐B*/
	output->len = (uint16_t)(GET_IF_IP_TCP_HDR_SIZE2(output, IF_IP_TCP_HDR_OFFSET) + len);

	/*
	 *  ^C}̒
	 */
	if ((cep->flags & TCP_CEP_FLG_FORCE) == 0 || cep->timer[TCP_TIM_PERSIST] == 0) {
		T_TCP_SEQ startseq = cep->snd_nxt;

		/*
		 *  ɑM SEQ (snd_nxt) 񑗐Mf[^i߂B
		 */
		if (flags & TCP_FLG_SYN)
			cep->snd_nxt ++;
		if (flags & TCP_FLG_FIN) {
			cep->flags |= TCP_CEP_FLG_SENT_FIN;
			cep->snd_nxt ++;
		}

		cep->snd_nxt += len;

		/*
		 *  ɑM SEQ (snd_nxt) 
		 *  Mő SEQ (snd_max) ił΁A
		 *  Mő SEQ (snd_max) XVB
		 */
		if (SEQ_GT(cep->snd_nxt, cep->snd_max)) {
			cep->snd_max = cep->snd_nxt;
			/*
			 *  AԌvsĂȂ΁A
			 *  ̑MɎԂ킹B
			 */
			if (cep->rtt == 0) {
				cep->rtt   = 1;
				cep->rtseq = startseq;	/* XVO cep->snd_nxt */
			}
		}

		/*
		 *  ݒ肳ĂȂAACK ܂͕ۗĂȂ΁A
		 *  đ^C}ݒ肷Bݒ肷鏉ĺA
		 * u炩ȉ + 2 ~ ԕϓvłB
		 *  đԂ̃obNItɎgVtgJEgB
		 */
		if (cep->timer[TCP_TIM_REXMT] == 0 && cep->snd_nxt != cep->snd_una) {
			cep->timer[TCP_TIM_REXMT] = cep->rxtcur;
			if (cep->timer[TCP_TIM_PERSIST] != 0) {
				cep->timer[TCP_TIM_PERSIST] = 0;
				cep->rxtshift = 0;
			}
		}
	}

	/*
	 *  ɑM SEQ (snd_nxt) + 񑗐Mf[^ (len) 
	 *  Mő SEQ (snd_max) ił΁A
	 *  Mő SEQ (snd_max) XVB
	 */
	else if (SEQ_GT(cep->snd_nxt + len, cep->snd_max))
		cep->snd_max = cep->snd_nxt + len;

#ifdef TCP_CFG_SWBUF_CSAVE

	if ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_SEND_READY)
		cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK) | TCP_CEP_FLG_WBCS_SENT;

#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

#ifdef TCP_CFG_TRACE

	tcp_output_trace(output, cep);

#endif	/* of #ifdef TCP_CFG_TRACE */

	/* lbg[Nw (IP) ̏o͊֐ĂяoB*/
	if ((error = IP_OUTPUT(output, TMO_TCP_OUTPUT)) != E_OK)
		goto err_ret;

	/*
	 *  ɓ`EBhETCY (win)  0 ȏŁA
	 *  M҂Ăŏ SEQ (rcv_nxt) + win 
	 *  M҂Ăő SEQ (rcv_adv) ił
	 *  M҂Ăő SEQ XVB
	 */
	if (win > 0 && SEQ_GT(cep->rcv_nxt + win, cep->rcv_adv)) {
		cep->rcv_adv = cep->rcv_nxt + win;
	}

	/*
	 *  ŌɑM ACK (last_ack_sent) XVB
	 */
	cep->last_ack_sent = cep->rcv_nxt;

	/*
	 *  tO̐ݒsB
	 */
	cep->flags &= ~(TCP_CEP_FLG_ACK_NOW | TCP_CEP_FLG_DEL_ACK);
	if (cep->flags & TCP_CEP_FLG_FORCE_CLEAR)
		cep->flags &= ~(TCP_CEP_FLG_FORCE | TCP_CEP_FLG_FORCE_CLEAR);

	return E_OK;

err_ret:
	/*
	 * ȉɊ֌WȂtONA[B
	 * EMEBhobt@̏ȃRs[@\
	 * EIȒʐM[_̐E폜@\
	 */
	cep->flags &= (TCP_CEP_FLG_WBCS_NBUF_REQ | TCP_CEP_FLG_WBCS_MASK | 
	               TCP_CEP_FLG_DYNAMIC       | TCP_CEP_FLG_VALID);

	return error;
}

/*
 *  tcp_output -- TCP o͏
 */

void
tcp_output (T_TCP_CEP *cep)
{
	bool_t	sendalot = true, idle;
	ER	error = E_OK;
	int32_t	len;
	uint_t	doff, win;
	uint8_t	flags;

	/*
	 *  snd_una: mF̍ŏM SEQ	 ܂́AmFꂽő呗M SEQ
	 *  snd_max: Mő SEQ
	 */
	idle = (cep->snd_max == cep->snd_una);

	/*
	 *  idle:   ACh
	 *  rxtcur: ݂̍đ^CAEg
	 */
	if (idle && cep->idle >= cep->rxtcur)

		/*
		 *  snd_cwnd: tsEBhTCY
		 *  maxseg  : ̍őMZOgTCY
		 *
		 *  ԃACĥŃX[X^[gɐݒ肷B
		 */
		cep->snd_cwnd = cep->maxseg;

	while (error == E_OK && sendalot) {
		sendalot = false;

		/*
		 *  snd_nxt: ɑM SEQA̎_ł́AO񑗐M SEQ
		 *  snd_una: mF̍ŏM SEQA܂͊mFꂽő呗M SEQ
		 *
		 *  doff: MJnItZbgB
		 *                                    swbuf_count (Mobt@ɂINebg)
		 *    0                               V
		 *    +-------------------------------------------+
		 *    |                    sbuf                   |
		 *    +-------------------------------------------+
		 *    ^               ^
		 *    |<------------->snd_nxt (O񑗐M SEQ)
		 *    |       doff
		 *    snd_una (܂mFĂȂ)
		 */
		doff = (uint_t)(cep->snd_nxt - cep->snd_una);

		/*
		 *  snd_wnd:  ̎M\EBhTCY
		 *  snd_cwnd: tsEBhTCY
		 *
		 *  win: ǂ炩EBhTCYɐݒ肷B
		 */
		win   = cep->snd_wnd < cep->snd_cwnd ? cep->snd_wnd : cep->snd_cwnd;
	
		/* o̓tO̐ݒ */
		flags = tcp_outflags[cep->fsm_state];
		if (cep->flags & TCP_CEP_FLG_NEED_FIN)
			flags |= TCP_FLG_FIN;
		if (cep->flags & TCP_CEP_FLG_NEED_SYN)
			flags |= TCP_FLG_SYN;
		if (cep->flags & TCP_CEP_FLG_FORCE) {

			/*
			 *  AMEChTCY (win)  0 Ȃ 1 INebgMB
			 *  łȂ΁A^CAEgLZA
			 *  đM (rxtshift)  0 ɂB
			 */
			if (win == 0) {

				/*
				 *  doff:        MINebgB
				 *  swbuf_count: Mobt@̎gpTCY
				 *
				 *  Mobt@ɎcĂINebgAꂩ
				 *  M悤ƂĂINebg葽
				 *  FIN tONAB
				 */
				if (doff < cep->swbuf_count)
					flags &=~TCP_FLG_FIN;
				win = 1;
			}
			else {
				/*
				 *  TCP_TIM_PERSIST: ^C}
				 *  rxtshift:        đM񐔂 log(2)
				 */
				cep->timer[TCP_TIM_PERSIST] = 0;
				cep->rxtshift = 0;
			}
		 	}

		/*
		 *  len: 񑗐MINebg
		 *        swbuf_count (Mobt@ɂINebg)
		 *                                    |
		 *    0                               V
		 *    +-------------------------------------------+
		 *    |                    sbuf       |           |
		 *    +-------------------------------------------+
		 *    ^               ^<------------->
		 *    |               |      len
		 *    |<------------->snd_nxt (O񑗐M SEQ)
		 *    |       doff
		 *    snd_una (܂mFĂȂ)
		 */
		if (cep->swbuf_count < win)
			len = (int32_t)cep->swbuf_count - doff;
		else
			len = (int32_t)win - doff;

		/*
		 *  łɑMĂ΁ASYN rbgItB
		 *  Aȉ̏ł͑MTB
		 *
		 *    EԂ SYN MB
		 *    EZOgf[^܂łB
		 */
		if ((flags & TCP_FLG_SYN) && SEQ_GT(cep->snd_nxt, cep->snd_una)) {
			flags &= ~TCP_FLG_SYN;
			doff --;		/* -1  SYN tO */
			len ++;			/* +1  SYN tO */
			if (len > 0 && cep->fsm_state == TCP_FSM_SYN_SENT)
				break;
		}

		if (flags & TCP_FLG_SYN) {
			len = 0;
			flags &= ~TCP_FLG_FIN;
		}

		if (len < 0) {

			/*
			 *  len  0 ȉȂA0 ɐݒ肷B
			 *  AMEBhETCY 0 ȂA
			 *  đM^C}LZA
			 *  O񑗐M SEQ (snd_nxt) 
			 *  mFꂽő呗M SEQ (snd_una) ɖ߂B
			 *  āA^C}[~܂Ă΁AĐݒ肷B
			 */
			len = 0;
			if (win == 0) {
				cep->timer[TCP_TIM_REXMT] = 0;
				cep->rxtshift = 0;
				cep->snd_nxt  = cep->snd_una;
				if (cep->timer[TCP_TIM_PERSIST] == 0)
					tcp_set_persist_timer(cep);
			}
		}


		/*
		 *  񑗐MINebg (len) ́A
		 *  ̍őMZOgTCY (maxseg) 𒴂Ȃ悤ɂB
		 */
		if (len > cep->maxseg) {
			len = cep->maxseg;
			sendalot = true;
		}

		/*
                 *        swbuf_count (Mobt@ɂINebg)
                 *                                           |
		 *    0                                      V
		 *    +-------------------------------------------+
		 *    |                    sbuf       |           |
		 *    +-------------------------------------------+
		 *    ^               ^<------------->
		 *    |               |      len
		 *    |<------------->snd_nxt (O񑗐M SEQ)
		 *    |       doff
		 *    snd_una (܂mFĂȂ)
		 *
		 *  񑗐MAMobt@Ƀf[^cĂ
		 *  FIN tONAB
		 */
		if (SEQ_LT(cep->snd_nxt + len, cep->snd_una + cep->swbuf_count))
			flags &= ~TCP_FLG_FIN;

		/*
		 *   win ́AMEBhETCYB
		 *  Mobt@̋󂫗e
		 */
		win = cep->rbufsz - cep->rwbuf_count;

		/*
		 *  ȃEBhEEVh[̉ (M)
		 *
		 *  ȉ̏ŁAMsB
		 *
		 *    EtTCY (maxseg) ̃ZOg𑗂邱ƂłB
		 *    E̍ő̎MEBhETCY 1/2 ̃f[^
		 *      邱ƂłB
		 *    EMobt@ɂłAAChxIvVLȂƂB
		 */
		if (len) {

			/*
			 *  񑗐MINebg (len) 
			 *  ̍őMZOgTCY (maxseg) 
			 *  vƂ͑MB
			 */
			if (len == cep->maxseg) {
				error = send_segment(&sendalot, cep, doff, win, (uint_t)len, flags);
				continue;
			}

			/*
			 *  ̑MŁAMobt@ɂłA
			 *  ACh PUSH IvVLȂƂB
			 */
			if ((idle || (cep->flags & TCP_CEP_FLG_NO_DELAY)) &&
			    (cep->flags & TCP_CEP_FLG_NO_PUSH) == 0 &&
			    len + doff >= cep->swbuf_count) {
				error = send_segment(&sendalot, cep, doff, win, (uint_t)len, flags);
				continue;
			}

			/*
			 *  max_sndwnd: ܂ł̍ő呗MEBhTCY
			 *  snd_nxt:    ɑM SEQ
			 *  snd_max:    Mő SEQ
			 *
			 *  ̏ł͑MsB
			 *
			 *    EMtOZbgĂB
			 *    Ef[^̍ő̎MEBhETCY 1/2 ȏŁA
			 *      ̍ő̎MEBhETCY 0 傫B
			 *    EɑM SEQ Mő SEQ 菬A
			 *      ܂AđƂB
			 */
			if ((cep->flags & TCP_CEP_FLG_FORCE) ||
			    (len >= cep->max_sndwnd / 2 && cep->max_sndwnd > 0) ||
			    SEQ_LT(cep->snd_nxt, cep->snd_max)) {
				error = send_segment(&sendalot, cep, doff, win, (uint_t)len, flags);
				continue;
			}
		}


		/*
		 *  ȃEBhEEVh[̉ (M)
		 *
		 *  EBhETCYtTCY 2 {̃ZOgA邢
		 *  Mobt@eʂ 1/2 ́Aꂩق
		 *  TCYőꍇ́AEBhETCY̍XVsB
		 */
		if (win > 0) {
			long adv;

			/*
			 *  win:              Mobt@̋󂫗e
			 *  MAX_TCP_WIN_SIZE: TCP wb_ win tB[hɐݒłől
			 *  rcv_adv:          M҂Ăő SEQ
			 *  rcv_nxt:          M҂Ăŏ SEQ
			 */
			if (win < MAX_TCP_WIN_SIZE)
				adv = win - (cep->rcv_adv - cep->rcv_nxt);
			else
				adv = MAX_TCP_WIN_SIZE - (cep->rcv_adv - cep->rcv_nxt);

			if (adv     >= (long)(cep->maxseg * 2) ||
			    adv * 2 >= (long) cep->rbufsz) {
				error = send_segment(&sendalot, cep, doff, win, (uint_t)len, flags);
				continue;
			}
		}
	
		/*
		 *  ACK 𑗐MB
		 */
		if (cep->flags & TCP_CEP_FLG_ACK_NOW) {
			error = send_segment(&sendalot, cep, doff, win, (uint_t)len, flags);
			continue;
		}

		if ( (flags & TCP_FLG_RST) ||
		    ((flags & TCP_FLG_SYN) && (cep->flags & TCP_CEP_FLG_NEED_SYN) == 0)) {
			error = send_segment(&sendalot, cep, doff, win, (uint_t)len, flags);
			continue;
		}

#ifdef TCP_CFG_EXTENTIONS

		if (SEQ_GT(cep->snd_up, cep->snd_una)) {
			error = send_segment(&sendalot, cep, doff, win, (uint_t)len, flags);
			continue;
		}

#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

		/*
		 *  snd_nxt: ɑM SEQ
		 *  snd_una: mF̍ŏM SEQA܂͊mFꂽő呗M SEQ
		 *
		 *  肩 FIN MA܂ FIN 𑗐MĂȂA
		 *  f[^ȂƂ́AFIN 𑊎ɓ͂邽߁A
		 *  ZOg𑗐MB
		 */
		if ((flags & TCP_FLG_FIN) &&
		    ((cep->flags & TCP_CEP_FLG_SENT_FIN) == 0 || cep->snd_nxt == cep->snd_una)) {
			error = send_segment(&sendalot, cep, doff, win, (uint_t)len, flags);
			continue;
		}

		/*
		 *  Mׂf[^Ađ^C}Ǝ^C}؂ĂƂ
		 *  ^C}ݒ肷B
		 */
		if (cep->swbuf_count && cep->timer[TCP_TIM_REXMT  ] == 0 &&
		                        cep->timer[TCP_TIM_PERSIST] == 0) {
			cep->rxtshift = 0;
			tcp_set_persist_timer(cep);
			break;
		}
		
	}
}

#ifdef TCP_CFG_SWBUF_CSAVE

/*
 *  tcptsk_alloc_swbufq -- MEBhobt@蓖
 */

static void
tcptsk_alloc_swbufq (T_TCP_CEP *cep)
{
 	ER	error;
	uint_t	win;

	/*
	 *  snd_wnd:  ̎M\EBhTCY
	 *  snd_cwnd: tsEBhTCY
	 *
	 *  win: ǂ炩EBhTCYɐݒ肷B
	 */
	win = cep->snd_wnd < cep->snd_cwnd ? cep->snd_wnd : cep->snd_cwnd;

	/*
	 *  ̎MEBhĂꍇ́AJ܂őҋ@B
	 */
	if (win == 0) {
		cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK) | TCP_CEP_FLG_WBCS_WOPEN_PEND;
	}
	else {

#ifdef TCP_CFG_NON_BLOCKING

		/* mubLOR[ */
		if (!IS_PTR_DEFINED(cep->callback)) {
			syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));

			/* LĂ^XN ID  API @\R[hNA[B*/
			cep->snd_tskid = TA_NULL;
			cep->snd_tfn   = cep->snd_nblk_tfn = TFN_TCP_UNDEF;
			return;
		}

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

		if ((error = tcp_get_segment(&cep->swbufq, cep, 0,
		                             (uint_t) TCP_CFG_SWBUF_CSAVE_MIN_SIZE,
		                             (uint_t)(TCP_CFG_SWBUF_CSAVE_MAX_SIZE - IF_IP_TCP_HDR_SIZE),
		                             (ATR)(NBA_SEARCH_DESCENT |
		                                   NBA_RESERVE_TCP    |
		                                   (GET_TCP_CEPID(cep) & NBA_ID_MASK)), TMO_POL)) != E_OK) {

			/* lbg[Nobt@\񂷂B*/
			cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK) | TCP_CEP_FLG_WBCS_NBUF_PEND;
		}
		else {

			/* MEBhobt@B*/
			tcp_init_swbuf(cep);

#ifdef TCP_CFG_NON_BLOCKING

			if (cep->snd_nblk_tfn == TFN_TCP_GET_BUF) {

				uint_t len;

				/* MEBhobt@̏݃AhXݒ肷B*/
				len = TCP_GET_SWBUF_ADDR(cep, cep->snd_p_buf);

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

				/* R[obN֐ĂяoB*/
				(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)(uint32_t)len);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

				/* R[obN֐ĂяoB*/
				(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)&len);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */


				/* LĂ^XN ID  API @\R[hNA[B*/
				cep->snd_tskid = TA_NULL;
				cep->snd_tfn   = cep->snd_nblk_tfn = TFN_TCP_UNDEF;
			}

			else {	/* cep->snd_nblk_tfn == TFN_TCP_SND_DAT || */
				/* cep->snd_nblk_tfn == TFN_TCP_SND_OOB    */

				uint_t len;

				/* MEBhobt@Ƀf[^ށB*/
				len = TCP_WRITE_SWBUF(cep, cep->snd_data, (uint_t)cep->snd_len);

#ifdef TCP_CFG_EXTENTIONS

				/* Mً}|C^ݒ肷B*/
			        if (cep->snd_nblk_tfn == TFN_TCP_SND_OOB)
					cep->snd_up = cep->snd_una + len;

#endif	/* of #ifdef TCP_CFG_EXTENTIONS */

				/* tOAM\ɐݒ肵AIɑMB*/
				cep->flags |= TCP_CEP_FLG_FORCE | TCP_CEP_FLG_FORCE_CLEAR | TCP_CEP_FLG_POST_OUTPUT;
#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

				/* R[obN֐ĂяoB*/
				(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)(uint32_t)len);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

				/* R[obN֐ĂяoB*/
				(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)&len);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */


				/* LĂ^XN ID  API @\R[hNA[B*/
				cep->snd_tskid = TA_NULL;
				cep->snd_tfn   = cep->snd_nblk_tfn = TFN_TCP_UNDEF;
			}

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

		}
	}
}

/*
 *  tcptsk_free_swbufq -- MEBhobt@J
 */

static void
tcptsk_free_swbufq (T_TCP_CEP *cep)
{
	/*
	 *  MmFAlbg[NC^tF[X
	 *  o͂Ƃ́AMEBhobt@L[B
	 */

	/* MEBhobt@̎gpTCYZbgB*/
	cep->swbuf_count = 0;

	/* MEBhobt@L[̃lbg[Nobt@B*/
	syscall(rel_net_buf(cep->swbufq));
	cep->swbufq = NULL;

	/* tO󂫂ɐݒ肷B*/
	cep->flags = (cep->flags & ~TCP_CEP_FLG_WBCS_MASK) | TCP_CEP_FLG_WBCS_FREE;

	/* MEBhobt@ɋ󂫂łƂm点B*/
	syscall(set_flg(cep->snd_flgid, TCP_CEP_EVT_SWBUF_READY));

	/* MEBhobt@̋󂫑҂̂Ƃ́ATCP o̓^XNNB*/
	if ((cep->flags & TCP_CEP_FLG_WBCS_NBUF_REQ) != 0) {
		sig_sem(SEM_TCP_POST_OUTPUT);
	}
}

#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

/*
 *  TCP o̓^XN
 */

void
tcp_output_task (intptr_t exinf)
{
	static int_t last_ix = 0;

	T_TCP_CEP	*cep;
	ID		tskid;
 	int_t		ix, sel_ix;

	get_tid(&tskid);
	syslog(LOG_NOTICE, "[TCP OUTPUT:%d] started.", tskid);

	tcp_init();

#ifdef SUPPORT_INET6

	/* IPv6 ̃Xe[gXEAhXݒsB*/
	in6_if_up(IF_GET_IFNET());

#endif	/* of #ifdef SUPPORT_INET6 */

	while (true) {

		/* o͂|Xg܂ő҂B*/
		syscall(wai_sem(SEM_TCP_POST_OUTPUT));

		if (++ last_ix == tmax_tcp_cepid)
			last_ix = 0;
		sel_ix = ix = last_ix;
		do {
			cep = &tcp_cep[ix];

#ifdef TCP_CFG_SWBUF_CSAVE

			if ((cep->flags & TCP_CEP_FLG_WBCS_NBUF_REQ) != 0 &&
			    ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_FREE ||
			     (cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_NBUF_RSVD)) {
				tcptsk_alloc_swbufq(cep);
				sel_ix = ix;
			}

			if ((cep->flags & TCP_CEP_FLG_WBCS_MASK) == TCP_CEP_FLG_WBCS_ACKED &&
			    (cep->swbufq->flags & NB_FLG_NOREL_IFOUT) == 0) {
				tcptsk_free_swbufq(cep);
				sel_ix = ix;
			}

			/*
			 *  lbg[NC^tF[X瑗MIĂȂƂ́A
			 *  M\񂷂B
			 */
			if (cep->flags & TCP_CEP_FLG_POST_OUTPUT &&
			   (cep->flags & TCP_CEP_FLG_WBCS_MASK) >= TCP_CEP_FLG_WBCS_SENT) {
				syscall(wai_sem(cep->semid_lock));
				if (cep->swbufq == NULL)
					cep->flags &= ~TCP_CEP_FLG_POST_OUTPUT;
				else if (cep->swbufq->flags & NB_FLG_NOREL_IFOUT) {
					cep->flags &= ~TCP_CEP_FLG_POST_OUTPUT;
					cep->flags |=  TCP_CEP_FLG_RESERVE_OUTPUT;
				}
				syscall(sig_sem(cep->semid_lock));
			}

			/*
			 *  M\񒆂ɁAlbg[NC^tF[X瑗MIA
			 *  MJnBASɑMIƂ͉ȂB
			 */
			if (cep->flags & TCP_CEP_FLG_RESERVE_OUTPUT) {
				syscall(wai_sem(cep->semid_lock));
				if (cep->swbufq != NULL && (cep->swbufq->flags & NB_FLG_NOREL_IFOUT) == 0) {
					cep->flags |=  TCP_CEP_FLG_POST_OUTPUT;
				}
				syscall(sig_sem(cep->semid_lock));
				cep->flags &= ~TCP_CEP_FLG_RESERVE_OUTPUT;
			}

#endif	/* of #ifdef TCP_CFG_SWBUF_CSAVE */

			if (cep->flags & TCP_CEP_FLG_POST_OUTPUT) {

				cep->flags &= ~TCP_CEP_FLG_POST_OUTPUT;

#ifdef TCP_CFG_NON_BLOCKING

				if (cep->snd_nblk_tfn == TFN_TCP_CON_CEP && cep->myaddr.portno == TCP_PORTANY) {
				 	ER	error;

					/*
					 *  tcp_con_cep ̃mubLOR[ŁA
					 *  ̂̏ꍇ́A|[gԍ蓖ĂB
					 *  p_myaddr  NADR (-1) A
					 *  |[gԍ TCP_PORTANY ȂAŊ蓖ĂB
					 */
					if (cep->p_myaddr == NADR || cep->p_myaddr->portno == TCP_PORTANY)
						tcp_alloc_auto_port(cep);
					else if ((error = tcp_alloc_port(cep, cep->p_myaddr->portno)) != E_OK) {

						if (IS_PTR_DEFINED(cep->callback))

#ifdef TCP_CFG_NON_BLOCKING_COMPAT14

							(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)error);

#else	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

							(*cep->callback)(GET_TCP_CEPID(cep), cep->snd_nblk_tfn, (void*)&error);

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING_COMPAT14 */

						else
							syslog(LOG_WARNING, "[TCP] no call back, CEP: %d.", GET_TCP_CEPID(cep));

						/* LĂ^XN ID  API @\R[hNA[B*/
						cep->snd_tfn   = cep->snd_nblk_tfn = TFN_TCP_UNDEF;
						cep->snd_tskid = TA_NULL;
						continue;
					}
				}

#endif	/* of #ifdef TCP_CFG_NON_BLOCKING */

				tcp_output(cep);

				if (cep->flags & TCP_CEP_FLG_CLOSE_AFTER_OUTPUT) {
					/* RlNVB*/
					tcp_close(cep);
					cep->flags &= ~TCP_CEP_FLG_CLOSE_AFTER_OUTPUT;
				}

				if (cep->flags & TCP_CEP_FLG_RESTORE_NEXT_OUTPUT) {
					/* snd_nxt ɖ߂B*/
					if (SEQ_GT(cep->snd_old_nxt, cep->snd_nxt))
						cep->snd_nxt = cep->snd_old_nxt;
					cep->flags &= ~TCP_CEP_FLG_RESTORE_NEXT_OUTPUT;
				}

				sel_ix = ix;
			}

			if (++ ix == tmax_tcp_cepid)
				ix = 0;
		} while (ix != last_ix);

		/* ́AʐM[_񂵂ɂB*/
		last_ix = sel_ix;
	}
}

#endif	/* of #ifdef SUPPORT_TCP */
