/*
 *  TLV - Trace Log Visualizer
 *
 *  Copyright (C) 2008-2010 by Nagoya Univ., JAPAN
 *
 *  上記著作権者は，以下の(1)〜(4)の条件を満たす場合に限り，本ソフトウェ
 *  ア（本ソフトウェアを改変したものを含む．以下同じ）を使用・複製・改
 *  変・再配布（以下，利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *      また，本ソフトウェアのユーザまたはエンドユーザからのいかなる理
 *      由に基づく請求からも，上記著作権者およびTOPPERSプロジェクトを
 *      免責すること．
 *
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，特定の使用目的
 *  に対する適合性も含めて，いかなる保証も行わない．また，本ソフトウェ
 *  アの利用により直接的または間接的に生じたいかなる損害に関しても，そ
 *  の責任を負わない．
 *
 *  @(#) $Id$
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using NU.OJL.MPRTOS.TLV.Base;
using System.Threading;

namespace NU.OJL.MPRTOS.TLV.Core.Commands
{
	public abstract class AbstractFileChangeCommand : ICommand
	{
		private IFileContext _fileContext;
		private Form _view;
		private string _Text;
		private volatile bool flag = false;

		public IFileContext FileContext { get { return _fileContext; } }

		public Form View { get { return _view; } }

		public string Text { get { return _Text; } set { _Text = value; } }

		public bool CanUndo
		{
			get { return false; }
			set { }
		}

		public AbstractFileChangeCommand(IFileContext fileContext)
		{
			_fileContext = fileContext;
		}

		public void Do()
		{
			if ((_fileContext != null) && _fileContext.IsOpened && !_fileContext.IsSaved)
			{
				switch (MessageBox.Show("ファイルが更新されています。\n保存しますか？", "ファイルが更新されています", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question))
				{
					case DialogResult.Yes:
						ApplicationFactory.CommandManager.Do(new SaveCommand(_fileContext));

						flag = false;
						for (; ; )
						{
							flag = _fileContext.IsSaved;

							if (flag)
								break;
							else
								Application.DoEvents();
						}

						if (_fileContext.IsSaved)
						{
							action();
						}
						break;
					case DialogResult.No:
						action();
						break;
					case DialogResult.Cancel:
						break;
				}
			}
			else
			{
				action();
			}
		}

		public void Undo()
		{
		}

		protected virtual void action()
		{
		}

		protected void CreateFileContext()
		{
			if (_fileContext != null)
				throw new InvalidOperationException();

			OnCreateFileContext(out _fileContext, out _view);

			ApplicationFactory.SetFileContext(_fileContext, _view);
		}

		protected virtual void OnCreateFileContext(out IFileContext fileContext, out Form view)
		{
			throw new InvalidOperationException();
		}
	}
}
