/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ppp_fsm.h,v 1.5 2009/12/24 05:42:40 abe Exp abe $
 */

/*
 * fsm.h - {Link, IP} Control Protocol Finite State Machine definitions.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $FreeBSD: src/usr.sbin/pppd/fsm.h,v 1.6.2.1 1999/08/29 15:47:00 peter Exp $
 */

/*
 *	    Written by Toshiharu OHNO (tony-o@iij.ad.jp)
 *
 *   Copyright (C) 1993, Internet Initiative Japan, Inc. All rights reserverd.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the Internet Initiative Japan.  The name of the
 * IIJ may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $FreeBSD: src/usr.sbin/ppp/fsm.h,v 1.23 1999/12/27 11:54:53 brian Exp $
 *
 *	TODO:
 */

#ifndef _PPP_FSM_H_
#define _PPP_FSM_H_

#ifdef SUPPORT_PPP

/*
 *  ԊǗ\
 */

struct t_ppp_fsm_callbacks;

typedef struct t_fsm {
	struct t_ppp_fsm_callbacks	*callbacks;	/* R[obN֐*/
	uint16_t	proto;		/* vgR				*/
	uint8_t		state;		/* FSM ̏				*/
	uint8_t		id;		/* ݂ ID				*/
	uint8_t		reqid;		/* v ID				*/
	uint8_t		seen_ack;	/* vɑ΂ ACK/NAK/REJ M	*/
	int8_t		failures;	/* ٔF NAK 			*/
	int8_t		retrans;	/* Configure-Request ܂́A		*/
					/* Terminate-Request ̍đ		*/
} T_PPP_FSM;

#define T_PPP_FSM_DEFINED

/*
 *  R[obN֐\
 */

typedef struct t_ppp_fsm_callbacks {
	void (*resetci)	(T_PPP_FSM *);	/* \ZbgB	*/
	int_t  (*cilen)	(T_PPP_FSM *);	/* \̒ԂB		*/
	void (*addci)	(T_PPP_FSM *, T_NET_BUF *);
					/* \ǉB		*/
	bool_t (*ackci)	(T_PPP_FSM *, T_NET_BUF *);
					/* ACK MƂ̏	*/
	int_t  (*nakci)	(T_PPP_FSM *, T_NET_BUF *);
					/* NAK MƂ̏	*/
	int_t  (*rejci)	(T_PPP_FSM *, T_NET_BUF *);
					/* REJ MƂ̏	*/
	int_t  (*reqci)	(T_PPP_FSM *, T_NET_BUF *, T_NET_BUF *);
					/* ̍\mFB	*/
	void (*up)	(T_PPP_FSM *);	/* N̐ڑmB	*/
	void (*down)	(T_PPP_FSM *);	/* N̐ڑB	*/
	void (*starting)(T_PPP_FSM *);	/* ʑwJnB		*/
	void (*finished)(T_PPP_FSM *);	/* ʑwIB		*/
	void (*retrans)	(T_PPP_FSM *);	/* đB			*/
					/* s CP MƂ̏	*/
	bool_t  (*extcode)(T_PPP_FSM *, uint8_t, uint8_t, T_NET_BUF *);
} T_PPP_FSM_CALLBACKS;

/*
 *  FSM ̏
 */

#define PPP_FSM_INITIAL		0	/* ڑAI[v	*/
#define PPP_FSM_STARTING	1	/* ڑAI[v	*/
#define PPP_FSM_CLOSED		2	/* ڑA  I[v	*/
#define PPP_FSM_STOPPED		3	/* I[vAؒf҂	*/
#define PPP_FSM_CLOSING		4	/* ؒfAI[v	*/
#define PPP_FSM_STOPPING	5	/* ؒfAI[v	*/
#define PPP_FSM_REQSENT		6	/* Config REQ Mς	*/
#define PPP_FSM_ACKRCVD		7	/* Config ACK Mς	*/
#define PPP_FSM_ACKSENT		8	/* Config ACK Mς	*/
#define PPP_FSM_OPENED		9	/* ڑAʐM\	*/

/*
 *  I[v̓샂[h
 */

#define PPP_OPEN_PASSIVE	false	/* 󓮃I[v		*/
#define PPP_OPEN_ACTIVE		true	/* \I[v		*/

/*
 *  đA^CAEg̊l
 */

#define DEF_PPP_TIMEOUT		(3*NET_TIMER_HZ)
					/* RFC1661 ł  3 b			*/
#define MAX_PPP_TERMINATES	2	/* Terminate-Requests ̍őđ	*/
					/* RFC1661 ł  2 			*/
#define MAX_PPP_CONFIGURES	10	/* Configure-Requests ̍őđ	*/
					/* RFC1661 ł 10 			*/
#define MAX_PPP_FAILURES	5	/* Configure-NAK ̍őٔF		*/
					/* RFC1661 ł  5 			*/

/*
 *  ֐
 */

extern void fsm_init    (T_PPP_FSM *fsm);
extern void fsm_lowerup (T_PPP_FSM *fsm);
extern void fsm_lowerdown(T_PPP_FSM *fsm);
extern void fsm_open    (T_PPP_FSM *fsm);
extern void fsm_close	(T_PPP_FSM *fsm);
extern void fsm_input	(T_PPP_FSM *fsm, T_NET_BUF *data);
extern void fsm_protreject(T_PPP_FSM *fsm);

/*
 *  ϐ
 */

extern uint8_t ppp_open_mode;

#endif	/* of #ifdef SUPPORT_PPP */

#endif	/* of #ifndef _PPP_FSM_H_ */
