/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

#ifndef TOPPERS_V850ESJX3E_H
#define TOPPERS_V850ESJX3E_H

#define DEFAULT_STK_TOP		((STK_T *const)0xFFFF0000)
#define STACKTOP			0x3FFFF000

/* I/OAhX(KvȂ̂̂) */

/* |[g */
#define PCT			(0xFFFFF00A)
#define PCMT		(0xFFFFF02A)
#define PMC3L		(0xFFFFF446)
#define PFC3		(0xFFFFF466)

/* UART */
#define UA0CTL0		(0xFFFFFA00)
#define UA0CTL1		(0xFFFFFA01)
#define UA0CTL2		(0xFFFFFA02)
#define UA0STR		(0xFFFFFA04)

#define UA0TX		(0xFFFFFA07)
#define UA1TX		(0xFFFFFA17)
#define UA2TX		(0xFFFFFA27)

#define UA0RX		(0xFFFFFA06)
#define UA1RX		(0xFFFFFA16)
#define UA2RX		(0xFFFFFA26)

#define UA0STR		(0xFFFFFA04)
#define UA1STR		(0xFFFFFA14)
#define UA2STR		(0xFFFFFA24)

/* NbN */
#define PRCMD		(0xFFFFF1FC)
#define CKC			(0xFFFFF822)
#define LOCKR 		(0xFFFFF824)
#define VSWC		(0xFFFFF06E)
#define PLLCTL		(0xFFFFF82C)

/* EHb`hbO */
#define WDTM2		(0xFFFFF6D0)
#define RCM			(0xFFFFF80C)

/* ^C} */
#define TM0CMP0		(0xFFFFF694)
#define TM0CTL0		(0xFFFFF690)

/*  */
#define INTF0		(0xFFFFFC00)
#define INTR0		(0xFFFFFC20)
#define INTF3		(0xFFFFFC00)
#define INTR3		(0xFFFFFC20)
#define INTF9H		(0xFFFFFC13)
#define INTR9H		(0xFFFFFC33)

#define IMR_SIZE	(4)
#define IMR0		(0xFFFFF100)
#define IMR1		(0xFFFFF102)
#define IMR2		(0xFFFFF104)
#define IMR3		(0xFFFFF106)


/*
 *	ݐ䃌WX^̔ԒnZo邽߂̃}N
 *
 *	ݐ䃌WX^͊ݔԍɕł邽߁C
 *	x[XAhX̃ItZbgŃAhX߂邱ƂłD
 */

#define INTREG_BASE				(0xFFFFF110)
#define INTREG_ADDRESS(intno)	(INTREG_BASE + (((intno) - 8) * 2))

/*
 *	O݋ɐݒ背WX^e[u
 */

#define INT_POLREG_TABLE											\
	{ 0 , 0 , 0 } , 			/* ZbgԒnȂ̂Ŗ */		\
	{ INTF0 , INTR0 , 2 } ,		/* NMI */							\
	{ 0, 0 , 0 } , 				/* O݂ŏoȂ̂Ŗ */	\
	{ 0 , 0 , 0 } , 			/* O݂ŏoȂ̂Ŗ */	\
	{ 0 , 0 , 0 } , 			/* O݂ŏoȂ̂Ŗ */	\
	{ 0 , 0 , 0 } , 			/* O݂ŏoȂ̂Ŗ */	\
	{ 0 , 0 , 0 } , 			/* O݂ŏoȂ̂Ŗ */	\
	{ 0 , 0 , 0 } , 			/* O݂ŏoȂ̂Ŗ */	\
	{ INTF0 , INTR0 , 3 } , 	/* INT0 */							\
	{ INTF0 , INTR0 , 4 } , 	/* INT1 */							\
	{ INTF0 , INTR0 , 5 } , 	/* INT2 */							\
	{ INTF0 , INTR0 , 6 } ,		/* INT3 */							\
	{ INTF9H , INTR9H , 5 } , 	/* INT4 */							\
	{ INTF9H , INTR9H , 6 } , 	/* INT5 */							\
	{ INTF9H , INTR9H , 7 } , 	/* INT6 */							\
	{ INTF3 , INTR3 , 1 } 		/* INT7 */

#endif	/* TOPPERS_V850ESJX3E_H */
