/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ppp_lcp.c,v 1.5 2009/12/24 05:42:40 abe Exp abe $
 */

/*
 * lcp.c - PPP Link Control Protocol.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 *	      PPP Link Control Protocol (LCP) Module
 *
 *	    Written by Toshiharu OHNO (tony-o@iij.ad.jp)
 *
 *   Copyright (C) 1993, Internet Initiative Japan, Inc. All rights reserverd.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the Internet Initiative Japan, Inc.  The name of the
 * IIJ may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $FreeBSD: src/usr.sbin/ppp/lcp.c,v 1.81.2.3 2000/08/19 09:30:04 brian Exp $
 *
 */

#include <string.h>

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/net.h>
#include <net/net_var.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>
#include <net/ppp.h>
#include <net/ppp_var.h>
#include <net/ppp_hdlc.h>
#include <net/ppp_auth.h>
#include <net/ppp_fsm.h>
#include <net/ppp_lcp.h>

#ifdef SUPPORT_PPP

/*
 *  ֐
 */

static void lcp_init    (void);
static void lcp_protrej (void);
static void lcp_input   (T_NET_BUF *input);

#if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC

static void send_echo_req  (T_PPP_FSM *fsm);
static void recv_echo_rep  (T_PPP_FSM *fsm, uint8_t id, T_NET_BUF *input);
static void echo_timeout   (void *arg);
static void echo_lowerup   (void);
static void echo_lowerdown (void);

#endif	/* of #if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC */

/*
 * FSM ďoR[obN֐
 */

static void  lcp_resetci(T_PPP_FSM *fsm);	/* \ZbgB	*/
static int_t lcp_cilen	(T_PPP_FSM *fsm);	/* \̒ԂB		*/
static void  lcp_addci	(T_PPP_FSM *fsm, T_NET_BUF *output);
						/* \ǉB		*/
static bool_t lcp_ackci	(T_PPP_FSM *fsm, T_NET_BUF *input);
						/* ACK MƂ̏	*/
static bool_t lcp_nakci	(T_PPP_FSM *fsm, T_NET_BUF *input);
						/* NAK MƂ̏	*/
static bool_t lcp_rejci	(T_PPP_FSM *fsm, T_NET_BUF *input);
						/* REJ MƂ̏	*/
static int_t lcp_reqci	(T_PPP_FSM *fsm, T_NET_BUF *input, T_NET_BUF *output);
						/* ̍\mFB	*/
static void lcp_up	(T_PPP_FSM *fsm);	/* NڑmB		*/
static void lcp_starting(T_PPP_FSM *fsm);	/* ʑwJnB		*/
static bool_t lcp_extcode	(T_PPP_FSM *fsm, uint8_t code, uint8_t id, T_NET_BUF *input);
						/* s CP MƂ̏	*/
static void lcp_rprotrej(T_PPP_FSM *fsm, T_NET_BUF *input);
						/* Proto-REJ MƂ̏	*/
/*
 *  ϐ
 */

static T_LCP_CONFIGS lcp_def_cfg = {		/* \̏ݒl		*/
	DEF_REMOTE_ACCM,			/* ACCM				*/

#ifdef LCP_CFG_MAGIC

	ULONG_C(0),				/* }WbNԍ			*/

#endif	/* of #ifdef LCP_CFG_MAGIC */

	DEF_PPP_MTU,				/* MRU				*/
	UINT_C(0),				/* IvVtO		*/
};

static T_LCP_CONFIGS lcp_local_def_cfg = {	/* \̋Kl		*/
	DEF_LOCAL_ACCM,				/* ACCM				*/

#ifdef LCP_CFG_MAGIC

	ULONG_C(0),				/* }WbNԍ			*/

#endif	/* of #ifdef LCP_CFG_MAGIC */

	DEF_PPP_MTU,				/* MRU				*/
	DEF_LCP_LOCAL_CFGS,			/* IvVtO		*/
};

static T_LCP_CONFIGS lcp_local_neg_cfg;		/* lS̎\		*/

static T_LCP_CONFIGS lcp_remote_neg_cfg;	/* lS̑̍\		*/

#if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC

static uint8_t echo_pending  = UINT_C(0);
static uint8_t echo_number   = UINT_C(0);
static uint8_t timer_running = false;

#endif	/* of #if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC */

/*
 *  Sϐ
 */

T_PPP_FSM_CALLBACKS lcp_callbacks = {
	lcp_resetci,			/* \ZbgB	*/
	lcp_cilen,			/* \̒ԂB		*/
	lcp_addci,			/* \ǉB		*/
	lcp_ackci,			/* ACK MƂ̏	*/
	lcp_nakci,			/* NAK MƂ̏	*/
	lcp_rejci,			/* REJ MƂ̏	*/
	lcp_reqci,			/* ̍\mFB	*/
	lcp_up,				/* NڑmB		*/
	lcp_down,			/* NڑB		*/
	lcp_starting,			/* ʑwJnB		*/
	lcp_finished,			/* ʑwIB		*/
	NULL,				/* đB			*/
	lcp_extcode,			/* s CP MƂ̏	*/
};

T_PPP_FSM lcp_fsm = {
	&lcp_callbacks,			/* R[obN֐		*/
	PPP_LCP,			/* vgR			*/
};

T_PPP_PROTENT lcp_protent = {
	PPP_LCP,
	lcp_init,			/* 			*/
	lcp_input,			/* 				*/
	lcp_protrej,			/* Proto-REJ M		*/
	NULL,				/* ʑwN		*/
	lcp_lowerdown,			/* ʑw~		*/
	NULL,				/* I[v			*/
	lcp_close,			/* N[Y			*/
	NULL,				/* f[^			*/
};

T_LCP_CONFIGS lcp_local_ack_cfg;	/* ɋꂽ̎\	*/
T_LCP_CONFIGS lcp_remote_ack_cfg;	/* ɋ\		*/

/*
 *  lcp_init -- LCP W[̏
 */

static void
lcp_init (void)
{
	fsm_init(&lcp_fsm);
}

/*
 *  lcp_input -- LCP 
 */

static void
lcp_input (T_NET_BUF *input)
{
	NET_COUNT_PPP_LCP(net_count_ppp_lcp_in_octets,  input->len);
	NET_COUNT_PPP_LCP(net_count_ppp_lcp_in_packets, 1);
	fsm_input(&lcp_fsm, input);
}

/*
 *  lcp_resetci -- LCP̍\ZbgB
 */

static void
lcp_resetci (T_PPP_FSM *fsm)
{
#ifdef LCP_CFG_MAGIC

	SYSTIM	time;

#endif	/* of #ifdef LCP_CFG_MAGIC */

	/* \̏ݒ */
	lcp_local_neg_cfg	= lcp_local_def_cfg;
	lcp_local_ack_cfg	= lcp_def_cfg;

	/* ̍\̏ݒ */
	lcp_remote_neg_cfg	= lcp_def_cfg;
	lcp_remote_ack_cfg	= lcp_def_cfg;

#ifdef LCP_CFG_MAGIC

	syscall(get_tim(&time));
	net_srand((unsigned int)time);
	lcp_local_neg_cfg.magic = net_rand();

#endif	/* of #ifdef LCP_CFG_MAGIC */

	auth_reset();
}

/*
 *  lcp_cilen -- \̒ԂB
 */

static int_t
lcp_cilen (T_PPP_FSM *fsm)
{
	int_t cilen = 0;

	if (lcp_local_neg_cfg.options & LCP_CFG_MRU)
		cilen += sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);	/* MRU   */

	if (lcp_local_neg_cfg.options & LCP_CFG_ACCM)
		cilen += sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);	/* ACCM  */

#ifdef LCP_CFG_MAGIC

	if (lcp_local_neg_cfg.options & LCP_CFG_MAGIC)
		cilen += sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);	/* Magic */

#endif	/* of #ifdef LCP_CFG_MAGIC */

#ifdef LCP_CFG_PAP

	if (lcp_local_neg_cfg.options & LCP_CFG_PAP)
		cilen += sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);	/* PAP   */

#endif	/* of #ifdef LCP_CFG_PAP */

#ifdef LCP_CFG_PCOMP

	if (lcp_local_neg_cfg.options & LCP_CFG_PCOMP)
		cilen += sizeof(T_PPP_CI_HDR);			/* vgRk */

#endif	/* of #ifdef LCP_CFG_PCOMP */

#ifdef LCP_CFG_ACCOMP

	if (lcp_local_neg_cfg.options & LCP_CFG_ACCOMP)
		cilen += sizeof(T_PPP_CI_HDR);			/* AhXE䈳k */

#endif	/* of #ifdef LCP_CFG_ACCOMP */

	return cilen;
}

/*
 *  lcp_addci -- LCP̍\ǉB
 */

static void
lcp_addci (T_PPP_FSM *fsm, T_NET_BUF *output)
{
	uint8_t *buf;

	buf = output->buf + sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);

	/* MRU IvVǉB */
	if (lcp_local_neg_cfg.options & LCP_CFG_MRU) {
		*buf ++ = LCP_CIT_MRU;
		*buf ++ = sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		*((uint16_t*)buf) = htons(lcp_local_neg_cfg.MRU);
		buf += sizeof(uint16_t);
	}

	/* ACCM IvVǉB */
	if (lcp_local_neg_cfg.options & LCP_CFG_ACCM) {
		*buf ++ = LCP_CIT_ACCM;
		*buf ++ = sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		ahtonl(buf, lcp_local_neg_cfg.ACCM);
		buf += sizeof(uint32_t);
	}

#ifdef LCP_CFG_MAGIC

	/* Magic Number IvVǉB */
	if (lcp_local_neg_cfg.options & LCP_CFG_MAGIC) {
		*buf ++ = LCP_CIT_MAGIC;
		*buf ++ = sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		ahtonl(buf, lcp_local_neg_cfg.magic);
		buf += sizeof(uint32_t);
	}

#endif	/* of #ifdef LCP_CFG_MAGIC */

#ifdef LCP_CFG_PAP

	/* F؃vgRIvVǉB */
	if (lcp_local_neg_cfg.options & LCP_CFG_PAP) {
		*buf ++ = LCP_CIT_AUTH;
		*buf ++ = sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		*((uint16_t*)buf) = htons(PPP_PAP);
		buf += sizeof(uint16_t);
	}

#endif	/* of #ifdef LCP_CFG_PAP */

#ifdef LCP_CFG_PCOMP

	/* vgRkIvVǉB */
	if (lcp_local_neg_cfg.options & LCP_CFG_PCOMP) {
		*buf ++ = LCP_CIT_PCOMP;
		*buf ++ = sizeof(T_PPP_CI_HDR);
	}

#endif	/* of #ifdef LCP_CFG_PCOMP */

#ifdef LCP_CFG_ACCOMP

	/* AhXE䈳kIvVǉB */
	if (lcp_local_neg_cfg.options & LCP_CFG_ACCOMP) {
		*buf ++ = LCP_CIT_ACCOMP;
		*buf ++ = sizeof(T_PPP_CI_HDR);
	}

#endif	/* of #ifdef LCP_CFG_ACCOMP */
}

/*
 *  lcp_ackci -- ACK MƂ̏
 *
 *	߂l:	TURE  ACK ͐
 *		false ACK ُ͈
 */

static bool_t
lcp_ackci (T_PPP_FSM *fsm, T_NET_BUF *input)
{
	uint8_t		*buf;
	uint16_t	len;

	buf = input->buf +  sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
	len = input->len - (sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));

	/*
	 *  \͑MɊSɈvȂ΂ȂȂB
	 *  ]āAlcp_addci ō쐬ɉ͂B
	 */

	/* MRU IvV͂B */
	if (lcp_local_neg_cfg.options & LCP_CFG_MRU) {
		if (len < sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)	||
		    *buf ++ != LCP_CIT_MRU			||
		    *buf ++ != sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)||
		    *((uint16_t*)buf) != htons(lcp_local_neg_cfg.MRU)	)
			return false;
		buf += sizeof(uint16_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
	}

	/* ACCM IvV͂B */
	if (lcp_local_neg_cfg.options & LCP_CFG_ACCM) {
		if (len < sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)	||
		    *buf ++ != LCP_CIT_ACCM			||
		    *buf ++ != sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)||
		    nahcmpl(buf, lcp_local_neg_cfg.ACCM)        )
			return false;
		buf += sizeof(uint32_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
	}

#ifdef LCP_CFG_MAGIC

	/* Magic Number IvV͂B */
	if (lcp_local_neg_cfg.options & LCP_CFG_MAGIC) {
		if (len < sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)	||
		    *buf ++ != LCP_CIT_MAGIC			||
		    *buf ++ != sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)||
		    nahcmpl(buf, lcp_local_neg_cfg.magic)       )
			return false;
		buf += sizeof(uint32_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
	}

#endif	/* of #ifdef LCP_CFG_MAGIC */

#ifdef LCP_CFG_PAP

	/* F؃vgRIvV͂B */
	if (lcp_local_neg_cfg.options & LCP_CFG_PAP) {
		if (len < sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)	||
		    *buf ++ != LCP_CIT_AUTH			||
		    *buf ++ != sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)||
		    *((uint16_t*)buf) != htons(PPP_PAP)		)
			return false;
		buf += sizeof(uint16_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
	}

#endif	/* of #ifdef LCP_CFG_PAP */

#ifdef LCP_CFG_PCOMP

	/* vgRkIvV͂B */
	if (lcp_local_neg_cfg.options & LCP_CFG_PCOMP) {
		if (len < sizeof(T_PPP_CI_HDR)			||
		    *buf ++ != LCP_CIT_PCOMP			||
		    *buf ++ != sizeof(T_PPP_CI_HDR))
			return false;
		len -= sizeof(T_PPP_CI_HDR);
	}

#endif	/* of #ifdef LCP_CFG_PCOMP */

#ifdef LCP_CFG_ACCOMP

	/* AhXE䈳kIvV͂B */
	if (lcp_local_neg_cfg.options & LCP_CFG_ACCOMP) {
		if (len < sizeof(T_PPP_CI_HDR)			||
		    *buf ++ != LCP_CIT_ACCOMP			||
		    *buf ++ != sizeof(T_PPP_CI_HDR))
			return false;
		len -= sizeof(T_PPP_CI_HDR);
	}

#endif	/* of #ifdef LCP_CFG_ACCOMP */
	return true;
}

/*
 *  lcp_nakci -- NAK MƂ̏
 *
 *	߂l:	1  NAK ͐
 *		0  NAK ُ͈
 */

static int_t
lcp_nakci (T_PPP_FSM *fsm, T_NET_BUF *input)
{
	T_LCP_CONFIGS	new_cfg;
	bool_t		loop = false;	/* [vobN`FbN */
	uint32_t	cilong;
	uint16_t	cishort, len;
	uint8_t		*buf, cilen;

	buf = input->buf +  sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
	len = input->len - (sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));

	new_cfg = lcp_local_neg_cfg;

	/* MRU IvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)		&&
	    * buf      == LCP_CIT_MRU				&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)	&&
	    (lcp_local_neg_cfg.options & LCP_CFG_MRU)) {
	    	cishort = ntohs(*((uint16_t*)(buf + 2)));
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		if (cishort <= lcp_local_neg_cfg.MRU || cishort <= DEF_PPP_MTU)
			new_cfg.MRU = cishort;
	}

	/* ACCM IvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)		&&
	    * buf      == LCP_CIT_ACCM				&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)	&&
	    (lcp_local_neg_cfg.options & LCP_CFG_ACCM)) {
	    	ntoahl(cilong, buf + 2);
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		new_cfg.ACCM |= cilong;
	}

#ifdef LCP_CFG_MAGIC

	/* Magic Number IvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)		&&
	    * buf      == LCP_CIT_MAGIC				&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)	&&
	    (lcp_local_neg_cfg.options & LCP_CFG_MAGIC)) {
	    	ntoahl(cilong, buf + 2);
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		new_cfg.magic = cilong;
		loop = true;
	}

#endif	/* of #ifdef LCP_CFG_MAGIC */

#ifdef LCP_CFG_PAP

	/* F؃vgRIvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)		&&
	    * buf      == LCP_CIT_AUTH				&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)	&&
	    (lcp_local_neg_cfg.options & LCP_CFG_PAP)) {
	    	cishort = ntohs(*((uint16_t*)(buf + 2)));
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		if (cishort == PPP_PAP)
			new_cfg.options &= ~LCP_CFG_PAP;
		else
			return 0;
	}

#endif	/* of #ifdef LCP_CFG_PAP */

#ifdef LCP_CFG_PCOMP

	/* vgRkIvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR)				&&
	    * buf      == LCP_CIT_PCOMP				&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR)			&&
	    (lcp_local_neg_cfg.options & LCP_CFG_PCOMP)) {
		buf += sizeof(T_PPP_CI_HDR);
		len -= sizeof(T_PPP_CI_HDR);
		new_cfg.options &= ~LCP_CFG_PCOMP;
	}

#endif	/* of #ifdef LCP_CFG_PCOMP */

#ifdef LCP_CFG_ACCOMP

	/* AhXE䈳kIvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR)				&&
	    * buf      == LCP_CIT_ACCOMP			&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR)			&&
	    (lcp_local_neg_cfg.options & LCP_CFG_ACCOMP)) {
		buf += sizeof(T_PPP_CI_HDR);
		len -= sizeof(T_PPP_CI_HDR);
		new_cfg.options &= ~LCP_CFG_ACCOMP;
	}

#endif	/* of #ifdef LCP_CFG_ACCOMP */

	/* ͖B*/
	while (len > sizeof(T_PPP_CI_HDR)) {
		cilen = *(buf + 1);
		if (len < cilen)
			return 0;
		buf += cilen;
		len -= cilen;
	}

	/*  0 łȂ΃G[ */
	if (len != 0)
		return 0;

	/* VIvVݒ肷B*/
	if (fsm->state != PPP_FSM_OPENED) {
		if (loop) {
			syslog(LOG_WARNING, "[PPP/LCP] line looped.");
			lcp_close();
		}
		lcp_local_neg_cfg = new_cfg;
	}
	return 1;
}

/*
 *  lcp_rejci -- REJ MƂ̏
 *
 *	߂l:	1  REJ ͐
 *		0  REJ ُ͈
 */

static int_t
lcp_rejci (T_PPP_FSM *fsm, T_NET_BUF *input)
{
	T_LCP_CONFIGS	new_cfg;
	uint32_t	cilong;
	uint16_t	cishort, len;
	uint8_t		*buf;

	buf = input->buf +  sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
	len = input->len - (sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));

	new_cfg = lcp_local_neg_cfg;

	/* MRU IvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)		&&
	    * buf      == LCP_CIT_MRU					&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)	&&
	    (lcp_local_neg_cfg.options & LCP_CFG_MRU)) {
	    	cishort = ntohs(*((uint16_t*)(buf + 2)));
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		if (cishort != lcp_local_neg_cfg.MRU)
			return 0;
		else
			new_cfg.options &= ~LCP_CFG_MRU;
	}
		
	/* ACCM IvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)		&&
	    * buf      == LCP_CIT_ACCM					&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)	&&
	    (lcp_local_neg_cfg.options & LCP_CFG_ACCM)) {
	    	ntoahl(cilong, buf + 2);
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		if (cilong != lcp_local_neg_cfg.ACCM)
			return 0;
		else
			new_cfg.options &= ~LCP_CFG_ACCM;
	}

#ifdef LCP_CFG_MAGIC

	/* Magic Number IvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)		&&
	    * buf      == LCP_CIT_MAGIC					&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint32_t)	&&
	    (lcp_local_neg_cfg.options & LCP_CFG_MAGIC)) {
	    	ntoahl(cilong, buf + 2);
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
		if (cilong != lcp_local_neg_cfg.magic)
			return 0;
		else
			new_cfg.options &= ~LCP_CFG_MAGIC;
	}

#endif	/* of #ifdef LCP_CFG_MAGIC */

#ifdef LCP_CFG_PAP

	/* F؃vgRIvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)		&&
	    * buf      == LCP_CIT_AUTH					&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR) + sizeof(uint16_t)	&&
	    (lcp_local_neg_cfg.options & LCP_CFG_PAP)) {
	    	cishort = ntohs(*((uint16_t*)(buf + 2)));
		buf += sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		len -= sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
		if (cishort != PPP_PAP)
			return 0;
		else
			new_cfg.options &= ~LCP_CFG_PAP;
	}

#endif	/* of #ifdef LCP_CFG_PAP */

#ifdef LCP_CFG_PCOMP

	/* vgRkIvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR)				&&
	    * buf      == LCP_CIT_PCOMP				&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR)			&&
	    (lcp_local_neg_cfg.options & LCP_CFG_PCOMP)) {
		buf += sizeof(T_PPP_CI_HDR);
		len -= sizeof(T_PPP_CI_HDR);
		new_cfg.options &= ~LCP_CFG_PCOMP;
	}

#endif	/* of #ifdef LCP_CFG_PCOMP */

#ifdef LCP_CFG_ACCOMP

	/* AhXE䈳kIvV͂B */
	if (len >= sizeof(T_PPP_CI_HDR)				&&
	    * buf      == LCP_CIT_ACCOMP			&&
	    *(buf + 1) == sizeof(T_PPP_CI_HDR)			&&
	    (lcp_local_neg_cfg.options & LCP_CFG_ACCOMP)) {
		buf += sizeof(T_PPP_CI_HDR);
		len -= sizeof(T_PPP_CI_HDR);
		new_cfg.options &= ~LCP_CFG_ACCOMP;
	}

#endif	/* of #ifdef LCP_CFG_ACCOMP */

	/*  0 łȂ΃G[ */
	if (len != 0)
		return 0;

	/* VIvVݒ肷B*/
	if (fsm->state != PPP_FSM_OPENED)
		lcp_local_neg_cfg = new_cfg;

	return 1;
}

/*
 *  lcp_reqci -- ̍\͂B
 */

static int_t
lcp_reqci (T_PPP_FSM *fsm, T_NET_BUF *input, T_NET_BUF *output)
{
#if DEF_LCP_REMOTE_CFGS & LCP_CFG_MAGIC

	uint32_t	cilong;

#endif	/* of #if DEF_LCP_REMOTE_CFGS & LCP_CFG_MAGIC */

	uint16_t	code, final, len, cilen, cishort;
	uint8_t		*np, *rp, *ap, *cp, type = 0;

	rp = ap = input->buf + sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
				/* rp: REJAap: ACK  CI ̃|C^		*/
				/* ۂꍇ́A input ɏ㏑B	*/
	len   = input->len - (sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));
	np    = output->buf + sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR);
	final = PPP_CONFACK;	/* ŏIIɑMR[h */
	while (len > 0) {
		code = PPP_CONFACK;
		cp   = ap;	/* cp: ݏ CI	*/

		if (len < sizeof(T_PPP_CI_HDR)) {

			/* c肪 CI wb_Z */
			syslog(LOG_WARNING, "[PPP/LCP] bad CI len: %d.", len);
			cilen = len;	/* f[^ُ̏ꍇ̏u	*/
			len   = 0;	/* [v甲B		*/
			code  = PPP_CONFREJ;
			goto endswitch;
		}

		type  = *ap ++;	/* CI ̌^		*/
		cilen = *ap ++;	/* CI ̒		*/
		if (len < cilen) {

			/* c肪 CI Z */
			syslog(LOG_WARNING, "[PPP/LCP] bad CI len: %d.", cilen);
			cilen = len;	/* f[^ُ̏ꍇ̏u	*/
			len   = 0;	/* [v甲B		*/
			code  = PPP_CONFREJ;
			goto endswitch;
		}
		len -= sizeof(T_PPP_CI_HDR);

		/* CI ̌^ɂ蕪򂷂B*/
		switch (type) {

		case LCP_CIT_MRU:	/* őM (Maximum Receive Unit) */

#if (DEF_LCP_REMOTE_CFGS & LCP_CFG_MRU) == 0

			code = PPP_CONFREJ;

#else	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_MRU) == 0 */

		 	/* CI Awb_ + 2 INebgłȂ REJ */
		 	if (cilen != sizeof(T_PPP_CI_HDR) + sizeof(uint16_t))
				code = PPP_CONFREJ;
			{
				cishort = ntohs(*(uint16_t*)ap);

				/* ŏMʂ菬 NAK */
				if (cishort < MIN_PPP_MTU) {
					*np ++ = LCP_CIT_MRU;
					*np ++ = sizeof(T_PPP_CI_HDR) + sizeof(uint16_t);
					*((uint16_t*)np) = htons(MIN_PPP_MTU);
					np  += sizeof(uint16_t);
					code = PPP_CONFNAK;
				}
				else {
					lcp_remote_neg_cfg.MRU = cishort;
					lcp_remote_neg_cfg.options |= LCP_CFG_MRU;
				}
			}

#endif	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_MRU) == 0 */

			break;

		case LCP_CIT_ACCM:	/* Async Control Character Map */

#if (DEF_LCP_REMOTE_CFGS & LCP_CFG_ACCM) == 0

			code = PPP_CONFREJ;

#else	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_ACCM) == 0 */

		 	/* CI Awb_ + 4 INebgłȂ REJ */
		 	if (cilen != sizeof(T_PPP_CI_HDR) + sizeof(uint32_t))
				code = PPP_CONFREJ;
			else {
				ntoahl(lcp_remote_neg_cfg.ACCM, ap);
				lcp_remote_neg_cfg.options |= LCP_CFG_ACCM;
			}

#endif	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_ACCM) == 0 */

			break;

		case LCP_CIT_MAGIC:	/* }WbNԍ */

#if (DEF_LCP_REMOTE_CFGS & LCP_CFG_MAGIC) == 0

			code = PPP_CONFREJ;

#else	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_MAGIC) == 0 */

		 	/* CI Awb_ + 4 INebgłȂ REJ */
		 	if (cilen != sizeof(T_PPP_CI_HDR) + sizeof(uint32_t))
				code = PPP_CONFREJ;
			else {
				ntoahl(cilong, ap);

				/* ԍƓȂ NAK */
				if (cilong == lcp_local_neg_cfg.magic) {
					cilong = net_rand();
					*np ++ = LCP_CIT_MAGIC;
					*np ++ = sizeof(T_PPP_CI_HDR) + sizeof(uint32_t);
					ahtonl(np, cilong);
					np  += sizeof(uint32_t);
					code = PPP_CONFNAK;
				}
				else {
					lcp_remote_neg_cfg.magic = cilong;
					lcp_remote_neg_cfg.options |= LCP_CFG_MAGIC;
				}
			}

#endif	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_MAGIC) == 0 */

			break;

#ifdef LCP_CFG_PAP
		/* CHAP ͎\	*/

		case LCP_CIT_AUTH:	/* F؃vgR */

		 	/* CI Awb_ + 2 INebgZƂ̓G[ */
		 	if (cilen < sizeof(T_PPP_CI_HDR) + sizeof(uint16_t))
				code = PPP_CONFREJ;
			else {
				cishort = ntohs(*(uint16_t*)ap);

				/* F؃vgRɂ蕪򂷂	*/
				if (cishort == PPP_PAP &&
				    cilen   == sizeof(T_PPP_CI_HDR) + sizeof(uint16_t) &&
			 	    (DEF_LCP_REMOTE_CFGS & LCP_CFG_PAP) != 0)
					lcp_remote_neg_cfg.options |= LCP_CFG_PAP;
				else
					code = PPP_CONFREJ;
			}
			break;

#endif	/* of #ifdef LCP_CFG_PAP */

#ifdef LCP_CFG_PCOMP

		case LCP_CIT_PCOMP:	/* vgRk͎\ */

#if (DEF_LCP_REMOTE_CFGS & LCP_CFG_PCOMP) == 0

			code = PPP_CONFREJ;

#else	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_PCOMP) == 0 */

		 	/* CI Awb_łȂ REJ */
		 	if (cilen != sizeof(T_PPP_CI_HDR))
				code = PPP_CONFREJ;
			else
				lcp_remote_neg_cfg.options |= LCP_CFG_PCOMP;

#endif	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_PCOMP) == 0 */

			break;

#endif	/* of #ifdef LCP_CFG_PCOMP */

#ifdef LCP_CFG_ACCOMP

		case LCP_CIT_ACCOMP:	/* AhXE䕔k */

#if (DEF_LCP_REMOTE_CFGS & LCP_CFG_ACCOMP) == 0

			code = PPP_CONFREJ;

#else	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_ACCOMP) == 0 */

		 	/* CI Awb_łȂ REJ */
		 	if (cilen != sizeof(T_PPP_CI_HDR))
				code = PPP_CONFREJ;
			else
				lcp_remote_neg_cfg.options |= LCP_CFG_ACCOMP;

#endif	/* of #if (DEF_LCP_REMOTE_CFGS & LCP_CFG_ACCOMP) == 0 */

			break;

#endif	/* of #ifdef LCP_CFG_ACCOMP */

		default:
			syslog(LOG_WARNING, "[PPP/LCP] unexp opt: %d.", type);
			code  = PPP_CONFREJ;
			break;
		}
endswitch:
		if (code == PPP_CONFNAK) {
			/* CI ̌^ Magic Number ̏ꍇāANAK ̉񐔂	*/
			/* ől MAX_PPP_FAILURES  𒴂狑ۂB	*/
			if (fsm->failures >= MAX_PPP_FAILURES && type != LCP_CIT_MAGIC)
				code = PPP_CONFREJ;
			else if (final != PPP_CONFREJ)
				final = PPP_CONFNAK;
		}

		/*  CI ۂ */
		if (code == PPP_CONFREJ) {
			if (rp < cp)		/* Oɋl߂B*/
				memcpy(rp, cp, cilen);
			rp += cilen;
			final = PPP_CONFREJ;
		}

		ap   += cilen - sizeof(T_PPP_CI_HDR);
		len  -= cilen - sizeof(T_PPP_CI_HDR);
	}

	/* ŏIIȒ𒲐B*/
	switch (final) {
	case PPP_CONFNAK:
		output->len = np - output->buf;
		memcpy(output->buf, input->buf, sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));
		break;
	case PPP_CONFREJ:
		memcpy(output->buf, input->buf, output->len = rp - input->buf);
		break;
	case PPP_CONFACK:
		memcpy(output->buf, input->buf, input->len);
		break;
	}
	return final;
}

/*
 *  lcp_up -- Nڑm (Phase: Establish Ɉڍs)B
 */

static void
lcp_up (T_PPP_FSM *fsm)
{
	/* \̐ݒ */
	lcp_local_ack_cfg = lcp_local_neg_cfg;

	/* ̍\̐ݒ */
	lcp_remote_ack_cfg = lcp_remote_neg_cfg;

#if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC

	echo_lowerup();

#endif	/* of #if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC */

	link_established();
}

/*
 *  lcp_starting -- ʑwJnB
 */

static void
lcp_starting (T_PPP_FSM *fsm)
{
	link_required();
}

/*
 *  lcp_extcode -- LCP L CP MƂ̏
 */

static bool_t
lcp_extcode (T_PPP_FSM *fsm, uint8_t code, uint8_t id, T_NET_BUF *input)
{
#if DEF_LCP_REMOTE_CFGS & LCP_CFG_MAGIC

	T_NET_BUF *output;

#endif	/* of #if DEF_LCP_REMOTE_CFGS & LCP_CFG_MAGIC */

	switch (code) {
	case PPP_PROTREJ:
		lcp_rprotrej(fsm, input);
		break;

	case PPP_ECHOREQ:

#if DEF_LCP_REMOTE_CFGS & LCP_CFG_MAGIC

		if (fsm->state == PPP_FSM_OPENED) {
			syscall(get_net_buf(&output, sizeof(T_PPP_HDR)
			                           + sizeof(T_PPP_CP_HDR)
			                           + sizeof(uint32_t)));
			*(uint32_t*)(output->buf + sizeof(T_PPP_HDR)
			                   + sizeof(T_PPP_CP_HDR)) = lcp_local_ack_cfg.magic;
			IF_SET_PROTO(output, PPP_LCP);
			ppp_cp_output(PPP_ECHOREP, id, output);
		}

#endif	/* of #if DEF_LCP_REMOTE_CFGS & LCP_CFG_MAGIC */

		break;

	case PPP_ECHOREP:

#if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC

		recv_echo_rep(fsm, id, input);

#endif	/* of #if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC */

		break;

	case PPP_DISCREQ:
		break;

	default:
		return false;
		break;

	}
	return true;
}

/*
 *  lcp_rprotrej -- Proto-REJ MƂ̏
 */

static void
lcp_rprotrej (T_PPP_FSM *fsm, T_NET_BUF *input)
{
	T_PPP_PROTENT	*entry;
	int_t		ix;
	uint16_t	proto;

	if (input->len < sizeof(uint16_t)) {
		syslog(LOG_WARNING, "[PPP/LCP] bad len: %d in recv Proto-REJ.");
		return;
	}

	proto = ntohs(*GET_PPP_HDR(input));

	if (fsm->state != PPP_FSM_OPENED) {
		return;
	}

	/* ʃvgR */
	for (ix = 0; (entry = protocols[ix]) != NULL; ix ++)
		if (entry->proto == proto) {
			(*entry->protrej)();
			return;
		}

	syslog(LOG_WARNING, "[PPP/LCP] unexp proto: %d in recv Proto-REJ.", proto);
}

/*
 *  lcp_protrej -- Proto-REJ MƂ̏
 */

static void
lcp_protrej (void)
{
	fsm_protreject(&lcp_fsm);
}

/*
 *  lcp_lowerup -- LCP ʑwNB
 */

void
lcp_lowerup (void)
{
	fsm_lowerup(&lcp_fsm);
}

/*
 *  lcp_lowerdown -- LCP ʑw~B
 */

void
lcp_lowerdown (void)
{
	fsm_lowerdown(&lcp_fsm);
}

/*
 *  lcp_open -- LCP ̃I[v
 */

void
lcp_open (uint8_t open_mode)
{
	ppp_open_mode = open_mode;	/* I[v̓샂[h	*/
	fsm_open(&lcp_fsm);
}

/*
 *  lcp_close -- LCP ̃N[Y
 */

void
lcp_close (void)
{
	if (ppp_phase != PPP_PHASE_DEAD)
		ppp_phase = PPP_PHASE_TERMINATE;

	if (ppp_open_mode == PPP_OPEN_PASSIVE && lcp_fsm.state == PPP_FSM_STOPPED) {
		lcp_fsm.state = PPP_FSM_CLOSED;
		lcp_finished(&lcp_fsm);
	}
	else
		fsm_close(&lcp_fsm);
}

/*
 *  lcp_sprotrej -- FłȂvgRĂƂ̏
 */

void
lcp_sprotrej (T_NET_BUF *input)
{
	T_NET_BUF	*output;
	/*
	 *  Protocol-Reject 𑗂ԂB
	 */

	syscall(get_net_buf(&output, input->len + sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR)));

	memcpy(output->buf, input->buf, sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));
	memcpy(output->buf + sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR), input->buf, input->len);

	IF_SET_PROTO(output, PPP_LCP);
	ppp_cp_output(PPP_PROTREJ, ++ lcp_fsm.id, output);
}

/*
 *  lcp_down -- Nڑ (Phase: Dead Ɉڍs)B
 */

void
lcp_down (T_PPP_FSM *fsm)
{

#if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC

	echo_lowerdown();

#endif	/* of #if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC */

	link_down();
}

/*
 *  lcp_finished -- ʑwIB
 */

void
lcp_finished (T_PPP_FSM *fsm)
{
	link_terminated();
}

#if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC

/*
 *  recv_echo_rep -- ECHOREP MƂ̏
 */

static void
recv_echo_rep(T_PPP_FSM *fsm, uint8_t id, T_NET_BUF *input)
{
	T_PPP_CP_HDR	*hdr;
	uint32_t	magic;

 	hdr = GET_PPP_CP_HDR(input);

 	/* Magic Number ̒ȉȂG[ */
 	if (hdr->len < sizeof(T_PPP_CP_HDR) + sizeof(uint32_t)) {
		syslog(LOG_WARNING, "[PPP/LCP] bad ECHOREP len: %d.", hdr->len);
		return;
	}

	ntoahl(magic, input->buf + sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR));

 	/* M Magic Number ƓȂ烋[vĂB*/
	if ((lcp_local_ack_cfg.options & LCP_CFG_MAGIC) && magic == lcp_local_ack_cfg.magic) {
		syslog(LOG_WARNING, "[PPP/LCP] ECHOREP looped.");
		return;
	}

	echo_pending = 0;
}

/*
 *  echo_timeout -- ECHO REQ/REP ̃^CAEg
 */

static void
echo_timeout (void *arg)
{
	if (timer_running) {
		timer_running = false;
		send_echo_req((T_PPP_FSM *)arg);
	}
}

/*
 *  send_echo_req -- ECHO REQ 𑗐MB
 */

static void
send_echo_req (T_PPP_FSM *fsm)
{
	T_NET_BUF	*input;

#if LCP_ECHO_FAILS > 0

	if (echo_pending >= LCP_ECHO_FAILS) {
		syslog(LOG_WARNING, "[PPP/LCP] no reply to ECHOREQ.");
		lcp_close();
		echo_pending = 0;
	}

#endif	/* of #if LCP_ECHO_FAILS > 0 */

	if (fsm->state == PPP_FSM_OPENED) {

		/* ECHOREQ 𑗐MB*/
		syscall(get_net_buf(&input, sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR) + sizeof(uint32_t)));
		*(uint32_t*)(input->buf +  sizeof(T_PPP_HDR) + sizeof(T_PPP_CP_HDR)) = lcp_local_ack_cfg.magic;
		IF_SET_PROTO(input, PPP_LCP);
		ppp_cp_output(PPP_ECHOREQ, echo_number ++, input);
		echo_pending ++;

		/* ^C}[X^[gB*/
		timeout((FP)echo_timeout, fsm, LCP_ECHO_INTERVAL);
		timer_running = true;
	}
}

/*
 *  echo_lowerup -- ECHO REQ/REP ̋N
 */

static void
echo_lowerup (void)
{
	echo_pending  = 0;
	echo_number   = 0;
	timer_running = false;

	send_echo_req(&lcp_fsm);
}

/*
 *  echo_lowerdown -- ECHO REQ/REP ̒~
 */

static void
echo_lowerdown (void)
{
	if (timer_running) {
		untimeout((FP)echo_timeout, &lcp_fsm);
		timer_running = false;
	}
}

#endif	/* of #if DEF_LCP_LOCAL_CFGS & LCP_CFG_MAGIC */

#endif	/* fo #ifdef SUPPORT_PPP */
