/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ping.c,v 1.5 2009/12/24 05:44:56 abe Exp abe $
 */

/* 
 *  ping -- ICMP ECHO bZ[W𑗐MB
 */

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>
#include <net/ppp_var.h>
#include <net/ppp_ipcp.h>
#include <net/net.h>
#include <net/net_buf.h>
#include <net/net_timer.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/icmp_var.h>

#ifdef USE_PING

/*
 *  ϐ
 */

static uint16_t	icmp_id = 0;
static uint16_t	curr_icmp_id;
static uint16_t	curr_icmp_len;
static SYSTIM	icmp_start_time;

/*
 *  icmp_reply_timeout -- ICMP REPLY ^CAEg
 */

static void
icmp_reply_timeout (void *arg)
{
	syslog(LOG_NOTICE, "[PING] request timeout.");
}

/*
 *  icmp_echo_reply -- ICMP ECHO REPLY bZ[WB
 */

void
icmp_echo_reply (T_NET_BUF *input, uint_t ihoff)
{
	SYSTIM time;

	syscall(get_tim(&time));
	untimeout(icmp_reply_timeout, NULL);
	syslog(LOG_NOTICE, "[PING] reply, %d [ms].",
	                   (time - icmp_start_time) * 1000 / SYSTIM_HZ);
}

/*
 *  ping4 -- ICMP ECHO bZ[W𑗐MB
 */

void
ping4 (T_IN4_ADDR *addr, uint_t tmo, uint_t len)
{
	T_ICMP4_HDR	*icmp4h;
	T_NET_BUF	*output;
	uint8_t		*sdu;
	int_t		ix;

	/* Mp IP f[^OlB*/
	if (in4_get_datagram(&output, ICMP4_HDR_SIZE + len, 0,
	                     addr, NULL, IPPROTO_ICMP,
	                     IP4_DEFTTL, NBA_SEARCH_ASCENT, TMO_FEVR) != E_OK)
		return;

	/* ICMP wb_ݒ肷B*/
	icmp4h			= GET_ICMP4_HDR(output, IF_IP4_ICMP4_HDR_OFFSET);
	icmp4h->type		= ICMP4_ECHO_REQUEST;
	icmp4h->code		= 0;
	icmp4h->data.id_seq.id	= htons(icmp_id);
	icmp4h->data.id_seq.seq	= 0;

	/* f[^ݒ肷B*/
	sdu = GET_ICMP4_SDU(output, IF_IP4_ICMP4_HDR_OFFSET) + len;
	for (ix = len; ix -- > 0; )
		*-- sdu = ('0' + icmp_id + ix) & 0xff;

	/* `FbNTvZB*/
	icmp4h->sum = 0;
	icmp4h->sum = in_cksum(icmp4h, ICMP4_HDR_SIZE + len);

	/* `FbNp̕ϐݒ肷B*/
	curr_icmp_id  = icmp_id ++;
	curr_icmp_len = len;

	NET_COUNT_MIB(icmp_stats.icmpOutMsgs, 1);
	NET_COUNT_MIB(icmp_stats.icmpOutEchos, 1);

	/* MA݂̎ԂLA^CAEgݒ肷B*/
	ip_output(output, TMO_FEVR);

	syscall(get_tim(&icmp_start_time));
	timeout(icmp_reply_timeout, NULL, tmo * NET_TIMER_HZ);

}

#endif	/* of #ifdef USE_PING */
