/*
 *  TOPPERS/FI4 Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Fullset uItron4 Kernel
 * 
 *  Copyright (C) 2003-2004 by Monami software Limited Partnership, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: /local/fi4-1.4/toppers/RELEASE_20061105_1/kernel/kmem.c 2750 2006-03-07T16:15:24.532712Z monaka  $
 */

/*
 *  J[lAP[^
 */
#include <limits.h>
#include <stddef.h>
#include "kernel_impl.h"
#include "kmem.h"

typedef union {
	long l;
#ifdef _int64_
	_int64_ i64;
#endif
#if (__STDC_VERSION__ >= 199901L)
	long long ll;
#endif
	//double d;
	//long double ld;
} __dummy_for_align;

/*
 *
 */
#ifdef TOPPERS_kmemsetup

bool_t 
kmem_setup(void *buf, uint_t bufsz, KMEMB **p_kmemb)
{
	KMEMB *top;
	KMEMB *kmemb;

	if (bufsz < sizeof(KMEMB) * 2 ||
	    (uint_t)buf % alignof(__dummy_for_align) != 0) {
		return false;
	}

	top = (KMEMB *)buf;
	top->magic = 0;
	top->used = true;
	top->size = 0;
	queue_initialize(&(top->queue));

	kmemb = top + 1;
	kmemb->magic = KMEM_MAGIC;
	kmemb->used = false;
	kmemb->size = bufsz - sizeof(KMEMB);
	queue_insert_prev((QUEUE *)top, (QUEUE *)kmemb);

	*p_kmemb = top;

	return true;
}

#endif /* TOPPERS_kmemsetup */

/*
 *
 */
#ifdef TOPPERS_kmemallocp

bool_t kmem_allocatable(KMEMB *kmemb, uint_t size)
{
	KMEMB *ptr;

	/* alignmentƂĂB */
	size = ((size + sizeof(KMEMB)) + sizeof(__dummy_for_align) - 1) & - sizeof(__dummy_for_align);

	for (ptr = kmemb; ptr != kmemb; ptr = (KMEMB *)(ptr->queue.p_next)) {
		if (ptr->magic != KMEM_MAGIC) {
			return false;
		}

		if (ptr->used == false && ptr->size >= size) {
			/*  */
			return true;
		}
	}

	return false;
}

#endif /* TOPPERS_kmemallocp */

/*
 *
 */
#ifdef TOPPERS_kmemallocate

bool_t kmem_allocate(KMEMB *kmemb, uint_t size, void **p_blk)
{
	KMEMB *ptr;

	/* alignmentƂĂB */
	size = ((size + sizeof(KMEMB)) + sizeof(__dummy_for_align) - 1) & - sizeof(__dummy_for_align);

	/* ̈̒T */
	for (ptr = (KMEMB *)(kmemb->queue.p_next); ptr != kmemb; ptr = (KMEMB *)(ptr->queue.p_next)) {
		if (ptr->magic != KMEM_MAGIC) {
			return false;
		}

		if (ptr->used == false && ptr->size >= size) {
			/*  */

			if (ptr->size - size > KMEM_DELTA) {
				/* ̈ɏ\ȗ]T̂ŁAB*/
				KMEMB *s;
				s = (KMEMB *)((UB *)ptr + size);
				s->size = ptr->size - size;
				s->magic = ptr->magic = KMEM_MAGIC;
				s->used = false;

				ptr->size = size;
				ptr->used = true;

				queue_insert_prev((QUEUE *)ptr, (QUEUE *)s);

			} else {
				/* ̈ɏ\ȗ]T̂ŁASĂLB*/
				ptr->used = true;
			}

			/* [U̂́Awb_̒ォB*/
			*p_blk = (VP)(ptr + 1);
			return true;
		}
	}

	return false;
}

#endif /* TOPPERS_kmemallocate */

/*
 *
 */
#ifdef TOPPERS_kmemrelease

bool_t kmem_release(KMEMB *kmemb, void *buf)
{
	KMEMB *hdr;
	KMEMB *check_kmemb;

	if ((KMEMB *)buf < kmemb) {
		/*
		 *  ̏͂蓾ȂB
		 */
		return false;
	}
	hdr = (KMEMB *)buf - 1;

	if (hdr->magic != KMEM_MAGIC) {
		/*
		 * }WbNioق΁A
		 * sȃAhXnėƂ݂ȂB
		 */
		return false;
	}

	hdr->used = false;
/* Toppers porting F.Okazaki Delete start@magicƓxƎgpłȂ */
/*	hdr->magic = 0;*/
/* Toppers porting F.Okazaki Delete end */

/* Toppers porting F.Okazaki Delete,Append start@̂Ƌtł*/
/*	check_kmemb = (KMEMB *)(hdr->queue.p_next);*/
	check_kmemb = (KMEMB *)(hdr->queue.p_prev);
/* Toppers porting F.Okazaki Delete,Append end */
	if (check_kmemb->used == false) {
		hdr->size += check_kmemb->size;
		check_kmemb->magic = 0;
		check_kmemb->queue.p_next->p_prev = check_kmemb->queue.p_prev;
		check_kmemb->queue.p_prev->p_next = check_kmemb->queue.p_next;
	}

	/*
	 *  ÖȂAB
	 */
/* Toppers porting F.Okazaki Delete,Append start@̂Ƌtł*/
/*	check_kmemb = (KMEMB *)(hdr->queue.p_prev);*/
	check_kmemb = (KMEMB *)(hdr->queue.p_next);
/* Toppers porting F.Okazaki Delete,Append end */
	if (check_kmemb->used == false) {
		check_kmemb->size += hdr->size;
		hdr->magic = 0;
		hdr->queue.p_next->p_prev = hdr->queue.p_prev;
		hdr->queue.p_prev->p_next = hdr->queue.p_next;
	}

	return true;
}

#endif /* TOPPERS_kmemrelease */

/*
 *
 */
#ifdef TOPPERS_kmemstat

bool_t
kmem_status(KMEMB *kmemb, uint_t *remain, uint_t *maxblk)
{
	KMEMB *blk;
	QUEUE *entry = NULL;
	uint_t maxblksize = 0;

	if (kmemb->magic != 0) {
		/*
		 * }WbNioق΁A
		 * sȃAhXnėƂ݂ȂB
		 */
		return false;
	}

	*remain = 0;
	while((entry = queue_enumerate((QUEUE *)kmemb, entry)) != NULL) {
		blk = (KMEMB *)entry;

		if (blk->used == false) {
			*remain += blk->size;
			if (maxblksize < blk->size) {
				maxblksize = blk->size;
			}
		}
	}

	/*
	 * ref_mpl ̎dlɍ킹B
	 * uɊlłő̃ubNTCYuint_t^ŕ\킹
	 * ől傫ꍇɂ́Auint_t^ŕ\킹őlcBv
	 */
	if (maxblksize >= UINT_MAX) {
		*maxblk = UINT_MAX;
	} else {
		*maxblk = (uint_t)maxblksize;
	}
	
	return true;
}
#endif /* TOPPERS_kmemstat */
