﻿//------------------------------------------------------------------------------
// Embedded Software Simulation Base Classes
// Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: ControlWrapper.cs 88 2011-04-05 11:03:57Z nagasima $
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SimBase;

namespace NU.OJL.MPRTOS.TLV.Third
{
	public class ControlWrapper : IControlWrapper
	{
		Control m_Control;

		public ControlWrapper(Control control)
		{
			m_Control = control;
		}

		public object Control
		{
			get { return m_Control; }
		}

		public IControlWrapper this[string key]
		{
			get
			{
				Control[] controls = m_Control.Controls.Find(key, true);

				if ((controls == null) || (controls.Length != 1))
					throw new IndexOutOfRangeException(key + "コントロールが見つかりません。");

				return new ControlWrapper(controls[0]);
			}
		}

		public void Click()
		{
			if (m_Control is Button)
			{
				((Button)m_Control).PerformClick();
			}
			else if (m_Control is RadioButton)
			{
				RadioButton radioButton = (RadioButton)m_Control;
				radioButton.Checked = !radioButton.Checked;
				radioButton.PerformClick();
			}
			else if (m_Control is CheckBox)
			{
				CheckBox checkBox = (CheckBox)m_Control;
				checkBox.Checked = !checkBox.Checked;
			}
			else
			{
				throw new InvalidOperationException();
			}
		}

		public string Text
		{
			get { return m_Control.Text; }
			set { m_Control.Text = value; }
		}

		public void Select(int index)
		{
			if (m_Control is ComboBox)
			{
				((ComboBox)m_Control).SelectedIndex = index;
			}
			else if (m_Control is TabControl)
			{
				((TabControl)m_Control).SelectedIndex = index;
			}
			else
			{
				throw new InvalidOperationException();
			}
		}

		public void Select(string text)
		{
			if (m_Control is ComboBox)
			{
				((ComboBox)m_Control).SelectedText = text;
			}
			else if (m_Control is TabControl)
			{
				foreach (TabPage page in ((TabControl)m_Control).TabPages)
				{
					if (page.Text == text)
					{
						((TabControl)m_Control).SelectedTab = page;
						break;
					}
				}
			}
			else
			{
				throw new InvalidOperationException();
			}
		}

		public bool Checked
		{
			get
			{
				if (m_Control is CheckBox)
				{
					return ((CheckBox)m_Control).Checked;
				}
				else if (m_Control is RadioButton)
				{
					return ((RadioButton)m_Control).Checked;
				}
				else
				{
					throw new InvalidOperationException();
				}
			}
			set
			{
				if (m_Control is CheckBox)
				{
					((CheckBox)m_Control).Checked = value;
				}
				else if (m_Control is RadioButton)
				{
					((RadioButton)m_Control).Checked = value;
				}
				else
				{
					throw new InvalidOperationException();
				}
			}
		}

		public int SelectedIndex
		{
			get
			{
				if (m_Control is ComboBox)
				{
					return ((ComboBox)m_Control).SelectedIndex;
				}
				else if (m_Control is TabControl)
				{
					return ((TabControl)m_Control).SelectedIndex;
				}
				else
				{
					throw new InvalidOperationException();
				}
			}
			set
			{
				if (m_Control is ComboBox)
				{
					((ComboBox)m_Control).SelectedIndex = value;
				}
				else if (m_Control is TabControl)
				{
					((TabControl)m_Control).SelectedIndex = value;
				}
				else
				{
					throw new InvalidOperationException();
				}
			}
		}

		public int Value
		{
			get
			{
				if (m_Control is TrackBar)
				{
					return ((TrackBar)m_Control).Value;
				}
				else if (m_Control is NumericUpDown)
				{
					return (int)((NumericUpDown)m_Control).Value;
				}
				else
				{
					throw new InvalidOperationException();
				}
			}
			set
			{
				if (m_Control is TrackBar)
				{
					((TrackBar)m_Control).Value = value;
				}
				else if (m_Control is NumericUpDown)
				{
					((NumericUpDown)m_Control).Value = value;
				}
				else
				{
					throw new InvalidOperationException();
				}
			}
		}
	}
}
