/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id$
*******************************************************************************/

#ifndef H_LOADED_DLG_PROCESS
#define H_LOADED_DLG_PROCESS
#ifdef __WINDOWS__
#include <Shobjidl.h>
#endif

class ProcessDialog: public wxDialog {
public:
    void OnInit(wxInitDialogEvent &);
	void OnClose(wxCloseEvent &);
	int CallbackProc(unsigned int, void *);

	ProcessDialog(wxWindow * parent, wxULongLong_t n = 0, wxString szPassword = wxEmptyString);
	~ProcessDialog();

	wxULongLong_t nFileCount;
	wxString szPassword;

	DECLARE_EVENT_TABLE()

private:
	bool fCancel, fOpen;
	int nOverwriteMode;
	wxFileName fnFormer;
	wxTextCtrl* ebTarget;
	wxTextCtrl* ebSource;
	wxGauge* gFile;
	wxGauge* gArchive;
	wxWindow* hParent;
#ifdef __WINDOWS__
	HWND hTBWnd;
	ITaskbarList3 * tlTaskbar;
#endif
};

extern ProcessDialog * g_procDlg;

class OverwriteDialog: public wxDialog {
public:
    void OnInit(wxInitDialogEvent &);
	void OnClose(wxCloseEvent &);
    void OnBtnOverwrite(wxCommandEvent&);
    void OnBtnSkip(     wxCommandEvent&);
    void OnBtnAuto(     wxCommandEvent&);
    void OnBtnBrowse(   wxCommandEvent&);

	OverwriteDialog();

	wxFileName * fnExist;
	wxDateTime * tmWrite;
	wxULongLong_t nWriteSize;
	wxCheckBox* cbApplyAll;

	DECLARE_EVENT_TABLE()

private:
	wxTextCtrl* ebTarget;
};

//******************************************************************************
//    プロシージャ
//******************************************************************************

int __stdcall TPICallbackProc(unsigned int, void *);

#endif
