/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id$
*******************************************************************************/

#include "lychee.h"
#include "frm_main.h"

//******************************************************************************
// Lychee
//******************************************************************************

IMPLEMENT_APP(Lychee)

bool Lychee::OnInit()
{
	wxInitAllImageHandlers();
	::wxXmlResource::Get()->InitAllHandlers();

	// 作業パスを設定。
	wxString szCwd;
	{
		wxChar cSep = wxFileName::GetPathSeparator();
		szCwd = ::wxGetCwd() + cSep;
		::wxSetWorkingDirectory(::wxPathOnly(wxStandardPaths::Get().GetExecutablePath()) + cSep);
	}

	// 言語ファイルのパスを指定。
	this->lc.AddCatalogLookupPathPrefix(L_DIR_S_LOC);
	this->lc.AddCatalog(wxT("lychee"));

	auto frm_main = new MainFrame();
	if (! ::wxXmlResource::Get()->Load(L_DIR_S_XRC wxT("frm_main.xrc")))
	{
		wxLogError(_("Unable to find XRC!"));
		return false;
	}

	::wxXmlResource::Get()->LoadFrame(frm_main, nullptr, wxT("frame_main"));
	::wxXmlResource::Get()->Unload(L_DIR_S_XRC wxT("frm_main.xrc"));
	frm_main->InitDialog();

	// コマンドライン読み込み。
	if (this->argc < 2)
	{
		// コマンドラインがなければウインドウを表示。
		frm_main->Show();
		return true;
	}

	// 書庫を開く。
	auto e = new wxCommandEvent(wxEVT_COMMAND_MENU_SELECTED, XRCID("Arc_Open"));
	e->SetInt(1);
	frm_main->fnArchive = wxFileName(wxString(this->argv[1]));
	frm_main->fnArchive.Normalize(wxPATH_NORM_ALL, szCwd);
#if wxCHECK_VERSION(2, 9, 0)
	frm_main->GetEventHandler()->QueueEvent(e);
#else
	frm_main->OnArcOpen(* e);
	delete e;
#endif
	return true;
}
