/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import java.io.Serializable;
import java.util.List;
import org.afree.chart.axis.AxisSpace;
import org.afree.chart.axis.AxisState;
import org.afree.chart.entity.AxisEntity;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.text.TextUtilities;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;
import org.afree.ui.TextAnchor;

public abstract class Axis
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7719289504573298271L;
    public static final boolean DEFAULT_AXIS_VISIBLE = true;
    public static final Font DEFAULT_AXIS_LABEL_FONT = new Font("SansSerif", 1, 12);
    public static final PaintType DEFAULT_AXIS_LABEL_PAINT_TYPE = new SolidColor(-16777216);
    public static final RectangleInsets DEFAULT_AXIS_LABEL_INSETS = new RectangleInsets(3.0, 3.0, 3.0, 3.0);
    public static final PaintType DEFAULT_AXIS_LINE_PAINT_TYPE = new SolidColor(-12303292);
    public static final float DEFAULT_AXIS_LINE_STROKE = 1.0f;
    public static final PathEffect DEFAULT_AXIS_LINE_EFFECT = null;
    public static final boolean DEFAULT_TICK_LABELS_VISIBLE = true;
    public static final Font DEFAULT_TICK_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final PaintType DEFAULT_TICK_LABEL_PAINT_TYPE = new SolidColor(-12303292);
    public static final RectangleInsets DEFAULT_TICK_LABEL_INSETS = new RectangleInsets(2.0, 4.0, 2.0, 4.0);
    public static final boolean DEFAULT_TICK_MARKS_VISIBLE = true;
    public static final int DEFAULT_TICK_MARK_STROKE = 1;
    public static final PaintType DEFAULT_TICK_MARK_PAINT = new SolidColor(-12303292);
    public static final PathEffect DEFAULT_TICK_MARK_EFFECT = null;
    public static final float DEFAULT_TICK_MARK_INSIDE_LENGTH = 0.0f;
    public static final float DEFAULT_TICK_MARK_OUTSIDE_LENGTH = 2.0f;
    private boolean visible;
    private String label;
    private Font labelFont;
    private transient PaintType labelPaintType;
    private RectangleInsets labelInsets;
    private double labelAngle;
    private boolean axisLineVisible;
    private transient float axisLineStroke;
    private transient PathEffect axisLineEffect;
    private transient PaintType axisLinePaintType;
    private boolean tickLabelsVisible;
    private Font tickLabelFont;
    private transient PaintType tickLabelPaintType;
    private RectangleInsets tickLabelInsets;
    private boolean tickMarksVisible;
    private float tickMarkInsideLength;
    private float tickMarkOutsideLength;
    private boolean minorTickMarksVisible;
    private float minorTickMarkInsideLength;
    private float minorTickMarkOutsideLength;
    private transient int tickMarkStroke;
    private transient PaintType tickMarkPaintType;
    private transient PathEffect tickMarkEffect;
    private double fixedDimension;
    private transient Plot plot;

    protected Axis(String label) {
        this.label = label;
        this.visible = true;
        this.labelFont = DEFAULT_AXIS_LABEL_FONT;
        this.labelPaintType = DEFAULT_AXIS_LABEL_PAINT_TYPE;
        this.labelInsets = DEFAULT_AXIS_LABEL_INSETS;
        this.labelAngle = 0.0;
        this.axisLineVisible = true;
        this.axisLinePaintType = DEFAULT_AXIS_LINE_PAINT_TYPE;
        this.axisLineStroke = 1.0f;
        this.axisLineEffect = DEFAULT_AXIS_LINE_EFFECT;
        this.tickLabelsVisible = true;
        this.tickLabelFont = DEFAULT_TICK_LABEL_FONT;
        this.tickLabelPaintType = DEFAULT_TICK_LABEL_PAINT_TYPE;
        this.tickLabelInsets = DEFAULT_TICK_LABEL_INSETS;
        this.tickMarksVisible = true;
        this.tickMarkStroke = 1;
        this.tickMarkPaintType = DEFAULT_TICK_MARK_PAINT;
        this.tickMarkEffect = DEFAULT_TICK_MARK_EFFECT;
        this.tickMarkInsideLength = 0.0f;
        this.tickMarkOutsideLength = 2.0f;
        this.minorTickMarksVisible = false;
        this.minorTickMarkInsideLength = 0.0f;
        this.minorTickMarkOutsideLength = 2.0f;
        this.plot = null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean flag) {
        if (flag != this.visible) {
            this.visible = flag;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        String existing = this.label;
        if (existing != null) {
            if (!existing.equals(label)) {
                this.label = label;
            }
        } else if (label != null) {
            this.label = label;
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
        }
    }

    public PaintType getLabelPaintType() {
        return this.labelPaintType;
    }

    public void setLabelPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaintType = paintType;
    }

    public RectangleInsets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(RectangleInsets insets) {
        this.setLabelInsets(insets, true);
    }

    public void setLabelInsets(RectangleInsets insets, boolean notify) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        if (!insets.equals(this.labelInsets)) {
            this.labelInsets = insets;
        }
    }

    public double getLabelAngle() {
        return this.labelAngle;
    }

    public void setLabelAngle(double angle) {
        this.labelAngle = angle;
    }

    public boolean isAxisLineVisible() {
        return this.axisLineVisible;
    }

    public void setAxisLineVisible(boolean visible) {
        this.axisLineVisible = visible;
    }

    public PaintType getAxisLinePaintType() {
        return this.axisLinePaintType;
    }

    public void setAxisLinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.axisLinePaintType = paintType;
    }

    public float getAxisLineStroke() {
        return this.axisLineStroke;
    }

    public void setAxisLineStroke(float stroke) {
        this.axisLineStroke = stroke;
    }

    public PathEffect getAxisLineEffect() {
        return this.axisLineEffect;
    }

    public void setAxisLineEffect(PathEffect pathEffect) {
        this.axisLineEffect = pathEffect;
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean flag) {
        if (flag != this.tickLabelsVisible) {
            this.tickLabelsVisible = flag;
        }
    }

    public boolean isMinorTickMarksVisible() {
        return this.minorTickMarksVisible;
    }

    public void setMinorTickMarksVisible(boolean flag) {
        if (flag != this.minorTickMarksVisible) {
            this.minorTickMarksVisible = flag;
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
        }
    }

    public PaintType getTickLabelPaintType() {
        return this.tickLabelPaintType;
    }

    public void setTickLabelPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.tickLabelPaintType = paintType;
    }

    public RectangleInsets getTickLabelInsets() {
        return this.tickLabelInsets;
    }

    public void setTickLabelInsets(RectangleInsets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        if (!this.tickLabelInsets.equals(insets)) {
            this.tickLabelInsets = insets;
        }
    }

    public boolean isTickMarksVisible() {
        return this.tickMarksVisible;
    }

    public void setTickMarksVisible(boolean flag) {
        if (flag != this.tickMarksVisible) {
            this.tickMarksVisible = flag;
        }
    }

    public float getTickMarkInsideLength() {
        return this.tickMarkInsideLength;
    }

    public void setTickMarkInsideLength(float length) {
        this.tickMarkInsideLength = length;
    }

    public float getTickMarkOutsideLength() {
        return this.tickMarkOutsideLength;
    }

    public void setTickMarkOutsideLength(float length) {
        this.tickMarkOutsideLength = length;
    }

    public int getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(int stroke) {
        this.tickMarkStroke = stroke;
    }

    public PathEffect getTickMarkEffect() {
        return this.tickMarkEffect;
    }

    public void setTickMarkEffect(PathEffect pathEffect) {
        this.tickMarkEffect = pathEffect;
    }

    public PaintType getTickMarkPaintType() {
        return this.tickMarkPaintType;
    }

    public void setTickMarkPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.tickMarkPaintType = paintType;
    }

    public float getMinorTickMarkInsideLength() {
        return this.minorTickMarkInsideLength;
    }

    public void setMinorTickMarkInsideLength(float length) {
        this.minorTickMarkInsideLength = length;
    }

    public float getMinorTickMarkOutsideLength() {
        return this.minorTickMarkOutsideLength;
    }

    public void setMinorTickMarkOutsideLength(float length) {
        this.minorTickMarkOutsideLength = length;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
        this.configure();
    }

    public double getFixedDimension() {
        return this.fixedDimension;
    }

    public void setFixedDimension(double dimension) {
        this.fixedDimension = dimension;
    }

    public abstract void configure();

    public abstract AxisSpace reserveSpace(Canvas var1, Plot var2, RectShape var3, RectangleEdge var4, AxisSpace var5);

    public abstract AxisState draw(Canvas var1, double var2, RectShape var4, RectShape var5, RectangleEdge var6, PlotRenderingInfo var7);

    public abstract List refreshTicks(Canvas var1, AxisState var2, RectShape var3, RectangleEdge var4);

    protected void createAndAddEntity(double cursor, AxisState state, RectShape dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        if (plotState == null || plotState.getOwner() == null) {
            return;
        }
        RectShape hotspot = null;
        if (edge.equals(RectangleEdge.TOP)) {
            hotspot = new RectShape((double)dataArea.getX(), state.getCursor(), (double)dataArea.getWidth(), cursor - state.getCursor());
        } else if (edge.equals(RectangleEdge.BOTTOM)) {
            hotspot = new RectShape((double)dataArea.getX(), cursor, (double)dataArea.getWidth(), state.getCursor() - cursor);
        } else if (edge.equals(RectangleEdge.LEFT)) {
            hotspot = new RectShape(state.getCursor(), (double)dataArea.getY(), cursor - state.getCursor(), (double)dataArea.getHeight());
        } else if (edge.equals(RectangleEdge.RIGHT)) {
            hotspot = new RectShape(cursor, (double)dataArea.getY(), state.getCursor() - cursor, (double)dataArea.getHeight());
        }
        EntityCollection e = plotState.getOwner().getEntityCollection();
        if (e != null) {
            e.add(new AxisEntity((Shape)hotspot, this));
        }
    }

    protected RectShape getLabelEnclosure(Canvas canvas, RectangleEdge edge) {
        RectShape result = new RectShape();
        String axisLabel = this.getLabel();
        if (axisLabel != null && !axisLabel.equals("")) {
            Paint paint = PaintUtility.createPaint(1, this.labelPaintType, this.labelFont);
            RectShape bounds = TextUtilities.getTextBounds(axisLabel, paint);
            RectangleInsets insets = this.getLabelInsets();
            bounds = insets.createOutsetRectangle(bounds);
            double angle = this.getLabelAngle();
            if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
                angle -= 90.0;
            }
            float x = bounds.getCenterX();
            float y = bounds.getCenterY();
            Matrix mat = new Matrix();
            mat.postRotate((float)angle, x, y);
            Path p = new Path(bounds.getPath());
            p.transform(mat);
            RectF rect = new RectF();
            p.computeBounds(rect, false);
            result = new RectShape(rect);
        }
        return result;
    }

    protected AxisState drawLabel(String label, Canvas canvas, RectShape plotArea, RectShape dataArea, RectangleEdge edge, AxisState state) {
        if (state == null) {
            throw new IllegalArgumentException("Null 'state' argument.");
        }
        if (label == null || label.equals("")) {
            return state;
        }
        Paint paint = PaintUtility.createPaint(1, this.labelPaintType, this.labelFont);
        RectShape labelBounds = TextUtilities.getTextBounds(label, paint);
        RectangleInsets insets = this.getLabelInsets();
        if (edge == RectangleEdge.TOP) {
            Matrix mat = new Matrix();
            mat.postRotate((float)this.getLabelAngle(), labelBounds.getCenterX(), labelBounds.getCenterY());
            Path tmpPath = new Path();
            tmpPath.addPath(labelBounds.getPath(), mat);
            RectF rect = new RectF();
            tmpPath.computeBounds(rect, false);
            labelBounds = new RectShape(rect);
            double labelx = dataArea.getCenterX();
            double labely = state.getCursor() - insets.getBottom() - (double)labelBounds.getHeight() / 2.0;
            TextUtilities.drawRotatedString(label, canvas, (float)labelx, (float)labely, TextAnchor.CENTER, Math.toRadians(this.getLabelAngle()), TextAnchor.CENTER, paint);
            state.cursorUp(insets.getTop() + (double)labelBounds.getHeight() + insets.getBottom());
        } else if (edge == RectangleEdge.BOTTOM) {
            Matrix mat = new Matrix();
            mat.postRotate((float)this.getLabelAngle(), labelBounds.getCenterX(), labelBounds.getCenterY());
            Path tmpPath = new Path();
            tmpPath.addPath(labelBounds.getPath(), mat);
            RectF rect = new RectF();
            tmpPath.computeBounds(rect, false);
            labelBounds = new RectShape(rect);
            double labelx = dataArea.getCenterX();
            double labely = state.getCursor() + insets.getTop() + (double)labelBounds.getHeight() / 2.0;
            TextUtilities.drawRotatedString(label, canvas, (float)labelx, (float)labely, TextAnchor.CENTER, Math.toRadians(this.getLabelAngle()), TextAnchor.CENTER, paint);
            state.cursorDown(insets.getTop() + (double)labelBounds.getHeight() + insets.getBottom());
        } else if (edge == RectangleEdge.LEFT) {
            Matrix mat = new Matrix();
            mat.postRotate((float)(this.getLabelAngle() - 90.0), labelBounds.getCenterX(), labelBounds.getCenterY());
            Path tmpPath = new Path();
            tmpPath.addPath(labelBounds.getPath(), mat);
            RectF rect = new RectF();
            tmpPath.computeBounds(rect, false);
            labelBounds = new RectShape(rect);
            double labelx = state.getCursor() - insets.getRight() - (double)labelBounds.getWidth() / 2.0;
            double labely = dataArea.getCenterY();
            TextUtilities.drawRotatedString(label, canvas, (float)labelx, (float)labely, TextAnchor.CENTER, Math.toRadians(this.getLabelAngle() - 90.0), TextAnchor.CENTER, paint);
            state.cursorLeft(insets.getLeft() + (double)labelBounds.getWidth() + insets.getRight());
        } else if (edge == RectangleEdge.RIGHT) {
            Matrix mat = new Matrix();
            mat.postRotate((float)(this.getLabelAngle() + 90.0), labelBounds.getCenterX(), labelBounds.getCenterY());
            Path tmpPath = new Path();
            tmpPath.addPath(labelBounds.getPath(), mat);
            RectF rect = new RectF();
            tmpPath.computeBounds(rect, false);
            labelBounds = new RectShape(rect);
            double labelx = state.getCursor() + insets.getLeft() + (double)labelBounds.getWidth() / 2.0;
            double labely = (double)dataArea.getY() + (double)dataArea.getHeight() / 2.0;
            TextUtilities.drawRotatedString(label, canvas, (float)labelx, (float)labely, TextAnchor.CENTER, Math.toRadians(this.getLabelAngle() + 90.0), TextAnchor.CENTER, paint);
            state.cursorRight(insets.getLeft() + (double)labelBounds.getWidth() + insets.getRight());
        }
        return state;
    }

    protected void drawAxisLine(Canvas canvas, double cursor, RectShape dataArea, RectangleEdge edge) {
        LineShape axisLine = null;
        if (edge == RectangleEdge.TOP) {
            axisLine = new LineShape(dataArea.getX(), (float)cursor, dataArea.getMaxX(), (float)cursor);
        } else if (edge == RectangleEdge.BOTTOM) {
            axisLine = new LineShape(dataArea.getX(), (float)cursor, dataArea.getMaxX(), (float)cursor);
        } else if (edge == RectangleEdge.LEFT) {
            axisLine = new LineShape((float)cursor, dataArea.getY(), (float)cursor, dataArea.getMaxY());
        } else if (edge == RectangleEdge.RIGHT) {
            axisLine = new LineShape((float)cursor, dataArea.getY(), (float)cursor, dataArea.getMaxY());
        }
        Paint paint = PaintUtility.createPaint(this.axisLinePaintType, this.axisLineStroke, this.axisLineEffect);
        axisLine.draw(canvas, paint);
    }
}

