/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.demo;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartHierarchyActivity
extends ListActivity {
    private final String TARGET_PACKAGE_NAME = "org.afree";
    public static final String CTEGORY_NAME = "org.afree.chart.demo";
    private static final Comparator<Map> sDisplayNameComparator = new Comparator<Map>(){
        private final Collator collator = Collator.getInstance();

        @Override
        public int compare(Map map1, Map map2) {
            return this.collator.compare(map1.get("title"), map2.get("title"));
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        String path = intent.getStringExtra("org.afree.demo.Path");
        if (path == null) {
            path = "";
        }
        this.setListAdapter((ListAdapter)new SimpleAdapter((Context)this, this.getData(path), 17367043, new String[]{"title"}, new int[]{16908308}));
        this.getListView().setTextFilterEnabled(true);
    }

    protected List getData(String prefix) {
        ArrayList<Map> myData = new ArrayList<Map>();
        Intent mainIntent = new Intent("android.intent.action.MAIN", null);
        mainIntent.addCategory(CTEGORY_NAME);
        PackageManager pm = this.getPackageManager();
        List list = pm.queryIntentActivities(mainIntent, 0);
        if (list == null) {
            return myData;
        }
        String[] prefixPath = prefix.equals("") ? (String[])null : prefix.split("/");
        int len = list.size();
        HashMap<String, Boolean> entries = new HashMap<String, Boolean>();
        int i = 0;
        while (i < len) {
            ResolveInfo info = (ResolveInfo)list.get(i);
            if (info.activityInfo.applicationInfo.packageName.equals("org.afree")) {
                String label;
                CharSequence labelSeq = info.loadLabel(pm);
                String string = label = labelSeq != null ? labelSeq.toString() : info.activityInfo.name;
                if (prefix.length() == 0 || label.startsWith(prefix)) {
                    String[] labelPath = label.split("/");
                    String nextLabel = prefixPath == null ? labelPath[0] : labelPath[prefixPath.length];
                    if ((prefixPath != null ? prefixPath.length : 0) == labelPath.length - 1) {
                        this.addItem(myData, nextLabel, this.activityIntent(info.activityInfo.applicationInfo.packageName, info.activityInfo.name));
                    } else if (entries.get(nextLabel) == null) {
                        this.addItem(myData, nextLabel, this.browseIntent(prefix.equals("") ? nextLabel : String.valueOf(prefix) + "/" + nextLabel));
                        entries.put(nextLabel, true);
                    }
                }
            }
            ++i;
        }
        Collections.sort(myData, sDisplayNameComparator);
        return myData;
    }

    protected Intent activityIntent(String pkg, String componentName) {
        Intent result = new Intent();
        result.setClassName(pkg, componentName);
        return result;
    }

    protected Intent browseIntent(String path) {
        Intent result = new Intent();
        result.setClass((Context)this, ChartHierarchyActivity.class);
        result.putExtra("org.afree.demo.Path", path);
        return result;
    }

    protected void addItem(List<Map> data, String name, Intent intent) {
        HashMap<String, String> temp = new HashMap<String, String>();
        temp.put("title", name);
        temp.put("intent", (String)intent);
        data.add(temp);
    }

    protected void onListItemClick(ListView l, View v, int position, long id) {
        Map map = (Map)l.getItemAtPosition(position);
        Intent intent = (Intent)map.get("intent");
        this.startActivity(intent);
    }
}

