/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.demo.view;

import android.content.Context;
import java.text.SimpleDateFormat;
import org.afree.chart.AFreeChart;
import org.afree.chart.ChartFactory;
import org.afree.chart.axis.DateAxis;
import org.afree.chart.demo.DemoView;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.afree.data.time.Month;
import org.afree.data.time.RegularTimePeriod;
import org.afree.data.time.TimeSeries;
import org.afree.data.time.TimeSeriesCollection;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.SolidColor;
import org.afree.ui.RectangleInsets;

public class TimeSeriesChartDemo1View
extends DemoView {
    public TimeSeriesChartDemo1View(Context context) {
        super(context);
        AFreeChart chart = TimeSeriesChartDemo1View.createChart(TimeSeriesChartDemo1View.createDataset());
        this.setChart(chart);
    }

    private static AFreeChart createChart(XYDataset dataset) {
        AFreeChart chart = ChartFactory.createTimeSeriesChart("Legal & General Unit Trust Prices", "Date", "Price Per Unit", dataset, true, true, false);
        chart.setBackgroundPaintType(new SolidColor(-1));
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaintType(new SolidColor(-3355444));
        plot.setDomainGridlinePaintType(new SolidColor(-1));
        plot.setRangeGridlinePaintType(new SolidColor(-1));
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            renderer.setDrawSeriesLineAsPath(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(new SimpleDateFormat("MMM-yyyy"));
        return chart;
    }

    private static XYDataset createDataset() {
        TimeSeries s1 = new TimeSeries((Comparable)((Object)"L&G European Index Trust"));
        s1.add((RegularTimePeriod)new Month(2, 2001), 181.8);
        s1.add((RegularTimePeriod)new Month(3, 2001), 167.3);
        s1.add((RegularTimePeriod)new Month(4, 2001), 153.8);
        s1.add((RegularTimePeriod)new Month(5, 2001), 167.6);
        s1.add((RegularTimePeriod)new Month(6, 2001), 158.8);
        s1.add((RegularTimePeriod)new Month(7, 2001), 148.3);
        s1.add((RegularTimePeriod)new Month(8, 2001), 153.9);
        s1.add((RegularTimePeriod)new Month(9, 2001), 142.7);
        s1.add((RegularTimePeriod)new Month(10, 2001), 123.2);
        s1.add((RegularTimePeriod)new Month(11, 2001), 131.8);
        s1.add((RegularTimePeriod)new Month(12, 2001), 139.6);
        s1.add((RegularTimePeriod)new Month(1, 2002), 142.9);
        s1.add((RegularTimePeriod)new Month(2, 2002), 138.7);
        s1.add((RegularTimePeriod)new Month(3, 2002), 137.3);
        s1.add((RegularTimePeriod)new Month(4, 2002), 143.9);
        s1.add((RegularTimePeriod)new Month(5, 2002), 139.8);
        s1.add((RegularTimePeriod)new Month(6, 2002), 137.0);
        s1.add((RegularTimePeriod)new Month(7, 2002), 132.8);
        TimeSeries s2 = new TimeSeries((Comparable)((Object)"L&G UK Index Trust"));
        s2.add((RegularTimePeriod)new Month(2, 2001), 129.6);
        s2.add((RegularTimePeriod)new Month(3, 2001), 123.2);
        s2.add((RegularTimePeriod)new Month(4, 2001), 117.2);
        s2.add((RegularTimePeriod)new Month(5, 2001), 124.1);
        s2.add((RegularTimePeriod)new Month(6, 2001), 122.6);
        s2.add((RegularTimePeriod)new Month(7, 2001), 119.2);
        s2.add((RegularTimePeriod)new Month(8, 2001), 116.5);
        s2.add((RegularTimePeriod)new Month(9, 2001), 112.7);
        s2.add((RegularTimePeriod)new Month(10, 2001), 101.5);
        s2.add((RegularTimePeriod)new Month(11, 2001), 106.1);
        s2.add((RegularTimePeriod)new Month(12, 2001), 110.3);
        s2.add((RegularTimePeriod)new Month(1, 2002), 111.7);
        s2.add((RegularTimePeriod)new Month(2, 2002), 111.0);
        s2.add((RegularTimePeriod)new Month(3, 2002), 109.6);
        s2.add((RegularTimePeriod)new Month(4, 2002), 113.2);
        s2.add((RegularTimePeriod)new Month(5, 2002), 111.6);
        s2.add((RegularTimePeriod)new Month(6, 2002), 108.8);
        s2.add((RegularTimePeriod)new Month(7, 2002), 101.6);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }
}

