/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.entity;

import java.io.Serializable;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.util.ObjectUtilities;

public class ChartEntity
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4445994133561919083L;
    private transient Shape area;
    private String toolTipText;
    private String urlText;

    public ChartEntity(Shape area) {
        this(area, null);
    }

    public ChartEntity(Shape area, String toolTipText) {
        this(area, toolTipText, null);
    }

    public ChartEntity(Shape area, String toolTipText, String urlText) {
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = area;
        this.toolTipText = toolTipText;
        this.urlText = urlText;
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Shape area) {
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = area;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String text) {
        this.urlText = text;
    }

    public String getShapeType() {
        if (this.area instanceof RectShape) {
            return "rect";
        }
        return "poly";
    }

    public String getShapeCoords() {
        if (this.area instanceof RectShape) {
            return this.getRectCoords((RectShape)this.area);
        }
        return this.getPolyCoords(this.area);
    }

    private String getRectCoords(RectShape RectShape2) {
        if (RectShape2 == null) {
            throw new IllegalArgumentException("Null 'RectShape' argument.");
        }
        int x1 = (int)RectShape2.getX();
        int y1 = (int)RectShape2.getY();
        int x2 = x1 + (int)RectShape2.getWidth();
        int y2 = y1 + (int)RectShape2.getHeight();
        if (x2 == x1) {
            ++x2;
        }
        if (y2 == y1) {
            ++y2;
        }
        return String.valueOf(x1) + "," + y1 + "," + x2 + "," + y2;
    }

    private String getPolyCoords(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        StringBuffer result = new StringBuffer();
        return result.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ChartEntity: ");
        buf.append("tooltip = ");
        buf.append(this.toolTipText);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChartEntity)) {
            return false;
        }
        ChartEntity that = (ChartEntity)obj;
        if (!this.area.equals(that.area)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipText, that.toolTipText)) {
            return false;
        }
        return ObjectUtilities.equal(this.urlText, that.urlText);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

