/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.category;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import java.io.Serializable;
import org.afree.chart.LegendItem;
import org.afree.chart.axis.CategoryAxis;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.event.RendererChangeListener;
import org.afree.chart.labels.CategoryItemLabelGenerator;
import org.afree.chart.labels.ItemLabelAnchor;
import org.afree.chart.labels.ItemLabelPosition;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.afree.chart.renderer.category.BarPainter;
import org.afree.chart.renderer.category.CategoryItemRendererState;
import org.afree.chart.renderer.category.GradientBarPainter;
import org.afree.chart.text.TextUtilities;
import org.afree.data.Range;
import org.afree.data.category.CategoryDataset;
import org.afree.data.general.DatasetUtilities;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.GradientShaderFactory;
import org.afree.ui.RectangleEdge;
import org.afree.ui.StandardGradientShaderFactory;
import org.afree.util.ShapeUtilities;

public class BarRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6000649414965887481L;
    public static final double DEFAULT_ITEM_MARGIN = 0.2;
    public static final double BAR_OUTLINE_WIDTH_THRESHOLD = 3.0;
    private static BarPainter defaultBarPainter = new GradientBarPainter();
    private static boolean defaultShadowsVisible = true;
    private double itemMargin = 0.2;
    private boolean drawBarOutline = false;
    private double maximumBarWidth = 1.0;
    private double minimumBarLength = 0.0;
    private GradientShaderFactory gradientPaintTransformer = new StandardGradientShaderFactory();
    private ItemLabelPosition positiveItemLabelPositionFallback = null;
    private ItemLabelPosition negativeItemLabelPositionFallback = null;
    private double upperClip;
    private double lowerClip;
    private double base = 0.0;
    private boolean includeBaseInRange = true;
    private BarPainter barPainter;
    private boolean shadowsVisible;
    private transient PaintType shadowPaintType;
    private double shadowXOffset;
    private double shadowYOffset;

    public static BarPainter getDefaultBarPainter() {
        return defaultBarPainter;
    }

    public static void setDefaultBarPainter(BarPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        defaultBarPainter = painter;
    }

    public static boolean getDefaultShadowsVisible() {
        return defaultShadowsVisible;
    }

    public static void setDefaultShadowsVisible(boolean visible) {
        defaultShadowsVisible = visible;
    }

    public BarRenderer() {
        this.setBaseLegendShape(new RectShape(-4.0, -4.0, 8.0, 8.0));
        this.barPainter = BarRenderer.getDefaultBarPainter();
        this.shadowsVisible = BarRenderer.getDefaultShadowsVisible();
        this.shadowPaintType = new SolidColor(-7829368);
        this.shadowXOffset = 4.0;
        this.shadowYOffset = 4.0;
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double percent) {
        this.itemMargin = percent;
    }

    public boolean isDrawBarOutline() {
        return this.drawBarOutline;
    }

    public void setDrawBarOutline(boolean draw) {
        this.drawBarOutline = draw;
    }

    public double getMaximumBarWidth() {
        return this.maximumBarWidth;
    }

    public void setMaximumBarWidth(double percent) {
        this.maximumBarWidth = percent;
    }

    public double getMinimumBarLength() {
        return this.minimumBarLength;
    }

    public void setMinimumBarLength(double min) {
        if (min < 0.0) {
            throw new IllegalArgumentException("Requires 'min' >= 0.0");
        }
        this.minimumBarLength = min;
    }

    public GradientShaderFactory getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientShaderFactory(GradientShaderFactory transformer) {
        this.gradientPaintTransformer = transformer;
    }

    public ItemLabelPosition getPositiveItemLabelPositionFallback() {
        return this.positiveItemLabelPositionFallback;
    }

    public void setPositiveItemLabelPositionFallback(ItemLabelPosition position) {
        this.positiveItemLabelPositionFallback = position;
    }

    public ItemLabelPosition getNegativeItemLabelPositionFallback() {
        return this.negativeItemLabelPositionFallback;
    }

    public void setNegativeItemLabelPositionFallback(ItemLabelPosition position) {
        this.negativeItemLabelPositionFallback = position;
    }

    public boolean getIncludeBaseInRange() {
        return this.includeBaseInRange;
    }

    public void setIncludeBaseInRange(boolean include) {
        if (this.includeBaseInRange != include) {
            this.includeBaseInRange = include;
        }
    }

    public BarPainter getBarPainter() {
        return this.barPainter;
    }

    public void setBarPainter(BarPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        this.barPainter = painter;
    }

    public boolean getShadowsVisible() {
        return this.shadowsVisible;
    }

    public void setShadowVisible(boolean visible) {
        this.shadowsVisible = visible;
    }

    public PaintType getShadowPaintType() {
        return this.shadowPaintType;
    }

    public void setShadowPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.shadowPaintType = paintType;
    }

    public double getShadowXOffset() {
        return this.shadowXOffset;
    }

    public void setShadowXOffset(double offset) {
        this.shadowXOffset = offset;
    }

    public double getShadowYOffset() {
        return this.shadowYOffset;
    }

    public void setShadowYOffset(double offset) {
        this.shadowYOffset = offset;
    }

    public double getLowerClip() {
        return this.lowerClip;
    }

    public double getUpperClip() {
        return this.upperClip;
    }

    public CategoryItemRendererState initialise(Canvas canvas, RectShape dataArea, CategoryPlot plot, int rendererIndex, PlotRenderingInfo info) {
        CategoryItemRendererState state = super.initialise(canvas, dataArea, plot, rendererIndex, info);
        ValueAxis rangeAxis = plot.getRangeAxisForDataset(rendererIndex);
        this.lowerClip = rangeAxis.getRange().getLowerBound();
        this.upperClip = rangeAxis.getRange().getUpperBound();
        this.calculateBarWidth(plot, dataArea, rendererIndex, state);
        return state;
    }

    protected void calculateBarWidth(CategoryPlot plot, RectShape dataArea, int rendererIndex, CategoryItemRendererState state) {
        CategoryAxis domainAxis = this.getDomainAxis(plot, rendererIndex);
        CategoryDataset dataset = plot.getDataset(rendererIndex);
        if (dataset != null) {
            int columns = dataset.getColumnCount();
            int rows = state.getVisibleSeriesCount() >= 0 ? state.getVisibleSeriesCount() : dataset.getRowCount();
            double space = 0.0;
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                space = dataArea.getHeight();
            } else if (orientation == PlotOrientation.VERTICAL) {
                space = dataArea.getWidth();
            }
            double maxWidth = space * this.getMaximumBarWidth();
            double categoryMargin = 0.0;
            double currentItemMargin = 0.0;
            if (columns > 1) {
                categoryMargin = domainAxis.getCategoryMargin();
            }
            if (rows > 1) {
                currentItemMargin = this.getItemMargin();
            }
            double used = space * (1.0 - domainAxis.getLowerMargin() - domainAxis.getUpperMargin() - categoryMargin - currentItemMargin);
            if (rows * columns > 0) {
                state.setBarWidth(Math.min(used / (double)(rows * columns), maxWidth));
            } else {
                state.setBarWidth(Math.min(used, maxWidth));
            }
        }
    }

    protected double calculateBarW0(CategoryPlot plot, PlotOrientation orientation, RectShape dataArea, CategoryAxis domainAxis, CategoryItemRendererState state, int row, int column) {
        double space = 0.0;
        space = orientation == PlotOrientation.HORIZONTAL ? (double)dataArea.getHeight() : (double)dataArea.getWidth();
        double barW0 = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        int seriesCount = state.getVisibleSeriesCount() >= 0 ? state.getVisibleSeriesCount() : this.getRowCount();
        int categoryCount = this.getColumnCount();
        if (seriesCount > 1) {
            double seriesGap = space * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
            double seriesW = this.calculateSeriesWidth(space, domainAxis, categoryCount, seriesCount);
            barW0 = barW0 + (double)row * (seriesW + seriesGap) + seriesW / 2.0 - state.getBarWidth() / 2.0;
        } else {
            barW0 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge()) - state.getBarWidth() / 2.0;
        }
        return barW0;
    }

    protected double[] calculateBarL0L1(double value) {
        double lclip = this.getLowerClip();
        double uclip = this.getUpperClip();
        double barLow = Math.min(this.base, value);
        double barHigh = Math.max(this.base, value);
        if (barHigh < lclip) {
            return null;
        }
        if (barLow > uclip) {
            return null;
        }
        barLow = Math.max(barLow, lclip);
        barHigh = Math.min(barHigh, uclip);
        return new double[]{barLow, barHigh};
    }

    public Range findRangeBounds(CategoryDataset dataset) {
        if (dataset == null) {
            return null;
        }
        Range result = DatasetUtilities.findRangeBounds(dataset);
        if (result != null && this.includeBaseInRange) {
            result = Range.expandToInclude(result, this.base);
        }
        return result;
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        String label;
        CategoryPlot cp = this.getPlot();
        if (cp == null) {
            return null;
        }
        if (!this.isSeriesVisible(series) || !this.isSeriesVisibleInLegend(series)) {
            return null;
        }
        CategoryDataset dataset = cp.getDataset(datasetIndex);
        String description = label = this.getLegendItemLabelGenerator().generateLabel(dataset, series);
        String toolTipText = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            toolTipText = this.getLegendItemToolTipGenerator().generateLabel(dataset, series);
        }
        String urlText = null;
        if (this.getLegendItemURLGenerator() != null) {
            urlText = this.getLegendItemURLGenerator().generateLabel(dataset, series);
        }
        Shape shape = this.lookupLegendShape(series);
        PaintType paintType = this.lookupSeriesPaintType(series);
        PaintType outlinePaintType = this.lookupSeriesOutlinePaintType(series);
        float outlineStroke = this.lookupSeriesOutlineStroke(series).floatValue();
        LegendItem result = new LegendItem(label, description, toolTipText, urlText, true, shape, true, paintType, this.isDrawBarOutline(), outlinePaintType, outlineStroke, false, (Shape)new LineShape(), 1.0f, (PaintType)new SolidColor(-16777216));
        result.setLabelFont(this.lookupLegendTextFont(series));
        PaintType labelPaintType = this.lookupLegendTextPaintType(series);
        if (labelPaintType != null) {
            result.setLabelPaintType(labelPaintType);
        }
        result.setDataset(dataset);
        result.setDatasetIndex(datasetIndex);
        result.setSeriesKey(dataset.getRowKey(series));
        result.setSeriesIndex(series);
        return result;
    }

    public void drawItem(Canvas canvas, CategoryItemRendererState state, RectShape dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        RectangleEdge barBase;
        int visibleRow = state.getVisibleSeriesIndex(row);
        if (visibleRow < 0) {
            return;
        }
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return;
        }
        double value = dataValue.doubleValue();
        PlotOrientation orientation = plot.getOrientation();
        double barW0 = this.calculateBarW0(plot, orientation, dataArea, domainAxis, state, visibleRow, column);
        double[] barL0L1 = this.calculateBarL0L1(value);
        if (barL0L1 == null) {
            return;
        }
        RectangleEdge edge = plot.getRangeAxisEdge();
        double transL0 = rangeAxis.valueToJava2D(barL0L1[0], dataArea, edge);
        double transL1 = rangeAxis.valueToJava2D(barL0L1[1], dataArea, edge);
        boolean positive = value >= this.base;
        boolean inverted = rangeAxis.isInverted();
        double barL0 = Math.min(transL0, transL1);
        double barLength = Math.abs(transL1 - transL0);
        double barLengthAdj = 0.0;
        if (barLength > 0.0 && barLength < this.getMinimumBarLength()) {
            barLengthAdj = this.getMinimumBarLength() - barLength;
        }
        double barL0Adj = 0.0;
        if (orientation == PlotOrientation.HORIZONTAL) {
            if (positive && inverted || !positive && !inverted) {
                barL0Adj = barLengthAdj;
                barBase = RectangleEdge.RIGHT;
            } else {
                barBase = RectangleEdge.LEFT;
            }
        } else if (positive && !inverted || !positive && inverted) {
            barL0Adj = barLengthAdj;
            barBase = RectangleEdge.BOTTOM;
        } else {
            barBase = RectangleEdge.TOP;
        }
        RectShape bar = null;
        bar = orientation == PlotOrientation.HORIZONTAL ? new RectShape(barL0 - barL0Adj, barW0, barLength + barLengthAdj, state.getBarWidth()) : new RectShape(barW0, barL0 - barL0Adj, state.getBarWidth(), barLength + barLengthAdj);
        if (this.getShadowsVisible()) {
            this.barPainter.paintBarShadow(canvas, this, row, column, bar, barBase, true);
        }
        this.barPainter.paintBar(canvas, this, row, column, bar, barBase);
        CategoryItemLabelGenerator generator = this.getItemLabelGenerator(row, column);
        if (generator != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(canvas, dataset, row, column, plot, generator, bar, value < 0.0);
        }
        int datasetIndex = plot.indexOf(dataset);
        this.updateCrosshairValues(state.getCrosshairState(), dataset.getRowKey(row), dataset.getColumnKey(column), value, datasetIndex, barW0, barL0, orientation);
        EntityCollection entities = state.getEntityCollection();
        if (entities != null) {
            this.addItemEntity(entities, dataset, row, column, bar);
        }
    }

    protected double calculateSeriesWidth(double space, CategoryAxis axis, int categories, int series) {
        double factor = 1.0 - this.getItemMargin() - axis.getLowerMargin() - axis.getUpperMargin();
        if (categories > 1) {
            factor -= axis.getCategoryMargin();
        }
        return space * factor / (double)(categories * series);
    }

    protected void drawItemLabel(Canvas canvas, CategoryDataset data, int row, int column, CategoryPlot plot, CategoryItemLabelGenerator generator, RectShape bar, boolean negative) {
        String label = generator.generateLabel(data, row, column);
        if (label == null) {
            return;
        }
        Font labelFont = this.getItemLabelFont(row, column);
        PaintType paintType = this.getItemLabelPaintType(row, column);
        ItemLabelPosition position = null;
        position = !negative ? this.getPositiveItemLabelPosition(row, column) : this.getNegativeItemLabelPosition(row, column);
        PointF anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), bar, plot.getOrientation());
        Paint paint = PaintUtility.createPaint(1, paintType, labelFont);
        if (this.isInternalAnchor(position.getItemLabelAnchor())) {
            Rect rectBounds = new Rect();
            paint.getTextBounds(label, 0, label.length(), rectBounds);
            Shape bounds = new RectShape(rectBounds);
            bounds = ShapeUtilities.rotateShape(bounds, position.getAngle(), anchorPoint.x, anchorPoint.y);
            if (bounds != null) {
                RectShape rectShape = new RectShape();
                bounds.getBounds(rectShape);
                if (!bar.contains(rectShape) && (position = !negative ? this.getPositiveItemLabelPositionFallback() : this.getNegativeItemLabelPositionFallback()) != null) {
                    anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), bar, plot.getOrientation());
                }
            }
        }
        if (position != null) {
            TextUtilities.drawRotatedString(label, canvas, anchorPoint.x, anchorPoint.y, position.getTextAnchor(), position.getAngle(), position.getRotationAnchor(), paint);
        }
    }

    private PointF calculateLabelAnchorPoint(ItemLabelAnchor anchor, RectShape bar, PlotOrientation orientation) {
        PointF result = null;
        double offset = this.getItemLabelAnchorOffset();
        double x0 = (double)bar.getX() - offset;
        double x1 = bar.getX();
        double x2 = (double)bar.getX() + offset;
        double x3 = bar.getCenterX();
        double x4 = (double)bar.getMaxX() - offset;
        double x5 = bar.getMaxX();
        double x6 = (double)bar.getMaxX() + offset;
        double y0 = (double)bar.getMaxY() + offset;
        double y1 = bar.getMaxY();
        double y2 = (double)bar.getMaxY() - offset;
        double y3 = bar.getCenterY();
        double y4 = (double)bar.getMinY() + offset;
        double y5 = bar.getMinY();
        double y6 = (double)bar.getMinY() - offset;
        if (anchor == ItemLabelAnchor.CENTER) {
            result = new PointF((float)x3, (float)y3);
        } else if (anchor == ItemLabelAnchor.INSIDE1) {
            result = new PointF((float)x4, (float)y4);
        } else if (anchor == ItemLabelAnchor.INSIDE2) {
            result = new PointF((float)x4, (float)y4);
        } else if (anchor == ItemLabelAnchor.INSIDE3) {
            result = new PointF((float)x4, (float)y3);
        } else if (anchor == ItemLabelAnchor.INSIDE4) {
            result = new PointF((float)x4, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE5) {
            result = new PointF((float)x4, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE6) {
            result = new PointF((float)x3, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE7) {
            result = new PointF((float)x2, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE8) {
            result = new PointF((float)x2, (float)y2);
        } else if (anchor == ItemLabelAnchor.INSIDE9) {
            result = new PointF((float)x2, (float)y3);
        } else if (anchor == ItemLabelAnchor.INSIDE10) {
            result = new PointF((float)x2, (float)y4);
        } else if (anchor == ItemLabelAnchor.INSIDE11) {
            result = new PointF((float)x2, (float)y4);
        } else if (anchor == ItemLabelAnchor.INSIDE12) {
            result = new PointF((float)x3, (float)y4);
        } else if (anchor == ItemLabelAnchor.OUTSIDE1) {
            result = new PointF((float)x5, (float)y6);
        } else if (anchor == ItemLabelAnchor.OUTSIDE2) {
            result = new PointF((float)x6, (float)y5);
        } else if (anchor == ItemLabelAnchor.OUTSIDE3) {
            result = new PointF((float)x6, (float)y3);
        } else if (anchor == ItemLabelAnchor.OUTSIDE4) {
            result = new PointF((float)x6, (float)y1);
        } else if (anchor == ItemLabelAnchor.OUTSIDE5) {
            result = new PointF((float)x5, (float)y0);
        } else if (anchor == ItemLabelAnchor.OUTSIDE6) {
            result = new PointF((float)x3, (float)y0);
        } else if (anchor == ItemLabelAnchor.OUTSIDE7) {
            result = new PointF((float)x1, (float)y0);
        } else if (anchor == ItemLabelAnchor.OUTSIDE8) {
            result = new PointF((float)x0, (float)y1);
        } else if (anchor == ItemLabelAnchor.OUTSIDE9) {
            result = new PointF((float)x0, (float)y3);
        } else if (anchor == ItemLabelAnchor.OUTSIDE10) {
            result = new PointF((float)x0, (float)y5);
        } else if (anchor == ItemLabelAnchor.OUTSIDE11) {
            result = new PointF((float)x1, (float)y6);
        } else if (anchor == ItemLabelAnchor.OUTSIDE12) {
            result = new PointF((float)x3, (float)y6);
        }
        return result;
    }

    private boolean isInternalAnchor(ItemLabelAnchor anchor) {
        return anchor == ItemLabelAnchor.CENTER || anchor == ItemLabelAnchor.INSIDE1 || anchor == ItemLabelAnchor.INSIDE2 || anchor == ItemLabelAnchor.INSIDE3 || anchor == ItemLabelAnchor.INSIDE4 || anchor == ItemLabelAnchor.INSIDE5 || anchor == ItemLabelAnchor.INSIDE6 || anchor == ItemLabelAnchor.INSIDE7 || anchor == ItemLabelAnchor.INSIDE8 || anchor == ItemLabelAnchor.INSIDE9 || anchor == ItemLabelAnchor.INSIDE10 || anchor == ItemLabelAnchor.INSIDE11 || anchor == ItemLabelAnchor.INSIDE12;
    }

    public void addChangeListener(RendererChangeListener listener) {
    }

    public void removeChangeListener(RendererChangeListener listener) {
    }
}

